/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.complexity.TSDChildGraphForest;
import com.tomsawyer.complexity.TSDChildGraphForestEdge;
import com.tomsawyer.complexity.TSFoldingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSDNodePair;
import com.tomsawyer.drawing.TSGeometricObject;
import com.tomsawyer.drawing.cv;
import com.tomsawyer.drawing.event.TSDEventManager;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.graph.TSChildGraphForest;
import com.tomsawyer.graph.TSChildGraphForestEdge;
import com.tomsawyer.graph.TSChildGraphForestNode;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.cw;
import com.tomsawyer.graph.de;
import com.tomsawyer.graph.event.TSEventManager;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.df;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSDGraphManager
extends TSGraphManager
implements TSGeometricObject {
    TSDGraph mainDisplayGraph;
    private boolean compressMetaEdges = true;
    private boolean reflexiveMetaEdgeReplacement = false;
    private boolean ignoreConnectorsForMetaEdges = true;
    public static final int META_EDGES = 4;
    public static final int NON_META_EDGES = 8;
    public static final int VIEWABLE = 16;
    public static final int UNVIEWABLE = 32;
    public static final int REACHABLE = 64;
    public static final int UNREACHABLE = 128;
    public static final int EXPANDED_NODES = 256;
    public static final int NON_EXPANDED_NODES = 512;
    public static final int COLLAPSED_NODES = 1024;
    public static final int NON_COLLAPSED_NODES = 2048;
    public static final int REACHABLE_INTERGRAPH_EDGES = 66;
    public static final int VIEWABLE_INTERGRAPH_EDGES = 18;
    private boolean readingInProgress;

    public TSEventManager newEventManager() {
        return new TSDEventManager();
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.mainDisplayGraph = null;
    }

    public void copy(Object object, boolean bl, Map map, Map map2) {
        TSSystem.tsAssert(this != object);
        super.copy(object, bl, map, map2);
        this.checkInvariants();
        if (object instanceof TSDGraphManager) {
            TSDGraphManager tSDGraphManager = (TSDGraphManager)object;
            this.setMainDisplayGraph(null);
            if (tSDGraphManager.getMainDisplayGraph() != null) {
                TSDGraph tSDGraph = tSDGraphManager.getMainDisplayGraph();
                Iterator iterator = tSDGraphManager.graphs(false).iterator();
                Iterator iterator2 = this.graphs(false).iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    TSDGraph tSDGraph2 = (TSDGraph)iterator.next();
                    TSDGraph tSDGraph3 = (TSDGraph)iterator2.next();
                    if (tSDGraph2 != tSDGraph) continue;
                    this.setMainDisplayGraph(tSDGraph3);
                    break;
                }
            }
        }
        if (this.getMainDisplayGraph() == null && this.numberOfGraphs() > 0) {
            this.setMainDisplayGraph((TSDGraph)this.firstGraph());
        }
    }

    protected void duplicateChildGraphForestEdge(TSChildGraphForestEdge tSChildGraphForestEdge) {
        super.duplicateChildGraphForestEdge(tSChildGraphForestEdge);
        if (tSChildGraphForestEdge instanceof TSDChildGraphForestEdge) {
            TSGraphMember tSGraphMember = tSChildGraphForestEdge.getGraphMember();
            TSGraphMember tSGraphMember2 = (TSGraphMember)tSGraphMember.getUtilityObject();
            if (TSNestingManager.isExpanded(tSGraphMember)) {
                this.expandNodeOnCopy(tSGraphMember2);
            }
        }
    }

    public void expandNodeOnCopy(TSGraphMember tSGraphMember) {
        TSNestingManager tSNestingManager = TSNestingManager.getManager((TSDGraphManager)tSGraphMember.getOwnerGraphManager());
        TSNestingManager.expand((TSDNode)tSGraphMember);
    }

    public TSGraph insert(TSGraph tSGraph) {
        TSDGraph tSDGraph = (TSDGraph)super.insert(tSGraph);
        if (tSDGraph != null) {
            if (this.numberOfGraphs() == 1) {
                this.setMainDisplayGraph(tSDGraph);
            }
            tSDGraph.checkInvariants();
            this.checkInvariants();
        }
        return tSDGraph;
    }

    public void insert(TSEdge tSEdge, TSNode tSNode, TSNode tSNode2) {
        TSSystem.tsAssert(tSEdge != null && !tSEdge.isOwned() && tSNode != null && tSNode2 != null);
        if (tSEdge != null && tSNode != null && tSNode2 != null && !tSEdge.isOwned()) {
            TSDGraph tSDGraph = (TSDGraph)tSNode.getOwnerGraph();
            TSDGraph tSDGraph2 = (TSDGraph)tSNode2.getOwnerGraph();
            if (tSDGraph != null && tSDGraph2 != null && tSDGraph.getOwnerGraphManager() == this && tSDGraph2.getOwnerGraphManager() == this) {
                if (tSDGraph.hideGraph() == tSDGraph2) {
                    tSDGraph.insert(tSEdge);
                } else if (tSDGraph2.hideGraph() == tSDGraph) {
                    tSDGraph2.insert(tSEdge);
                } else {
                    super.insert(tSEdge, tSNode, tSNode2);
                }
            }
        }
    }

    public void discard(TSGraph tSGraph) {
        TSDGraph tSDGraph = (TSDGraph)tSGraph;
        if (tSDGraph != null && tSDGraph.getOwner() == this && !tSDGraph.isIntergraph()) {
            super.discard(tSDGraph);
        }
    }

    public TSGraph remove(TSGraph tSGraph) {
        TSDGraph tSDGraph = (TSDGraph)tSGraph;
        if (tSDGraph != null && tSDGraph.getOwner() == this && !tSDGraph.isIntergraph()) {
            if (tSDGraph == this.getMainDisplayGraph()) {
                this.setMainDisplayGraph(this.findNewMainDisplayGraph());
            }
            if ((tSDGraph = (TSDGraph)super.remove(tSDGraph)) != null) {
                tSDGraph.checkInvariants();
                this.checkInvariants();
            }
        } else {
            tSDGraph = null;
        }
        return tSDGraph;
    }

    public void emptyTopology() {
        super.emptyTopology();
        this.setMainDisplayGraph(null);
    }

    public void setAllPathNodesVisited(boolean bl) {
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            tSDGraph.setAllPathNodesVisited(bl);
        }
    }

    public TSDEdge getMetaEdge(TSDEdge tSDEdge) {
        TSDEdge tSDEdge2 = null;
        TSDNode tSDNode = (TSDNode)tSDEdge.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
        if (tSDNode != null && tSDNode2 != null) {
            TSGraph tSGraph = this.getCommonOwnerGraph(tSDNode, tSDNode2);
            TSDNode tSDNode3 = (TSDNode)tSDNode.getViewableParentIn(tSGraph);
            TSDNode tSDNode4 = (TSDNode)tSDNode2.getViewableParentIn(tSGraph);
            tSDEdge2 = this.getMetaEdge(tSDEdge, tSDNode3, tSDNode4);
        }
        return tSDEdge2;
    }

    public TSDEdge getMetaEdge(TSDNode tSDNode, TSDNode tSDNode2) {
        TSDEdge tSDEdge = null;
        if (tSDNode != null && tSDNode2 != null) {
            if (tSDNode.getOwnerGraph() == tSDNode2.getOwnerGraph() && tSDNode.getOwnerGraph() != null) {
                TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwnerGraph();
                tSDEdge = tSDGraph.getMetaEdge(tSDNode, tSDNode2);
            } else if (this.queryIntergraph() != null) {
                tSDEdge = ((TSDGraph)this.queryIntergraph()).getMetaEdge(tSDNode, tSDNode2);
            }
        }
        return tSDEdge;
    }

    public TSDEdge getMetaEdge(TSDEdge tSDEdge, TSDNode tSDNode, TSDNode tSDNode2) {
        TSDEdge tSDEdge2 = null;
        if (tSDNode != null && tSDNode2 != null) {
            if (tSDNode.getOwnerGraph() == tSDNode2.getOwnerGraph() && tSDNode.getOwnerGraph() != null) {
                TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwnerGraph();
                tSDEdge2 = tSDGraph.getMetaEdge(tSDEdge, tSDNode, tSDNode2);
            } else if (this.queryIntergraph() != null) {
                tSDEdge2 = ((TSDGraph)this.queryIntergraph()).getMetaEdge(tSDEdge, tSDNode, tSDNode2);
            }
        }
        return tSDEdge2;
    }

    public void checkMetaEdges(List list, List list2) {
        Vector vector = new Vector();
        this.buildAllMetaEdges(vector, true, true);
        Vector<TSDNodePair> vector2 = new Vector<TSDNodePair>();
        if (this.queryIntergraph() != null) {
            Object object;
            Iterator iterator;
            boolean bl;
            TSDNodePair tSDNodePair;
            Object object2;
            TSDGraph tSDGraph = (TSDGraph)this.queryIntergraph();
            Iterator iterator2 = tSDGraph.disconnectedEdges().iterator();
            while (iterator2.hasNext()) {
                object2 = (TSDEdge)iterator2.next();
                if (((TSDEdge)object2).isMetaEdge()) continue;
                tSDNodePair = null;
                tSDNodePair = new TSDNodePair();
                this.checkMetaEdge((TSDEdge)object2, tSDNodePair);
                if (tSDNodePair.getFirstNode() == null || tSDNodePair.getSecondNode() == null) continue;
                bl = true;
                if (!this.getReflexiveMetaEdgeReplacement() && tSDNodePair.getFirstNode() == tSDNodePair.getSecondNode()) {
                    bl = false;
                }
                if (this.getCompressMetaEdges()) {
                    iterator = vector2.iterator();
                    while (iterator.hasNext() && bl) {
                        object = (TSDNodePair)iterator.next();
                        bl = !((TSDNodePair)object).isEqual(tSDNodePair);
                    }
                }
                if (!bl) continue;
                vector2.add(tSDNodePair);
            }
            object2 = vector2.iterator();
            while (object2.hasNext()) {
                tSDNodePair = (TSDNodePair)object2.next();
                bl = false;
                iterator = vector.iterator();
                while (iterator.hasNext() && !bl) {
                    object = (TSDEdge)iterator.next();
                    if (tSDNodePair.getFirstNode() != ((TSEdge)object).getSourceNode() || tSDNodePair.getSecondNode() != ((TSEdge)object).getTargetNode() || !this.getIgnoreConnectorsForMetaEdges() && (tSDNodePair.getFirstConnector() != ((TSDEdge)object).getSourceConnector() || tSDNodePair.getSecondConnector() != ((TSDEdge)object).getTargetConnector())) continue;
                    iterator.remove();
                    object2.remove();
                    bl = true;
                }
            }
            list.clear();
            list2.clear();
            list.addAll(vector2);
            list2.addAll(vector);
        }
    }

    protected void checkMetaEdge(TSDEdge tSDEdge, TSDNodePair tSDNodePair) {
        if (tSDEdge.isIntergraphEdge()) {
            TSDNode tSDNode = (TSDNode)tSDEdge.getSourceNode();
            TSDNode tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
            TSDGraph tSDGraph = null;
            TSDGraph tSDGraph2 = this.getCommonNestedGraphOwner(tSDEdge);
            if (tSDGraph2 != null) {
                tSDNodePair.setFirstNode(null);
                tSDNodePair.setSecondNode(null);
            } else {
                tSDGraph = (TSDGraph)tSDEdge.getTransformGraph();
                if (tSDGraph != null) {
                    TSDNode tSDNode3 = this.nearestCollapsedNode(tSDGraph, tSDNode);
                    TSDNode tSDNode4 = this.nearestCollapsedNode(tSDGraph, tSDNode2);
                    tSDNodePair.setFirstNode(tSDNode3);
                    tSDNodePair.setSecondNode(tSDNode4);
                    if (!this.getIgnoreConnectorsForMetaEdges()) {
                        TSConnector tSConnector = tSDEdge.getSourceConnector();
                        if (tSConnector != null && tSDNode3 == tSDEdge.getSourceNode()) {
                            tSDNodePair.setFirstConnector(tSConnector);
                        }
                        if ((tSConnector = tSDEdge.getTargetConnector()) != null && tSDNode4 == tSDEdge.getTargetNode()) {
                            tSDNodePair.setSecondConnector(tSConnector);
                        }
                    }
                } else {
                    tSDNodePair.setFirstNode(null);
                    tSDNodePair.setSecondNode(null);
                }
            }
        }
    }

    public TSDNode nearestCollapsedNode(TSDGraph tSDGraph, TSDNode tSDNode) {
        TSDNode tSDNode2 = null;
        TSDNode tSDNode3 = tSDNode;
        TSDGraph tSDGraph2 = (TSDGraph)tSDNode3.getOwnerGraph();
        boolean bl = tSDGraph2.isHideGraph();
        if (!bl) {
            tSDNode2 = tSDNode;
            while (!bl && tSDGraph2 != tSDGraph) {
                tSDNode3 = (TSDNode)tSDGraph2.getParent();
                if ((tSDGraph2 = (TSDGraph)tSDNode3.getOwnerGraph()).isHideGraph()) {
                    bl = true;
                    tSDNode2 = null;
                    continue;
                }
                if (!tSDNode3.isCollapsed()) continue;
                tSDNode2 = tSDNode3;
            }
        }
        return tSDNode2;
    }

    public void updateMetaEdges(List list, List list2, List list3, int n) {
        TSDEdge tSDEdge;
        Object object;
        Iterator iterator = list.iterator();
        Vector<TSDEdge> vector = new Vector<TSDEdge>();
        while (iterator.hasNext()) {
            object = (TSDNodePair)iterator.next();
            if (((TSDNodePair)object).getFirstNode() == null || ((TSDNodePair)object).getSecondNode() == null) continue;
            tSDEdge = this.addMetaEdge(((TSDNodePair)object).getFirstNode(), ((TSDNodePair)object).getSecondNode(), n);
            if (!this.getIgnoreConnectorsForMetaEdges()) {
                if (((TSDNodePair)object).getFirstConnector() != null) {
                    tSDEdge.setSourceConnector(((TSDNodePair)object).getFirstConnector());
                }
                if (((TSDNodePair)object).getSecondConnector() != null) {
                    tSDEdge.setTargetConnector(((TSDNodePair)object).getSecondConnector());
                }
            }
            vector.add(tSDEdge);
        }
        object = list2.iterator();
        while (object.hasNext()) {
            tSDEdge = (TSDEdge)object.next();
            if (!tSDEdge.isOwned()) continue;
            tSDEdge.getOwnerGraph().remove(tSDEdge);
        }
        list3.clear();
        list3.addAll(vector);
    }

    public void updateMetaEdges(List list, List list2, List list3) {
        TSDEdge tSDEdge;
        Object object;
        Iterator iterator = list.iterator();
        Vector<TSDEdge> vector = new Vector<TSDEdge>();
        while (iterator.hasNext()) {
            object = (TSDNodePair)iterator.next();
            if (((TSDNodePair)object).getFirstNode() == null || ((TSDNodePair)object).getSecondNode() == null) continue;
            tSDEdge = this.addMetaEdge(((TSDNodePair)object).getFirstNode(), ((TSDNodePair)object).getSecondNode());
            if (!this.getIgnoreConnectorsForMetaEdges()) {
                if (((TSDNodePair)object).getFirstConnector() != null) {
                    tSDEdge.setSourceConnector(((TSDNodePair)object).getFirstConnector());
                }
                if (((TSDNodePair)object).getSecondConnector() != null) {
                    tSDEdge.setTargetConnector(((TSDNodePair)object).getSecondConnector());
                }
            }
            vector.add(tSDEdge);
        }
        object = list2.iterator();
        while (object.hasNext()) {
            tSDEdge = (TSDEdge)object.next();
            if (!tSDEdge.isOwned()) continue;
            tSDEdge.getOwnerGraph().remove(tSDEdge);
        }
        list3.clear();
        list3.addAll(vector);
    }

    public void buildAllMetaEdges(List list, boolean bl, boolean bl2) {
        if (list != null) {
            Iterator iterator = this.graphs(true).iterator();
            while (iterator.hasNext()) {
                ((TSDGraph)iterator.next()).buildMetaEdges(list, bl, bl2);
            }
        }
    }

    protected TSDEdge addMetaEdge(TSDNode tSDNode, TSDNode tSDNode2, int n) {
        return this.addMetaEdge(tSDNode, tSDNode2);
    }

    protected TSDEdge addMetaEdge(TSDNode tSDNode, TSDNode tSDNode2) {
        TSDEdge tSDEdge = null;
        if (tSDNode != null && tSDNode2 != null) {
            tSDEdge = (TSDEdge)this.newEdge();
            this.insert(tSDEdge, tSDNode, tSDNode2);
            tSDEdge.setMetaEdge(true);
        }
        return tSDEdge;
    }

    public boolean getReflexiveMetaEdgeReplacement() {
        return this.reflexiveMetaEdgeReplacement;
    }

    public void setReflexiveMetaEdgeReplacement(boolean bl) {
        this.reflexiveMetaEdgeReplacement = bl;
    }

    public boolean getIgnoreConnectorsForMetaEdges() {
        return this.ignoreConnectorsForMetaEdges;
    }

    public void setIgnoreConnectorsForMetaEdges(boolean bl) {
        this.ignoreConnectorsForMetaEdges = bl;
    }

    public boolean getCompressMetaEdges() {
        return this.compressMetaEdges;
    }

    public void setCompressMetaEdges(boolean bl) {
        this.compressMetaEdges = bl;
    }

    public TSDGraph getMainDisplayGraph() {
        if (this.mainDisplayGraph == null) {
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.mainDisplayGraph = (TSDGraph)this.addGraph();
            this.getEventManager().setFireEvents(bl);
        }
        return this.mainDisplayGraph;
    }

    public void setMainDisplayGraph(TSDGraph tSDGraph) {
        if (tSDGraph == this.mainDisplayGraph) {
            return;
        }
        TSDGraph tSDGraph2 = this.mainDisplayGraph;
        if (tSDGraph != null && tSDGraph.isHideGraph()) {
            tSDGraph = tSDGraph.hideFromGraph();
        }
        if (tSDGraph == null || tSDGraph.getOwner() == this && !tSDGraph.isIntergraph()) {
            this.mainDisplayGraph = tSDGraph;
        }
        if (tSDGraph != null) {
            List list = TSNestingManager.getNestedGraphsWithin(tSDGraph);
            Iterator iterator = this.graphs(false).iterator();
            while (iterator.hasNext()) {
                ((TSDGraph)iterator.next()).setViewability(false);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                ((TSDGraph)iterator.next()).setViewability(true);
            }
        }
        this.getEventManager().fireEvent(new TSDrawingChangeEvent(1L, new TSDrawingChangeEventData(this, tSDGraph2, this.mainDisplayGraph)));
    }

    protected List reachableIntergraphEdgeList() {
        df df2 = new df();
        Iterator iterator = this.intergraphEdges().iterator();
        TSDGraph tSDGraph = (TSDGraph)this.getMainDisplayGraph().getGreatestAncestor();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph2;
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            TSDGraph tSDGraph3 = (TSDGraph)tSDEdge.getSourceNode().getOwnerGraph();
            if (tSDGraph3.isHideGraph()) {
                tSDGraph3 = tSDGraph3.hideFromGraph();
            }
            if ((tSDGraph2 = (TSDGraph)tSDEdge.getTargetNode().getOwnerGraph()).isHideGraph()) {
                tSDGraph2 = tSDGraph2.hideFromGraph();
            }
            if (tSDGraph3.getGreatestAncestor() != tSDGraph || tSDGraph2.getGreatestAncestor() != tSDGraph) continue;
            df2.add(tSDEdge);
        }
        return df2;
    }

    TSDGraph findNewMainDisplayGraph() {
        TSDGraph tSDGraph = this.mainDisplayGraph;
        Object object = null;
        if (tSDGraph != null && this.numberOfGraphs() > 1) {
            Iterator iterator;
            Object object2;
            TSDGraph tSDGraph2;
            if (tSDGraph.nestedWithinGraph() != null && !(tSDGraph2 = tSDGraph.nestedWithinGraph()).isHideGraph() && !tSDGraph2.isIntergraph()) {
                object = tSDGraph2;
            }
            if (object == null && TSNestingManager.hasExpandedNodes(tSDGraph)) {
                object2 = new de();
                TSNestingManager.buildNestedGraphList(tSDGraph, (List)object2, false);
                iterator = ((df)object2).iterator();
                while (iterator.hasNext()) {
                    tSDGraph2 = (TSDGraph)iterator.next();
                    if (tSDGraph2 == tSDGraph || tSDGraph2.isHideGraph() || tSDGraph2.isIntergraph()) continue;
                    object = tSDGraph2;
                    break;
                }
            }
            object2 = null;
            if (object == null) {
                iterator = this.graphs(false).iterator();
                while (iterator.hasNext()) {
                    tSDGraph2 = (TSDGraph)iterator.next();
                    if (tSDGraph2 == tSDGraph || tSDGraph2.isHideGraph() || tSDGraph2.isIntergraph()) continue;
                    object2 = tSDGraph2;
                    if (TSNestingManager.isNested(tSDGraph2)) continue;
                    object = tSDGraph2;
                    break;
                }
            }
            if (object == null) {
                object = object2;
            }
        }
        return object;
    }

    TSDGraph getCommonNestedGraphOwner(TSDEdge tSDEdge) {
        TSDNode tSDNode = (TSDNode)tSDEdge.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
        TSDGraph tSDGraph = this.getCommonNestedGraphOwner((TSDGraph)tSDNode.getOwnerGraph(), (TSDGraph)tSDNode2.getOwnerGraph());
        return tSDGraph;
    }

    TSDGraph getCommonNestedGraphOwner(TSDGraph tSDGraph, TSDGraph tSDGraph2) {
        TSDGraph tSDGraph3 = null;
        if (tSDGraph != null && tSDGraph2 != null) {
            if (tSDGraph == tSDGraph2) {
                tSDGraph3 = tSDGraph;
            } else {
                TSChildGraphForestNode tSChildGraphForestNode = ((TSDChildGraphForest)this.getChildGraphForest()).leastCommonNestedAncestor(tSDGraph.getChildGraphForestNode(), tSDGraph2.getChildGraphForestNode());
                if (tSChildGraphForestNode != null) {
                    tSDGraph3 = (TSDGraph)tSChildGraphForestNode.getGraph();
                }
            }
        }
        return tSDGraph3;
    }

    public TSGraph getCommonOwnerGraph(TSGraph tSGraph, TSGraph tSGraph2) {
        TSGraph tSGraph3;
        if (tSGraph == null || tSGraph2 == null) {
            return null;
        }
        if (tSGraph == tSGraph2) {
            return tSGraph;
        }
        Vector vector = new Vector();
        if (tSGraph.getOwnerGraphManager() != tSGraph2.getOwnerGraphManager()) {
            vector.addAll(tSGraph.getOwnerGraphManager().graphs());
            vector.addAll(tSGraph2.getOwnerGraphManager().graphs());
        } else {
            vector.addAll(tSGraph.getOwnerGraphManager().graphs());
        }
        boolean[] blArray = new boolean[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            tSGraph3 = (TSGraph)iterator.next();
            blArray[n++] = tSGraph3.isMarked();
            tSGraph3.setMarked(false);
        }
        tSGraph3 = tSGraph;
        while (tSGraph3 != null) {
            if (tSGraph3.isHideGraph()) {
                ((TSDGraph)tSGraph3).hideFromGraph().setMarked(true);
            } else {
                tSGraph3.setMarked(true);
            }
            if (tSGraph3.getParent() != null && tSGraph3.getParent().isOwned()) {
                tSGraph3 = tSGraph3.getParent().getTransformGraph();
                continue;
            }
            tSGraph3 = null;
        }
        TSDGraph tSDGraph = (TSDGraph)tSGraph2;
        while (tSDGraph != null) {
            if (tSDGraph.isHideGraph()) {
                tSDGraph = tSDGraph.hideFromGraph();
            }
            if (tSDGraph.isMarked()) break;
            if (tSDGraph.getParent() != null && tSDGraph.getParent().isOwned()) {
                tSDGraph = (TSDGraph)tSDGraph.getParent().getTransformGraph();
                continue;
            }
            tSDGraph = null;
        }
        iterator = vector.iterator();
        n = 0;
        while (iterator.hasNext()) {
            TSGraph tSGraph4 = (TSGraph)iterator.next();
            tSGraph4.setMarked(blArray[n++]);
        }
        return tSDGraph;
    }

    public List buildReachableIntergraphEdges() {
        de de2 = new de();
        Iterator iterator = this.intergraphEdges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isReachable()) continue;
            de2.add(tSDEdge);
        }
        return de2;
    }

    public List buildViewableIntergraphEdges() {
        de de2 = new de();
        Iterator iterator = this.intergraphEdges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isViewable()) continue;
            de2.add(tSDEdge);
        }
        return de2;
    }

    public List buildEdges(int n) {
        return this.buildEdges(n, false);
    }

    public List buildEdges(int n, boolean bl) {
        de de2 = new de();
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            de2.addAll(tSDGraph.buildEdges(n));
            if (!bl || tSDGraph.isHideGraph() || tSDGraph.hideGraph() == null) continue;
            de2.addAll(tSDGraph.hideGraph().buildEdges(n));
        }
        return de2;
    }

    public List buildNodes(int n) {
        return this.buildNodes(n, false);
    }

    public List buildNodes(int n, boolean bl) {
        de de2 = new de();
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            de2.addAll(tSDGraph.buildNodes(n));
            if (!bl || tSDGraph.isHideGraph() || tSDGraph.hideGraph() == null) continue;
            de2.addAll(tSDGraph.hideGraph().buildNodes(n));
        }
        return de2;
    }

    public List buildGraphs(int n) {
        List list = this.graphs(true);
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            if ((n & 0x10) == 0 || !tSDGraph.isViewable()) {
                if ((n & 0x10) != 0) continue;
            }
            if ((n & 0x20) == 0 || tSDGraph.isViewable()) {
                if ((n & 0x20) != 0) continue;
            }
            if ((n & 0x40) == 0 || !tSDGraph.isReachable()) {
                if ((n & 0x40) != 0) continue;
            }
            if ((n & 0x80) == 0 || tSDGraph.isReachable()) {
                if ((n & 0x80) != 0) continue;
            }
            de2.add(tSDGraph);
        }
        return de2;
    }

    public List buildNodeLabels(int n) {
        return this.buildNodeLabels(n, false);
    }

    public List buildNodeLabels(int n, boolean bl) {
        de de2 = new de();
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            de2.addAll(tSDGraph.buildNodeLabels(n));
            if (!bl || tSDGraph.isHideGraph() || tSDGraph.hideGraph() == null) continue;
            de2.addAll(tSDGraph.hideGraph().buildNodeLabels(n));
        }
        return de2;
    }

    public List buildEdgeLabels(int n) {
        return this.buildEdgeLabels(n, false);
    }

    public List buildEdgeLabels(int n, boolean bl) {
        de de2 = new de();
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            de2.addAll(tSDGraph.buildEdgeLabels(n));
            if (!bl || tSDGraph.isHideGraph() || tSDGraph.hideGraph() == null) continue;
            de2.addAll(tSDGraph.hideGraph().buildEdgeLabels(n));
        }
        return de2;
    }

    public List buildConnectorLabels(int n) {
        return this.buildConnectorLabels(n, false);
    }

    public List buildConnectorLabels(int n, boolean bl) {
        de de2 = new de();
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            de2.addAll(tSDGraph.buildConnectorLabels(n));
            if (!bl || tSDGraph.isHideGraph() || tSDGraph.hideGraph() == null) continue;
            de2.addAll(tSDGraph.hideGraph().buildConnectorLabels(n));
        }
        return de2;
    }

    public void setGeometryChangeNotified(boolean bl) {
        Iterator iterator = this.graphs(false).iterator();
        TSDGraph tSDGraph = null;
        while (iterator.hasNext()) {
            tSDGraph = (TSDGraph)iterator.next();
            tSDGraph.setGeometryChangeNotified(bl);
        }
    }

    public void updateBounds() {
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            tSDGraph.updateBounds();
        }
    }

    public void readGMF(Reader reader, TSOptionData tSOptionData) throws IOException {
        this.readGMF(reader, tSOptionData, true);
    }

    public void readGMF(Reader reader, TSOptionData tSOptionData, boolean bl) throws IOException {
        this.readingInProgress = true;
        this.emptyTopology();
        cv cv2 = (cv)this.newGMFReader(reader);
        cv2.a(tSOptionData);
        cv2.a(this, bl);
        this.readingInProgress = false;
        this.updateBounds();
    }

    boolean isFileReadingInProgress() {
        return this.readingInProgress;
    }

    public int numberOfEdgeLabels() {
        int n = 0;
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            n += tSDGraph.numberOfEdgeLabels();
        }
        return n;
    }

    public int numberOfViewableNodes() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            if (!tSDGraph.isViewable()) continue;
            n += tSDGraph.numberOfNodes();
        }
        return n;
    }

    public int numberOfViewableEdges() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            if (!((TSGraphObject)tSDGraph).isViewable()) continue;
            n += tSDGraph.numberOfEdges();
        }
        return n;
    }

    public int numberOfViewableIntergraphEdges() {
        int n = 0;
        Iterator iterator = this.intergraphEdges().iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isViewable()) continue;
            ++n;
        }
        return n;
    }

    public int numberOfViewableEdgeLabels() {
        int n = 0;
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            if (tSDGraph.isIntergraph()) {
                Iterator iterator2 = tSDGraph.disconnectedEdges().iterator();
                while (iterator2.hasNext()) {
                    TSDEdge tSDEdge = (TSDEdge)iterator2.next();
                    if (!tSDEdge.isViewable()) continue;
                    n += tSDEdge.labels().size();
                }
                continue;
            }
            if (!tSDGraph.isViewable()) continue;
            n += tSDGraph.numberOfEdgeLabels();
        }
        return n;
    }

    public int numberOfNodeLabels() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            n += tSDGraph.numberOfNodeLabels();
        }
        return n;
    }

    public int numberOfViewableNodeLabels() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            if (!tSDGraph.isViewable()) continue;
            n += tSDGraph.numberOfNodeLabels();
        }
        return n;
    }

    public int numberOfConnectorLabels() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            n += tSDGraph.numberOfConnectorLabels();
        }
        return n;
    }

    public int numberOfViewableConnectorLabels() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator.next();
            if (!tSDGraph.isViewable()) continue;
            n += tSDGraph.numberOfConnectorLabels();
        }
        return n;
    }

    public boolean hasViewableFolderNodes() {
        boolean bl = false;
        de de2 = new de();
        de2.add(this.getMainDisplayGraph());
        while (!bl && !de2.isEmpty()) {
            TSDGraph tSDGraph = (TSDGraph)de2.remove(0);
            TSFoldingManager tSFoldingManager = TSFoldingManager.getManager(this);
            bl = tSFoldingManager.hasFolderNodes(tSDGraph);
            if (bl) continue;
            Vector vector = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraph, vector, false);
            de2.addAll(vector);
        }
        return bl;
    }

    static void markGraphs(TSDGraphManager tSDGraphManager, boolean bl, boolean bl2) {
        TSDGraphManager.markGraphs(tSDGraphManager.graphs(bl2), bl);
    }

    static void markGraphs(List list, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((TSDGraph)iterator.next()).setMarked(bl);
        }
    }

    public boolean deep() {
        return true;
    }

    public int levelNumber() {
        return 1;
    }

    protected TSGraph newGraph() {
        return new TSDGraph();
    }

    protected TSGraph newGraph(int n) {
        return new TSDGraph();
    }

    protected TSGraph newIntergraph() {
        return new TSDGraph();
    }

    protected TSGraph newIntergraph(int n) {
        return new TSDGraph();
    }

    protected TSEdge newEdge() {
        return new TSDEdge();
    }

    protected TSEdge newEdge(int n) {
        return new TSDEdge();
    }

    protected TSChildGraphForest newChildGraphForest() {
        return new TSDChildGraphForest();
    }

    protected cw newGMFReader(Reader reader) {
        return new cv(reader);
    }

    public TSConstRect getBounds() {
        return this.getMainDisplayGraph().getBounds();
    }

    public TSConstRect getLocalBounds() {
        return this.getMainDisplayGraph().getLocalBounds();
    }

    public double getBottom() {
        return this.getMainDisplayGraph().getBottom();
    }

    public double getLocalBottom() {
        return this.getMainDisplayGraph().getLocalBottom();
    }

    public double getLeft() {
        return this.getMainDisplayGraph().getLeft();
    }

    public double getLocalLeft() {
        return this.getMainDisplayGraph().getLocalLeft();
    }

    public double getRight() {
        return this.getMainDisplayGraph().getRight();
    }

    public double getLocalRight() {
        return this.getMainDisplayGraph().getLocalRight();
    }

    public double getTop() {
        return this.getMainDisplayGraph().getTop();
    }

    public double getLocalTop() {
        return this.getMainDisplayGraph().getLocalTop();
    }

    public double getWidth() {
        return this.getMainDisplayGraph().getWidth();
    }

    public double getLocalWidth() {
        return this.getMainDisplayGraph().getLocalWidth();
    }

    public double getHeight() {
        return this.getMainDisplayGraph().getHeight();
    }

    public double getLocalHeight() {
        return this.getMainDisplayGraph().getLocalHeight();
    }

    public boolean intersects(TSConstRect tSConstRect) {
        return this.getMainDisplayGraph().intersects(tSConstRect);
    }

    public boolean locallyIntersects(TSConstRect tSConstRect) {
        return this.getMainDisplayGraph().locallyIntersects(tSConstRect);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.getMainDisplayGraph().intersects(d, d2, d3, d4);
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        return this.getMainDisplayGraph().locallyIntersects(d, d2, d3, d4);
    }
}

