/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.complexity.TSDChildGraphForestEdge;
import com.tomsawyer.complexity.TSExpandedNodeExtension;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSAbstractShape;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSHasShape;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.TSRectangularObjectLabel;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.de;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f0;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSDNode
extends TSGNode
implements TSHasShape {
    public static String NODE_LEFT = "left";
    public static String NODE_RIGHT = "right";
    public static String NODE_TOP = "top";
    public static String NODE_BOTTOM = "bottom";
    private TSRect nodeBounds;
    de labelSet;
    de connectorSet;
    TSAbstractShape nodeShape;
    private double originalWidth;
    private double originalHeight;
    private boolean folderNode;

    protected TSDNode() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.connectorSet = new de();
        this.labelSet = new de();
        this.nodeBounds = new TSRect();
        double d = this.getDefaultWidth() / 2.0;
        double d2 = this.getDefaultHeight() / 2.0;
        this.assignBounds(-d, -d2, d, d2);
        this.setOriginalSize(this.getLocalWidth(), this.getLocalHeight());
        this.setFolderNode(false);
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        TSDGraph tSDGraph = (TSDGraph)tSGraphObject;
        tSDGraph.onNodeBecomesInserted(this);
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        TSDGraph tSDGraph = (TSDGraph)tSGraphObject;
        tSDGraph.onNodeBecomesRemoved(this);
        super.onRemove(tSGraphObject);
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        super.onDiscard(tSGraphObject);
    }

    public void emptyTopology() {
        this.discardAllLabels();
        this.discardAllConnectors();
    }

    public boolean contains(double d, double d2) {
        TSDGraph tSDGraph;
        TSDGraph tSDGraph2 = (TSDGraph)this.getOwner();
        if (tSDGraph2 != null && tSDGraph2 != (tSDGraph = tSDGraph2.getMainDisplayGraph())) {
            TSPoint tSPoint = new TSPoint(d, d2);
            tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint);
            d = tSPoint.getX();
            d2 = tSPoint.getY();
        }
        return this.locallyContains(d, d2);
    }

    public boolean locallyContains(double d, double d2) {
        if (!this.nodeBounds.contains(d, d2)) {
            return false;
        }
        return this.getShape().contains(d, d2);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyContains(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyContains(double d, double d2, double d3, double d4) {
        if (!this.nodeBounds.contains(d, d2, d3, d4)) {
            return false;
        }
        return this.getShape().contains(d, d2, d3, d4);
    }

    public boolean intersectsNodeFrame(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        if (this.getOwnerGraph() != null) {
            ((TSDGraph)this.getOwnerGraph()).inverseExpandedTransformPoint(tSPoint);
        }
        return this.locallyIntersectsNodeFrame(tSPoint);
    }

    public boolean locallyIntersectsNodeFrame(TSPoint tSPoint) {
        if (this.isExpanded()) {
            TSDGraph tSDGraph = (TSDGraph)this.getChildGraph();
            TSConstRect tSConstRect = tSDGraph.getLocalFrameBounds();
            TSRect tSRect = new TSRect();
            tSDGraph.getTransform().transformRect(tSConstRect, tSRect);
            if (!tSRect.contains(tSPoint) && this.locallyContains(tSPoint)) {
                return true;
            }
        }
        return false;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        if (d == d3 && d4 == d2) {
            return this.locallyContains(d, d2);
        }
        if (!this.nodeBounds.intersects(d, d2, d3, d4)) {
            return false;
        }
        return this.getShape().intersects(d, d2, d3, d4);
    }

    public boolean inside(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyInside(tSRect);
    }

    public boolean locallyInside(TSConstRect tSConstRect) {
        return tSConstRect.contains(this.getLocalBounds());
    }

    protected TSNodeLabel newLabel() {
        return new TSNodeLabel();
    }

    public TSNodeLabel addLabel() {
        TSNodeLabel tSNodeLabel = this.newLabel();
        this.insert(tSNodeLabel);
        return tSNodeLabel;
    }

    public String getDefaultLabelDirection() {
        return NODE_BOTTOM;
    }

    public double getDefaultLabelDistance() {
        return 10.0;
    }

    public void discard(TSLabel tSLabel) {
        TSSystem.tsAssert(tSLabel != null);
        TSSystem.tsAssert(tSLabel.isOwned());
        TSSystem.tsAssert(tSLabel.getOwner() == this);
        if (this.getOwnerGraph() != null && this.getOwnerGraph().isFiringEvents()) {
            this.getOwnerGraph().setFireEvents(false);
            this.remove(tSLabel);
            this.getOwnerGraph().setFireEvents(true);
        } else {
            this.remove(tSLabel);
        }
        tSLabel.onDiscard(this);
    }

    public void discardAllLabels() {
        f0 f02 = this.labelSet.a();
        while (f02 != null) {
            f0 f03 = f02.a();
            this.discard((TSNodeLabel)f02.b());
            f02 = f03;
        }
    }

    public int numberOfLabels() {
        if (this.labelSet == null) {
            return 0;
        }
        return this.labelSet.size();
    }

    public int numberOfConnectorLabels() {
        int n = 0;
        Iterator iterator = this.connectors().iterator();
        while (iterator.hasNext()) {
            TSConnector tSConnector = (TSConnector)iterator.next();
            if (tSConnector.labels() == null) continue;
            n += tSConnector.labels().size();
        }
        return n;
    }

    public void insert(TSNodeLabel tSNodeLabel) {
        TSSystem.tsAssert(tSNodeLabel != null);
        TSSystem.tsAssert(!tSNodeLabel.isOwned());
        this.labelSet.add(tSNodeLabel);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned()) {
            ++((TSDGraph)tSGraphObject).nodeLabelCount;
        }
        tSNodeLabel.onInsert(this);
        tSNodeLabel.ltShiftBounds();
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            this.notifyGraphOnInsert(tSNodeLabel.getLocalBounds());
        }
    }

    public List labels() {
        return this.labelSet;
    }

    public void remove(TSLabel tSLabel) {
        TSSystem.tsAssert(tSLabel != null);
        TSSystem.tsAssert(tSLabel.isOwned());
        TSSystem.tsAssert(tSLabel.getOwner() == this);
        TSConstRect tSConstRect = tSLabel.getLocalBounds();
        this.labelSet.remove(tSLabel);
        tSLabel.onRemove(this);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned()) {
            --((TSDGraph)tSGraphObject).nodeLabelCount;
        }
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            this.notifyGraphOnRemove(tSConstRect);
        }
    }

    public List getLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLabelsTouchingBounds(tSRect, list);
    }

    public List getLocalLabelsTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSNodeLabel>();
        }
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSNodeLabel tSNodeLabel = (TSNodeLabel)f02.b();
            if (!tSNodeLabel.isVisible() || !tSNodeLabel.locallyIntersects(tSConstRect)) continue;
            vector.add(0, tSNodeLabel);
        }
        return vector;
    }

    public List getConnectorsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalConnectorsTouchingBounds(tSRect, list);
    }

    public List getLocalConnectorsTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSConnector>();
        }
        for (f0 f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            TSConnector tSConnector = (TSConnector)f02.b();
            if (!tSConnector.isVisible() || !tSConnector.locallyIntersects(tSConstRect)) continue;
            vector.add(0, tSConnector);
        }
        return vector;
    }

    public TSNodeLabel getFirstLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalFirstLabelTouchingBounds(tSRect, object);
    }

    TSNodeLabel getLocalFirstLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSNodeLabel tSNodeLabel = (TSNodeLabel)f02.b();
            if (!tSNodeLabel.isVisible() || !tSNodeLabel.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSNodeLabel;
            }
            bl = tSNodeLabel.equals(object);
        }
        return null;
    }

    public TSNodeLabel getLastLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLastLabelTouchingBounds(tSRect, object);
    }

    public TSNodeLabel getLocalLastLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.labelSet.b(); f02 != null; f02 = f02.d()) {
            TSNodeLabel tSNodeLabel = (TSNodeLabel)f02.b();
            if (!tSNodeLabel.isVisible() || !tSNodeLabel.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSNodeLabel;
            }
            bl = tSNodeLabel.equals(object);
        }
        return null;
    }

    public TSConnector getFirstConnectorTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalFirstConnectorTouchingBounds(tSRect, object);
    }

    TSConnector getLocalFirstConnectorTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            TSConnector tSConnector = (TSConnector)f02.b();
            if (!tSConnector.isVisible() || !tSConnector.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSConnector;
            }
            bl = tSConnector.equals(object);
        }
        return null;
    }

    public TSConnector getLastConnectorTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLastConnectorTouchingBounds(tSRect, object);
    }

    TSConnector getLocalLastConnectorTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.connectorSet.b(); f02 != null; f02 = f02.d()) {
            TSConnector tSConnector = (TSConnector)f02.b();
            if (!tSConnector.isVisible() || !tSConnector.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSConnector;
            }
            bl = tSConnector.equals(object);
        }
        return null;
    }

    public List getLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLabelsInsideBounds(tSRect, list);
    }

    public List getLocalLabelsInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSNodeLabel>();
        }
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSNodeLabel tSNodeLabel = (TSNodeLabel)f02.b();
            if (!tSNodeLabel.isVisible() || !tSNodeLabel.locallyInside(tSConstRect)) continue;
            vector.add(0, tSNodeLabel);
        }
        return vector;
    }

    public List getConnectorsInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalConnectorsInsideBounds(tSRect, list);
    }

    public List getLocalConnectorsInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSConnector>();
        }
        for (f0 f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            TSConnector tSConnector = (TSConnector)f02.b();
            if (!tSConnector.isVisible() || !tSConnector.locallyInside(tSConstRect)) continue;
            vector.add(0, tSConnector);
        }
        return vector;
    }

    public TSConstRect getBounds() {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds() {
        return this.nodeBounds;
    }

    public double getBottom() {
        double d = this.getLocalBottom();
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom() {
        return this.nodeBounds.getBottom();
    }

    public double getCenterX() {
        double d = this.getLocalCenterX();
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalCenterX() {
        return this.nodeBounds.getCenterX();
    }

    public double getCenterY() {
        double d = this.getLocalCenterY();
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalCenterY() {
        return this.nodeBounds.getCenterY();
    }

    public double getHeight() {
        return this.getLocalHeight();
    }

    public double getLocalHeight() {
        return this.nodeBounds.getHeight();
    }

    public double getLeft() {
        double d = this.getLocalLeft();
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft() {
        return this.nodeBounds.getLeft();
    }

    public double getRight() {
        double d = this.getLocalRight();
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight() {
        return this.nodeBounds.getRight();
    }

    public double getTop() {
        double d = this.getLocalTop();
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop() {
        return this.nodeBounds.getTop();
    }

    public double getWidth() {
        return this.getLocalWidth();
    }

    public double getLocalWidth() {
        return this.nodeBounds.getWidth();
    }

    public TSConstRect getBounds(int n) {
        TSRect tSRect = new TSRect(this.getLocalBounds(n));
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds(int n) {
        TSGraphObject tSGraphObject;
        f0 f02;
        TSRect tSRect = new TSRect(this.getLocalBounds());
        if ((n & 4) != 0) {
            for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSConnector)f02.b();
                ((TSConnector)tSGraphObject).mergeLocalBounds(tSRect, n);
            }
        }
        if ((n & 2) != 0) {
            for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSNodeLabel)f02.b();
                ((TSLabel)tSGraphObject).mergeLocalBounds(tSRect);
            }
        }
        return tSRect;
    }

    public void mergeLocalBounds(TSRect tSRect) {
        tSRect.merge(this.getLocalBounds());
    }

    public void mergeLocalBounds(TSRect tSRect, int n) {
        TSGraphObject tSGraphObject;
        f0 f02;
        this.mergeLocalBounds(tSRect);
        if ((n & 4) != 0) {
            for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSConnector)f02.b();
                ((TSConnector)tSGraphObject).mergeLocalBounds(tSRect, n);
            }
        }
        if ((n & 2) != 0) {
            for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSNodeLabel)f02.b();
                ((TSLabel)tSGraphObject).mergeLocalBounds(tSRect);
            }
        }
    }

    public double getBottom(int n) {
        double d = this.getLocalBottom(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom(int n) {
        double d;
        TSGraphObject tSGraphObject;
        f0 f02;
        double d2 = this.getLocalBottom();
        if ((n & 4) != 0) {
            for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSConnector)f02.b();
                d = ((TSConnector)tSGraphObject).getLocalBottom(n);
                if (!(d < d2)) continue;
                d2 = d;
            }
        }
        if ((n & 2) != 0) {
            for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSNodeLabel)f02.b();
                d = ((TSLabel)tSGraphObject).getLocalBottom();
                if (!(d < d2)) continue;
                d2 = d;
            }
        }
        return d2;
    }

    public double getLeft(int n) {
        double d = this.getLocalLeft(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft(int n) {
        double d;
        TSGraphObject tSGraphObject;
        f0 f02;
        double d2 = this.getLocalLeft();
        if ((n & 4) != 0) {
            for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSConnector)f02.b();
                d = ((TSConnector)tSGraphObject).getLocalLeft(n);
                if (!(d < d2)) continue;
                d2 = d;
            }
        }
        if ((n & 2) != 0) {
            for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSNodeLabel)f02.b();
                d = ((TSLabel)tSGraphObject).getLocalLeft();
                if (!(d < d2)) continue;
                d2 = d;
            }
        }
        return d2;
    }

    public double getRight(int n) {
        double d = this.getLocalRight(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight(int n) {
        double d;
        TSGraphObject tSGraphObject;
        f0 f02;
        double d2 = this.getLocalRight();
        if ((n & 4) != 0) {
            for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSConnector)f02.b();
                d = ((TSConnector)tSGraphObject).getLocalRight(n);
                if (!(d > d2)) continue;
                d2 = d;
            }
        }
        if ((n & 2) != 0) {
            for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSNodeLabel)f02.b();
                d = ((TSLabel)tSGraphObject).getLocalRight();
                if (!(d > d2)) continue;
                d2 = d;
            }
        }
        return d2;
    }

    public double getTop(int n) {
        double d = this.getLocalTop(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop(int n) {
        double d;
        TSGraphObject tSGraphObject;
        f0 f02;
        double d2 = this.getLocalTop();
        if ((n & 4) != 0) {
            for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSConnector)f02.b();
                d = ((TSConnector)tSGraphObject).getLocalTop(n);
                if (!(d > d2)) continue;
                d2 = d;
            }
        }
        if ((n & 2) != 0) {
            for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                tSGraphObject = (TSNodeLabel)f02.b();
                d = ((TSLabel)tSGraphObject).getLocalTop();
                if (!(d > d2)) continue;
                d2 = d;
            }
        }
        return d2;
    }

    public void setWidth(double d) {
        this.setLocalWidth(d);
    }

    public void setLocalWidth(double d) {
        this.setLocalSize(d, this.getLocalHeight());
    }

    public void setHeight(double d) {
        this.setLocalHeight(d);
    }

    public void setLocalHeight(double d) {
        this.setLocalSize(this.getLocalWidth(), d);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        this.setLocalBounds(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public void setLocalBounds(double d, double d2, double d3, double d4) {
        TSConstRect tSConstRect = this.getLocalBounds(7);
        TSConstRect tSConstRect2 = new TSConstRect(this.nodeBounds);
        this.assignBounds(d, d2, d3, d4);
        if (this.isExpanded()) {
            TSExpTransform tSExpTransform = TSNestingManager.fitToNestedGraph(this);
            TSDGraph tSDGraph = (TSDGraph)this.getChildGraph();
            tSDGraph.updateTransform(tSExpTransform);
        }
        if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
            this.ltUpdateBoundsOfLabels();
            this.notifyGraphOnMove(tSConstRect);
            this.notifyEdgesOnGeometryChange();
        }
        if (this.getOwnerGraph() != null) {
            if (!tSConstRect.getCenter().equals(this.nodeBounds.getCenter())) {
                this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(4096L, new TSDrawingChangeEventData(this, tSConstRect2, this.getLocalBounds())));
            }
            if (!tSConstRect.getSize().equals(this.nodeBounds.getSize())) {
                this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(65536L, new TSDrawingChangeEventData(this, tSConstRect2, this.getLocalBounds())));
            }
        }
    }

    public void setCenter(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenter(tSPoint.getX(), tSPoint.getY());
    }

    public void setLocalCenter(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds(7);
        TSConstRect tSConstRect2 = new TSConstRect(this.nodeBounds);
        this.assignCenter(d, d2);
        if (this.isExpanded()) {
            TSExpTransform tSExpTransform = TSNestingManager.fitToNestedGraph(this);
            TSDGraph tSDGraph = (TSDGraph)this.getChildGraph();
            tSDGraph.updateTransform(tSExpTransform);
        }
        if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
            this.ltUpdateBoundsOfLabels();
            this.notifyGraphOnMove(tSConstRect);
            this.notifyEdgesOnGeometryChange();
        }
        if (this.getOwnerGraph() != null && !tSConstRect.getCenter().equals(this.nodeBounds.getCenter())) {
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(4096L, new TSDrawingChangeEventData(this, tSConstRect2, this.getLocalBounds())));
        }
    }

    public void setSize(double d, double d2) {
        this.setLocalSize(d, d2);
    }

    public void setLocalSize(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds(7);
        TSConstRect tSConstRect2 = new TSConstRect(this.nodeBounds);
        this.assignSize(d, d2);
        if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
            this.ltUpdateBoundsOfLabels();
            this.notifyGraphOnResize(tSConstRect);
            this.notifyEdgesOnGeometryChange();
        }
        if (this.getOwnerGraph() != null && !tSConstRect.getSize().equals(this.nodeBounds.getSize())) {
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(65536L, new TSDrawingChangeEventData(this, tSConstRect2, this.getLocalBounds())));
        }
    }

    public void setOriginalSize(TSConstSize tSConstSize) {
        this.setLocalOriginalSize(tSConstSize);
    }

    public void setLocalOriginalSize(TSConstSize tSConstSize) {
        this.setLocalOriginalSize(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public TSConstSize getOriginalSize() {
        return this.getLocalOriginalSize();
    }

    public TSConstSize getLocalOriginalSize() {
        return new TSConstSize(this.originalWidth, this.originalHeight);
    }

    public void setOriginalSize(double d, double d2) {
        this.setLocalOriginalSize(d, d2);
    }

    public void setLocalOriginalSize(double d, double d2) {
        this.assignOriginalSize(d, d2);
    }

    public double getOriginalWidth() {
        return this.getLocalOriginalWidth();
    }

    public double getLocalOriginalWidth() {
        return this.originalWidth;
    }

    public void setOriginalWidth(double d) {
        this.setLocalOriginalWidth(d);
    }

    public void setLocalOriginalWidth(double d) {
        this.setLocalOriginalSize(d, this.getLocalOriginalHeight());
    }

    public double getOriginalHeight() {
        return this.getLocalOriginalHeight();
    }

    public double getLocalOriginalHeight() {
        return this.originalHeight;
    }

    public void setOriginalHeight(double d) {
        this.setLocalOriginalHeight(d);
    }

    public void setLocalOriginalHeight(double d) {
        this.setLocalOriginalSize(this.getLocalOriginalWidth(), d);
    }

    public double getDefaultWidth() {
        return 40.0;
    }

    public double getDefaultHeight() {
        return 40.0;
    }

    public boolean isFolderNode() {
        return this.folderNode;
    }

    public void setFolderNode(boolean bl) {
        this.folderNode = bl;
    }

    public List buildIncidentMetaEdgeList() {
        TSDEdge tSDEdge;
        df df2 = new df();
        Iterator iterator = this.inEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isMetaEdge() || df2.contains(tSDEdge)) continue;
            df2.add(tSDEdge);
        }
        iterator = this.outEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isMetaEdge() || df2.contains(tSDEdge)) continue;
            df2.add(tSDEdge);
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isMetaEdge() || !tSDEdge.isOwned() || df2.contains(tSDEdge)) continue;
            df2.add(tSDEdge);
        }
        return df2;
    }

    public List buildInEdges(int n) {
        List list = super.buildInEdges(n);
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (((n & 4) == 0 || !tSDEdge.isMetaEdge()) && (n & 4) != 0 || ((n & 8) == 0 || tSDEdge.isMetaEdge()) && (n & 8) != 0 || ((n & 0x10) == 0 || !tSDEdge.isViewable()) && (n & 0x10) != 0 || ((n & 0x20) == 0 || tSDEdge.isViewable()) && (n & 0x20) != 0 || ((n & 0x40) == 0 || !tSDEdge.isReachable()) && (n & 0x40) != 0 || ((n & 0x80) == 0 || tSDEdge.isReachable()) && (n & 0x80) != 0) continue;
            de2.add(tSDEdge);
        }
        return de2;
    }

    public List buildOutEdges(int n) {
        List list = super.buildOutEdges(n);
        de de2 = new de();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (((n & 4) == 0 || !tSDEdge.isMetaEdge()) && (n & 4) != 0 || ((n & 8) == 0 || tSDEdge.isMetaEdge()) && (n & 8) != 0 || ((n & 0x10) == 0 || !tSDEdge.isViewable()) && (n & 0x10) != 0 || ((n & 0x20) == 0 || tSDEdge.isViewable()) && (n & 0x20) != 0 || ((n & 0x40) == 0 || !tSDEdge.isReachable()) && (n & 0x40) != 0 || ((n & 0x80) == 0 || tSDEdge.isReachable()) && (n & 0x80) != 0) continue;
            de2.add(tSDEdge);
        }
        return de2;
    }

    void notifyEdgesOnGeometryChange() {
        TSDEdge tSDEdge;
        Iterator iterator;
        if (!this.inEdges().isEmpty()) {
            iterator = this.inEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                tSDEdge.updateBoundsOfLabels();
                tSDEdge.recomputeClippingPoints();
            }
        }
        iterator = this.outEdges().iterator();
        if (!this.outEdges().isEmpty()) {
            iterator = this.outEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                tSDEdge.updateBoundsOfLabels();
                tSDEdge.recomputeClippingPoints();
            }
        }
        iterator = this.buildIncidentIntergraphEdgeList(true, false, false, true).iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            tSDEdge.updateBoundsOfLabels();
            tSDEdge.recomputeClippingPoints();
        }
    }

    void notifyGraphOnInsert(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.updateGraphBoundsOnInsert(tSConstRect);
        }
    }

    void notifyGraphOnRemove(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.updateGraphBoundsOnRemove(tSConstRect);
        }
    }

    void notifyGraphOnMove(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.updateGraphBoundsOnMove(tSConstRect, this.getLocalBounds(7));
            this.recomputeClippingPoints();
        }
    }

    public void notifyGraphOnResize(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.updateGraphBoundsOnResize(tSConstRect, this.getLocalBounds(7));
        }
    }

    public void notifyAffectedLowestCommonGraphsOnCollapse(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            TSDGraph tSDGraph = (TSDGraph)tSDEdge.getTransformGraph();
            if (tSDGraph == null) continue;
            tSDGraph.updateGraphBoundsOnRemove(tSDEdge.getLocalBounds(7));
        }
    }

    public void notifyAffectedLowestCommonGraphsOnExpand(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            TSDGraph tSDGraph = (TSDGraph)tSDEdge.getTransformGraph();
            if (tSDGraph == null || !tSDEdge.isViewable()) continue;
            tSDGraph.updateGraphBoundsOnInsert(tSDEdge.getLocalBounds(7));
        }
    }

    void updateBoundsOfLabels() {
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSNodeLabel tSNodeLabel = (TSNodeLabel)f02.b();
            tSNodeLabel.updateBounds();
        }
    }

    public void ltUpdateBoundsOfLabels() {
        this.ltUpdateBoundsOfLabels(false);
    }

    public void ltUpdateBoundsOfLabels(boolean bl) {
        Object object;
        TSGraphObject tSGraphObject;
        f0 f02;
        for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSNodeLabel)f02.b();
            object = ((TSLabel)tSGraphObject).getLocalCenter();
            ((TSRectangularObjectLabel)tSGraphObject).ltShiftBounds();
            if (!bl || this.getOwnerGraph() == null) continue;
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(tSGraphObject, object, ((TSLabel)tSGraphObject).getLocalCenter())));
        }
        for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSConnector)f02.b();
            object = ((TSConnector)tSGraphObject).labels().iterator();
            while (object.hasNext()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)object.next();
                TSConstPoint tSConstPoint = tSConnectorLabel.getLocalCenter();
                tSConnectorLabel.ltShiftBounds();
                if (!bl || this.getOwnerGraph() == null) continue;
                this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(tSConnectorLabel, tSConstPoint, tSConnectorLabel.getLocalCenter())));
            }
        }
    }

    void updateNodeBoundsOnLabelMove(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        if (this.isOwned()) {
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.updateGraphBoundsOnMove(tSConstRect, tSConstRect2);
        }
    }

    void updateNodeBoundsOnLabelResize(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        if (this.isOwned()) {
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.updateGraphBoundsOnResize(tSConstRect, tSConstRect2);
        }
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        if (object instanceof TSDNode) {
            TSGraphObject tSGraphObject;
            TSGraphObject tSGraphObject2;
            Cloneable cloneable;
            TSDNode tSDNode = (TSDNode)object;
            if (tSDNode.nodeShape != null) {
                cloneable = (TSAbstractShape)tSDNode.nodeShape.clone();
                ((TSAbstractShape)cloneable).setOwner(this);
                this.setShape((TSShape)((Object)cloneable));
            }
            if (tSDNode.isExpanded()) {
                cloneable = ((TSDChildGraphForestEdge)tSDNode.getChildGraphForestEdge()).getExpandedNodeExtension();
                this.originalWidth = ((TSExpandedNodeExtension)cloneable).getPreExpandOriginalSize().getWidth();
                this.originalHeight = ((TSExpandedNodeExtension)cloneable).getPreExpandOriginalSize().getHeight();
                this.setLocalCenter(tSDNode.getLocalCenterX(), tSDNode.getLocalCenterY());
                this.setLocalSize(((TSExpandedNodeExtension)cloneable).getPreExpandSize());
            } else {
                this.originalWidth = tSDNode.getOriginalWidth();
                this.originalHeight = tSDNode.getOriginalHeight();
                this.setLocalBounds(tSDNode.getLocalBounds());
            }
            if (tSDNode.connectorSet.size() > 0) {
                for (cloneable = tSDNode.connectorSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                    tSGraphObject2 = (TSConnector)((f0)cloneable).b();
                    if (!bl) {
                        tSGraphObject = this.newConnector();
                        tSGraphObject2.setUtilityObject(tSGraphObject);
                    } else {
                        tSGraphObject = (TSConnector)tSGraphObject2.clone(true);
                    }
                    this.insert((TSConnector)tSGraphObject);
                    ((TSConnector)tSGraphObject).copy(tSGraphObject2, bl);
                }
            }
            for (cloneable = tSDNode.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                tSGraphObject2 = (TSNodeLabel)((f0)cloneable).b();
                if (!bl) {
                    tSGraphObject = this.newLabel();
                    tSGraphObject2.setUtilityObject(tSGraphObject);
                } else {
                    tSGraphObject = (TSNodeLabel)tSGraphObject2.clone(true);
                }
                this.insert((TSNodeLabel)tSGraphObject);
                ((TSRectangularObjectLabel)tSGraphObject).copy(tSGraphObject2, bl);
            }
            this.setFolderNode(tSDNode.isFolderNode());
        }
    }

    protected void createMapping(Map map, Map map2) {
        TSGraphObject tSGraphObject;
        super.createMapping(map, map2);
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSNodeLabel)iterator.next();
            if (!(tSGraphObject.getUtilityObject() instanceof TSNodeLabel)) continue;
            TSNodeLabel tSNodeLabel = (TSNodeLabel)tSGraphObject.getUtilityObject();
            TSGraph.map(tSGraphObject, tSNodeLabel, map, map2);
        }
        iterator = this.connectors().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSConnector)iterator.next();
            ((TSConnector)tSGraphObject).createMapping(map, map2);
        }
    }

    public TSConnector addConnector() {
        TSConnector tSConnector = this.newConnector();
        this.insert(tSConnector);
        return tSConnector;
    }

    public void insert(TSConnector tSConnector) {
        TSSystem.tsAssert(tSConnector != null);
        TSSystem.tsAssert(tSConnector.degree() == 0);
        TSSystem.tsAssert(!tSConnector.isOwned());
        this.connectorSet.add(tSConnector);
        tSConnector.onInsert(this);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            ((TSDGraph)tSGraphObject).updateGraphBoundsOnInsert(tSConnector.getLocalBounds(7));
        }
    }

    public void remove(TSConnector tSConnector) {
        TSSystem.tsAssert(tSConnector != null);
        TSSystem.tsAssert(tSConnector.isOwned());
        TSSystem.tsAssert(tSConnector.getOwner() == this);
        TSConstRect tSConstRect = null;
        if (this.isOwned()) {
            tSConstRect = tSConnector.getLocalBounds(7);
        }
        this.connectorSet.remove(tSConnector);
        tSConnector.onRemove(this);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            ((TSDGraph)tSGraphObject).updateGraphBoundsOnRemove(tSConstRect);
        }
    }

    void onConnectorBecomesInserted(TSConnector tSConnector) {
        if (this.isOwned()) {
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.connectorLabelCount += tSConnector.numberOfLabels();
        }
    }

    void onConnectorBecomesRemoved(TSConnector tSConnector) {
        if (this.isOwned()) {
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            tSDGraph.connectorLabelCount -= tSConnector.numberOfLabels();
        }
    }

    public void discard(TSConnector tSConnector) {
        TSSystem.tsAssert(tSConnector != null);
        TSSystem.tsAssert(tSConnector.isOwned());
        TSSystem.tsAssert(tSConnector.getOwner() == this);
        if (this.getOwnerGraph() != null && this.getOwnerGraph().isFiringEvents()) {
            this.getOwnerGraph().setFireEvents(false);
            this.remove(tSConnector);
            this.getOwnerGraph().setFireEvents(true);
        } else {
            this.remove(tSConnector);
        }
        tSConnector.onDiscard(this);
    }

    protected TSConnector newConnector() {
        return new TSConnector();
    }

    public int numberOfConnectors() {
        return this.connectorSet.size();
    }

    public List connectors() {
        return this.connectorSet;
    }

    public boolean isOverConnector(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        return this.isLocallyOverConnector(tSPoint);
    }

    public boolean isLocallyOverConnector(TSConstPoint tSConstPoint) {
        for (f0 f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            TSConnector tSConnector = (TSConnector)f02.b();
            if (!tSConnector.isVisible() || !tSConnector.locallyContains(tSConstPoint)) continue;
            return true;
        }
        return false;
    }

    public void discardAllConnectors() {
        while (this.connectorSet.size() > 0) {
            this.discard((TSConnector)this.connectorSet.d());
        }
    }

    public boolean isOverLabel(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        return this.isLocallyOverLabel(tSPoint);
    }

    public boolean isLocallyOverLabel(TSConstPoint tSConstPoint) {
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSNodeLabel tSNodeLabel = (TSNodeLabel)f02.b();
            if (!tSNodeLabel.isVisible() || !tSNodeLabel.locallyContains(tSConstPoint)) continue;
            return true;
        }
        return false;
    }

    public TSShape getShape() {
        if (this.nodeShape == null) {
            return this.getLocalBounds();
        }
        return this.nodeShape;
    }

    public void setShape(TSShape tSShape) {
        TSAbstractShape tSAbstractShape = this.nodeShape;
        if (tSShape != tSAbstractShape) {
            TSAbstractShape tSAbstractShape2 = null;
            if (tSShape instanceof TSAbstractShape) {
                TSAbstractShape tSAbstractShape3;
                this.nodeShape = tSAbstractShape3 = (TSAbstractShape)tSShape;
                tSAbstractShape3.setOwner(this);
                tSAbstractShape2 = tSAbstractShape3;
            } else {
                this.nodeShape = null;
            }
            this.recomputeClippingPoints();
            if (this.isOwned() && this.getOwnerGraph() != null) {
                this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(524288L, new TSDrawingChangeEventData(this, tSAbstractShape, tSAbstractShape2)));
            }
        }
    }

    public boolean userObjectInUse() {
        boolean bl = super.userObjectInUse();
        Iterator iterator = this.connectors().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSConnector)iterator.next()).userObjectInUse();
        }
        iterator = this.labels().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSNodeLabel)iterator.next()).userObjectInUse();
        }
        return bl;
    }

    public void nullifyUserObject() {
        super.nullifyUserObject();
        Iterator iterator = this.connectors().iterator();
        while (iterator.hasNext()) {
            ((TSConnector)iterator.next()).nullifyUserObject();
        }
        iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            ((TSNodeLabel)iterator.next()).nullifyUserObject();
        }
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        TSGraphObject tSGraphObject;
        f0 f02;
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSConnector)f02.b();
            l = ((TSConnector)tSGraphObject).assignIDs(tSGraphObjectTable, l);
        }
        for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSNodeLabel)f02.b();
            l = ((TSLabel)tSGraphObject).assignIDs(tSGraphObjectTable, l);
        }
        return l;
    }

    public void nullifyUtilityObject() {
        TSGraphObject tSGraphObject;
        f0 f02;
        super.nullifyUtilityObject();
        for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSConnector)f02.b();
            ((TSConnector)tSGraphObject).nullifyUtilityObject();
        }
        for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSNodeLabel)f02.b();
            tSGraphObject.nullifyUtilityObject();
        }
    }

    public boolean utilityObjectInUse() {
        boolean bl = super.utilityObjectInUse();
        Iterator iterator = this.connectors().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSConnector)iterator.next()).utilityObjectInUse();
        }
        iterator = this.labels().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSNodeLabel)iterator.next()).utilityObjectInUse();
        }
        return bl;
    }

    public void setAllMarked(boolean bl) {
        TSGraphObject tSGraphObject;
        f0 f02;
        super.setAllMarked(bl);
        for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSConnector)f02.b();
            ((TSConnector)tSGraphObject).setAllMarked(bl);
        }
        for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSNodeLabel)f02.b();
            tSGraphObject.setMarked(bl);
        }
    }

    public boolean hasMarkedObject() {
        TSGraphObject tSGraphObject;
        f0 f02;
        if (super.hasMarkedObject()) {
            return true;
        }
        for (f02 = this.connectorSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSConnector)f02.b();
            if (!((TSConnector)tSGraphObject).hasMarkedObject()) continue;
            return true;
        }
        for (f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            tSGraphObject = (TSNodeLabel)f02.b();
            if (!tSGraphObject.isMarked()) continue;
            return true;
        }
        return false;
    }

    public void assignCenter(double d, double d2) {
        this.nodeBounds.setCenter(d, d2);
        this.recomputeClippingPoints();
    }

    public void assignSize(double d, double d2) {
        this.nodeBounds.setSize(d, d2);
        this.recomputeClippingPoints();
    }

    public void assignOriginalSize(double d, double d2) {
        this.originalWidth = d;
        this.originalHeight = d2;
    }

    public void assignBounds(double d, double d2, double d3, double d4) {
        this.nodeBounds.setBounds(d, d2, d3, d4);
        this.recomputeClippingPoints();
    }

    public TSRect adjustBounds(double d, double d2, double d3, double d4, TSRect tSRect) {
        if (tSRect == null) {
            tSRect = new TSRect();
        }
        tSRect.setSize(this.adjustSize(d3 - d, d4 - d2, null));
        tSRect.setCenter((d + d3) / 2.0, (d2 + d4) / 2.0);
        return tSRect;
    }

    public TSSize adjustSize(double d, double d2, double d3, double d4, TSSize tSSize) {
        if (tSSize == null) {
            tSSize = new TSSize();
        }
        tSSize.setSize(this.getLocalSize());
        return tSSize;
    }

    public TSSize adjustSize(double d, double d2, TSSize tSSize) {
        return this.adjustSize(d, d2, this.getLocalWidth(), this.getLocalHeight(), tSSize);
    }

    public void recomputeClippingPoints() {
        Iterator iterator = this.inEdges().iterator();
        while (iterator.hasNext()) {
            ((TSDEdge)iterator.next()).recomputeClippingPoints();
        }
        iterator = this.outEdges().iterator();
        while (iterator.hasNext()) {
            ((TSDEdge)iterator.next()).recomputeClippingPoints();
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            ((TSDEdge)iterator.next()).recomputeClippingPoints();
        }
        iterator = this.buildIncidentIntergraphEdgeList(false, true, false, true).iterator();
        while (iterator.hasNext()) {
            ((TSDEdge)iterator.next()).recomputeClippingPoints();
        }
    }

    public void adjustIncidentClippings() {
        TSEdge tSEdge;
        Iterator iterator = this.inEdges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            if (!(tSEdge instanceof TSDEdge)) continue;
            ((TSDEdge)tSEdge).adjustClipping(false);
        }
        iterator = this.outEdges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            if (!(tSEdge instanceof TSDEdge)) continue;
            ((TSDEdge)tSEdge).adjustClipping(true);
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSEdge = (TSEdge)iterator.next();
            if (!(tSEdge instanceof TSDEdge)) continue;
            TSDEdge tSDEdge = (TSDEdge)tSEdge;
            if (tSDEdge.getSourceNode() == this) {
                if (tSDEdge.isIntergraphEdge() && tSDEdge.isViewable()) {
                    tSDEdge.adjustClipping(true);
                    continue;
                }
                tSDEdge.discardCalculatedSourceClipping();
                continue;
            }
            if (tSDEdge.getTargetNode() != this) continue;
            if (tSDEdge.isIntergraphEdge() && tSDEdge.isViewable()) {
                tSDEdge.adjustClipping(false);
                continue;
            }
            tSDEdge.discardCalculatedTargetClipping();
        }
    }

    public void setChildGraph(TSGraph tSGraph) {
        f2.a(f2.a5);
        if (this.getChildGraph() != tSGraph) {
            if (tSGraph != null && (tSGraph.isChildGraph() || tSGraph.isHideGraph() || tSGraph.isIntergraph())) {
                throw new IllegalStateException();
            }
            if (this.hasChildGraph() && this.isExpanded()) {
                TSNestingManager.collapse(this);
            }
            super.setChildGraph(tSGraph);
        }
    }

    public TSGraphMember getViewableParentIn(TSGraph tSGraph) {
        if (tSGraph == null) {
            return null;
        }
        TSGraph tSGraph2 = this.getOwnerGraph();
        TSGraphMember tSGraphMember = this;
        while (tSGraph2 != tSGraph && (tSGraph2 == null || !(tSGraph2.getParent() instanceof TSDNode) || tSGraph2.isViewable() || (tSGraphMember = tSGraph2.getParent()) != null && tSGraphMember.isOwned())) {
            tSGraph2 = tSGraph2.getParent().getOwnerGraph();
        }
        return tSGraphMember;
    }

    public boolean isCollapsed() {
        return TSNestingManager.isCollapsed(this);
    }

    public boolean isExpanded() {
        return TSNestingManager.isExpanded(this);
    }

    public boolean isViewable() {
        return this.isOwned() && this.getOwnerGraph().isViewable();
    }

    public boolean isReachable() {
        if (!this.isOwned() || this.getOwner() == null) {
            return false;
        }
        return ((TSDGraph)this.getOwnerGraph()).isReachable();
    }

    public TSDEdge metaEdgeTo(TSDNode tSDNode) {
        TSDEdge tSDEdge;
        Iterator iterator = this.outEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isMetaEdge() || tSDEdge.getTargetNode() != tSDNode) continue;
            return tSDEdge;
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (!tSDEdge.isMetaEdge() || tSDEdge.getTargetNode() != tSDNode) continue;
            return tSDEdge;
        }
        return null;
    }

    public TSExpandedNodeExtension expandedNodeExtension() {
        TSExpandedNodeExtension tSExpandedNodeExtension = null;
        if (this.isExpanded()) {
            tSExpandedNodeExtension = ((TSDChildGraphForestEdge)this.getChildGraphForestEdge()).getExpandedNodeExtension();
        }
        return tSExpandedNodeExtension;
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }
}

