/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.util.TSSystem;

public abstract class TSGEdge
extends TSEdge
implements TSGeometricObject {
    public double getProjectionPoint(TSConstPoint tSConstPoint, TSPoint tSPoint) {
        TSPoint tSPoint2 = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint2);
        }
        double d = this.getLocalProjectionPoint(tSPoint2, tSPoint);
        TSSize tSSize = new TSSize(d, d);
        if (tSDGraph != null) {
            tSDGraph.expandedTransformSize(tSSize);
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSSize.getWidth();
    }

    public double getLocalProjectionPoint(TSConstPoint tSConstPoint, TSPoint tSPoint) {
        TSSystem.tsAssert(tSPoint != null);
        TSSystem.tsAssert(this.isPathEdge());
        TSConstPoint tSConstPoint2 = this.getLocalSourcePoint();
        TSConstPoint tSConstPoint3 = this.getLocalTargetPoint();
        double d = tSConstPoint2.getX();
        double d2 = tSConstPoint2.getY();
        double d3 = tSConstPoint3.getX();
        double d4 = tSConstPoint3.getY();
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = tSConstPoint.getX() - d;
        double d8 = tSConstPoint.getY() - d2;
        double d9 = d5 * d5 + d6 * d6;
        if (d9 != 0.0) {
            d9 = (d7 * d5 + d8 * d6) / d9;
        }
        if (d9 <= 0.0) {
            d9 = 0.0;
            tSPoint.setLocation(d, d2);
        } else if (d9 >= 1.0) {
            d9 = 1.0;
            tSPoint.setLocation(d3, d4);
        } else {
            tSPoint.setLocation(d + d9 * d5, d2 + d9 * d6);
        }
        return d9 * Math.sqrt(d5 * d5 + d6 * d6);
    }

    public TSConstPoint getPointOnEdge(double d) {
        TSPoint tSPoint = new TSPoint(this.getLocalPointOnEdge(d));
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalPointOnEdge(double d) {
        TSSystem.tsAssert(this.isPathEdge());
        if (d <= 0.0) {
            return this.getLocalSourcePoint();
        }
        if (d >= 1.0) {
            return this.getLocalTargetPoint();
        }
        TSConstPoint tSConstPoint = this.getLocalSourcePoint();
        TSConstPoint tSConstPoint2 = this.getLocalTargetPoint();
        double d2 = tSConstPoint.getX();
        double d3 = tSConstPoint2.getX();
        double d4 = tSConstPoint.getY();
        double d5 = tSConstPoint2.getY();
        return new TSConstPoint(d2 + d * (d3 - d2), d4 + d * (d5 - d4));
    }

    public double getXOnEdge(double d) {
        return this.getPointOnEdge(d).getX();
    }

    public double getLocalXOnEdge(double d) {
        return this.getLocalPointOnEdge(d).getX();
    }

    public double getYOnEdge(double d) {
        return this.getPointOnEdge(d).getY();
    }

    public double getLocalYOnEdge(double d) {
        return this.getLocalPointOnEdge(d).getY();
    }

    public double getBottom() {
        double d = this.getLocalBottom();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom() {
        return this.getLocalBounds().getBottom();
    }

    public double getLeft() {
        double d = this.getLocalLeft();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft() {
        return this.getLocalBounds().getLeft();
    }

    public double getRight() {
        double d = this.getLocalRight();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight() {
        return this.getLocalBounds().getRight();
    }

    public double getTop() {
        double d = this.getLocalTop();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop() {
        return this.getLocalBounds().getTop();
    }

    public double getWidth() {
        return this.getLocalWidth();
    }

    public double getLocalWidth() {
        return this.getLocalRight() - this.getLocalLeft();
    }

    public double getHeight() {
        return this.getLocalHeight();
    }

    public double getLocalHeight() {
        return this.getLocalTop() - this.getLocalBottom();
    }

    public double getSourceX() {
        return this.getSourcePoint().getX();
    }

    public double getSourceY() {
        return this.getSourcePoint().getY();
    }

    public double getLocalSourceX() {
        return this.getLocalSourcePoint().getX();
    }

    public double getLocalSourceY() {
        return this.getLocalSourcePoint().getY();
    }

    public TSConstPoint getSourcePoint() {
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        TSPoint tSPoint = new TSPoint(this.getLocalSourcePoint());
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public abstract TSConstPoint getLocalSourcePoint();

    public double getTargetX() {
        return this.getTargetPoint().getX();
    }

    public double getTargetY() {
        return this.getTargetPoint().getY();
    }

    public double getLocalTargetX() {
        return this.getLocalTargetPoint().getX();
    }

    public double getLocalTargetY() {
        return this.getLocalTargetPoint().getY();
    }

    public TSConstPoint getTargetPoint() {
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        TSPoint tSPoint = new TSPoint(this.getLocalTargetPoint());
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public abstract TSConstPoint getLocalTargetPoint();

    protected String getAttributeString() {
        return super.getAttributeString() + TSSystem.eol + "\tbounds = " + this.getLocalBounds();
    }

    public TSGraph getTransformGraph() {
        TSDGraph tSDGraph;
        TSGEdge tSGEdge = this.isPathEdge() ? (TSGEdge)this.getOwner() : this;
        if (tSGEdge.isIntergraphEdge()) {
            TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraph().getOwnerGraphManager();
            tSDGraph = (TSDGraph)tSDGraphManager.getCommonOwnerGraph(tSGEdge);
        } else {
            tSDGraph = (TSDGraph)this.getOwnerGraph();
        }
        return tSDGraph;
    }

    public int levelNumber() {
        return 1;
    }

    public abstract TSConstRect getLocalBounds();
}

