/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.util.TSSystem;

public abstract class TSLabel
extends TSGraphObject
implements TSSolidGeometricObject {
    protected TSRect labelBounds;

    protected TSLabel() {
    }

    protected TSLabel(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.labelBounds = new TSRect();
        double d = this.getLocalDefaultWidth() / 2.0;
        double d2 = this.getLocalDefaultHeight() / 2.0;
        this.assignBounds(-d, -d2, d, d2);
    }

    protected void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        if (tSGraphObject.getOwnerGraph() != null) {
            tSGraphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(2L, new TSDrawingChangeEventData(this, null, tSGraphObject)));
        }
    }

    protected void onRemove(TSGraphObject tSGraphObject) {
        if (tSGraphObject.getOwnerGraph() != null) {
            tSGraphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(16L, new TSDrawingChangeEventData(this, tSGraphObject, null)));
        }
        super.onRemove(tSGraphObject);
    }

    protected void onDiscard(TSGraphObject tSGraphObject) {
        tSGraphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(128L, new TSDrawingChangeEventData(this, tSGraphObject, null)));
        super.onDiscard(tSGraphObject);
    }

    public boolean isViewable() {
        return this.isOwned() && this.getOwner().isViewable();
    }

    public boolean inside(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformRect(tSRect);
        }
        return this.locallyInside(tSRect);
    }

    public boolean locallyInside(TSConstRect tSConstRect) {
        return tSConstRect.contains(this.getLocalBounds());
    }

    public boolean contains(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint.getX(), tSConstPoint.getY());
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformPoint(tSPoint);
        }
        return this.locallyContains(tSPoint);
    }

    public boolean locallyContains(TSConstPoint tSConstPoint) {
        return this.labelBounds.contains(tSConstPoint);
    }

    public boolean contains(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformPoint(tSPoint);
        }
        return this.locallyContains(tSPoint.getX(), tSPoint.getY());
    }

    public boolean locallyContains(double d, double d2) {
        return this.labelBounds.contains(d, d2);
    }

    public boolean contains(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformRect(tSRect);
        }
        return this.locallyContains(tSRect);
    }

    public boolean locallyContains(TSConstRect tSConstRect) {
        return this.labelBounds.contains(tSConstRect);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformRect(tSRect);
        }
        return this.locallyContains(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyContains(double d, double d2, double d3, double d4) {
        return this.labelBounds.contains(d, d2, d3, d4);
    }

    public boolean intersects(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect);
    }

    public boolean locallyIntersects(TSConstRect tSConstRect) {
        return this.labelBounds.intersects(tSConstRect);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        return this.labelBounds.intersects(d, d2, d3, d4);
    }

    public void setWidth(double d) {
        this.setLocalWidth(d);
    }

    public void setLocalWidth(double d) {
        this.setLocalSize(d, this.getLocalHeight());
    }

    public void setHeight(double d) {
        this.setLocalHeight(d);
    }

    public void setLocalHeight(double d) {
        this.setLocalSize(this.getLocalWidth(), d);
    }

    public void setSize(TSConstSize tSConstSize) {
        this.setLocalSize(tSConstSize);
    }

    public void setLocalSize(TSConstSize tSConstSize) {
        this.setLocalSize(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void setSize(double d, double d2) {
        this.setLocalSize(d, d2);
    }

    public void setLocalSize(double d, double d2) {
        this.assignSize(d, d2);
    }

    public void setBounds(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformRect(tSRect);
        }
        this.setLocalBounds(tSRect);
    }

    public void setLocalBounds(TSConstRect tSConstRect) {
        this.setLocalSize(tSConstRect.getWidth(), tSConstRect.getHeight());
        this.setLocalCenter(tSConstRect.getCenterX(), tSConstRect.getCenterY());
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformRect(tSRect);
        }
        this.setLocalBounds(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public void setLocalBounds(double d, double d2, double d3, double d4) {
        this.setLocalSize(d3 - d, d4 - d2);
        this.setLocalCenter((d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    public void setCenter(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenter(tSPoint);
    }

    public void setLocalCenter(TSConstPoint tSConstPoint) {
        this.setLocalCenter(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public void setLocalCenterX(double d) {
        this.setLocalCenter(d, this.getLocalCenterY());
    }

    public void setLocalCenterY(double d) {
        this.setLocalCenter(this.getLocalCenterX(), d);
    }

    public void setCenterX(double d) {
        this.setCenter(d, this.getCenterY());
    }

    public void setCenterY(double d) {
        this.setCenter(this.getCenterX(), d);
    }

    public void setCenter(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenter(tSPoint.getX(), tSPoint.getY());
    }

    public void setLocalCenter(double d, double d2) {
        this.assignCenter(d, d2);
    }

    public void moveBy(TSConstSize tSConstSize) {
        this.moveBy(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void moveByLocal(TSConstSize tSConstSize) {
        this.moveByLocal(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void moveBy(double d, double d2) {
        this.moveByLocal(d, d2);
    }

    public void moveByLocal(double d, double d2) {
        this.setLocalCenter(this.getLocalCenterX() + d, this.getLocalCenterY() + d2);
    }

    public TSConstRect getBounds() {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds() {
        return new TSConstRect(this.labelBounds);
    }

    public void mergeLocalBounds(TSRect tSRect) {
        tSRect.merge(this.labelBounds);
    }

    public TSConstPoint getCenter() {
        TSPoint tSPoint = new TSPoint(this.getLocalCenter());
        if (this.isOwned() && this.getOwner().isOwned()) {
            this.getTransformGraph().expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalCenter() {
        return this.labelBounds.getCenter();
    }

    public TSConstSize getSize() {
        return this.getLocalSize();
    }

    public TSConstSize getLocalSize() {
        return this.labelBounds.getSize();
    }

    public abstract TSConstPoint getAttachmentPoint();

    public abstract TSConstPoint getLocalAttachmentPoint();

    public abstract TSConstPoint getDrawableAttachmentPoint();

    public double getBottom() {
        double d = this.getLocalBottom();
        if (this.isOwned() && this.getOwner().isOwned()) {
            d = this.getTransformGraph().expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom() {
        return this.labelBounds.getBottom();
    }

    public double getCenterX() {
        double d = this.getLocalCenterX();
        if (this.isOwned() && this.getOwner().isOwned()) {
            d = this.getTransformGraph().expandedTransformX(d);
        }
        return d;
    }

    public double getLocalCenterX() {
        return this.labelBounds.getCenterX();
    }

    public double getCenterY() {
        double d = this.getLocalCenterY();
        if (this.isOwned() && this.getOwner().isOwned()) {
            d = this.getTransformGraph().expandedTransformY(d);
        }
        return d;
    }

    public double getLocalCenterY() {
        return this.labelBounds.getCenterY();
    }

    public double getHeight() {
        return this.getLocalHeight();
    }

    public double getLocalHeight() {
        return this.labelBounds.getHeight();
    }

    public double getLeft() {
        double d = this.getLocalLeft();
        if (this.isOwned() && this.getOwner().isOwned()) {
            d = this.getTransformGraph().expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft() {
        return this.labelBounds.getLeft();
    }

    public double getRight() {
        double d = this.getLocalRight();
        if (this.isOwned() && this.getOwner().isOwned()) {
            d = this.getTransformGraph().expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight() {
        return this.labelBounds.getRight();
    }

    public double getTop() {
        double d = this.getLocalTop();
        if (this.isOwned() && this.getOwner().isOwned()) {
            d = this.getTransformGraph().expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop() {
        return this.labelBounds.getTop();
    }

    public double getWidth() {
        return this.getLocalWidth();
    }

    public double getLocalWidth() {
        return this.labelBounds.getWidth();
    }

    public double getLocalDefaultWidth() {
        return 16.0;
    }

    public double getLocalDefaultHeight() {
        return 10.0;
    }

    public TSDGraph getTransformGraph() {
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        return tSDGraph;
    }

    public TSGraph getOwnerGraph() {
        TSGraphObject tSGraphObject = this.getOwner();
        if (tSGraphObject == null) {
            return null;
        }
        return (TSGraph)tSGraphObject.getOwner();
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        TSLabel tSLabel = (TSLabel)object;
        this.setLocalBounds(tSLabel.getLocalBounds());
    }

    public void assignCenter(double d, double d2) {
        this.labelBounds.setCenter(d, d2);
    }

    public void assignSize(double d, double d2) {
        this.labelBounds.setSize(d, d2);
    }

    public void assignBounds(double d, double d2, double d3, double d4) {
        this.labelBounds.setBounds(d, d2, d3, d4);
    }

    public TSRect adjustBounds(double d, double d2, double d3, double d4, TSRect tSRect) {
        if (tSRect == null) {
            tSRect = new TSRect();
        }
        tSRect.setSize(this.adjustSize(d3 - d, d4 - d2, null));
        tSRect.setCenter((d + d3) / 2.0, (d2 + d4) / 2.0);
        return tSRect;
    }

    public TSSize adjustSize(double d, double d2, double d3, double d4, TSSize tSSize) {
        if (tSSize == null) {
            tSSize = new TSSize();
        }
        tSSize.setSize(this.getLocalSize());
        return tSSize;
    }

    public TSSize adjustSize(double d, double d2, TSSize tSSize) {
        return this.adjustSize(d, d2, this.getLocalWidth(), this.getLocalHeight(), tSSize);
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setText(String string) {
        this.setTag(string);
    }

    public void setTag(Object object) {
        Object object2 = this.getTag();
        super.setTag(object);
        if (this.getOwnerGraph() != null && !TSSystem.equals(object2, object)) {
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(1024L, new TSDrawingChangeEventData(this, object2, object)));
        }
    }

    public void dispose() {
        if (this.isOwned()) {
            TSGraphObject tSGraphObject = this.getOwner();
            if (tSGraphObject instanceof TSDEdge) {
                ((TSDEdge)tSGraphObject).discard(this);
            } else if (tSGraphObject instanceof TSDNode) {
                ((TSDNode)tSGraphObject).discard(this);
            }
        } else if (!this.isDiscarded()) {
            this.onDiscard(this.getOwner());
        }
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        return l;
    }
}

