/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSAbstractShape;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstSegment;
import com.tomsawyer.drawing.geometry.TSPoint;

public class TSOvalShape
extends TSAbstractShape {
    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.getOwner() == null) {
            d6 = 100.0 / 2.0;
            d5 = 100.0 / 2.0;
            d4 = 100.0;
            d3 = 100.0;
        } else {
            d6 = this.getOwner().getLocalCenterX();
            d5 = this.getOwner().getLocalCenterY();
            d4 = this.getOwner().getLocalWidth();
            d3 = this.getOwner().getLocalHeight();
        }
        double d7 = (d - d6) / d4;
        double d8 = (d2 - d5) / d3;
        return d7 * d7 + d8 * d8 <= 0.25;
    }

    public TSConstPoint intersection(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        TSPoint tSPoint = null;
        if (this.getOwner() == null) {
            d8 = 100.0 / 2.0;
            d7 = 100.0 / 2.0;
            d6 = 100.0;
            d5 = 100.0;
        } else {
            d8 = this.getOwner().getLocalCenterX();
            d7 = this.getOwner().getLocalCenterY();
            d6 = this.getOwner().getLocalWidth();
            d5 = this.getOwner().getLocalHeight();
        }
        tSPoint = TSOvalShape.intersection(d, d2, d3, d4, d8, d7, d6, d5);
        return tSPoint;
    }

    public double xIntersection(double d, double d2, double d3, double d4) {
        double d5 = Double.NaN;
        TSConstPoint tSConstPoint = this.intersection(d, d2, d3, d4);
        if (tSConstPoint != null) {
            d5 = tSConstPoint.getX();
        }
        return d5;
    }

    public double yIntersection(double d, double d2, double d3, double d4) {
        double d5 = Double.NaN;
        TSConstPoint tSConstPoint = this.intersection(d, d2, d3, d4);
        if (tSConstPoint != null) {
            d5 = tSConstPoint.getY();
        }
        return d5;
    }

    private static TSPoint intersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        TSPoint tSPoint = null;
        double d9 = 1.0E-13;
        d7 /= 2.0;
        d8 /= 2.0;
        double d10 = Math.max(Math.abs(d -= d5), Math.abs(d3 -= d5));
        double d11 = Math.max(Math.abs(d2 -= d6), Math.abs(d4 -= d6));
        if (d10 * d9 > d7) {
            double d12 = TSConstSegment.horizontalSegmentIntersection(d, d2, d3, d4, 0.0, -d7, d7);
            if (!Double.isNaN(d12)) {
                tSPoint = new TSPoint(d12, 0.0);
            }
        } else if (d11 * d9 > d8) {
            double d13 = TSConstSegment.verticalSegmentIntersection(d, d2, d3, d4, 0.0, -d7, d7);
            if (!Double.isNaN(d13)) {
                tSPoint = new TSPoint(0.0, d13);
            }
        } else {
            double d14 = d3 - d;
            double d15 = d7 * d7;
            double d16 = d4 - d2;
            double d17 = d8 * d8;
            double d18 = d * d14 / d15 + d2 * d16 / d17;
            double d19 = d14 * d14 / d15 + d16 * d16 / d17;
            double d20 = d * d / d15 + d2 * d2 / d17 - 1.0;
            double d21 = d18 * d18 - d19 * d20;
            if (d21 >= 0.0) {
                double d22 = Math.sqrt(d21);
                double d23 = (-d18 - d22) / d19;
                double d24 = (-d18 + d22) / d19;
                double d25 = d24;
                if (d25 > 1.0) {
                    d25 = d23;
                }
                if (d25 >= 0.0 && d25 <= 1.0) {
                    tSPoint = new TSPoint(d + d14 * d25, d2 + d16 * d25);
                }
            }
        }
        if (tSPoint != null) {
            tSPoint.moveBy(d5, d6);
        }
        return tSPoint;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof TSOvalShape;
    }
}

