/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;

public class TSPEdge
extends TSGEdge {
    protected TSPEdge() {
    }

    public TSConstRect getBounds() {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds() {
        return new TSConstRect(this.getLocalSourcePoint(), this.getLocalTargetPoint());
    }

    public TSConstPoint getLocalSourcePoint() {
        TSDEdge tSDEdge = (TSDEdge)this.getOwner();
        TSConstPoint tSConstPoint = this == tSDEdge.getSourceEdge() ? tSDEdge.getLocalSourcePoint() : ((TSGNode)this.getSourceNode()).getLocalCenter();
        return tSConstPoint;
    }

    public TSConstPoint getLocalTargetPoint() {
        TSDEdge tSDEdge = (TSDEdge)this.getOwner();
        TSConstPoint tSConstPoint = this == tSDEdge.getTargetEdge() ? tSDEdge.getLocalTargetPoint() : ((TSGNode)this.getTargetNode()).getLocalCenter();
        return tSConstPoint;
    }

    public boolean intersects(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect);
    }

    public boolean locallyIntersects(TSConstRect tSConstRect) {
        TSConstPoint tSConstPoint = this.getLocalSourcePoint();
        TSConstPoint tSConstPoint2 = this.getLocalTargetPoint();
        return tSConstRect.intersectsLine(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect);
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        TSConstPoint tSConstPoint = this.getLocalSourcePoint();
        TSConstPoint tSConstPoint2 = this.getLocalTargetPoint();
        return TSConstRect.intersectsLine(d, d2, d3, d4, tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY());
    }

    public boolean inside(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyInside(tSRect);
    }

    public boolean locallyInside(TSConstRect tSConstRect) {
        return tSConstRect.contains(this.getLocalBounds());
    }

    protected boolean isAttachableTo(TSGraphObject tSGraphObject) {
        TSSystem.tsAssert(tSGraphObject != null, "null potential owner");
        TSGNode tSGNode = (TSGNode)this.getSourceNode();
        TSGNode tSGNode2 = (TSGNode)this.getTargetNode();
        if (tSGNode == null || !tSGNode.isOwned()) {
            return false;
        }
        if (tSGNode2 == null || !tSGNode2.isOwned()) {
            return false;
        }
        if (!this.isOwned() || this.getOwner() != tSGraphObject) {
            return false;
        }
        if (tSGNode.isPathNode() ? tSGNode.getOwner() != tSGraphObject : tSGNode != ((TSDEdge)tSGraphObject).getSourceNode()) {
            return false;
        }
        return !(tSGNode2.isPathNode() ? tSGNode2.getOwner() != tSGraphObject : tSGNode2 != ((TSDEdge)tSGraphObject).getTargetNode());
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return TSConstPoint.distanceSquared(this.getLocalSourcePoint(), this.getLocalTargetPoint());
    }

    public boolean isPathEdge() {
        return true;
    }

    public void connect() {
        TSSystem.tsAssert(this.getSourceNode() != null);
        TSSystem.tsAssert(this.getTargetNode() != null);
        if (!this.isConnected()) {
            if (this.getSourceNode() != null) {
                this.getSourceNode().onEdgeBecomesConnected(this);
            }
            if (this.getTargetNode() != null && this.getSourceNode() != this.getTargetNode()) {
                this.getTargetNode().onEdgeBecomesConnected(this);
            }
            this.setConnected(true);
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            if (this.getSourceNode() != null) {
                this.getSourceNode().onEdgeBecomesDisconnected(this);
            }
            if (this.getTargetNode() != null && this.getSourceNode() != this.getTargetNode()) {
                this.getTargetNode().onEdgeBecomesDisconnected(this);
            }
            this.setConnected(false);
        }
    }

    public void dispose() {
        if (this.isOwned()) {
            TSDEdge tSDEdge = (TSDEdge)this.getOwner();
            tSDEdge.discard(this);
        } else if (!this.isDiscarded()) {
            this.onDiscard(this.getOwner());
        }
    }

    public boolean isVisible() {
        return this.getOwner().isVisible();
    }

    public void fireEndNodeChangedEvent(Object object, Object object2) {
    }
}

