/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSAddConnectorLabelCommand
extends TSCommand {
    double x;
    double y;
    String direction;
    double distance;
    boolean isSetByCenter;
    String text;
    TSConnector connector;
    TSConnectorLabel label;
    List graphs;
    List margins;

    public TSAddConnectorLabelCommand(TSConnector tSConnector, double d, double d2, String string) {
        this.connector = tSConnector;
        this.x = d;
        this.y = d2;
        this.text = string;
        this.isSetByCenter = true;
    }

    public TSAddConnectorLabelCommand(TSConnector tSConnector, String string, double d, String string2) {
        this.connector = tSConnector;
        this.direction = string;
        this.distance = d;
        this.text = string2;
        this.isSetByCenter = false;
    }

    protected void doAction() throws Throwable {
        TSGraph tSGraph = this.connector.getOwnerGraph();
        boolean bl = tSGraph.isFiringEvents();
        tSGraph.setFireEvents(false);
        this.storeOldMargins();
        this.label = this.connector.addLabel();
        this.label.setText(this.text);
        if (this.isSetByCenter) {
            this.label.setCenter(this.x, this.y);
        } else {
            this.label.setOffset(this.direction, this.distance);
        }
        this.connector.remove(this.label);
        tSGraph.setFireEvents(bl);
        TSDrawingChangeEvent tSDrawingChangeEvent = new TSDrawingChangeEvent(2L, new TSDrawingChangeEventData(this.label, null, this.connector));
        if (tSGraph.fireEvent(tSDrawingChangeEvent, true)) {
            this.connector.insert(this.label);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.connector.remove(this.label);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        this.connector.insert(this.label);
    }

    public List getAffectedObjects() {
        Vector<TSConnectorLabel> vector = new Vector<TSConnectorLabel>();
        if (this.label != null) {
            vector.add(this.label);
        }
        return vector;
    }

    protected void undoCleanup() {
        if (!this.label.isOwned()) {
            this.label.dispose();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String getText() {
        return this.text;
    }

    public TSConnector getConnector() {
        return this.connector;
    }

    public TSConnectorLabel getConnectorLabel() {
        return this.label;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager;
        if (this.connector.getOwner() != null && this.connector.getOwner().getOwner() != null && (tSDGraphManager = (TSDGraphManager)this.connector.getOwner().getOwner().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

