/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSAddEdgeLabelCommand
extends TSCommand {
    double x;
    double y;
    String text;
    TSDEdge edge;
    TSEdgeLabel label;
    List graphs;
    List margins;

    public TSAddEdgeLabelCommand(TSDEdge tSDEdge, double d, double d2, String string) {
        this.edge = tSDEdge;
        this.x = d;
        this.y = d2;
        this.text = string;
    }

    protected void doAction() throws Throwable {
        TSGraph tSGraph = this.edge.getOwnerGraph();
        boolean bl = tSGraph.isFiringEvents();
        tSGraph.setFireEvents(false);
        this.storeOldMargins();
        this.label = this.edge.addLabel();
        TSConstSize tSConstSize = this.label.getLocalOffset();
        this.label.setText(this.text);
        this.label.setCenter(this.x, this.y);
        this.label.setLocalOffset(tSConstSize);
        this.edge.remove(this.label);
        tSGraph.setFireEvents(bl);
        TSDrawingChangeEvent tSDrawingChangeEvent = new TSDrawingChangeEvent(2L, new TSDrawingChangeEventData(this.label, null, this.edge));
        if (tSGraph.fireEvent(tSDrawingChangeEvent, true)) {
            this.edge.insert(this.label);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.edge.remove(this.label);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        this.edge.insert(this.label);
    }

    public List getAffectedObjects() {
        Vector<TSEdgeLabel> vector = new Vector<TSEdgeLabel>();
        if (this.label != null) {
            vector.add(this.label);
        }
        return vector;
    }

    protected void undoCleanup() {
        if (!this.label.isOwned()) {
            this.label.dispose();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String getText() {
        return this.text;
    }

    public TSDEdge getEdge() {
        return this.edge;
    }

    public TSEdgeLabel getEdgeLabel() {
        return this.label;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager;
        if (this.edge.getOwner() != null && (tSDGraphManager = (TSDGraphManager)this.edge.getOwner().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

