/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSAddPNodeCommand
extends TSCommand {
    TSDEdge ownerEdge;
    TSPNode bend;
    TSConstPoint location;
    TSPEdge pathEdge;
    int pNodeIndex;
    TSPEdge extraPath;
    List graphs;
    List margins;

    public TSAddPNodeCommand(double d, double d2, TSPEdge tSPEdge) {
        this.ownerEdge = (TSDEdge)tSPEdge.getOwner();
        this.location = new TSConstPoint(d, d2);
        this.pathEdge = tSPEdge;
    }

    protected void doAction() throws Throwable {
        this.storeOldMargins();
        TSDGraph tSDGraph = (TSDGraph)this.ownerEdge.getOwnerGraph();
        boolean bl = tSDGraph.isFiringEvents();
        tSDGraph.setFireEvents(false);
        this.bend = this.ownerEdge.addPathNode(this.pathEdge, this.location);
        this.pNodeIndex = this.ownerEdge.getPathNodeIndex(this.bend);
        this.extraPath = this.bend.getOutEdge();
        tSDGraph.setFireEvents(bl);
        TSDrawingChangeEvent tSDrawingChangeEvent = new TSDrawingChangeEvent(4L, new TSDrawingChangeEventData(this.bend, null, this.pathEdge));
        if (!tSDGraph.fireEvent(tSDrawingChangeEvent, true)) {
            tSDGraph.setFireEvents(false);
            this.ownerEdge.removePathSegment(this.bend);
            tSDGraph.setFireEvents(bl);
            this.setAddToUndoStack(false);
        } else {
            tSDGraph.fireEvent(tSDrawingChangeEvent);
        }
    }

    protected void undoAction() throws Throwable {
        TSPEdge tSPEdge = this.ownerEdge.getPathEdgeAtIndex(this.pNodeIndex);
        if (tSPEdge != null) {
            this.bend = (TSPNode)tSPEdge.getTargetNode();
            this.extraPath = this.ownerEdge.removePathSegment(this.bend);
        }
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        TSPEdge tSPEdge = this.ownerEdge.getPathEdgeAtIndex(this.pNodeIndex);
        if (tSPEdge.getTargetNode() == this.extraPath.getTargetNode()) {
            this.ownerEdge.insertPathSegment(this.bend, this.extraPath);
        } else {
            this.bend = this.ownerEdge.addLocalPathNode(tSPEdge, this.location);
            this.extraPath = this.bend.getOutEdge();
        }
        this.restoreMargins();
    }

    protected void undoCleanup() {
        this.bend.dispose();
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public TSPEdge getPathEdge() {
        return this.pathEdge;
    }

    public TSPNode getPathNode() {
        return this.bend;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager;
        if (this.ownerEdge.getOwner() != null && (tSDGraphManager = (TSDGraphManager)this.ownerEdge.getOwner().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }

    public void setMarginLists(List list, List list2) {
        this.graphs = new Vector(list);
        this.margins = new Vector(list2);
    }
}

