/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSDeleteNodeCommand
extends TSCommand {
    TSDGraph graph;
    TSDNode node;
    boolean compressMetaEdges;
    double rightConstantMargin;
    double leftConstantMargin;
    double topConstantMargin;
    double bottomConstantMargin;
    List graphs;
    List margins;

    public TSDeleteNodeCommand(TSDNode tSDNode) {
        if (tSDNode == null || !tSDNode.isOwned()) {
            throw new IllegalArgumentException();
        }
        this.node = tSDNode;
        this.graph = (TSDGraph)this.node.getOwner();
        TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDNode.getOwner().getOwner();
        this.compressMetaEdges = tSDGraphManager.getCompressMetaEdges();
    }

    protected void doAction() throws Throwable {
        if (this.graph.fireEvent(new TSGraphChangeEvent(16L, new TSGraphChangeEventData(this.node, this.graph, null)), true)) {
            this.removeNode();
        } else {
            this.setAddToUndoStack(false);
        }
    }

    private void removeNode() {
        this.storeOldMargins();
        if (this.node.getChildGraph() != null) {
            TSGraphTailor tSGraphTailor = ((TSDGraph)this.node.getChildGraph()).getTailor();
            this.leftConstantMargin = tSGraphTailor.getLeftConstantMargin();
            this.rightConstantMargin = tSGraphTailor.getRightConstantMargin();
            this.topConstantMargin = tSGraphTailor.getTopConstantMargin();
            this.bottomConstantMargin = tSGraphTailor.getBottomConstantMargin();
        }
        this.graph.remove(this.node);
    }

    protected void redoAction() throws Throwable {
        this.removeNode();
    }

    protected void undoAction() throws Throwable {
        this.graph.insert(this.node);
        if (this.node.getChildGraph() != null) {
            TSDGraph tSDGraph = (TSDGraph)this.node.getChildGraph();
            TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
            double d = tSGraphTailor.getOriginalRightConstantMargin();
            double d2 = tSGraphTailor.getOriginalLeftConstantMargin();
            double d3 = tSGraphTailor.getOriginalTopConstantMargin();
            double d4 = tSGraphTailor.getOriginalBottomConstantMargin();
            tSGraphTailor.setRightConstantMargin(this.rightConstantMargin);
            tSGraphTailor.setLeftConstantMargin(this.leftConstantMargin);
            tSGraphTailor.setTopConstantMargin(this.topConstantMargin);
            tSGraphTailor.setBottomConstantMargin(this.bottomConstantMargin);
            tSGraphTailor.setOriginalRightConstantMargin(d);
            tSGraphTailor.setOriginalLeftConstantMargin(d2);
            tSGraphTailor.setOriginalTopConstantMargin(d3);
            tSGraphTailor.setOriginalBottomConstantMargin(d4);
            tSDGraph.updateBounds();
        }
        this.restoreMargins();
    }

    protected void doCleanup() {
        if (!this.node.isOwned()) {
            this.node.dispose();
        }
    }

    public TSDNode getNode() {
        return this.node;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwnerGraphManager();
        if (tSDGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

