/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSInsertNodeCommand
extends TSCommand {
    TSDGraph graph;
    TSDNode node;
    List graphs;
    List margins;

    public TSInsertNodeCommand(TSDGraph tSDGraph, TSDNode tSDNode) {
        this.graph = tSDGraph;
        this.node = tSDNode;
    }

    protected void doAction() throws Throwable {
        if (this.graph.fireEvent(new TSGraphChangeEvent(2L, new TSGraphChangeEventData(this.node, null, this.graph)), true)) {
            this.graph.insert(this.node);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.graph.remove(this.node);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        this.graph.insert(this.node);
    }

    public List getAffectedObjects() {
        Vector<Cloneable> vector = new Vector<Cloneable>();
        if (this.node != null) {
            vector.add(this.node);
            vector.add(this.node.getBounds(7));
            if (this.getGraph().getParent() != null && this.getGraph().getParent() instanceof TSDNode) {
                vector.add(((TSDNode)this.getGraph().getParent()).getBounds(7));
            }
        }
        return vector;
    }

    protected void undoCleanup() {
        if (!this.node.isOwned()) {
            this.node.dispose();
        }
    }

    public TSDGraph getGraph() {
        return this.graph;
    }

    public TSDNode getNode() {
        return this.node;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwnerGraphManager();
        if (tSDGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }

    public void setMarginLists(List list, List list2) {
        this.graphs = new Vector(list);
        this.margins = new Vector(list2);
    }
}

