/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;

public class TSSetTagCommand
extends TSCommand {
    TSGraphObject object;
    Object oldValue;
    Object newValue;

    public TSSetTagCommand(TSGraphObject tSGraphObject, Object object) {
        this.object = tSGraphObject;
        this.oldValue = tSGraphObject.getTag();
        this.newValue = object;
    }

    protected void doAction() throws Throwable {
        if (this.object instanceof TSDNode || this.object instanceof TSDEdge || this.object instanceof TSDGraph) {
            long l = this.object instanceof TSDNode ? 1024L : (this.object instanceof TSDEdge ? 2048L : 512L);
            if (this.object.getOwnerGraph().fireEvent(new TSGraphChangeEvent(l, new TSGraphChangeEventData(this.object, this.oldValue, this.newValue)), true)) {
                this.object.setTag(this.newValue);
            } else {
                this.setAddToUndoStack(false);
            }
        } else {
            long l = 1024L;
            if (this.object.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(l, new TSDrawingChangeEventData(this.object, this.oldValue, this.newValue)), true)) {
                this.object.setTag(this.newValue);
            } else {
                this.setAddToUndoStack(false);
            }
        }
    }

    protected void undoAction() throws Throwable {
        this.object.setTag(this.oldValue);
    }

    protected void redoAction() throws Throwable {
        this.object.setTag(this.newValue);
    }

    public TSGraphObject getGraphObject() {
        return this.object;
    }

    public Object getNewTag() {
        return this.newValue;
    }

    public Object getOriginalTag() {
        return this.oldValue;
    }
}

