/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.geometry;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TSConstPoint
implements Cloneable {
    static final NumberFormat formatter = new DecimalFormat("+0.0;-0.0");
    double x;
    double y;

    public TSConstPoint(TSConstPoint tSConstPoint) {
        this(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public TSConstPoint(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public double distanceSquared(TSConstPoint tSConstPoint) {
        return this.distanceSquared(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public double distanceSquared(double d, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d2;
        return d3 * d3 + d4 * d4;
    }

    public double distance(TSConstPoint tSConstPoint) {
        return this.distance(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public double distance(double d, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public static double distanceSquared(TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        double d = Double.NaN;
        if (tSConstPoint != null && tSConstPoint2 != null) {
            d = tSConstPoint.distanceSquared(tSConstPoint2);
        }
        return d;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TSConstPoint) {
            TSConstPoint tSConstPoint = (TSConstPoint)object;
            bl = tSConstPoint.getX() == this.getX() && tSConstPoint.getY() == this.getY();
        }
        return bl;
    }

    public String toString() {
        return formatter.format(this.getX()) + " " + formatter.format(this.getY());
    }
}

