/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.geometry;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstSegment;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSShape;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TSConstRect
implements Cloneable,
TSShape,
Serializable {
    static final NumberFormat formatter = new DecimalFormat("+0.0;-0.0");
    public static final int OUT_LEFT = 8;
    public static final int OUT_RIGHT = 1;
    public static final int OUT_TOP = 4;
    public static final int OUT_BOTTOM = 2;
    public static final int INSIDE = 0;
    double left;
    double bottom;
    double right;
    double top;

    public TSConstRect(double d, double d2, double d3, double d4) {
        if (d < d3) {
            this.left = d;
            this.right = d3;
        } else {
            this.left = d3;
            this.right = d;
        }
        if (d2 < d4) {
            this.bottom = d2;
            this.top = d4;
        } else {
            this.bottom = d4;
            this.top = d2;
        }
    }

    public TSConstRect(TSConstRect tSConstRect) {
        this.left = tSConstRect.left;
        this.bottom = tSConstRect.bottom;
        this.right = tSConstRect.right;
        this.top = tSConstRect.top;
    }

    public TSConstRect(TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        this(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY());
    }

    public TSConstRect getBounds() {
        return this;
    }

    public final TSConstSize getSize() {
        return new TSConstSize(this.getWidth(), this.getHeight());
    }

    public final TSConstPoint getCenter() {
        return new TSConstPoint(this.getCenterX(), this.getCenterY());
    }

    public final double getCenterX() {
        return (this.right + this.left) / 2.0;
    }

    public final double getCenterY() {
        return (this.bottom + this.top) / 2.0;
    }

    public final double getHeight() {
        return this.top - this.bottom;
    }

    public final double getWidth() {
        return this.right - this.left;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final int outcode(double d, double d2) {
        return TSConstRect.outcode(this.left, this.bottom, this.right, this.top, d, d2);
    }

    public static final int outcode(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = 0;
        if (d3 < d) {
            n |= 9;
        } else if (d5 < d) {
            n |= 8;
        } else if (d5 > d3) {
            n |= 1;
        }
        if (d4 < d2) {
            n |= 6;
        } else if (d6 < d2) {
            n |= 2;
        } else if (d6 > d4) {
            n |= 4;
        }
        return n;
    }

    public static boolean intersectsLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        boolean bl = d5 >= d && d5 <= d3 && d6 >= d2 && d6 <= d4;
        boolean bl2 = d7 >= d && d7 <= d3 && d8 >= d2 && d8 <= d4;
        return bl || bl2 || !Double.isNaN(TSConstSegment.horizontalSegmentIntersection(d5, d6, d7, d8, d4, d, d3)) || !Double.isNaN(TSConstSegment.horizontalSegmentIntersection(d5, d6, d7, d8, d2, d, d3)) || !Double.isNaN(TSConstSegment.verticalSegmentIntersection(d5, d6, d7, d8, d, d2, d4)) || !Double.isNaN(TSConstSegment.verticalSegmentIntersection(d5, d6, d7, d8, d3, d2, d4));
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        return TSConstRect.intersectsLine(this.left, this.bottom, this.right, this.top, d, d2, d3, d4);
    }

    public TSConstPoint intersection(TSConstSegment tSConstSegment) {
        if (tSConstSegment == null) {
            return null;
        }
        return this.intersection(tSConstSegment.getX1(), tSConstSegment.getY1(), tSConstSegment.getX2(), tSConstSegment.getY2());
    }

    public TSConstPoint intersection(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = Double.MAX_VALUE;
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        double d9 = this.getTop();
        double d10 = TSConstSegment.horizontalSegmentIntersection(d, d2, d3, d4, this.getTop(), this.getLeft(), this.getRight());
        if (!Double.isNaN(d10) && (d5 = (d10 - d3) * (d10 - d3) + (d9 - d4) * (d9 - d4)) < d6) {
            d7 = d10;
            d8 = d9;
            d6 = d5;
        }
        d9 = this.getBottom();
        d10 = TSConstSegment.horizontalSegmentIntersection(d, d2, d3, d4, this.getBottom(), this.getLeft(), this.getRight());
        if (!Double.isNaN(d10) && (d5 = (d10 - d3) * (d10 - d3) + (d9 - d4) * (d9 - d4)) < d6) {
            d7 = d10;
            d8 = d9;
            d6 = d5;
        }
        d10 = this.getLeft();
        d9 = TSConstSegment.verticalSegmentIntersection(d, d2, d3, d4, this.getLeft(), this.getBottom(), this.getTop());
        if (!Double.isNaN(d9) && (d5 = (d10 - d3) * (d10 - d3) + (d9 - d4) * (d9 - d4)) < d6) {
            d7 = d10;
            d8 = d9;
            d6 = d5;
        }
        d10 = this.getRight();
        d9 = TSConstSegment.verticalSegmentIntersection(d, d2, d3, d4, this.getRight(), this.getBottom(), this.getTop());
        if (!Double.isNaN(d9) && (d5 = (d10 - d3) * (d10 - d3) + (d9 - d4) * (d9 - d4)) < d6) {
            d7 = d10;
            d8 = d9;
            d6 = d5;
        }
        TSConstPoint tSConstPoint = null;
        if (!Double.isNaN(d7)) {
            tSConstPoint = new TSConstPoint(d7, d8);
        }
        return tSConstPoint;
    }

    public double xIntersection(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = Double.MAX_VALUE;
        double d7 = Double.NaN;
        double d8 = this.getTop();
        double d9 = TSConstSegment.horizontalSegmentIntersection(d, d2, d3, d4, this.getTop(), this.getLeft(), this.getRight());
        if (!Double.isNaN(d9) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d9;
            d6 = d5;
        }
        d8 = this.getBottom();
        d9 = TSConstSegment.horizontalSegmentIntersection(d, d2, d3, d4, this.getBottom(), this.getLeft(), this.getRight());
        if (!Double.isNaN(d9) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d9;
            d6 = d5;
        }
        d9 = this.getLeft();
        d8 = TSConstSegment.verticalSegmentIntersection(d, d2, d3, d4, this.getLeft(), this.getBottom(), this.getTop());
        if (!Double.isNaN(d8) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d9;
            d6 = d5;
        }
        d9 = this.getRight();
        d8 = TSConstSegment.verticalSegmentIntersection(d, d2, d3, d4, this.getRight(), this.getBottom(), this.getTop());
        if (!Double.isNaN(d8) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d9;
            d6 = d5;
        }
        return d7;
    }

    public double yIntersection(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = Double.MAX_VALUE;
        double d7 = Double.NaN;
        double d8 = this.getTop();
        double d9 = TSConstSegment.horizontalSegmentIntersection(d, d2, d3, d4, this.getTop(), this.getLeft(), this.getRight());
        if (!Double.isNaN(d9) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d8;
            d6 = d5;
        }
        d8 = this.getBottom();
        d9 = TSConstSegment.horizontalSegmentIntersection(d, d2, d3, d4, this.getBottom(), this.getLeft(), this.getRight());
        if (!Double.isNaN(d9) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d8;
            d6 = d5;
        }
        d9 = this.getLeft();
        d8 = TSConstSegment.verticalSegmentIntersection(d, d2, d3, d4, this.getLeft(), this.getBottom(), this.getTop());
        if (!Double.isNaN(d8) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d8;
            d6 = d5;
        }
        d9 = this.getRight();
        d8 = TSConstSegment.verticalSegmentIntersection(d, d2, d3, d4, this.getRight(), this.getBottom(), this.getTop());
        if (!Double.isNaN(d8) && (d5 = (d9 - d3) * (d9 - d3) + (d8 - d4) * (d8 - d4)) < d6) {
            d7 = d8;
            d6 = d5;
        }
        return d7;
    }

    public final boolean isEmpty() {
        return this.right <= this.left || this.top <= this.bottom;
    }

    public boolean intersects(TSConstRect tSConstRect) {
        return tSConstRect.right >= this.left && this.right >= tSConstRect.left && tSConstRect.top >= this.bottom && this.top >= tSConstRect.bottom;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (d < d3) {
            if (d2 < d4) {
                return d3 >= this.left && this.right >= d && d4 >= this.bottom && this.top >= d2;
            }
            return d3 >= this.left && this.right >= d && d2 >= this.bottom && this.top >= d4;
        }
        if (d2 < d4) {
            return d >= this.left && this.right >= d3 && d4 >= this.bottom && this.top >= d2;
        }
        return d >= this.left && this.right >= d3 && d2 >= this.bottom && this.top >= d4;
    }

    public boolean withinXRange(TSConstPoint tSConstPoint) {
        return tSConstPoint.getX() >= this.getLeft() && tSConstPoint.getX() <= this.getRight();
    }

    public boolean withinYRange(TSConstPoint tSConstPoint) {
        return tSConstPoint.getY() >= this.getBottom() && tSConstPoint.getY() <= this.getTop();
    }

    public boolean contains(TSConstPoint tSConstPoint) {
        return this.withinXRange(tSConstPoint) && this.withinYRange(tSConstPoint);
    }

    public boolean contains(double d, double d2) {
        return this.left <= d && d <= this.right && this.bottom <= d2 && d2 <= this.top;
    }

    public boolean contains(TSConstRect tSConstRect) {
        return this.contains(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (d < d3) {
            if (d2 < d4) {
                return d >= this.left && d3 <= this.right && d2 >= this.bottom && d4 <= this.top;
            }
            return d >= this.left && d3 <= this.right && d4 >= this.bottom && d2 <= this.top;
        }
        if (d2 < d4) {
            return d3 >= this.left && d <= this.right && d2 >= this.bottom && d4 <= this.top;
        }
        return d3 >= this.left && d <= this.right && d4 >= this.bottom && d2 <= this.top;
    }

    public TSConstRect intersection(TSConstRect tSConstRect) {
        double d = Math.max(this.left, tSConstRect.left);
        double d2 = Math.min(this.right, tSConstRect.right);
        double d3 = Math.min(this.top, tSConstRect.top);
        double d4 = Math.max(this.bottom, tSConstRect.bottom);
        if (d <= d2 && d4 <= d3) {
            return new TSConstRect(d, d4, d2, d3);
        }
        return null;
    }

    public TSConstRect union(TSConstRect tSConstRect) {
        return new TSConstRect(Math.min(this.left, tSConstRect.left), Math.min(this.bottom, tSConstRect.bottom), Math.max(this.right, tSConstRect.right), Math.max(this.top, tSConstRect.top));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TSConstRect) {
            TSConstRect tSConstRect = (TSConstRect)object;
            bl = tSConstRect.left == this.left && tSConstRect.bottom == this.bottom && tSConstRect.right == this.right && tSConstRect.top == this.top;
        }
        return bl;
    }

    public String toString() {
        return "[(" + this.getLeft() + ", " + this.getBottom() + ")(" + this.getRight() + ", " + this.getTop() + ")]";
    }
}

