/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.geometry;

import com.tomsawyer.drawing.geometry.TSConstSpacing;
import com.tomsawyer.util.TSSystem;

public class TSSpacing
extends TSConstSpacing {
    public TSSpacing() {
        super(0.0, 0.0);
    }

    public TSSpacing(double d, double d2) {
        super(d, d2);
    }

    public TSSpacing(TSConstSpacing tSConstSpacing) {
        super(tSConstSpacing);
    }

    public void setConstantSpacing(double d) {
        this.constant = d;
    }

    public void setProportionalSpacing(double d) {
        this.proportional = d;
    }

    public void setSpacing(TSConstSpacing tSConstSpacing) {
        if (tSConstSpacing != null) {
            this.constant = tSConstSpacing.constant;
            this.proportional = tSConstSpacing.proportional;
        }
    }

    public static double calculateOuterSize(TSConstSpacing tSConstSpacing, TSConstSpacing tSConstSpacing2, double d) {
        double d2 = 0.0;
        double d3 = d + tSConstSpacing.constant + tSConstSpacing2.constant;
        double d4 = tSConstSpacing.proportional;
        double d5 = tSConstSpacing2.proportional;
        TSSystem.tsAssert(d4 + d5 < 1000.0);
        if (d3 > 0.0) {
            double d6;
            double d7;
            double d8 = 1.0 + (d3 - 2.0) * 1000.0 / (1000.0 - d4 - d5);
            double d9 = 1.0 + (d3 - 1.0) * 1000.0 / (1000.0 - d4 - d5);
            double d10 = d9 + (d9 - d8);
            double d11 = d8 - (d10 - d8);
            do {
                if ((d7 = (d6 = (d11 + d10) / 2.0) - d6 * d4 / 1000.0 + d6 * d5 / 1000.0) > d3) {
                    d10 = d6;
                    continue;
                }
                if (!(d7 < d3)) continue;
                d11 = d6;
            } while (d7 != d3);
            d2 = d6;
        }
        return d2;
    }
}

