/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeEventData;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeEventData;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSEConnectorUI;
import com.tomsawyer.editor.ui.TSEDefaultConnectorUI;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class TSEConnector
extends TSConnector
implements TSESolidObject,
TSEInspectable {
    public static TSEInspectorPropertyID URL_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("URL"), class$java$lang$String == null ? (class$java$lang$String = TSEConnector.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Width"), class$java$lang$Double == null ? (class$java$lang$Double = TSEConnector.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID HEIGHT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Height"), class$java$lang$Double == null ? (class$java$lang$Double = TSEConnector.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID X_CENTER_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("X_Center"), class$java$lang$Double == null ? (class$java$lang$Double = TSEConnector.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID Y_CENTER_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Y_Center"), class$java$lang$Double == null ? (class$java$lang$Double = TSEConnector.class$("java.lang.Double")) : class$java$lang$Double);
    TSEConnectorUI connectorUI;
    boolean selected;
    URL url;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    protected TSEConnector() {
        this(null);
    }

    protected TSEConnector(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.setUI(this.newConnectorUI());
        this.selected = false;
    }

    protected TSConnectorLabel newLabel() {
        return new TSEConnectorLabel();
    }

    protected TSEConnectorUI newConnectorUI() {
        return new TSEDefaultConnectorUI();
    }

    public TSEObjectUI getUI() {
        return this.connectorUI;
    }

    public TSEConnectorUI getConnectorUI() {
        return this.connectorUI;
    }

    public void setUI(TSEObjectUI tSEObjectUI) {
        if (tSEObjectUI instanceof TSEConnectorUI) {
            this.connectorUI = (TSEConnectorUI)tSEObjectUI;
            this.connectorUI.setOwner(this);
            if (this.connectorUI.getShape() != null) {
                this.setShape(this.connectorUI.getShape());
            }
        }
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        if (this.getUI() != null) {
            this.getUI().onOwnerInserted();
        }
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        this.setSelected(false);
        if (this.getUI() != null) {
            this.getUI().onOwnerRemoved();
        }
        super.onRemove(tSGraphObject);
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        if (this.getUI() != null) {
            this.getUI().onOwnerDiscarded();
        }
        super.onDiscard(tSGraphObject);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (bl == this.selected || bl && !this.isViewable()) {
            return;
        }
        TSENode tSENode = (TSENode)this.getOwner();
        if (tSENode == null) {
            throw new IllegalStateException("connector has no owner node");
        }
        TSEGraph tSEGraph = (TSEGraph)tSENode.getOwner();
        if (tSEGraph == null) {
            throw new IllegalStateException("owner node of the connector has no owner graph");
        }
        TSESelectionChangeEvent tSESelectionChangeEvent = new TSESelectionChangeEvent(32L, new TSESelectionChangeEventData(this, bl));
        if (tSEGraph.fireEvent(tSESelectionChangeEvent, true)) {
            if (bl) {
                this.selected = true;
                tSEGraph.selectedConnectorsList.add(this);
            } else {
                this.selected = false;
                tSEGraph.selectedConnectorsList.remove(this);
            }
            tSEGraph.fireEvent(tSESelectionChangeEvent);
        }
    }

    public void setLabelsSelected(boolean bl) {
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            TSEConnectorLabel tSEConnectorLabel = (TSEConnectorLabel)iterator.next();
            tSEConnectorLabel.setSelected(bl);
        }
    }

    public void setDragged(boolean bl) {
    }

    public boolean isDragged() {
        return false;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        if (object instanceof TSEConnector) {
            TSEConnector tSEConnector = (TSEConnector)object;
            this.url = tSEConnector.getURL();
            this.setUI((TSEConnectorUI)tSEConnector.getUI().clone());
        }
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(URL_ID);
        if (this.connectorUI != null) {
            this.connectorUI.getInspectorPropertyIDs(list);
        }
        list.add(WIDTH_ID);
        list.add(HEIGHT_ID);
        list.add(X_CENTER_ID);
        list.add(Y_CENTER_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty = null;
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            if (this.getURL() != null) {
                return new TSEInspectorProperty(this.getURL().toExternalForm());
            }
            return new TSEInspectorProperty(new String());
        }
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalWidth()), new Double(this.getMinimumWidth()), new Double(99999.0));
        }
        if (tSEInspectorPropertyID.equals(HEIGHT_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalHeight()), new Double(this.getMinimumHeight()), new Double(99999.0));
        }
        if (tSEInspectorPropertyID.equals(X_CENTER_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalCenterX()), new Double(-999999.0), new Double(999999.0));
        }
        if (tSEInspectorPropertyID.equals(Y_CENTER_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalCenterY()), new Double(-999999.0), new Double(999999.0));
        }
        if (this.connectorUI != null) {
            tSEInspectorProperty = this.connectorUI.getInspectorProperty(tSEInspectorPropertyID);
        }
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n = 0;
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            URL uRL = TSSystem.getValidatedURL((String)tSEInspectorProperty.getValue());
            this.setURL(uRL);
            return 2;
        }
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            double d = (Double)tSEInspectorProperty.getValue();
            this.setLocalSize(d, this.getLocalHeight());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(HEIGHT_ID)) {
            double d = (Double)tSEInspectorProperty.getValue();
            this.setLocalSize(this.getLocalWidth(), d);
            n = 1;
        } else {
            if (tSEInspectorPropertyID.equals(X_CENTER_ID)) {
                this.setLocalCenterX((Double)tSEInspectorProperty.getValue());
                return 1;
            }
            if (tSEInspectorPropertyID.equals(Y_CENTER_ID)) {
                this.setLocalCenterY((Double)tSEInspectorProperty.getValue());
                return 1;
            }
            if (this.connectorUI != null) {
                n = this.connectorUI.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
            }
        }
        return n;
    }

    public TSSize adjustSize(double d, double d2, TSSize tSSize) {
        if (tSSize == null) {
            tSSize = new TSSize();
        }
        tSSize.setSize(d, d2);
        return tSSize;
    }

    public void resize() {
    }

    public int getResizability() {
        return 0;
    }

    public void setResizability(int n) {
    }

    public double getMinimumWidth() {
        double d = 1.0;
        if (this.getUI() != null) {
            d = Math.max(this.getConnectorUI().getMinimumWidth(), d);
        }
        return d;
    }

    public double getMinimumHeight() {
        double d = 1.0;
        if (this.getUI() != null) {
            d = Math.max(this.getConnectorUI().getMinimumHeight(), d);
        }
        return d;
    }

    public String getToolTipText() {
        return this.getText();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.url;
        this.url = uRL;
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(4L, new TSEPropertyChangeEventData(this, uRL2, uRL)));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

