/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.editor.TSEButtonKeyListener;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEPreferences;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.dialog.TSUnsignedIntegerField;
import com.tomsawyer.editor.event.TSEEventManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class TSEDrawingPreferencesDialog
extends JDialog
implements ActionListener,
KeyListener {
    TSEPreferences preferences;
    JPanel mainPanel;
    JPanel buttonPanel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton applyButton;
    protected JButton resetButton;
    protected JButton defaultsButton;
    Window owner;
    TSEGraphWindow graphWindow;
    protected Rectangle bounds;
    protected TSEResourceBundleWrapper labels;
    boolean firstTime = true;
    protected Color normalTextColor;
    protected Color disableTextColor;
    protected Color labelColor = Color.black;
    protected Font font;
    JCheckBox autoHide;
    JCheckBox tooltips;
    TSUnsignedDoubleField maxZoomPercentField;
    TSUnsignedDoubleField minZoomPercentField;
    TSUnsignedIntegerField undoStackSizeField;
    JCheckBox inPlaceEditing;
    JCheckBox partialSelection;
    JCheckBox opaqueMovement;
    TSUnsignedIntegerField hitToleranceField;
    TSUnsignedDoubleField reconnectEdgeSensitivityField;
    TSUnsignedDoubleField interactiveZoomSensitivityField;
    TSUnsignedDoubleField panningSensitivityField;
    TSUnsignedIntegerField tripDurationField;
    TSUnsignedIntegerField blinkDurationField;
    TSUnsignedIntegerField frameCountField;
    JCheckBox geometricAdjustment;
    JCheckBox compressMetaEdges;

    public TSEDrawingPreferencesDialog(Frame owner, String title, TSEGraphWindow graphWindow) {
        super(owner, title);
        this.owner = owner;
        this.preferences = graphWindow.getPreferences();
        this.graphWindow = graphWindow;
        this.font = new Font("Dialog", 0, 12);
        this.normalTextColor = Color.white;
        this.disableTextColor = new Color(204, 204, 204);
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
        this.init();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected void init() {
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
        this.buttonPanel = this.createButtonPanel();
        this.mainPanel = this.createMainPanel();
        Container contentPane = this.getContentPane();
        Dimension mainPanelSize = this.mainPanel.getPreferredSize();
        Dimension buttonPanelSize = this.buttonPanel.getPreferredSize();
        int margin = 6;
        int compWidth = (int)Math.max(mainPanelSize.getWidth(), buttonPanelSize.getWidth());
        this.mainPanel.setBounds(margin, margin, compWidth, (int)mainPanelSize.getHeight());
        this.buttonPanel.setBounds(margin, 3 * margin + (int)mainPanelSize.getHeight(), compWidth, (int)buttonPanelSize.getHeight());
        ((JPanel)contentPane).setPreferredSize(new Dimension(2 * margin + compWidth, 5 * margin + (int)mainPanelSize.getHeight() + (int)buttonPanelSize.getHeight()));
        contentPane.setLayout(null);
        contentPane.add(this.mainPanel);
        contentPane.add(this.buttonPanel);
        this.onReset();
        this.addKeyListener(new TSEButtonKeyListener(this, this));
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TSEDrawingPreferencesDialog.this.onReset();
            }
        });
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TSEDrawingPreferencesDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getAccessibleContext().setAccessibleDescription(this.getTitle());
    }

    public void setValues(TSEPreferences preferences) {
        this.setValue(this.autoHide, (Object)"autoHideScrollbars", preferences);
        this.setValue(this.tooltips, (Object)"tooltipsEnabled", preferences);
        this.setValue(this.maxZoomPercentField, "maximumZoomLevel", true, preferences);
        this.setValue(this.minZoomPercentField, "minimumZoomLevel", true, preferences);
        this.setValue(this.undoStackSizeField, (Object)"undoStackSize", preferences);
        this.setValue(this.compressMetaEdges, (Object)"compressMetaEdges", preferences);
        this.setValue(this.geometricAdjustment, (Object)"geometricAdjustment", preferences);
        this.setValue(this.inPlaceEditing, (Object)"inPlaceEditing", preferences);
        this.setValue(this.partialSelection, (Object)"partialSelection", preferences);
        this.setValue(this.opaqueMovement, (Object)"opaqueMovement", preferences);
        this.setValue(this.hitToleranceField, (Object)"hitTolerance", preferences);
        this.setValue(this.reconnectEdgeSensitivityField, (Object)"reconnectEdgeSensitivity", preferences);
        this.setValue(this.interactiveZoomSensitivityField, (Object)"interactiveZoomSensitivity", preferences);
        this.setValue(this.panningSensitivityField, (Object)"panningSensitivity", preferences);
        this.setValue(this.tripDurationField, (Object)"edgeNavigationTripDuration", preferences);
        this.setValue(this.blinkDurationField, (Object)"edgeNavigationBlinkDuration", preferences);
        this.setValue(this.frameCountField, (Object)"edgeNavigationFrameCount", preferences);
    }

    public void setValue(JCheckBox checkbox, Object key, TSEPreferences preferences) {
        Boolean value = (Boolean)preferences.getValue(key);
        if (value != null) {
            checkbox.setSelected(value);
        }
    }

    public void setValue(TSUnsignedIntegerField field, Object key, TSEPreferences preferences) {
        Integer value = (Integer)preferences.getValue(key);
        if (value != null) {
            field.setText(String.valueOf(value));
        }
    }

    public void setValue(TSUnsignedDoubleField field, Object key, TSEPreferences preferences) {
        this.setValue(field, key, false, preferences);
    }

    private void setValue(TSUnsignedDoubleField field, Object key, boolean timesHundred, TSEPreferences preferences) {
        Double value = (Double)preferences.getValue(key);
        if (value != null) {
            if (timesHundred) {
                value = new Double(value * 100.0);
            }
            field.setText(String.valueOf(value));
        }
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = this.createBoxLayoutPanel(0);
        JPanel leftPanel = this.createBoxLayoutPanel(1);
        JPanel windowOptions = this.createWindowPanel();
        JPanel stateOptions = this.createToolsPanel();
        JPanel complexityOptions = this.createComplexityPanel();
        LinkedList<JPanel> comps = new LinkedList<JPanel>();
        comps.add(windowOptions);
        comps.add(complexityOptions);
        this.normalizeComponentWidths(comps);
        leftPanel.add(windowOptions);
        leftPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        leftPanel.add(complexityOptions);
        mainPanel.add(leftPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        mainPanel.add(stateOptions);
        return mainPanel;
    }

    protected JPanel createWindowPanel() {
        JPanel result = this.createBoxLayoutPanel(1);
        this.autoHide = this.createCheckbox("Auto_Hide_Scroll_Bars", "autoHide");
        this.tooltips = this.createCheckbox("Show_Tool_Tips", "tooltips");
        this.maxZoomPercentField = this.createDoubleField(5, 1.0E-6, 20000.0);
        this.minZoomPercentField = this.createDoubleField(5, 1.0E-6, 20000.0);
        this.undoStackSizeField = this.createIntegerField(5, 4);
        JLabel maxZoomPercentLabel = this.createLabel("Max_Zoom_Percent", this.maxZoomPercentField);
        JLabel minZoomPercentLabel = this.createLabel("Min_Zoom_Percent", this.minZoomPercentField);
        JLabel undoStackSizeLabel = this.createLabel("Undo_Stack_Size", this.undoStackSizeField);
        this.setAccessibleProperties(this.maxZoomPercentField, null, "Max_Zoom_Percent");
        this.setAccessibleProperties(this.minZoomPercentField, null, "Min_Zoom_Percent");
        this.setAccessibleProperties(this.undoStackSizeField, null, "Undo_Stack_Size");
        JPanel southPanel = this.createBoxLayoutPanel(0);
        JPanel labelPanel = this.createBoxLayoutPanel(1);
        JPanel fieldPanel = this.createBoxLayoutPanel(1);
        labelPanel.add(maxZoomPercentLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        labelPanel.add(minZoomPercentLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        labelPanel.add(undoStackSizeLabel);
        fieldPanel.add(this.maxZoomPercentField);
        fieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        fieldPanel.add(this.minZoomPercentField);
        fieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        fieldPanel.add(this.undoStackSizeField);
        southPanel.add(labelPanel);
        southPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        southPanel.add(fieldPanel);
        result.add(this.autoHide);
        result.add(Box.createRigidArea(new Dimension(0, 5)));
        result.add(this.tooltips);
        result.add(Box.createRigidArea(new Dimension(0, 5)));
        result.add(southPanel);
        this.createCompoundBorder(result, "Graph_Window", 0, 6, 5, 5);
        return result;
    }

    protected JPanel createComplexityPanel() {
        JPanel panel = this.createBoxLayoutPanel(1);
        this.geometricAdjustment = this.createCheckbox("Geometric_Adjustment");
        this.compressMetaEdges = this.createCheckbox("Compress_Meta_Edges");
        panel.add(this.compressMetaEdges);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(this.geometricAdjustment);
        this.createCompoundBorder(panel, "Complexity", 0, 6, 6, 6);
        return panel;
    }

    protected JPanel createEdgeNavigationPanel() {
        this.tripDurationField = this.createIntegerField(5, 0, 20000);
        this.blinkDurationField = this.createIntegerField(5, 0, 20000);
        this.frameCountField = this.createIntegerField(5, 1, 200);
        JLabel tripDurationLabel = this.createLabel("Trip_Duration", this.tripDurationField);
        JLabel blinkDurationLabel = this.createLabel("Blink_Duration", this.blinkDurationField);
        JLabel frameCountLabel = this.createLabel("Frame_Count", this.frameCountField);
        this.setAccessibleProperties(this.tripDurationField, null, "Trip_Duration");
        this.setAccessibleProperties(this.blinkDurationField, null, "Blink_Duration");
        this.setAccessibleProperties(this.frameCountField, null, "Frame_Count");
        JPanel result = this.createBoxLayoutPanel(0);
        JPanel labelPanel = this.createBoxLayoutPanel(1);
        JPanel fieldPanel = this.createBoxLayoutPanel(1);
        labelPanel.add(tripDurationLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        labelPanel.add(blinkDurationLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        labelPanel.add(frameCountLabel);
        fieldPanel.add(this.tripDurationField);
        fieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        fieldPanel.add(this.blinkDurationField);
        fieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        fieldPanel.add(this.frameCountField);
        result.add(labelPanel);
        result.add(Box.createHorizontalGlue());
        result.add(Box.createRigidArea(new Dimension(20, 0)));
        result.add(fieldPanel);
        this.createCompoundBorder(result, "Edge_Navigation", 0, 6, 5, 5);
        return result;
    }

    protected JPanel createToolsPanel() {
        JPanel result = this.createBoxLayoutPanel(1);
        this.inPlaceEditing = this.createCheckbox("In_Place_Editing");
        this.partialSelection = this.createCheckbox("Partial_Selection");
        this.opaqueMovement = this.createCheckbox("Opaque_Movement");
        this.hitToleranceField = this.createIntegerField(5, 0, 1000);
        this.reconnectEdgeSensitivityField = this.createDoubleField(5, 0.0, 40.0);
        this.interactiveZoomSensitivityField = this.createDoubleField(5, 0.0, 2000.0);
        this.panningSensitivityField = this.createDoubleField(5, 0.0, 20.0);
        JLabel edgeHitToleranceLabel = this.createLabel("Edge_Hit_Tolerance", this.hitToleranceField);
        JLabel reconnectEdgeSensitivityLabel = this.createLabel("Reconnect_Edge_Sensitivity", this.reconnectEdgeSensitivityField);
        JLabel interactiveZoomSensitivityLabel = this.createLabel("Interactive_Zoom_Sensitivity", this.interactiveZoomSensitivityField);
        JLabel panningSensitivityLabel = this.createLabel("Panning_Sensitivity", this.panningSensitivityField);
        this.setAccessibleProperties(this.hitToleranceField, null, "Edge_Hit_Tolerance");
        this.setAccessibleProperties(this.reconnectEdgeSensitivityField, null, "Reconnect_Edge_Sensitivity");
        this.setAccessibleProperties(this.interactiveZoomSensitivityField, null, "Interactive_Zoom_Sensitivity");
        this.setAccessibleProperties(this.panningSensitivityField, null, "Panning_Sensitivity");
        JPanel linkNavigationOptions = this.createEdgeNavigationPanel();
        JPanel middle = this.createBoxLayoutPanel(0);
        JPanel labelPanel = this.createBoxLayoutPanel(1);
        labelPanel.add(edgeHitToleranceLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        labelPanel.add(reconnectEdgeSensitivityLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        labelPanel.add(interactiveZoomSensitivityLabel);
        labelPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        labelPanel.add(panningSensitivityLabel);
        JPanel fieldPanel = this.createBoxLayoutPanel(1);
        fieldPanel.add(this.hitToleranceField);
        fieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        fieldPanel.add(this.reconnectEdgeSensitivityField);
        fieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        fieldPanel.add(this.interactiveZoomSensitivityField);
        fieldPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        fieldPanel.add(this.panningSensitivityField);
        middle.add(labelPanel);
        middle.add(Box.createHorizontalGlue());
        middle.add(Box.createRigidArea(new Dimension(20, 0)));
        middle.add(fieldPanel);
        result.add(this.inPlaceEditing);
        result.add(Box.createRigidArea(new Dimension(0, 5)));
        result.add(this.partialSelection);
        result.add(Box.createRigidArea(new Dimension(0, 5)));
        result.add(this.opaqueMovement);
        result.add(Box.createRigidArea(new Dimension(0, 5)));
        result.add(middle);
        result.add(Box.createRigidArea(new Dimension(0, 5)));
        result.add(linkNavigationOptions);
        this.createCompoundBorder(result, "Tools", 0, 6, 5, 5);
        return result;
    }

    public JPanel createButtonPanel() {
        JPanel buttons = new JPanel();
        this.okButton = new JButton(this.labels.getStringSafely("OK"));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.setAccessibleProperties(this.okButton, null, "OK");
        this.okButton.setMnemonic(this.getMnemonic("OK"));
        this.cancelButton = new JButton(this.labels.getStringSafely("Cancel"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.setAccessibleProperties(this.cancelButton, null, "Cancel");
        this.cancelButton.setMnemonic(this.getMnemonic("Cancel"));
        this.applyButton = new JButton(this.labels.getStringSafely("Apply"));
        this.applyButton.setActionCommand("apply");
        this.applyButton.addActionListener(this);
        this.setAccessibleProperties(this.applyButton, null, "Apply");
        this.applyButton.setMnemonic(this.getMnemonic("Apply"));
        this.resetButton = new JButton(this.labels.getStringSafely("Reset"));
        this.resetButton.setActionCommand("reset");
        this.resetButton.addActionListener(this);
        this.setAccessibleProperties(this.resetButton, null, "Reset");
        this.resetButton.setMnemonic(this.getMnemonic("Reset"));
        this.defaultsButton = new JButton(this.labels.getStringSafely("Defaults"));
        this.defaultsButton.setActionCommand("defaults");
        this.defaultsButton.addActionListener(this);
        this.setAccessibleProperties(this.defaultsButton, null, "Defaults");
        this.defaultsButton.setMnemonic(this.getMnemonic("Defaults"));
        this.deactivateButtons();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setAlignmentX(0.0f);
        Vector<JButton> buttonList = new Vector<JButton>();
        buttonList.add(this.okButton);
        buttonList.add(this.cancelButton);
        buttonList.add(this.applyButton);
        buttonList.add(this.resetButton);
        buttonList.add(this.defaultsButton);
        this.normalizeComponentWidths(buttonList);
        buttons.add(Box.createRigidArea(new Dimension(12, 0)));
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.okButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.cancelButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.applyButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.resetButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.defaultsButton);
        return buttons;
    }

    protected int normalizeComponentWidths(List components) {
        int width = -1;
        if (components != null) {
            for (JComponent comp : components) {
                width = (int)Math.max(comp.getPreferredSize().getWidth(), (double)width);
            }
            for (JComponent comp : components) {
                Dimension compDimension = new Dimension(width, (int)comp.getPreferredSize().getHeight());
                comp.setPreferredSize(compDimension);
                comp.setMinimumSize(compDimension);
                comp.setMaximumSize(compDimension);
            }
        }
        return width;
    }

    public JPanel createBoxLayoutPanel(int layout) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, layout));
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(0.0f);
        return panel;
    }

    public JCheckBox createCheckbox(String text) {
        return this.createCheckbox(text, text);
    }

    public JCheckBox createCheckbox(String text, String actionCommand) {
        String labelStr = this.translateText(text);
        labelStr = " " + labelStr;
        JCheckBox checkbox = new JCheckBox(" " + labelStr);
        checkbox.setActionCommand(actionCommand);
        checkbox.addActionListener(this);
        checkbox.setAlignmentX(0.0f);
        checkbox.setAlignmentY(0.0f);
        checkbox.setBorder(null);
        this.setAccessibleProperties(checkbox, null, text);
        checkbox.setMnemonic(this.getMnemonic(text));
        return checkbox;
    }

    public JLabel createLabel(String text, Component labelForComp) {
        String labelText = this.translateText(text);
        JLabel label = new JLabel(labelText + ":");
        label.setForeground(this.labelColor);
        label.setAlignmentX(0.0f);
        label.setAlignmentY(0.0f);
        label.setLabelFor(labelForComp);
        label.setDisplayedMnemonic(this.getMnemonic(text));
        return label;
    }

    public TSUnsignedIntegerField createIntegerField(int columns, int maxLength) {
        TSUnsignedIntegerField field = new TSUnsignedIntegerField(columns, maxLength);
        field.setMaximumSize(field.getPreferredSize());
        field.addKeyListener(this);
        field.setAlignmentX(0.0f);
        field.setAlignmentY(0.0f);
        return field;
    }

    public TSUnsignedIntegerField createIntegerField(int columns, int min, int max) {
        TSUnsignedIntegerField field = new TSUnsignedIntegerField(columns, min, max);
        field.setMaximumSize(field.getPreferredSize());
        field.addKeyListener(this);
        field.setAlignmentX(0.0f);
        field.setAlignmentY(0.0f);
        return field;
    }

    public TSUnsignedDoubleField createDoubleField(int columns, double min, double max) {
        TSUnsignedDoubleField field = new TSUnsignedDoubleField(columns, min, max);
        field.setMaximumSize(field.getPreferredSize());
        field.addKeyListener(this);
        field.setAlignmentX(0.0f);
        field.setAlignmentY(0.0f);
        return field;
    }

    public void createBorder(JPanel panel, String text) {
        text = this.translateText(text);
        panel.setBorder(BorderFactory.createTitledBorder(text));
        ((TitledBorder)panel.getBorder()).setTitleColor(this.labelColor);
    }

    public void createCompoundBorder(JPanel panel, String text, int top, int left, int bottom, int right) {
        text = this.translateText(text);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(text);
        titledBorder.setTitleColor(this.labelColor);
        panel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(top, left, bottom, right)));
    }

    public String translateText(String text) {
        boolean isNumber = true;
        try {
            Integer.parseInt(text);
        }
        catch (Exception e) {
            isNumber = false;
        }
        if (text.equals("") || isNumber) {
            return text;
        }
        return this.labels.getStringSafely(text);
    }

    protected void setAccessibleProperties(Component comp, String accsNameKey, String accsDescKey) {
        if (comp != null) {
            String labelStr = null;
            AccessibleContext accsContext = comp.getAccessibleContext();
            if (accsNameKey != null) {
                labelStr = this.labels.getStringSafely("ACSN_" + accsNameKey);
                accsContext.setAccessibleName(labelStr);
            }
            if (accsDescKey != null) {
                labelStr = this.labels.getStringSafely("ACSD_" + accsDescKey);
                accsContext.setAccessibleDescription(labelStr);
            }
        }
    }

    protected char getMnemonic(String bundleKey) {
        String mnm;
        char mnmChar = '?';
        if (bundleKey != null && (mnm = this.labels.getStringSafely("MNE_" + bundleKey)) != null && mnm.length() > 0) {
            mnmChar = mnm.charAt(0);
        }
        return mnmChar;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ok")) {
            this.setVisible(false);
            this.onApply();
        } else if (command.equals("cancel")) {
            this.setVisible(false);
            this.onReset();
        } else if (command.equals("apply")) {
            this.onApply();
        } else if (command.equals("reset")) {
            this.onReset();
        } else if (command.equals("defaults")) {
            this.onDefaults();
        } else {
            this.activateButtons();
        }
    }

    public void keyPressed(KeyEvent e) {
        this.activateButtons();
    }

    public void keyTyped(KeyEvent e) {
        this.activateButtons();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void onApply() {
        if (this.getGraphWindow() != null) {
            TSEEventManager eventManager = (TSEEventManager)this.getGraphWindow().getGraphManager().getEventManager();
            int oldContext = eventManager.getContext();
            eventManager.setContext(19);
            boolean wasCoalescing = eventManager.isCoalesce();
            eventManager.setCoalesce(true);
            this.process(this.autoHide, (Object)"autoHideScrollbars");
            this.process(this.tooltips, (Object)"tooltipsEnabled");
            this.process(this.minZoomPercentField, "minimumZoomLevel", true);
            this.process(this.maxZoomPercentField, "maximumZoomLevel", true);
            if (this.preferences.getDoubleValue("minimumZoomLevel") > this.preferences.getDoubleValue("maximumZoomLevel")) {
                this.minZoomPercentField.setText(this.maxZoomPercentField.getText());
                this.process(this.minZoomPercentField, (Object)"minimumZoomLevel");
            }
            this.process(this.undoStackSizeField, (Object)"undoStackSize");
            this.process(this.compressMetaEdges, (Object)"compressMetaEdges");
            this.process(this.geometricAdjustment, (Object)"geometricAdjustment");
            this.process(this.inPlaceEditing, (Object)"inPlaceEditing");
            this.process(this.partialSelection, (Object)"partialSelection");
            this.process(this.hitToleranceField, (Object)"hitTolerance");
            this.process(this.opaqueMovement, (Object)"opaqueMovement");
            this.process(this.reconnectEdgeSensitivityField, (Object)"reconnectEdgeSensitivity");
            this.process(this.interactiveZoomSensitivityField, (Object)"interactiveZoomSensitivity");
            this.process(this.panningSensitivityField, (Object)"panningSensitivity");
            this.process(this.tripDurationField, (Object)"edgeNavigationTripDuration");
            this.process(this.blinkDurationField, (Object)"edgeNavigationBlinkDuration");
            this.process(this.frameCountField, (Object)"edgeNavigationFrameCount");
            eventManager.setCoalesce(wasCoalescing);
            eventManager.setContext(oldContext);
            this.deactivateButtons();
        }
    }

    public void process(JCheckBox checkbox, Object key) {
        Boolean value = new Boolean(checkbox.isSelected());
        this.preferences.setValue(key, value);
    }

    public void process(TSUnsignedIntegerField field, Object key) {
        field.ensureValidValue();
        String text = field.getText();
        if (text == null || text.equals("")) {
            int value = (Integer)this.preferences.getValue(key);
            field.setText(String.valueOf(value));
        } else {
            int value = Integer.parseInt(text);
            this.preferences.setValue(key, new Integer(value));
        }
    }

    private void process(TSUnsignedDoubleField field, Object key) {
        this.process(field, key, false);
    }

    public void process(TSUnsignedDoubleField field, Object key, boolean divideByHundred) {
        field.ensureValidValue();
        String text = field.getText();
        if (text == null || text.equals("")) {
            double value = (Double)this.preferences.getValue(key);
            field.setText(String.valueOf(value));
        } else {
            double value = Double.valueOf(field.getText());
            if (divideByHundred) {
                value /= 100.0;
            }
            this.preferences.setValue(key, new Double(value));
        }
    }

    public void onReset() {
        if (this.getGraphWindow() != null) {
            this.setValues(this.preferences);
        }
        this.deactivateButtons();
    }

    public void onDefaults() {
        TSEPreferences sourceOfDefaults = new TSEPreferences(this.getGraphWindow());
        if (this.getGraphWindow() != null) {
            this.setValues(sourceOfDefaults);
        }
        this.activateButtons();
    }

    public void activateButtons() {
        this.applyButton.setEnabled(true);
        this.resetButton.setEnabled(true);
    }

    public void deactivateButtons() {
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.defaultsButton.setEnabled(this.graphWindow != null);
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public void setGraphWindow(TSEGraphWindow window) {
        if (window != null) {
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.add(this.mainPanel);
            contentPane.revalidate();
            contentPane.repaint();
            this.graphWindow = window;
            this.preferences = window.getPreferences();
            this.onReset();
        } else {
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.remove(this.mainPanel);
            contentPane.revalidate();
            contentPane.repaint();
            this.graphWindow = null;
            this.preferences = null;
            this.deactivateButtons();
        }
    }

    public TSEPreferences getPreferences() {
        return this.preferences;
    }

    public JButton getOKButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }
}

