/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeEventData;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeEventData;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.ui.TSECurvedEdgeUI;
import com.tomsawyer.editor.ui.TSEDefaultEdgeUI;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSSystem;
import java.awt.Shape;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class TSEEdge
extends TSDEdge
implements TSEObject,
TSEInspectable {
    public static TSEInspectorPropertyID NAME_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Name"), class$java$lang$String == null ? (class$java$lang$String = TSEEdge.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID URL_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("URL"), class$java$lang$String == null ? (class$java$lang$String = TSEEdge.class$("java.lang.String")) : class$java$lang$String);
    TSEEdgeUI edgeUI;
    boolean dragged;
    boolean selected;
    boolean highlighted;
    URL url;
    static /* synthetic */ Class class$java$lang$String;

    protected TSEEdge() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.setUI(this.newEdgeUI());
    }

    protected TSPNode newPathNode() {
        return new TSEPNode(this);
    }

    protected TSEdgeLabel newLabel() {
        return new TSEEdgeLabel(this);
    }

    protected TSEEdgeUI newEdgeUI() {
        return new TSEDefaultEdgeUI();
    }

    public TSPNode addPathNode(TSPEdge tSPEdge, TSConstPoint tSConstPoint) {
        TSEPNode tSEPNode = (TSEPNode)super.addPathNode(tSPEdge, tSConstPoint);
        if (this.isSelected()) {
            tSEPNode.setSelected(true);
        }
        return tSEPNode;
    }

    public TSPNode addLocalPathNode(TSPEdge tSPEdge, TSConstPoint tSConstPoint) {
        TSEPNode tSEPNode = (TSEPNode)super.addLocalPathNode(tSPEdge, tSConstPoint);
        if (this.isSelected() && this.getOwner() != null) {
            tSEPNode.setSelected(true);
        }
        return tSEPNode;
    }

    public TSEObjectUI getUI() {
        return this.edgeUI;
    }

    public TSEEdgeUI getEdgeUI() {
        return this.edgeUI;
    }

    public void setUI(TSEObjectUI tSEObjectUI) {
        if (tSEObjectUI instanceof TSEEdgeUI) {
            this.edgeUI = (TSEEdgeUI)tSEObjectUI;
            this.edgeUI.setOwner(this);
        }
    }

    public int levelNumber() {
        return 2;
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        if (this.getUI() != null) {
            this.getUI().onOwnerInserted();
        }
        this.updateHideMarks();
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        this.setSelected(false);
        this.setLabelsSelected(false);
        this.setPathNodesSelected(false);
        this.setHighlighted(false);
        if (this.getUI() != null) {
            this.getUI().onOwnerRemoved();
        }
        super.onRemove(tSGraphObject);
        this.updateHideMarks();
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        if (this.getUI() != null) {
            this.getUI().onOwnerDiscarded();
        }
        super.onDiscard(tSGraphObject);
    }

    public void setSourceNode(TSNode tSNode) {
        super.setSourceNode(tSNode);
        this.updateHideMarks();
    }

    public void setTargetNode(TSNode tSNode) {
        super.setTargetNode(tSNode);
        this.updateHideMarks();
    }

    protected void connect() {
        super.connect();
        this.updateHideMarks();
    }

    public void disconnect() {
        super.disconnect();
        this.updateHideMarks();
    }

    void updateHideMarks() {
        TSENode tSENode = (TSENode)this.getTargetNode();
        TSENode tSENode2 = (TSENode)this.getSourceNode();
        if (tSENode2 != null && tSENode2.getUI() != null) {
            tSENode2.getNodeUI().updateHideMark();
        }
        if (tSENode != null && tSENode.getUI() != null) {
            tSENode.getNodeUI().updateHideMark();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        TSGraphObject tSGraphObject;
        if (bl == this.selected || bl && !this.isViewable()) {
            return;
        }
        Iterator iterator = this.bendIterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEPNode)iterator.next();
            ((TSEPNode)tSGraphObject).setSelected(bl);
        }
        tSGraphObject = (TSEGraph)this.getOwner();
        if (tSGraphObject == null) {
            throw new IllegalStateException("edge has no owner");
        }
        TSESelectionChangeEvent tSESelectionChangeEvent = new TSESelectionChangeEvent(4L, new TSESelectionChangeEventData(this, bl));
        if (((TSGraph)tSGraphObject).fireEvent(tSESelectionChangeEvent, true)) {
            boolean bl2 = ((TSGraph)tSGraphObject).isFiringEvents();
            ((TSGraph)tSGraphObject).setFireEvents(false);
            iterator = this.bendIterator();
            while (iterator.hasNext()) {
                TSEPNode tSEPNode = (TSEPNode)iterator.next();
                tSEPNode.setSelected(bl);
            }
            ((TSGraph)tSGraphObject).setFireEvents(bl2);
            if (bl) {
                this.selected = true;
                ((TSEGraph)tSGraphObject).selectedEdgesList.add(this);
            } else {
                this.selected = false;
                ((TSEGraph)tSGraphObject).selectedEdgesList.remove(this);
            }
            ((TSGraph)tSGraphObject).fireEvent(tSESelectionChangeEvent);
        }
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public void setPathNodesSelected(boolean bl) {
        Iterator iterator = this.pathNodes().iterator();
        while (iterator.hasNext()) {
            TSEPNode tSEPNode = (TSEPNode)iterator.next();
            tSEPNode.setSelected(bl);
        }
    }

    public void setLabelsSelected(boolean bl) {
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator.next();
            tSEEdgeLabel.setSelected(bl);
        }
    }

    public void setDragged(boolean bl) {
        this.dragged = bl;
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        if (object instanceof TSEEdge) {
            TSEEdge tSEEdge = (TSEEdge)object;
            this.url = tSEEdge.getURL();
            this.setUI((TSEEdgeUI)tSEEdge.getUI().clone());
            this.selected = false;
            this.dragged = false;
            this.highlighted = false;
            Iterator iterator = this.bendIterator();
            while (iterator.hasNext()) {
                TSEPNode tSEPNode = (TSEPNode)iterator.next();
                tSEPNode.setSelected(false);
            }
        }
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(NAME_ID);
        list.add(URL_ID);
        if (this.edgeUI != null) {
            this.edgeUI.getInspectorPropertyIDs(list);
        }
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            if (this.getTag() instanceof String) {
                return new TSEInspectorProperty(new String((String)this.getTag()));
            }
            return new TSEInspectorProperty(new String());
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            if (this.getURL() != null) {
                return new TSEInspectorProperty(this.getURL().toExternalForm());
            }
            return new TSEInspectorProperty(new String());
        }
        if (this.edgeUI != null && (tSEInspectorProperty = this.edgeUI.getInspectorProperty(tSEInspectorPropertyID)) != null) {
            return tSEInspectorProperty;
        }
        return null;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            this.setTag(tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            URL uRL = TSSystem.getValidatedURL((String)tSEInspectorProperty.getValue());
            this.setURL(uRL);
            return 2;
        }
        if (this.edgeUI != null) {
            int n = this.edgeUI.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public String getToolTipText() {
        return this.getText();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.url;
        this.url = uRL;
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(4L, new TSEPropertyChangeEventData(this, uRL2, uRL)));
        }
    }

    public boolean isCurved() {
        return this.getCurve() != null;
    }

    public Shape getCurve() {
        Shape shape = null;
        if (this.getUI() != null && this.getUI() instanceof TSECurvedEdgeUI) {
            shape = ((TSECurvedEdgeUI)this.getUI()).getCurve();
        }
        return shape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

