/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.editor.TSEResourceBundleWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TSEFontChooser
extends JDialog
implements WindowListener,
ActionListener,
ItemListener {
    protected EventListenerList listenerList = new EventListenerList();
    public static TSEResourceBundleWrapper labels = TSEResourceBundleWrapper.getSystemLabelBundle();
    public static final int OK = 111;
    public static final int CANCEL = 2323;
    public static final String[] STYLE_NAME = new String[]{labels.getStringSafely("Plain"), labels.getStringSafely("Bold"), labels.getStringSafely("Italic"), labels.getStringSafely("Bold_Italic")};
    public static final int[] STYLE_VALUE = new int[]{0, 1, 2, 3};
    public static final String[] SIZE_NAME = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    public static final int MAX_SIZE = 255;
    public static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    public static final String DEFAULT_TITLE = labels.getStringSafely("Choose_Font");
    public static final String DEFAULT_SAMPLE = labels.getStringSafely("0123AaBbYyZz");
    int exitCode;
    Font currentFont;
    JTextField sampleText;
    JComboBox fontFamily;
    JComboBox fontSize;
    JComboBox fontStyle;
    JButton okButton;
    JButton cancelButton;

    public TSEFontChooser() {
        this.setTitle(DEFAULT_TITLE);
        this.init();
        this.setLocationRelativeTo(null);
    }

    public TSEFontChooser(boolean modal) {
        this.setTitle(DEFAULT_TITLE);
        this.setModal(modal);
        this.init();
        this.setLocationRelativeTo(null);
    }

    public TSEFontChooser(Frame ownerFrame, boolean modal) {
        super(ownerFrame, modal);
        this.setTitle(DEFAULT_TITLE);
        this.init();
        this.setLocationRelativeTo(ownerFrame);
    }

    public TSEFontChooser(Frame ownerFrame, String title, boolean modal) {
        super(ownerFrame, title, modal);
        this.init();
        this.setLocationRelativeTo(ownerFrame);
    }

    void init() {
        this.addWindowListener(this);
        this.sampleText = new JTextField(DEFAULT_SAMPLE);
        JPanel samplePanel = new JPanel();
        samplePanel.setLayout(new BorderLayout());
        samplePanel.add((Component)this.sampleText, "Center");
        samplePanel.setPreferredSize(new Dimension(300, 96));
        this.okButton = new JButton(labels.getStringSafely("OK"));
        this.cancelButton = new JButton(labels.getStringSafely("Cancel"));
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("cancel");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.fontFamily = new JComboBox();
        this.fontSize = new JComboBox();
        this.fontSize.setEditable(true);
        JTextField fontSizeField = (JTextField)this.fontSize.getEditor().getEditorComponent();
        fontSizeField.setDocument(new FontSizeDocument(255));
        this.fontStyle = new JComboBox();
        this.fontFamily.addItemListener(this);
        this.fontSize.addItemListener(this);
        this.fontStyle.addItemListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel comboBoxes = new JPanel();
        comboBoxes.setLayout(new BoxLayout(comboBoxes, 1));
        comboBoxes.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 0));
        samplePanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 10));
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(BorderFactory.createEmptyBorder(17, 12, 11, 11));
        this.getContentPane().add((Component)comboBoxes, "West");
        this.getContentPane().add((Component)samplePanel, "Center");
        this.getContentPane().add((Component)buttons, "South");
        comboBoxes.add(this.fontFamily);
        comboBoxes.add(Box.createRigidArea(new Dimension(0, 5)));
        comboBoxes.add(this.fontStyle);
        comboBoxes.add(Box.createRigidArea(new Dimension(0, 5)));
        comboBoxes.add(this.fontSize);
        comboBoxes.add(Box.createGlue());
        buttons.add(Box.createGlue());
        buttons.add(this.okButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(DEFAULT_TITLE);
        this.setAccessibleProperties(this.fontFamily, "Font_Family", "Font_Family");
        this.setAccessibleProperties(this.fontStyle, "Font_Style", "Font_Style");
        this.setAccessibleProperties(this.fontSize, "Font_Size", "Font_Size");
        this.setAccessibleProperties(this.sampleText, "Font_Sample", "Font_Sample");
        this.setAccessibleProperties(this.okButton, null, "OK");
        this.setAccessibleProperties(this.cancelButton, null, "Cancel");
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TSEFontChooser.this.dispose();
            }
        };
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.pack();
        this.setResizable(false);
        this.currentFont = DEFAULT_FONT;
        this.getFontInfo();
    }

    public static Font showDialog(Component owner, String title, Font initialFont) {
        TSEFontChooser chooser = new TSEFontChooser(JOptionPane.getFrameForComponent(owner), title, true);
        chooser.setLocationRelativeTo(owner);
        chooser.setSelectedFont(initialFont);
        chooser.show();
        Font result = null;
        if (chooser.getExitCode() != 2323) {
            result = chooser.getSelectedFont();
        }
        chooser.dispose();
        return result;
    }

    public void show() {
        this.adjustFontDisplay();
        super.show();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Font getSelectedFont() {
        return this.currentFont;
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            font = DEFAULT_FONT;
        }
        this.currentFont = font;
        this.adjustFontDisplay();
    }

    void adjustFontDisplay() {
        this.fontFamily.setSelectedItem(this.currentFont.getName());
        this.fontSize.setSelectedItem(Integer.toString(this.currentFont.getSize()));
        this.fontStyle.setSelectedItem(this.styleToString(this.currentFont.getStyle()));
        this.sampleText.setFont(this.currentFont);
        this.repaint();
    }

    String styleToString(int style) {
        for (int i = 0; i < STYLE_VALUE.length; ++i) {
            if (STYLE_VALUE[i] != style) continue;
            return STYLE_NAME[i];
        }
        throw new InternalError(Integer.toString(style));
    }

    int stringToStyle(String name) {
        for (int i = 0; i < STYLE_NAME.length; ++i) {
            if (!STYLE_NAME[i].equals(name)) continue;
            return STYLE_VALUE[i];
        }
        throw new InternalError(name);
    }

    String sizeToString(int value) {
        return Integer.toString(value);
    }

    int stringToInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Throwable error) {
            return this.currentFont.getSize();
        }
    }

    void getFontInfo() {
        int i;
        String[] fonts = this.getToolkit().getFontList();
        for (i = 0; i < fonts.length; ++i) {
            this.fontFamily.addItem(fonts[i]);
        }
        for (i = 0; i < SIZE_NAME.length; ++i) {
            this.fontSize.addItem(SIZE_NAME[i]);
        }
        for (i = 0; i < STYLE_NAME.length; ++i) {
            this.fontStyle.addItem(STYLE_NAME[i]);
        }
    }

    void onFontChange() {
        if (this.isVisible()) {
            this.currentFont = new Font(this.fontFamily.getSelectedItem().toString(), this.stringToStyle(this.fontStyle.getSelectedItem().toString()), this.stringToInt(this.fontSize.getSelectedItem().toString()));
            this.sampleText.setFont(this.currentFont);
            this.repaint();
        }
    }

    protected void setAccessibleProperties(Component comp, String accsNameKey, String accsDescKey) {
        if (comp != null) {
            String labelStr = null;
            AccessibleContext accsContext = comp.getAccessibleContext();
            if (accsNameKey != null) {
                labelStr = labels.getStringSafely("ACSN_" + accsNameKey);
                accsContext.setAccessibleName(labelStr);
            }
            if (accsDescKey != null) {
                labelStr = labels.getStringSafely("ACSD_" + accsDescKey);
                accsContext.setAccessibleDescription(labelStr);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(this.okButton.getActionCommand())) {
            this.fireActionPerformed(new ActionEvent(this, 1001, command));
            this.closeDialog(111);
        }
        if (command.equals(this.cancelButton.getActionCommand())) {
            this.fireActionPerformed(new ActionEvent(this, 1001, command));
            this.closeDialog(2323);
        }
    }

    void closeDialog(int exitCode) {
        this.exitCode = exitCode;
        this.setVisible(false);
    }

    public void windowClosing(WindowEvent event) {
        this.closeDialog(2323);
    }

    public void itemStateChanged(ItemEvent event) {
        this.onFontChange();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, event.getActionCommand(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    class FontSizeDocument
    extends PlainDocument {
        int maxValue;

        public FontSizeDocument(int max) {
            this.maxValue = max;
        }

        public void insertString(int offs, String toInsert, AttributeSet a) throws BadLocationException {
            if (toInsert == null) {
                return;
            }
            char[] source = toInsert.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (!Character.isDigit(source[i])) continue;
                char[] newresult = new char[j + 1];
                for (int k = 0; k < j; ++k) {
                    newresult[k] = result[k];
                }
                newresult[j] = source[i];
                String s = this.getText(0, this.getLength()) + String.copyValueOf(newresult);
                if (Integer.parseInt(s) > this.maxValue) continue;
                result[j++] = source[i];
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

