/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.c1;
import com.tomsawyer.editor.complexity.TSENestingManager;
import com.tomsawyer.editor.complexity.command.TSECollapseCommand;
import com.tomsawyer.editor.complexity.command.TSEExpandCommand;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeEventData;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeEventData;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.ui.TSEDefaultGraphUI;
import com.tomsawyer.editor.ui.TSEGraphUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.cw;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f2;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEGraph
extends TSDGraph
implements TSEObject,
TSEInspectable {
    public static TSEInspectorPropertyID NAME_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Name"), class$java$lang$String == null ? (class$java$lang$String = TSEGraph.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID URL_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("URL"), class$java$lang$String == null ? (class$java$lang$String = TSEGraph.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID NODES_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Nodes"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEGraph.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID EDGES_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Edges"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEGraph.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID LABELS_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Labels"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEGraph.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID CHILD_GRAPHS_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Child_Graphs"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEGraph.class$("java.lang.Integer")) : class$java$lang$Integer);
    TSEGraphUI graphUI;
    boolean dragged;
    boolean selected;
    List selectedNodesList;
    List selectedEdgesList;
    List selectedEdgeLabelsList;
    List selectedNodeLabelsList;
    List selectedConnectorLabelsList;
    List selectedPNodesList;
    List selectedConnectorsList;
    TSConstRect originalWorldBounds = null;
    URL url;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    protected TSEGraph() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.setUI(this.newGraphUI());
        this.selected = false;
        this.selectedNodesList = new df();
        this.selectedEdgesList = new df();
        this.selectedEdgeLabelsList = new df();
        this.selectedNodeLabelsList = new df();
        this.selectedConnectorLabelsList = new df();
        this.selectedPNodesList = new df();
        this.selectedConnectorsList = new df();
    }

    protected TSEGraphUI newGraphUI() {
        return new TSEDefaultGraphUI();
    }

    protected TSNode newNode() {
        return new TSENode();
    }

    protected TSNode newNode(int n) {
        return new TSENode();
    }

    public void emptyTopology() {
        this.deselectAll();
        super.emptyTopology();
    }

    public TSEObjectUI getUI() {
        return this.graphUI;
    }

    public TSEGraphUI getGraphUI() {
        return this.graphUI;
    }

    public void setUI(TSEObjectUI tSEObjectUI) {
        if (tSEObjectUI instanceof TSEGraphUI) {
            this.graphUI = (TSEGraphUI)tSEObjectUI;
            this.graphUI.setOwner(this);
        }
    }

    public void setViewability(boolean bl) {
        super.setViewability(bl);
        if (!bl) {
            TSEGraphManager tSEGraphManager;
            if (this.hasSelected()) {
                this.deselectAll();
            }
            if ((tSEGraphManager = (TSEGraphManager)this.getOwnerGraphManager()) != null && !this.isIntergraph()) {
                Vector vector = new Vector(this.buildAllAffectedIntergraphEdgeList());
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    TSGraphObject tSGraphObject;
                    Iterator iterator2;
                    TSEEdge tSEEdge = (TSEEdge)iterator.next();
                    if (tSEEdge.isViewable()) continue;
                    if (tSEEdge.isSelected()) {
                        tSEEdge.setSelected(false);
                    }
                    if (tSEEdge.numberOfPathNodes() > 0) {
                        iterator2 = tSEEdge.pathNodes().iterator();
                        while (iterator2.hasNext()) {
                            tSGraphObject = (TSEPNode)iterator2.next();
                            if (!((TSEPNode)tSGraphObject).isSelected()) continue;
                            ((TSEPNode)tSGraphObject).setSelected(false);
                        }
                    }
                    iterator2 = tSEEdge.labels().iterator();
                    while (iterator2.hasNext()) {
                        tSGraphObject = (TSEEdgeLabel)iterator2.next();
                        if (!((TSEEdgeLabel)tSGraphObject).isSelected()) continue;
                        ((TSEEdgeLabel)tSGraphObject).setSelected(false);
                    }
                }
            }
        }
    }

    public void remove(TSEdge tSEdge) {
        super.remove(tSEdge);
        if (tSEdge instanceof TSEEdge) {
            ((TSEEdge)tSEdge).updateHideMarks();
        }
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        if (this.getUI() != null) {
            this.getUI().onOwnerInserted();
        }
        if (this.numberOfNodes() > 0) {
            Iterator iterator = this.nodes().iterator();
            while (iterator.hasNext()) {
                TSENode tSENode = (TSENode)iterator.next();
                TSENodeUI tSENodeUI = (TSENodeUI)tSENode.getUI();
                if (tSENodeUI == null) continue;
                tSENodeUI.updateHideMark();
            }
        }
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        this.setSelected(false);
        this.selectAll(false);
        if (this.getUI() != null) {
            this.getUI().onOwnerRemoved();
        }
        super.onRemove(tSGraphObject);
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        if (this.getUI() != null) {
            this.getUI().onOwnerDiscarded();
        }
        super.onDiscard(tSGraphObject);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (bl != this.selected) {
            TSEGraphManager tSEGraphManager = (TSEGraphManager)this.getOwner();
            if (tSEGraphManager == null) {
                throw new IllegalStateException("graph has no owner");
            }
            TSESelectionChangeEvent tSESelectionChangeEvent = new TSESelectionChangeEvent(1L, new TSESelectionChangeEventData(this, bl));
            if (this.fireEvent(tSESelectionChangeEvent, true)) {
                boolean bl2 = this.isCoalesce();
                this.setCoalesce(true);
                if (bl) {
                    TSEGraph tSEGraph = tSEGraphManager.selectedGraph();
                    if (tSEGraph != null) {
                        tSEGraph.setSelected(false);
                    }
                    this.selected = true;
                    tSEGraphManager.selectedGraph = this;
                } else {
                    this.selected = false;
                    tSEGraphManager.selectedGraph = null;
                }
                this.fireEvent(tSESelectionChangeEvent);
                this.setCoalesce(bl2);
            }
        }
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public void setDragged(boolean bl) {
        this.dragged = bl;
    }

    public boolean hasSelected() {
        return this.hasSelectedEdges() || this.hasSelectedNodes() || this.hasSelectedEdgeLabels() || this.hasSelectedNodeLabels() || this.hasSelectedConnectorLabels() || this.hasSelectedPathNodes() || this.hasSelectedConnectors();
    }

    public boolean hasSelectedNodes() {
        return !this.selectedNodesList.isEmpty();
    }

    public boolean hasSelectedEdges(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.selectedEdgesList.isEmpty();
        if (bl2 && !bl) {
            bl2 = false;
            Iterator iterator = this.selectedEdgesList.iterator();
            while (!bl2 && iterator.hasNext()) {
                bl2 = !((TSEEdge)iterator.next()).isMetaEdge();
            }
        }
        return bl2;
    }

    public boolean hasSelectedEdges() {
        return this.hasSelectedEdges(true);
    }

    public boolean hasSelectedEdgeLabels() {
        return this.hasSelectedEdgeLabels(true);
    }

    public boolean hasSelectedEdgeLabels(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.selectedEdgeLabelsList.isEmpty();
        if (bl2 && !bl) {
            bl2 = false;
            Iterator iterator = this.selectedEdgeLabelsList.iterator();
            while (!bl2 && iterator.hasNext()) {
                TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator.next();
                bl2 = !((TSEEdge)tSEEdgeLabel.getOwner()).isMetaEdge();
            }
        }
        return bl2;
    }

    public boolean hasSelectedNodeLabels() {
        return !this.selectedNodeLabelsList.isEmpty();
    }

    public boolean hasSelectedConnectorLabels() {
        return !this.selectedConnectorLabelsList.isEmpty();
    }

    public boolean hasSelectedPathNodes(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.selectedPNodesList.isEmpty();
        if (bl2 && !bl) {
            bl2 = false;
            Iterator iterator = this.selectedPNodesList.iterator();
            while (!bl2 && iterator.hasNext()) {
                TSEPNode tSEPNode = (TSEPNode)iterator.next();
                bl2 = !((TSEEdge)tSEPNode.getOwner()).isMetaEdge();
            }
        }
        return bl2;
    }

    public boolean hasSelectedPathNodes() {
        return this.hasSelectedPathNodes(true);
    }

    public boolean hasSelectedConnectors() {
        return !this.selectedConnectorsList.isEmpty();
    }

    public int numberOfSelectedObjects() {
        return this.selectedEdges().size() + this.selectedNodes().size() + this.selectedEdgeLabels().size() + this.selectedNodeLabels().size() + this.selectedConnectorLabels().size() + this.selectedPathNodes().size() + this.selectedConnectors().size();
    }

    public List selectedNodes() {
        return this.selectedNodesList;
    }

    public List selectedEdges() {
        return this.selectedEdgesList;
    }

    public List selectedEdgeLabels() {
        return this.selectedEdgeLabelsList;
    }

    public List selectedNodeLabels() {
        return this.selectedNodeLabelsList;
    }

    public List selectedConnectorLabels() {
        return this.selectedConnectorLabelsList;
    }

    public List selectedPathNodes() {
        return this.selectedPNodesList;
    }

    public List selectedConnectors() {
        return this.selectedConnectorsList;
    }

    public void selectAll(boolean bl) {
        this.selectAllEdges(bl);
        this.selectAllNodes(bl);
        this.selectAllEdgeLabels(bl);
        this.selectAllNodeLabels(bl);
        this.selectAllConnectorLabels(bl);
        this.selectAllPathNodes(bl);
        this.selectAllConnectors(bl);
    }

    public void selectAllNodes(boolean bl) {
        this.selectAllNodes(bl, null);
    }

    public void selectAllNodes(boolean bl, TSEObject tSEObject) {
        if (bl) {
            f2.a(f2.az);
        }
        boolean bl2 = tSEObject instanceof TSENode;
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (bl) {
            Iterator iterator = this.nodes().iterator();
            while (iterator.hasNext()) {
                TSENode tSENode = (TSENode)iterator.next();
                if (bl2 && tSEObject == tSENode) continue;
                tSENode.setSelected(bl);
            }
        } else {
            List list = this.selectedNodes();
            int n = 0;
            while (n < list.size()) {
                TSENode tSENode = (TSENode)list.get(n);
                int n2 = list.size();
                if (!bl2 || tSEObject != tSENode) {
                    tSENode.setSelected(false);
                }
                if (n2 != list.size()) continue;
                ++n;
            }
        }
        this.setCoalesce(bl3);
    }

    public void selectAllEdges(boolean bl) {
        this.selectAllEdges(bl, null);
    }

    public void selectAllEdges(boolean bl, TSEObject tSEObject) {
        if (bl) {
            f2.a(f2.az);
        }
        boolean bl2 = tSEObject instanceof TSEEdge;
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (bl) {
            Iterator iterator = this.isIntergraph() ? this.disconnectedEdges().iterator() : this.edges().iterator();
            while (iterator.hasNext()) {
                TSEEdge tSEEdge = (TSEEdge)iterator.next();
                if (!tSEEdge.isViewable() || bl2 && tSEEdge == tSEObject) continue;
                tSEEdge.setSelected(bl);
            }
        } else {
            List list = this.selectedEdges();
            int n = 0;
            while (n < list.size()) {
                TSEEdge tSEEdge = (TSEEdge)list.get(n);
                int n2 = list.size();
                if (!bl2 || tSEEdge != tSEObject) {
                    tSEEdge.setSelected(false);
                }
                if (n2 != list.size()) continue;
                ++n;
            }
        }
        this.setCoalesce(bl3);
    }

    public void selectAllEdgeLabels(boolean bl) {
        this.selectAllEdgeLabels(bl, null);
    }

    public void selectAllEdgeLabels(boolean bl, TSEObject tSEObject) {
        if (bl) {
            f2.a(f2.az);
        }
        boolean bl2 = tSEObject instanceof TSEEdgeLabel;
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (bl) {
            Iterator iterator = this.isIntergraph() ? this.disconnectedEdges().iterator() : this.edges().iterator();
            while (iterator.hasNext()) {
                TSEEdge tSEEdge = (TSEEdge)iterator.next();
                if (!tSEEdge.isViewable()) continue;
                Iterator iterator2 = tSEEdge.labels().iterator();
                while (iterator2.hasNext()) {
                    TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator2.next();
                    if (bl2 && tSEEdgeLabel == tSEObject) continue;
                    tSEEdgeLabel.setSelected(bl);
                }
            }
        } else {
            List list = this.selectedEdgeLabels();
            int n = 0;
            while (n < list.size()) {
                TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)list.get(n);
                int n2 = list.size();
                if (!bl2 || tSEEdgeLabel != tSEObject) {
                    tSEEdgeLabel.setSelected(false);
                }
                if (n2 != list.size()) continue;
                ++n;
            }
        }
        this.setCoalesce(bl3);
    }

    public void selectAllNodeLabels(boolean bl) {
        this.selectAllNodeLabels(bl, null);
    }

    public void selectAllNodeLabels(boolean bl, TSEObject tSEObject) {
        if (bl) {
            f2.a(f2.az);
        }
        boolean bl2 = tSEObject instanceof TSENodeLabel;
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (bl) {
            Iterator iterator = this.nodes().iterator();
            while (iterator.hasNext()) {
                TSENode tSENode = (TSENode)iterator.next();
                Iterator iterator2 = tSENode.labels().iterator();
                while (iterator2.hasNext()) {
                    TSENodeLabel tSENodeLabel = (TSENodeLabel)iterator2.next();
                    if (bl2 && tSEObject == tSENodeLabel) continue;
                    tSENodeLabel.setSelected(bl);
                }
            }
        } else {
            List list = this.selectedNodeLabels();
            int n = 0;
            while (n < list.size()) {
                TSENodeLabel tSENodeLabel = (TSENodeLabel)list.get(n);
                int n2 = list.size();
                if (!bl2 || tSEObject != tSENodeLabel) {
                    tSENodeLabel.setSelected(false);
                }
                if (n2 != list.size()) continue;
                ++n;
            }
        }
        this.setCoalesce(bl3);
    }

    public void selectAllConnectorLabels(boolean bl) {
        this.selectAllConnectorLabels(bl, null);
    }

    public void selectAllConnectorLabels(boolean bl, TSEObject tSEObject) {
        if (bl) {
            f2.a(f2.az);
        }
        boolean bl2 = tSEObject instanceof TSEConnectorLabel;
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (bl) {
            Iterator iterator = this.nodes().iterator();
            while (iterator.hasNext()) {
                TSENode tSENode = (TSENode)iterator.next();
                Iterator iterator2 = tSENode.connectors().iterator();
                while (iterator2.hasNext()) {
                    TSEConnector tSEConnector = (TSEConnector)iterator2.next();
                    Iterator iterator3 = tSEConnector.labels().iterator();
                    while (iterator3.hasNext()) {
                        TSEConnectorLabel tSEConnectorLabel = (TSEConnectorLabel)iterator3.next();
                        if (bl2 && tSEObject == tSEConnectorLabel) continue;
                        tSEConnectorLabel.setSelected(bl);
                    }
                }
            }
        } else {
            List list = this.selectedConnectorLabels();
            int n = 0;
            while (n < list.size()) {
                TSEConnectorLabel tSEConnectorLabel = (TSEConnectorLabel)list.get(n);
                int n2 = list.size();
                if (!bl2 || tSEObject != tSEConnectorLabel) {
                    tSEConnectorLabel.setSelected(false);
                }
                if (n2 != list.size()) continue;
                ++n;
            }
        }
        this.setCoalesce(bl3);
    }

    public void selectAllPathNodes(boolean bl) {
        this.selectAllPathNodes(bl, null);
    }

    public void selectAllPathNodes(boolean bl, TSEObject tSEObject) {
        if (bl) {
            f2.a(f2.az);
        }
        boolean bl2 = tSEObject instanceof TSEPNode || tSEObject instanceof TSEEdge;
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (bl) {
            Iterator iterator = this.isIntergraph() ? this.disconnectedEdges().iterator() : this.edges().iterator();
            while (iterator.hasNext()) {
                TSEEdge tSEEdge = (TSEEdge)iterator.next();
                if (tSEEdge.numberOfPathEdges() <= 1 || !tSEEdge.isViewable()) continue;
                Iterator iterator2 = tSEEdge.bendIterator();
                while (iterator2.hasNext()) {
                    TSEPNode tSEPNode = (TSEPNode)iterator2.next();
                    if (bl2 && (tSEPNode == tSEObject || tSEPNode.getOwner() == tSEObject)) continue;
                    tSEPNode.setSelected(bl);
                }
            }
        } else {
            List list = this.selectedPathNodes();
            int n = 0;
            while (n < list.size()) {
                TSEPNode tSEPNode = (TSEPNode)list.get(n);
                int n2 = list.size();
                if (!bl2 || tSEPNode != tSEObject && tSEPNode.getOwner() != tSEObject) {
                    tSEPNode.setSelected(false);
                }
                if (n2 != list.size()) continue;
                ++n;
            }
        }
        this.setCoalesce(bl3);
    }

    public void selectAllConnectors(boolean bl) {
        this.selectAllConnectors(bl, null);
    }

    public void selectAllConnectors(boolean bl, TSEObject tSEObject) {
        if (bl) {
            f2.a(f2.az);
        }
        boolean bl2 = tSEObject instanceof TSEConnector;
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (bl) {
            Iterator iterator = this.nodes().iterator();
            while (iterator.hasNext()) {
                TSENode tSENode = (TSENode)iterator.next();
                Iterator iterator2 = tSENode.connectors().iterator();
                while (iterator2.hasNext()) {
                    TSEConnector tSEConnector = (TSEConnector)iterator2.next();
                    if (bl2 && tSEObject == tSEConnector) continue;
                    tSEConnector.setSelected(bl);
                }
            }
        } else {
            List list = this.selectedConnectors();
            int n = 0;
            while (n < list.size()) {
                TSEConnector tSEConnector = (TSEConnector)list.get(n);
                int n2 = list.size();
                if (!bl2 || tSEObject != tSEConnector) {
                    tSEConnector.setSelected(false);
                }
                if (n2 != list.size()) continue;
                ++n;
            }
        }
        this.setCoalesce(bl3);
    }

    public void deselectAll() {
        this.deselectAll(null);
    }

    public void deselectAll(TSEObject tSEObject) {
        boolean bl = this.isCoalesce();
        this.setCoalesce(true);
        this.selectAllNodes(false, tSEObject);
        this.selectAllEdges(false, tSEObject);
        this.selectAllEdgeLabels(false, tSEObject);
        this.selectAllNodeLabels(false, tSEObject);
        this.selectAllConnectorLabels(false, tSEObject);
        this.selectAllPathNodes(false, tSEObject);
        this.selectAllConnectors(false, tSEObject);
        this.setCoalesce(bl);
    }

    protected void notifyParentOnBoundsUpdate() {
        TSGraphMember tSGraphMember = this.getParent();
        if (tSGraphMember != null && tSGraphMember.isExpanded()) {
            TSENestingManager tSENestingManager = (TSENestingManager)TSENestingManager.getManager((TSEGraphManager)this.getOwnerGraphManager());
            tSENestingManager.updateOnNestedGraphBoundsChange((TSENode)tSGraphMember);
        }
    }

    public TSRect getSelectedNodesBounds() {
        if (this.hasSelectedNodes()) {
            TSRect tSRect = new TSRect();
            Iterator iterator = this.selectedNodesList.iterator();
            tSRect.setBounds(((TSENode)iterator.next()).getBounds(4));
            while (iterator.hasNext()) {
                tSRect.merge(((TSENode)iterator.next()).getBounds(4));
            }
            return tSRect;
        }
        return null;
    }

    public TSRect getSelectedEdgesBounds() {
        TSDGraph tSDGraph;
        Iterator iterator;
        TSEEdge tSEEdge;
        TSRect tSRect = new TSRect();
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        List list = tSGraphManager.intergraphEdges();
        if (list.size() > 0 && (tSEEdge = (TSEEdge)(iterator = list.iterator()).next()).isReachable() && (tSDGraph = (TSDGraph)tSEEdge.getTransformGraph()) == this && tSEEdge.isViewable()) {
            tSRect.setBounds(tSEEdge.getBounds(1));
            while (iterator.hasNext()) {
                tSRect.merge(((TSEEdge)iterator.next()).getBounds(1));
            }
        }
        if (this.hasSelectedEdges()) {
            iterator = this.selectedEdgesList.iterator();
            tSRect.setBounds(((TSEEdge)iterator.next()).getBounds(1));
            while (iterator.hasNext()) {
                tSRect.merge(((TSEEdge)iterator.next()).getBounds(1));
            }
        }
        return tSRect;
    }

    public TSRect getSelectedNodeLabelsBounds() {
        if (this.hasSelectedNodeLabels()) {
            TSRect tSRect = new TSRect();
            Iterator iterator = this.selectedNodeLabelsList.iterator();
            tSRect.setBounds(((TSENodeLabel)iterator.next()).getBounds());
            while (iterator.hasNext()) {
                tSRect.merge(((TSENodeLabel)iterator.next()).getBounds());
            }
            return tSRect;
        }
        return null;
    }

    public TSRect getSelectedEdgeLabelsBounds() {
        Iterator iterator;
        TSRect tSRect = new TSRect();
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        Iterator iterator2 = tSGraphManager.intergraphEdges().iterator();
        while (iterator2.hasNext()) {
            TSDGraph tSDGraph;
            TSEEdge tSEEdge = (TSEEdge)iterator2.next();
            if (!tSEEdge.isReachable() || (tSDGraph = (TSDGraph)tSEEdge.getTransformGraph()) != this || !tSEEdge.isViewable()) continue;
            tSRect.setBounds(tSEEdge.getBounds(1));
            iterator = tSEEdge.labels().iterator();
            while (iterator.hasNext()) {
                tSRect.merge(((TSEEdgeLabel)iterator.next()).getBounds());
            }
        }
        if (this.hasSelectedEdgeLabels()) {
            iterator = this.selectedEdgeLabelsList.iterator();
            tSRect.setBounds(((TSEEdgeLabel)iterator.next()).getBounds());
            while (iterator.hasNext()) {
                tSRect.merge(((TSEEdgeLabel)iterator.next()).getBounds());
            }
        }
        return tSRect;
    }

    public TSRect getSelectedConnectorLabelsBounds() {
        if (this.hasSelectedConnectorLabels()) {
            TSRect tSRect = new TSRect();
            Iterator iterator = this.selectedConnectorLabelsList.iterator();
            tSRect.setBounds(((TSEConnectorLabel)iterator.next()).getBounds());
            while (iterator.hasNext()) {
                tSRect.merge(((TSEConnectorLabel)iterator.next()).getBounds());
            }
            return tSRect;
        }
        return null;
    }

    public TSRect getSelectedPathNodesBounds() {
        Iterator iterator;
        TSRect tSRect = new TSRect();
        TSGraphManager tSGraphManager = this.getOwnerGraphManager();
        List list = tSGraphManager.intergraphEdges();
        if (list.size() > 0) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph;
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (!tSDEdge.isReachable() || (tSDGraph = (TSDGraph)tSDEdge.getTransformGraph()) != this || !tSDEdge.isViewable()) continue;
                Iterator iterator2 = tSDEdge.bendIterator();
                while (iterator2.hasNext()) {
                    TSEPNode tSEPNode = (TSEPNode)iterator2.next();
                    tSRect.merge(tSEPNode.getBounds());
                }
            }
        }
        if (this.hasSelectedPathNodes()) {
            iterator = this.selectedPNodesList.iterator();
            tSRect.setBounds(((TSEPNode)iterator.next()).getBounds());
            while (iterator.hasNext()) {
                tSRect.merge(((TSEPNode)iterator.next()).getBounds());
            }
        }
        return tSRect;
    }

    public TSRect getSelectedConnectorsBounds() {
        if (this.hasSelectedConnectors()) {
            TSRect tSRect = new TSRect();
            Iterator iterator = this.selectedConnectorsList.iterator();
            tSRect.setBounds(((TSEConnector)iterator.next()).getBounds());
            while (iterator.hasNext()) {
                tSRect.merge(((TSEConnector)iterator.next()).getBounds());
            }
            return tSRect;
        }
        return null;
    }

    public TSRect getSelectedObjectsBounds() {
        TSRect tSRect = null;
        if (this.hasSelectedNodes()) {
            if (tSRect == null) {
                tSRect = this.getSelectedNodesBounds();
            } else {
                tSRect.merge(this.getSelectedNodesBounds());
            }
        }
        if (this.hasSelectedEdges()) {
            if (tSRect == null) {
                tSRect = this.getSelectedEdgesBounds();
            } else {
                tSRect.merge(this.getSelectedEdgesBounds());
            }
        }
        if (this.hasSelectedConnectors()) {
            if (tSRect == null) {
                tSRect = this.getSelectedConnectorsBounds();
            } else {
                tSRect.merge(this.getSelectedConnectorsBounds());
            }
        }
        if (this.hasSelectedNodeLabels()) {
            if (tSRect == null) {
                tSRect = this.getSelectedNodeLabelsBounds();
            } else {
                tSRect.merge(this.getSelectedNodeLabelsBounds());
            }
        }
        if (this.hasSelectedEdgeLabels()) {
            if (tSRect == null) {
                tSRect = this.getSelectedEdgeLabelsBounds();
            } else {
                tSRect.merge(this.getSelectedEdgeLabelsBounds());
            }
        }
        if (this.hasSelectedConnectorLabels()) {
            if (tSRect == null) {
                tSRect = this.getSelectedConnectorLabelsBounds();
            } else {
                tSRect.merge(this.getSelectedConnectorLabelsBounds());
            }
        }
        if (this.hasSelectedPathNodes()) {
            if (tSRect == null) {
                tSRect = this.getSelectedPathNodesBounds();
            } else {
                tSRect.merge(this.getSelectedPathNodesBounds());
            }
        }
        return tSRect;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        if (object instanceof TSEGraph) {
            TSEGraph tSEGraph = (TSEGraph)object;
            this.url = tSEGraph.getURL();
            this.setUI((TSEObjectUI)tSEGraph.getUI().clone());
        }
    }

    public void setOriginalVisibleBounds(TSConstRect tSConstRect) {
        this.originalWorldBounds = tSConstRect == null ? null : new TSConstRect(tSConstRect);
    }

    public TSConstRect getOriginalVisibleBounds() {
        return this.originalWorldBounds;
    }

    protected cw newGMFReader(Reader reader) {
        return new c1(reader);
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(NAME_ID);
        list.add(URL_ID);
        list.add(NODES_ID);
        list.add(EDGES_ID);
        list.add(LABELS_ID);
        list.add(CHILD_GRAPHS_ID);
        if (this.graphUI != null) {
            this.graphUI.getInspectorPropertyIDs(list);
        }
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            if (this.getTag() instanceof String) {
                return new TSEInspectorProperty(new String((String)this.getTag()));
            }
            return new TSEInspectorProperty(new String());
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            if (this.getURL() != null) {
                return new TSEInspectorProperty(this.getURL().toExternalForm());
            }
            return new TSEInspectorProperty(new String());
        }
        if (tSEInspectorPropertyID.equals(NODES_ID)) {
            return new TSEInspectorProperty((Object)new Integer(this.numberOfNodes()), false);
        }
        if (tSEInspectorPropertyID.equals(EDGES_ID)) {
            return new TSEInspectorProperty((Object)new Integer(this.numberOfEdges()), false);
        }
        if (tSEInspectorPropertyID.equals(LABELS_ID)) {
            return new TSEInspectorProperty((Object)new Integer(this.numberOfNodeLabels() + this.numberOfConnectorLabels() + this.numberOfEdgeLabels()), false);
        }
        if (tSEInspectorPropertyID.equals(CHILD_GRAPHS_ID)) {
            return new TSEInspectorProperty((Object)new Integer(this.numberOfGraphs() - 1), false);
        }
        if (this.graphUI != null && (tSEInspectorProperty = this.graphUI.getInspectorProperty(tSEInspectorPropertyID)) != null) {
            return tSEInspectorProperty;
        }
        return null;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            this.setTag(tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            URL uRL = TSSystem.getValidatedURL((String)tSEInspectorProperty.getValue());
            this.setURL(uRL);
            return 2;
        }
        if (this.graphUI != null) {
            int n = this.graphUI.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public TSEGraphWindow getGraphWindow() {
        return ((TSEGraphManager)this.getOwnerGraphManager()).getGraphWindow();
    }

    public int levelNumber() {
        return 2;
    }

    public void expandAll() {
        this.expandCollapseAll(true, false);
    }

    public void collapseAll() {
        this.expandCollapseAll(false, false);
    }

    public void expandSelected() {
        this.expandCollapseAll(true, true);
    }

    public void collapseSelected() {
        this.expandCollapseAll(false, true);
    }

    void expandCollapseAll(boolean bl, boolean bl2) {
        TSCommand tSCommand = bl ? new TSEExpandCommand(this, true, !bl2) : new TSECollapseCommand(this, true, !bl2);
        this.getGraphWindow().transmit(tSCommand);
    }

    public TSDGraph newHideGraph() {
        return new TSEGraph();
    }

    public String getToolTipText() {
        return this.getText();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.url;
        this.url = uRL;
        this.fireEvent(new TSEPropertyChangeEvent(4L, new TSEPropertyChangeEventData(this, uRL2, uRL)));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

