/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.util.f2;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;

public class TSEGraphImageEncoder {
    private TSEGraphWindow graphWindow;
    boolean useAlpha = false;
    int filterDepth = 0;
    int compressionLevel = 3;
    static /* synthetic */ Class class$java$awt$image$BufferedImage;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$com$lowagie$text$Rectangle;
    static /* synthetic */ Class class$java$lang$String;

    public TSEGraphImageEncoder(TSEGraphWindow tSEGraphWindow) {
        f2.a(f2.a6);
        this.graphWindow = tSEGraphWindow;
    }

    public void writeJPEGFormat(OutputStream outputStream) throws IOException, ImageFormatException {
        this.writeJPEGFormat(outputStream, false, 1, false, false, 1.0f, (int)this.getGraph().getWidth(), (int)this.getGraph().getHeight());
    }

    public void writeJPEGFormat(OutputStream outputStream, boolean bl, int n, boolean bl2, boolean bl3, float f, int n2, int n3) throws IOException, ImageFormatException {
        if (outputStream == null) {
            return;
        }
        BufferedImage bufferedImage = this.getBufferedGraphImage(bl, n, bl2, bl3, n2, n3);
        try {
            Method method;
            Class<?> clazz = Class.forName("com.sun.image.codec.jpeg.JPEGCodec");
            Class<?> clazz2 = Class.forName("com.sun.image.codec.jpeg.JPEGImageEncoder");
            Class<?> clazz3 = Class.forName("com.sun.image.codec.jpeg.JPEGEncodeParam");
            Method method2 = this.findMethod(clazz, "createJPEGEncoder", 1);
            Object object = method2.invoke(null, outputStream);
            Object object2 = this.getJPEGEncodeParam();
            if (object2 == null) {
                method = clazz2.getMethod("getDefaultJPEGEncodeParam", class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = TSEGraphImageEncoder.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage);
                object2 = method.invoke(object, bufferedImage);
            }
            method = this.findMethod(clazz3, "setQuality", 2);
            method.invoke(object2, new Float(f), Boolean.FALSE);
            Method method3 = this.findMethod(clazz2, "setJPEGEncodeParam", 1);
            method3.invoke(object, object2);
            if (bufferedImage != null) {
                Method method4 = clazz2.getMethod("encode", class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = TSEGraphImageEncoder.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage);
                method4.invoke(object, bufferedImage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.getGraphWindow().drawGraph();
        }
    }

    public JPEGEncodeParam getJPEGEncodeParam() {
        return null;
    }

    public void writeSVGFormat(OutputStream outputStream) throws IOException {
        this.writeSVGFormat(outputStream, false, 1, false, false, (int)this.getGraph().getWidth(), (int)this.getGraph().getHeight());
    }

    public void writeSVGFormat(OutputStream outputStream, boolean bl, int n, boolean bl2, boolean bl3, int n2, int n3) throws IOException {
        if (outputStream == null) {
            return;
        }
        try {
            Object object;
            Class<?> clazz = Class.forName("org.w3c.dom.DOMImplementation");
            Class<?> clazz2 = Class.forName("org.apache.batik.dom.GenericDOMImplementation");
            Class<?> clazz3 = Class.forName("org.w3c.dom.Document");
            Class<?> clazz4 = Class.forName("org.apache.batik.svggen.SVGGraphics2D");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            Method method = this.findMethod(clazz2, "getDOMImplementation", 0);
            Object object2 = method.invoke(null, null);
            Method method2 = this.findMethod(clazz, "createDocument", 3);
            Object object3 = method2.invoke(object2, null, "svg", null);
            Constructor<?> constructor = clazz4.getConstructor(clazz3);
            Object obj = constructor.newInstance(object3);
            Method method3 = this.findMethod(clazz4, "setSVGCanvasSize", 1);
            if (!bl) {
                object = this.getSize(n, n2, n3);
                n2 = (int)((Dimension)object).getWidth();
                n3 = (int)((Dimension)object).getHeight();
            } else {
                n2 = this.getGraphWindow().getCanvas().getWidth();
                n3 = this.getGraphWindow().getCanvas().getHeight();
            }
            method3.invoke(obj, new Dimension(n2, n3));
            object = System.getProperty("useCss", "true");
            boolean bl4 = ((String)object).equalsIgnoreCase("true");
            TSEGraphics tSEGraphics = this.getGraphWindow().newGraphics((Graphics)obj);
            if (bl) {
                this.getGraphWindow().drawGraph(tSEGraphics, bl2, false, bl3);
            } else {
                this.getGraphWindow().drawEntireGraph(tSEGraphics, n, bl2, bl3, n2, n3);
            }
            if (outputStreamWriter != null) {
                Method method4 = clazz4.getMethod("stream", class$java$io$Writer == null ? (class$java$io$Writer = TSEGraphImageEncoder.class$("java.io.Writer")) : class$java$io$Writer, Boolean.TYPE);
                method4.invoke(obj, outputStreamWriter, new Boolean(bl4));
            }
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.getGraphWindow().drawGraph();
        }
    }

    public void writePNGFormat(OutputStream outputStream) throws IOException, ImageFormatException {
        this.writePNGFormat(outputStream, false, 1, false, false, (int)this.getGraph().getWidth(), (int)this.getGraph().getHeight());
    }

    public void writePNGFormat(OutputStream outputStream, boolean bl, int n, boolean bl2, boolean bl3, int n2, int n3) throws IOException, ImageFormatException {
        if (outputStream == null) {
            return;
        }
        BufferedImage bufferedImage = this.getBufferedGraphImage(bl, n, bl2, bl3, n2, n3);
        byte[] byArray = null;
        try {
            Class<?> clazz = Class.forName("com.keypoint.PngEncoder");
            Constructor<?> constructor = clazz.getConstructor(class$java$awt$Image == null ? (class$java$awt$Image = TSEGraphImageEncoder.class$("java.awt.Image")) : class$java$awt$Image, Boolean.TYPE, Integer.TYPE, Integer.TYPE);
            Method method = clazz.getMethod("pngEncode", null);
            Object obj = constructor.newInstance(bufferedImage, new Boolean(this.useAlpha), new Integer(this.filterDepth), new Integer(this.compressionLevel));
            byArray = (byte[])method.invoke(obj, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray == null) {
            System.out.println("Null image");
        } else {
            outputStream.write(byArray);
        }
        outputStream.flush();
        outputStream.close();
        if (bl) {
            this.getGraphWindow().drawGraph();
        }
    }

    public void configurePNGEncoder(boolean bl, int n, int n2) {
        this.useAlpha = bl;
        this.filterDepth = n;
        this.compressionLevel = n2;
    }

    public void writePDFFormat(OutputStream outputStream) throws IOException, DocumentException {
        this.writePDFFormat(outputStream, false, 1, false, false, (int)this.getGraph().getWidth(), (int)this.getGraph().getHeight());
    }

    public void writePDFFormat(OutputStream outputStream, boolean bl, int n, boolean bl2, boolean bl3, int n2, int n3) throws IOException {
        Object object;
        if (outputStream == null) {
            return;
        }
        if (!bl) {
            object = this.getSize(n, n2, n3);
            n2 = (int)((Dimension)object).getWidth();
            n3 = (int)((Dimension)object).getHeight();
        } else {
            n2 = this.getGraphWindow().getCanvas().getWidth();
            n3 = this.getGraphWindow().getCanvas().getHeight();
        }
        object = this.createPDFDocument(n2, n3);
        if (object == null) {
            return;
        }
        Document document = (Document)object;
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)n2, (float)n3);
            Graphics2D graphics2D = pdfTemplate.createGraphics((float)n2, (float)n3);
            TSEGraphics tSEGraphics = this.getGraphWindow().newGraphics(graphics2D);
            if (bl) {
                this.getGraphWindow().drawGraph(tSEGraphics, bl2, false, bl3);
                this.getGraphWindow().drawGraph();
            } else {
                this.getGraphWindow().drawEntireGraph(tSEGraphics, n, bl2, bl3, n2, n3);
            }
            tSEGraphics.dispose();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        document.close();
    }

    private Dimension getSize(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n == 0) {
            n4 = (int)(this.getGraph().getFrameBounds().getWidth() * this.graphWindow.getZoomLevel());
            n5 = (int)(this.getGraph().getFrameBounds().getHeight() * this.graphWindow.getZoomLevel());
        } else if (n == 2) {
            n4 = this.getGraphWindow().getCanvas().getWidth();
            n5 = this.getGraphWindow().getCanvas().getHeight();
        } else if (n != 3) {
            n4 = (int)this.getGraph().getFrameBounds().getWidth();
            n5 = (int)this.getGraph().getFrameBounds().getHeight();
        }
        return new Dimension(n4, n5);
    }

    public Object createPDFDocument(int n, int n2) {
        Object obj;
        Executable executable;
        Class<?> clazz;
        try {
            clazz = Class.forName("com.lowagie.text.Document");
            executable = clazz.getConstructor(class$com$lowagie$text$Rectangle == null ? (class$com$lowagie$text$Rectangle = TSEGraphImageEncoder.class$("com.lowagie.text.Rectangle")) : class$com$lowagie$text$Rectangle);
            obj = ((Constructor)executable).newInstance(new Rectangle((float)n, (float)n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        try {
            executable = clazz.getMethod("addAuthor", class$java$lang$String == null ? (class$java$lang$String = TSEGraphImageEncoder.class$("java.lang.String")) : class$java$lang$String);
            Method method = clazz.getMethod("addCreator", class$java$lang$String == null ? (class$java$lang$String = TSEGraphImageEncoder.class$("java.lang.String")) : class$java$lang$String);
            Method method2 = clazz.getMethod("addTitle", class$java$lang$String == null ? (class$java$lang$String = TSEGraphImageEncoder.class$("java.lang.String")) : class$java$lang$String);
            Boolean bl = (Boolean)((Method)executable).invoke(obj, "Tom Sawyer Software");
            bl = (Boolean)method.invoke(obj, "Tom Sawyer Visualization");
            if (this.getGraph().getText() != null) {
                bl = (Boolean)method2.invoke(obj, this.getGraph().getText());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return obj;
    }

    public BufferedImage getBufferedGraphImage() {
        return this.getBufferedGraphImage(false, 1, false, false);
    }

    public BufferedImage getBufferedGraphImage(boolean bl, int n, boolean bl2, boolean bl3) {
        return this.getBufferedGraphImage(bl, n, bl2, bl3, (int)this.getGraph().getWidth(), (int)this.getGraph().getHeight());
    }

    public BufferedImage getBufferedGraphImage(boolean bl, int n, boolean bl2, boolean bl3, int n2, int n3) {
        BufferedImage bufferedImage;
        if (!bl) {
            Dimension dimension = this.getSize(n, n2, n3);
            n2 = (int)dimension.getWidth();
            n3 = (int)dimension.getHeight();
            bufferedImage = (BufferedImage)this.getGraphWindow().createImage(n2, n3);
            this.getGraphWindow().createEntireGraphImage(bufferedImage, n, bl2, bl3, n2, n3);
        } else {
            bufferedImage = (BufferedImage)this.getGraphWindow().getVisibleGraphImage(bl2, bl3);
        }
        return bufferedImage;
    }

    protected TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    protected TSEGraph getGraph() {
        return this.getGraphWindow().getGraph();
    }

    Method findMethod(Class clazz, String string, int n) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(string) || method.getParameterTypes().length != n) continue;
            return method;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

