/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.c1;
import com.tomsawyer.editor.complexity.TSEFoldingManager;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.complexity.TSENestingManager;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.cw;
import com.tomsawyer.graph.event.TSEventManager;
import com.tomsawyer.util.df;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEGraphManager
extends TSDGraphManager {
    TSEGraph selectedGraph;
    TSEGraphWindow graphWindow;

    protected void initGraphObject() {
        super.initGraphObject();
        this.graphWindow = null;
        this.selectedGraph = null;
        TSENestingManager.getManager(this);
        TSEFoldingManager.getManager(this);
        TSEHidingManager.getManager(this);
    }

    public TSEventManager newEventManager() {
        return new TSEEventManager();
    }

    public void expandNodeOnCopy(TSGraphMember tSGraphMember) {
        TSENestingManager tSENestingManager = (TSENestingManager)TSNestingManager.getManager((TSDGraphManager)tSGraphMember.getOwnerGraphManager());
        TSENestingManager.expand((TSENode)tSGraphMember);
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public void setGraphWindow(TSEGraphWindow tSEGraphWindow) {
        this.graphWindow = tSEGraphWindow;
        if (tSEGraphWindow != null) {
            tSEGraphWindow.getGraph().setSelected(true);
        }
    }

    protected TSGraph duplicateGraph(TSGraph tSGraph, boolean bl) {
        TSEGraph tSEGraph = (TSEGraph)super.duplicateGraph(tSGraph, bl);
        if (tSEGraph.hideGraph() != null) {
            Iterator iterator = tSEGraph.nodes().iterator();
            while (iterator.hasNext()) {
                TSENode tSENode = (TSENode)iterator.next();
                tSENode.getNodeUI().updateHideMark();
            }
        }
        return tSEGraph;
    }

    public List reachableGraphList() {
        df df2 = new df();
        Iterator iterator = this.graphs(false).iterator();
        TSEGraph tSEGraph = null;
        if (iterator.hasNext()) {
            tSEGraph = (TSEGraph)this.getMainDisplayGraph().getGreatestAncestor();
        }
        while (iterator.hasNext()) {
            TSEGraph tSEGraph2 = (TSEGraph)iterator.next();
            if (tSEGraph2.getGreatestAncestor() != tSEGraph) continue;
            df2.add(tSEGraph2);
        }
        return df2;
    }

    protected List reachableIntergraphEdgeList() {
        df df2 = new df();
        Iterator iterator = this.intergraphEdges().iterator();
        TSEGraph tSEGraph = (TSEGraph)this.getMainDisplayGraph().getGreatestAncestor();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph2;
            TSEEdge tSEEdge = (TSEEdge)iterator.next();
            TSEGraph tSEGraph3 = (TSEGraph)tSEEdge.getSourceNode().getOwnerGraph();
            if (tSEGraph3.isHideGraph()) {
                tSEGraph3 = (TSEGraph)tSEGraph3.hideFromGraph();
            }
            if ((tSEGraph2 = (TSEGraph)tSEEdge.getTargetNode().getOwnerGraph()).isHideGraph()) {
                tSEGraph2 = (TSEGraph)tSEGraph2.hideFromGraph();
            }
            if (tSEGraph3.getGreatestAncestor() != tSEGraph || tSEGraph2.getGreatestAncestor() != tSEGraph) continue;
            df2.add(tSEEdge);
        }
        return df2;
    }

    protected cw newGMFReader(Reader reader) {
        return new c1(reader);
    }

    public TSEGraph selectedGraph() {
        return this.selectedGraph;
    }

    public List selectedNodes() {
        Vector vector = new Vector();
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelectedNodes()) continue;
            vector.addAll(tSEGraph.selectedNodes());
        }
        return vector;
    }

    public List selectedEdges(boolean bl) {
        Vector vector = new Vector();
        Iterator iterator = this.graphs(bl).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelectedEdges()) continue;
            vector.addAll(tSEGraph.selectedEdges());
        }
        return vector;
    }

    public List selectedEdgeLabels(boolean bl) {
        Vector vector = new Vector();
        Iterator iterator = this.graphs(bl).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelectedEdgeLabels()) continue;
            vector.addAll(tSEGraph.selectedEdgeLabels());
        }
        return vector;
    }

    public List selectedNodeLabels() {
        Vector vector = new Vector();
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelectedNodeLabels()) continue;
            vector.addAll(tSEGraph.selectedNodeLabels());
        }
        return vector;
    }

    public List selectedConnectorLabels() {
        Vector vector = new Vector();
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelectedConnectorLabels()) continue;
            vector.addAll(tSEGraph.selectedConnectorLabels());
        }
        return vector;
    }

    public List selectedPathNodes(boolean bl) {
        Vector vector = new Vector();
        Iterator iterator = this.graphs(bl).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelectedPathNodes()) continue;
            vector.addAll(tSEGraph.selectedPathNodes());
        }
        return vector;
    }

    public List selectedConnectors() {
        Vector vector = new Vector();
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelectedConnectors()) continue;
            vector.addAll(tSEGraph.selectedConnectors());
        }
        return vector;
    }

    public boolean hasSelected(boolean bl) {
        return this.hasSelected(bl, true);
    }

    public boolean hasSelected(boolean bl, boolean bl2) {
        return this.hasSelectedNodes() || this.hasSelectedEdges(bl, bl2) || this.hasSelectedEdgeLabels(bl, bl2) || this.hasSelectedNodeLabels() || this.hasSelectedConnectorLabels() || this.hasSelectedPathNodes(bl, bl2) || this.hasSelectedConnectors();
    }

    public boolean hasSelectedNodes() {
        Iterator iterator = this.reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!((TSEGraph)iterator.next()).hasSelectedNodes()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedEdges(boolean bl) {
        return this.hasSelectedEdges(bl, true);
    }

    public boolean hasSelectedEdges(boolean bl, boolean bl2) {
        if (bl && this.queryIntergraph() != null && ((TSEGraph)this.queryIntergraph()).hasSelectedEdges(bl2)) {
            return true;
        }
        Iterator iterator = this.reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!((TSEGraph)iterator.next()).hasSelectedEdges(bl2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedEdgeLabels(boolean bl) {
        return this.hasSelectedEdgeLabels(bl, true);
    }

    public boolean hasSelectedEdgeLabels(boolean bl, boolean bl2) {
        if (bl && this.queryIntergraph() != null && ((TSEGraph)this.queryIntergraph()).hasSelectedEdgeLabels(bl2)) {
            return true;
        }
        Iterator iterator = this.reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!((TSEGraph)iterator.next()).hasSelectedEdgeLabels(bl2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedNodeLabels() {
        Iterator iterator = this.reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!((TSEGraph)iterator.next()).hasSelectedNodeLabels()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedConnectorLabels() {
        Iterator iterator = this.reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!((TSEGraph)iterator.next()).hasSelectedConnectorLabels()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedPathNodes(boolean bl) {
        return this.hasSelectedPathNodes(bl, true);
    }

    public boolean hasSelectedPathNodes(boolean bl, boolean bl2) {
        if (bl && this.queryIntergraph() != null && ((TSEGraph)this.queryIntergraph()).hasSelectedPathNodes(bl2)) {
            return true;
        }
        Iterator iterator = this.reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!((TSEGraph)iterator.next()).hasSelectedPathNodes(bl2)) continue;
            return true;
        }
        return false;
    }

    public TSRect getSelectedObjectsBounds() {
        Cloneable cloneable;
        Object object;
        TSRect tSRect = null;
        Iterator iterator = this.graphs().iterator();
        while (iterator.hasNext()) {
            object = (TSEGraph)iterator.next();
            cloneable = ((TSEGraph)object).getSelectedObjectsBounds();
            if (cloneable == null) continue;
            if (tSRect != null) {
                tSRect.merge(((TSEGraph)object).getSelectedObjectsBounds());
                continue;
            }
            tSRect = ((TSEGraph)object).getSelectedObjectsBounds();
        }
        object = this.intergraphEdges().iterator();
        while (object.hasNext()) {
            Object object2;
            cloneable = (TSEEdge)object.next();
            if (!((TSDEdge)cloneable).isViewable() || !((TSDEdge)cloneable).isReachable()) continue;
            if (((TSEEdge)cloneable).isSelected()) {
                if (tSRect != null) {
                    tSRect.merge(((TSDEdge)cloneable).getBounds(7));
                    continue;
                }
                tSRect = new TSRect(((TSDEdge)cloneable).getBounds(7));
                continue;
            }
            Iterator iterator2 = ((TSDEdge)cloneable).labels().iterator();
            while (iterator2.hasNext()) {
                object2 = (TSEEdgeLabel)iterator2.next();
                if (!((TSEEdgeLabel)object2).isSelected()) continue;
                if (tSRect != null) {
                    tSRect.merge(((TSLabel)object2).getBounds());
                    continue;
                }
                tSRect = new TSRect(((TSLabel)object2).getBounds());
            }
            object2 = ((TSDEdge)cloneable).pathNodes().iterator();
            while (object2.hasNext()) {
                TSEPNode tSEPNode = (TSEPNode)object2.next();
                if (!tSEPNode.isSelected()) continue;
                if (tSRect != null) {
                    tSRect.merge(tSEPNode.getBounds());
                    continue;
                }
                tSRect = new TSRect(tSEPNode.getBounds());
            }
        }
        return tSRect;
    }

    public boolean hasSelectedConnectors() {
        Iterator iterator = this.reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!((TSEGraph)iterator.next()).hasSelectedConnectors()) continue;
            return true;
        }
        return false;
    }

    public List graphsWithSelectedObjects() {
        df df2 = new df();
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.hasSelected()) continue;
            df2.add(tSEGraph);
        }
        return df2;
    }

    public void selectAll(boolean bl) {
        Iterator iterator = this.graphs(true).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable() && !tSEGraph.isIntergraph()) continue;
            tSEGraph.selectAll(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void selectAllNodes(boolean bl) {
        Iterator iterator = this.graphs(false).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable()) continue;
            tSEGraph.selectAllNodes(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void selectAllEdges(boolean bl) {
        Iterator iterator = this.graphs(true).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable() && !tSEGraph.isIntergraph()) continue;
            tSEGraph.selectAllEdges(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void selectAllPathNodes(boolean bl) {
        Iterator iterator = this.graphs(true).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable() && !tSEGraph.isIntergraph()) continue;
            tSEGraph.selectAllPathNodes(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void selectAllNodeLabels(boolean bl) {
        Iterator iterator = this.graphs(false).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable()) continue;
            tSEGraph.selectAllNodeLabels(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void selectAllEdgeLabels(boolean bl) {
        Iterator iterator = this.graphs(true).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable() && !tSEGraph.isIntergraph()) continue;
            tSEGraph.selectAllEdgeLabels(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void selectAllConnectorLabels(boolean bl) {
        Iterator iterator = this.graphs(false).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable()) continue;
            tSEGraph.selectAllConnectorLabels(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void selectAllConnectors(boolean bl) {
        Iterator iterator = this.graphs(false).iterator();
        boolean bl2 = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            if (!tSEGraph.isViewable()) continue;
            tSEGraph.selectAllConnectors(bl);
        }
        this.getEventManager().setCoalesce(bl2);
    }

    public void expandAll() {
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            tSEGraph.expandAll();
        }
    }

    public void collapseAll() {
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            tSEGraph.collapseAll();
        }
    }

    public void expandSelected() {
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            tSEGraph.expandSelected();
        }
    }

    public void collapseSelected() {
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            tSEGraph.collapseSelected();
        }
    }

    public boolean getCompressMetaEdges() {
        if (this.getGraphWindow() != null) {
            return this.getGraphWindow().getPreferences().getBooleanValue("compressMetaEdges");
        }
        return super.getCompressMetaEdges();
    }

    public void setCompressMetaEdges(boolean bl) {
        if (this.getGraphWindow() != null) {
            this.getGraphWindow().getPreferences().setValue((Object)"compressMetaEdges", bl);
        } else {
            super.setCompressMetaEdges(bl);
        }
    }

    protected TSDEdge addMetaEdge(TSDNode tSDNode, TSDNode tSDNode2) {
        TSEEdge tSEEdge = (TSEEdge)super.addMetaEdge(tSDNode, tSDNode2);
        if (this.getGraphWindow() != null) {
            tSEEdge.setUI((TSEEdgeUI)this.getGraphWindow().getCurrentMetaEdgeUI().clone());
        }
        return tSEEdge;
    }

    public int levelNumber() {
        return 2;
    }

    protected TSGraph newGraph() {
        return new TSEGraph();
    }

    protected TSGraph newGraph(int n) {
        return new TSEGraph();
    }

    protected TSGraph newIntergraph() {
        return new TSEGraph();
    }

    protected TSGraph newIntergraph(int n) {
        return new TSEGraph();
    }

    protected TSEdge newEdge() {
        return new TSEEdge();
    }

    protected TSEdge newEdge(int n) {
        return new TSEEdge();
    }

    public void emptyTopology() {
        TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
        if (tSEGraphWindow != null) {
            tSEGraphWindow.setCoalesce(true);
        }
        this.selectedGraph = null;
        super.emptyTopology();
        if (tSEGraphWindow != null) {
            tSEGraphWindow.setCoalesce(false);
        }
    }
}

