/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.diagramming.TSCutCopyPasteControl;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGrid;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSEInnerCanvas;
import com.tomsawyer.editor.TSELocalization;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEPreferences;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSEWindowState;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.c0;
import com.tomsawyer.editor.command.TSEAddConnectorCommand;
import com.tomsawyer.editor.command.TSEAddConnectorLabelCommand;
import com.tomsawyer.editor.command.TSEAddEdgeCommand;
import com.tomsawyer.editor.command.TSEAddEdgeLabelCommand;
import com.tomsawyer.editor.command.TSEAddNodeCommand;
import com.tomsawyer.editor.command.TSEAddNodeLabelCommand;
import com.tomsawyer.editor.command.TSEAddPNodeCommand;
import com.tomsawyer.editor.command.TSEClearAllCommand;
import com.tomsawyer.editor.command.TSEDeleteConnectorCommand;
import com.tomsawyer.editor.command.TSEDeleteConnectorLabelCommand;
import com.tomsawyer.editor.command.TSEDeleteEdgeCommand;
import com.tomsawyer.editor.command.TSEDeleteEdgeLabelCommand;
import com.tomsawyer.editor.command.TSEDeleteNodeCommand;
import com.tomsawyer.editor.command.TSEDeleteNodeLabelCommand;
import com.tomsawyer.editor.command.TSEDeletePNodeCommand;
import com.tomsawyer.editor.command.TSEDuplicateCommand;
import com.tomsawyer.editor.command.TSEInsertEdgeCommand;
import com.tomsawyer.editor.command.TSEInsertNodeCommand;
import com.tomsawyer.editor.command.TSEReconnectEdgeCommand;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.event.TSEModeChangeEvent;
import com.tomsawyer.editor.event.TSEModeChangeEventData;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.event.TSEViewportChangeEventData;
import com.tomsawyer.editor.g3;
import com.tomsawyer.editor.graphics.TSEDefaultGraphics;
import com.tomsawyer.editor.graphics.TSEDefaultPrinterGraphics;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.gw;
import com.tomsawyer.editor.tool.TSEReconnectEdgeTool;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.editor.ui.TSEConnectorUI;
import com.tomsawyer.editor.ui.TSEDefaultConnectorUI;
import com.tomsawyer.editor.ui.TSEDefaultEdgeUI;
import com.tomsawyer.editor.ui.TSEDefaultLabelUI;
import com.tomsawyer.editor.ui.TSEDefaultNodeUI;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.editor.ui.TSEGraphUI;
import com.tomsawyer.editor.ui.TSELabelUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editor.ui.db;
import com.tomsawyer.editor.ui.dc;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSCommandListener;
import com.tomsawyer.util.command.TSCommandTransmitter;
import com.tomsawyer.util.command.TSGroupCommand;
import com.tomsawyer.util.command.TSUndoStack;
import com.tomsawyer.util.f2;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterGraphics;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class TSEGraphWindow
extends JComponent
implements TSCommandTransmitter,
TSCommandListener,
Serializable {
    public static String TOOLTIP_PLACEHOLDER = "%TOOLTIP%";
    static String tooltipFormat = "<html>" + TOOLTIP_PLACEHOLDER + "</html>";
    public static final double MAX_ZOOM = 50.0;
    public static final double MIN_ZOOM = 1.0E-4;
    public static final int CURRENT_ZOOM_LEVEL = 0;
    public static final int ACTUAL_SIZE = 1;
    public static final int FIT_IN_WINDOW = 2;
    public static final int CUSTOM_SIZE = 3;
    transient TSEGraphManager graphManager;
    transient TSENodeUI currentNodeUI;
    transient dc currentPathNodeUI;
    transient TSEEdgeUI currentEdgeUI;
    transient TSELabelUI currentLabelUI;
    transient TSEConnectorUI currentConnectorUI;
    transient TSEEdgeUI currentMetaEdgeUI;
    transient boolean edgeCreatedWithLabel;
    transient boolean nodeCreatedWithLabel;
    transient boolean connectorCreatedWithLabel;
    boolean isInRunMode;
    transient TSUndoStack undoStack = new TSUndoStack();
    transient TSRect invalidGraphRegion = null;
    transient Image doubleBuffer;
    transient TSCutCopyPasteControl cutCopyPasteControl = this.newCutCopyPasteControl();
    TSTransform transform = new TSTransform(0, 0, 100, 100);
    transient Clipboard clipboard;
    transient TSEWindowTool currentTool;
    transient TSEWindowTool defaultTool;
    transient List listeners = new Vector();
    transient TSEInnerCanvas canvas;
    transient JScrollBar horizontalScrollBar;
    transient JScrollBar verticalScrollBar;
    transient double proportionInX;
    transient double proportionInY;
    transient boolean userActionPossible = true;
    transient boolean noRedrawInAdjustmentListener = false;
    transient TSRect workBounds = new TSRect();
    TSEGrid grid;
    transient boolean waitCursorShownOnCanvas;
    DragSource dragSource;
    DropTarget dropTarget;
    DragGestureRecognizer dragGestureRecognizer;
    TSEPreferences preferences;
    TSEHitTesting hitTesting;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSENode;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSENodeLabel;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEEdge;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEEdgeLabel;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEConnectorLabel;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEPNode;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEConnector;

    public TSEGraphWindow() {
        this(null, true);
    }

    public TSEGraphWindow(TSEGraphManager tSEGraphManager) {
        this(tSEGraphManager, true);
    }

    public TSEGraphWindow(boolean bl) {
        this(null, bl);
    }

    public TSEGraphWindow(TSEGraphManager tSEGraphManager, boolean bl) {
        TSEWindowInputTool tSEWindowInputTool;
        this.createGUI(bl);
        if (tSEGraphManager == null) {
            this.graphManager = this.generateGraphManager();
        } else if (tSEGraphManager.getGraphWindow() != null || this.isOverview()) {
            this.graphManager = tSEGraphManager;
        } else {
            this.graphManager = tSEGraphManager;
            this.graphManager.setGraphWindow(this);
        }
        this.hitTesting = new TSEHitTesting(this);
        this.setCurrentNodeUI(new TSEDefaultNodeUI());
        this.currentPathNodeUI = new db();
        this.setCurrentEdgeUI(new TSEDefaultEdgeUI());
        this.setCurrentLabelUI(new TSEDefaultLabelUI());
        this.setCurrentConnectorUI(new TSEDefaultConnectorUI());
        this.setCurrentMetaEdgeUI(new TSEDefaultEdgeUI());
        this.getCurrentMetaEdgeUI().setLineColor(TSEColor.gray);
        this.getCurrentMetaEdgeUI().setSelectedColor(TSEColor.blue);
        this.setEdgeCreatedWithLabel(false);
        this.setNodeCreatedWithLabel(false);
        this.setWaitCursorShownOnCanvas(true);
        c0 c02 = new c0(this);
        this.verticalScrollBar.addAdjustmentListener(c02);
        this.horizontalScrollBar.addAdjustmentListener(c02);
        this.addCommandListener(this);
        this.enableEvents(48L);
        try {
            tSEWindowInputTool = new TSESelectTool();
        }
        catch (Exception exception) {
            tSEWindowInputTool = new TSEWindowInputTool();
        }
        this.setCurrentTool(tSEWindowInputTool);
        this.setDefaultTool(tSEWindowInputTool);
        this.setDragSource(new DragSource());
        this.dragGestureRecognizer = this.getDragSource().createDefaultDragGestureRecognizer(this.getCanvas(), 0x40000001, tSEWindowInputTool.getInternalDragGestureListener());
        this.preferences = this.newPreferences(this);
        this.onPreferenceChanged(new TSProperty("tooltipsEnabled", new Boolean(this.isToolTipShown())));
        this.setInRunMode(this.isInRunModeByDefault());
        this.setScrollRange(this.getDefaultScrollRange());
        this.fitInWindow(false);
        this.initDropTarget();
    }

    public synchronized int transmit(TSCommand tSCommand) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TSCommandListener tSCommandListener = (TSCommandListener)iterator.next();
            tSCommandListener.listen(tSCommand);
        }
        return 1;
    }

    public void addCommandListener(TSCommandListener tSCommandListener) {
        this.listeners.add(tSCommandListener);
    }

    public void removeCommandListener(TSCommandListener tSCommandListener) {
        this.listeners.remove(tSCommandListener);
    }

    public List getCommandListeners() {
        return this.listeners;
    }

    public int listen(TSCommand tSCommand) {
        TSLicenseRuntimeException tSLicenseRuntimeException = null;
        List list = tSCommand.getAffectedObjects();
        if (list == null) {
            this.addInvalidRegion(this.transform.getWorldBounds());
        } else {
            this.addInvalidRegion(list);
        }
        if (tSCommand.getState() == TSCommand.CREATED) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = this.getUndoLimit() == 0;
            if (tSCommand.isAddToUndoStack()) {
                bl2 = true;
                this.undoStack.add(tSCommand);
            } else {
                bl = true;
            }
            boolean bl4 = false;
            if (tSCommand.isCoalesced()) {
                bl4 = this.isCoalesce();
                this.setCoalesce(true);
            }
            try {
                tSCommand.execute();
            }
            catch (TSLicenseRuntimeException tSLicenseRuntimeException2) {
                tSLicenseRuntimeException = tSLicenseRuntimeException2;
            }
            this.restoreCoalescingState(tSCommand, bl4);
            if ((!tSCommand.isAddToUndoStack() || tSCommand.getState() != TSCommand.DONE) && bl2) {
                this.popUndoStack();
            }
            if (bl) {
                tSCommand.internalDoCleanup();
            }
        } else {
            if (tSCommand.getState() == TSCommand.DONE) {
                try {
                    boolean bl = false;
                    if (tSCommand.isCoalesced()) {
                        bl = this.isCoalesce();
                        this.setCoalesce(true);
                    }
                    try {
                        tSCommand.undo();
                    }
                    catch (TSLicenseRuntimeException tSLicenseRuntimeException3) {
                        tSLicenseRuntimeException = tSLicenseRuntimeException3;
                    }
                    this.restoreCoalescingState(tSCommand, bl);
                }
                catch (RuntimeException runtimeException) {
                    this.undoStack.undoFailed();
                    throw runtimeException;
                }
            }
            if (tSCommand.getState() == TSCommand.UNDONE) {
                try {
                    boolean bl = false;
                    if (tSCommand.isCoalesced()) {
                        bl = this.isCoalesce();
                        this.setCoalesce(true);
                    }
                    try {
                        tSCommand.redo();
                    }
                    catch (TSLicenseRuntimeException tSLicenseRuntimeException4) {
                        tSLicenseRuntimeException = tSLicenseRuntimeException4;
                    }
                    this.restoreCoalescingState(tSCommand, bl);
                }
                catch (RuntimeException runtimeException) {
                    this.undoStack.redoFailed();
                    throw runtimeException;
                }
            }
        }
        this.updateScrollBarValues();
        list = tSCommand.getAffectedObjects();
        if (list == null) {
            this.addInvalidRegion(this.transform.getWorldBounds());
        } else {
            this.addInvalidRegion(list);
        }
        if (this.getGraph().numberOfNodes() > 0) {
            this.updateInvalidRegion(true);
        } else {
            this.drawGraph();
            this.fastRepaint();
        }
        if (tSLicenseRuntimeException != null) {
            throw tSLicenseRuntimeException;
        }
        return 1;
    }

    private void restoreCoalescingState(TSCommand tSCommand, boolean bl) {
        if (tSCommand.isCoalesced()) {
            if (tSCommand.isOrderPreservedInCoalescing()) {
                TSEEventManager tSEEventManager = (TSEEventManager)this.getGraphManager().getEventManager();
                boolean bl2 = tSEEventManager.isCoalescingPreservesOrder();
                tSEEventManager.setCoalescingPreservesOrder(true);
                this.setCoalesce(bl);
                tSEEventManager.setCoalescingPreservesOrder(bl2);
            } else {
                this.setCoalesce(bl);
            }
        }
    }

    public void setCoalesce(boolean bl) {
        this.getGraphManager().getEventManager().setCoalesce(bl);
    }

    public boolean isCoalesce() {
        return this.getGraphManager().getEventManager().isCoalesce();
    }

    public synchronized void fastRepaint() {
        this.getCanvas().repaint();
    }

    public synchronized void fastRepaint(double d, double d2, double d3, double d4) {
        TSTransform tSTransform = this.getTransform();
        this.getCanvas().repaint(0L, tSTransform.xToDevice(d), tSTransform.yToDevice(d2), tSTransform.widthToDevice(d3), tSTransform.heightToDevice(d4));
    }

    public void drawGraph() {
        this.drawGraph((Graphics)null);
    }

    public void drawGraph(boolean bl) {
        this.drawGraph(null, bl);
    }

    public void drawGraph(Graphics graphics) {
        this.drawGraph(graphics, true);
    }

    public void drawGraph(Graphics graphics, boolean bl) {
        this.drawGraph(graphics, bl, true);
    }

    public void drawGraph(Graphics graphics, boolean bl, boolean bl2) {
        this.drawGraph(graphics, bl, bl2, false);
    }

    public void drawGraph(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        this.drawGraph(graphics, bl, true, true, bl2, bl3);
    }

    public TSEGraphics newGraphics(TSEGraphWindow tSEGraphWindow, Graphics graphics, TSTransform tSTransform) {
        if (graphics == null || tSTransform == null) {
            throw new IllegalArgumentException("null graphics or transform");
        }
        TSEDefaultGraphics tSEDefaultGraphics = null;
        tSEDefaultGraphics = graphics instanceof PrinterGraphics ? new TSEDefaultPrinterGraphics(tSEGraphWindow, graphics, tSTransform) : new TSEDefaultGraphics(tSEGraphWindow, graphics, tSTransform);
        return tSEDefaultGraphics;
    }

    public TSEGraphics newGraphics(Graphics graphics, TSTransform tSTransform) {
        return this.newGraphics(this, graphics, tSTransform);
    }

    public TSEGraphics newGraphics(Graphics graphics) {
        return this.newGraphics(this, graphics, this.getTransform());
    }

    public void drawGraph(Graphics graphics, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (this.doubleBuffer == null && graphics == null) {
            return;
        }
        if (graphics == null) {
            graphics = this.doubleBuffer.getGraphics();
        }
        TSEGraphics tSEGraphics = this.newGraphics(graphics);
        TSConstRect tSConstRect = this.getTransform().getWorldBounds();
        this.getGraph().getGraphUI().drawBackground(tSEGraphics, tSConstRect, bl2, bl3);
        if (this.hasGrid() && bl) {
            this.getGrid().draw(tSEGraphics, tSConstRect);
        }
        this.getGraph().getGraphUI().draw(tSEGraphics, bl4, true, tSConstRect, bl5);
        this.invalidGraphRegion = null;
    }

    public void drawEntireGraph(TSEGraphics tSEGraphics, int n, boolean bl, boolean bl2) {
        if (n != 3) {
            this.drawEntireGraph(tSEGraphics, n, bl, bl2, 0, 0);
        }
    }

    public void drawEntireGraph(TSEGraphics tSEGraphics, int n, boolean bl, boolean bl2, int n2, int n3) {
        if (tSEGraphics == null) {
            return;
        }
        tSEGraphics.setColor(this.getGraph().getGraphUI().getBackgroundColor().getColor());
        tSEGraphics.fillRect(0, 0, n2, n3);
        TSConstRect tSConstRect = this.getGraph().getFrameBounds();
        double d = tSConstRect.getLeft();
        double d2 = tSConstRect.getTop();
        double d3 = tSConstRect.getWidth();
        double d4 = tSConstRect.getHeight();
        Cursor cursor = this.showWaitCursorOnCanvas();
        TSTransform tSTransform = (TSTransform)tSEGraphics.getTSTransform().clone();
        if (n == 0) {
            double d5 = tSEGraphics.getGraphWindow().getZoomLevel();
            tSTransform.setDeviceSize((int)Math.round(d3 * d5), (int)Math.round(d4 * d5));
            tSTransform.fitToDevice(tSConstRect);
            d5 = Math.max(1.0, d5);
            tSConstRect = new TSConstRect(d, d2, d + d3 * d5, d2 - d4 * d5);
        } else if (n == 2) {
            tSTransform.fitToDevice(tSConstRect);
        } else if (n == 3) {
            tSTransform = new TSTransform(0, 0, n2, n3);
            tSTransform.fitToDevice(tSConstRect);
        } else if (n == 1) {
            tSTransform = new TSTransform(0, 0, (int)Math.round(d3), (int)Math.round(d4));
            tSTransform.setZoomLevel(1.0);
            tSTransform.setDeviceBounds(0, 0, (int)Math.round(d3), (int)Math.round(d4));
            tSTransform.fitToDevice(tSConstRect);
        } else {
            return;
        }
        TSEGraphics tSEGraphics2 = tSEGraphics.deriveGraphics(tSTransform);
        this.getGraph().getGraphUI().drawBackground(tSEGraphics2, tSConstRect);
        tSEGraphics2.translate(0, 0);
        if (this.hasGrid() && bl) {
            this.getGrid().draw(tSEGraphics2, tSConstRect);
        }
        this.getGraph().getGraphUI().drawAll(tSEGraphics2, tSConstRect, bl2);
        if (bl2) {
            this.drawAdditionalSelectedObjects(this.getGraphManager(), tSEGraphics2);
        }
        tSEGraphics2.dispose();
        this.setCursorOnCanvas(cursor);
    }

    public void drawAdditionalSelectedObjects(TSEGraphManager tSEGraphManager, TSEGraphics tSEGraphics) {
        Object object;
        Object object2;
        TSGraphObject tSGraphObject;
        TSGraphObject tSGraphObject2;
        Iterator iterator;
        if (tSEGraphManager.hasSelectedConnectors()) {
            iterator = tSEGraphManager.selectedConnectors().iterator();
            while (iterator.hasNext()) {
                tSGraphObject2 = (TSEConnector)iterator.next();
                tSGraphObject = (TSEGraph)tSGraphObject2.getOwner().getOwnerGraph();
                object2 = tSEGraphics;
                while (!((TSDGraph)tSGraphObject).isMainDisplayGraph()) {
                    object = TSTransform.compose(((TSEGraphics)object2).getTSTransform(), ((TSDGraph)tSGraphObject).getClonedTransform());
                    object2 = tSEGraphics.deriveGraphics((TSTransform)object);
                    if (((TSDGraph)tSGraphObject).getParent() != null) {
                        tSGraphObject = (TSEGraph)((TSDGraph)tSGraphObject).getParent().getOwnerGraph();
                        continue;
                    }
                    return;
                }
                ((TSEConnector)tSGraphObject2).getUI().draw((TSEGraphics)object2);
            }
        }
        if (tSEGraphManager.hasSelectedPathNodes(true)) {
            iterator = tSEGraphManager.selectedPathNodes(true).iterator();
            while (iterator.hasNext()) {
                tSGraphObject2 = (TSEPNode)iterator.next();
                tSGraphObject = (TSEEdge)tSGraphObject2.getOwner();
                object2 = (TSEGraph)tSEGraphManager.getCommonOwnerGraph((TSEdge)tSGraphObject);
                object = tSEGraphics;
                while (!((TSDGraph)object2).isMainDisplayGraph()) {
                    TSTransform tSTransform = TSTransform.compose(((TSEGraphics)object).getTSTransform(), ((TSDGraph)object2).getClonedTransform());
                    object = tSEGraphics.deriveGraphics(tSTransform);
                    if (((TSDGraph)object2).getParent() != null) {
                        object2 = (TSEGraph)((TSDGraph)object2).getParent().getOwnerGraph();
                        continue;
                    }
                    return;
                }
                ((TSEPNode)tSGraphObject2).getUI().draw((TSEGraphics)object);
            }
        }
    }

    public boolean hasGrid() {
        return this.getGrid() != null;
    }

    public boolean isOverview() {
        return false;
    }

    public void drawGraph(TSConstRect tSConstRect) {
        this.drawGraph(tSConstRect, true, true);
    }

    public void drawGraph(TSConstRect tSConstRect, boolean bl, boolean bl2) {
        if (this.doubleBuffer == null) {
            return;
        }
        TSEGraphics tSEGraphics = this.newGraphics(this.doubleBuffer.getGraphics());
        int n = this.transform.xToDevice(tSConstRect.getLeft());
        int n2 = this.transform.yToDevice(tSConstRect.getTop());
        int n3 = this.transform.widthToDevice(tSConstRect.getWidth());
        int n4 = this.transform.heightToDevice(tSConstRect.getHeight());
        this.getGraph().getGraphUI().drawBackground(tSEGraphics, tSConstRect, bl, bl2);
        if (this.hasGrid()) {
            this.getGrid().draw(tSEGraphics, tSConstRect);
        }
        this.getGraph().getGraphUI().draw(tSEGraphics, true, tSConstRect);
    }

    public boolean isDrawInvisibleOnDragging() {
        return this.getPreferences().getBooleanValue("drawInvisibleOnDragging");
    }

    public void setDrawInvisibleOnDragging(boolean bl) {
        this.getPreferences().setValue((Object)"drawInvisibleOnDragging", bl);
    }

    public boolean isDrawFullUIOnDragging() {
        return this.getPreferences().getBooleanValue("opaqueMovement");
    }

    public void setDrawFullUIOnDragging(boolean bl) {
        this.getPreferences().setValue((Object)"opaqueMovement", bl);
    }

    public boolean isInRunMode() {
        return this.isInRunMode;
    }

    public void setInRunMode(boolean bl) {
        if (bl != this.isInRunMode) {
            this.isInRunMode = bl;
            this.getGraphManager().getEventManager().fireEvent(new TSEModeChangeEvent(1L, new TSEModeChangeEventData(this, new Boolean(!this.isInRunMode), new Boolean(this.isInRunMode))));
            this.drawGraph();
            this.repaint();
        }
    }

    public boolean isInRunModeByDefault() {
        return false;
    }

    public synchronized void updateInvalidRegions(boolean bl) {
        this.updateInvalidRegion(bl);
    }

    public synchronized void updateInvalidRegion(boolean bl) {
        if (this.invalidGraphRegion != null) {
            double d = this.transform.widthToWorld(1);
            double d2 = this.transform.heightToWorld(1);
            this.invalidGraphRegion = new TSRect(this.invalidGraphRegion.getLeft() - d, this.invalidGraphRegion.getBottom() - d2, this.invalidGraphRegion.getRight() + d, this.invalidGraphRegion.getTop() + d2);
        } else {
            this.addInvalidRegion(this.transform.getWorldBounds());
        }
        TSRect tSRect = this.invalidGraphRegion;
        this.drawGraph(tSRect);
        if (bl) {
            this.fastRepaint(tSRect.getLeft(), tSRect.getTop(), tSRect.getWidth(), tSRect.getHeight());
        }
        this.invalidGraphRegion = null;
    }

    public void updateInvalidRegions() {
        this.updateInvalidRegion();
    }

    public void updateInvalidRegion() {
        this.updateInvalidRegion(false);
    }

    public void addInvalidRegion(TSConstRect tSConstRect) {
        if (tSConstRect != null && tSConstRect.intersects(this.transform.getWorldBounds())) {
            if (this.invalidGraphRegion == null) {
                this.invalidGraphRegion = new TSRect(tSConstRect);
            } else {
                this.invalidGraphRegion.merge(tSConstRect);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addInvalidRegion(TSEObject tSEObject) {
        Cloneable cloneable;
        TSEGraph tSEGraph = null;
        if (tSEObject.getOwnerGraph() != null) {
            tSEGraph = (TSEGraph)tSEObject.getOwnerGraph();
            if (tSEGraph.isIntergraph()) {
                cloneable = tSEObject instanceof TSEEdge ? (TSEEdge)tSEObject : (TSEEdge)tSEObject.getOwner();
                if (!((TSDEdge)cloneable).isViewable()) return;
                tSEGraph = (TSEGraph)((TSGEdge)cloneable).getTransformGraph();
            } else if (tSEGraph.isHideGraph()) {
                tSEGraph = (TSEGraph)tSEGraph.hideFromGraph();
            }
        } else {
            tSEGraph = this.getGraph();
        }
        if (tSEGraph == null || (cloneable = tSEGraph.getLocalToMainDisplayGraphTransform()) == null) return;
        this.addInvalidRegion(tSEObject.getUI().getInvalidRegion(this.getTransform(), (TSExpTransform)cloneable));
    }

    public void addInvalidRegion(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TSConstRect) {
                this.addInvalidRegion((TSConstRect)e);
                continue;
            }
            if (!(e instanceof TSEObject)) continue;
            this.addInvalidRegion((TSEObject)e);
        }
    }

    public boolean isGraphInvalid() {
        return this.invalidGraphRegion != null;
    }

    public TSRect getInvalidRegions() {
        return this.getInvalidRegion();
    }

    public TSRect getInvalidRegion() {
        return this.invalidGraphRegion;
    }

    public void onResize(int n, int n2) {
    }

    public void setWaitCursorShownOnCanvas(boolean bl) {
        this.waitCursorShownOnCanvas = bl;
    }

    public boolean isWaitCursorShownOnCanvas() {
        return this.waitCursorShownOnCanvas;
    }

    public Cursor showWaitCursorOnCanvas() {
        Cursor cursor = this.getCanvas().getCursor();
        if (this.isWaitCursorShownOnCanvas()) {
            this.getCanvas().setCursor(Cursor.getPredefinedCursor(3));
        }
        return cursor;
    }

    public void setCursorOnCanvas(Cursor cursor) {
        if (cursor != this.getCursorOnCanvas()) {
            this.getCanvas().setCursor(cursor);
        }
    }

    public Cursor getCursorOnCanvas() {
        return this.getCanvas().getCursor();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return ((TSEWindowInputTool)this.getCurrentTool()).getToolTipText(mouseEvent);
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return ((TSEWindowInputTool)this.getCurrentTool()).getToolTipLocation(mouseEvent);
    }

    public Point getDefaultToolTipLocation(MouseEvent mouseEvent) {
        return super.getToolTipLocation(mouseEvent);
    }

    public void setToolTipShown(boolean bl) {
        if (this.getPreferences() != null) {
            this.getPreferences().setValue((Object)"tooltipsEnabled", bl);
        }
    }

    public boolean isToolTipShown() {
        if (this.getPreferences() != null) {
            return this.getPreferences().getBooleanValue("tooltipsEnabled");
        }
        return false;
    }

    public TSENode insertNode(TSENode tSENode) {
        return this.insertNode(tSENode, this.getGraph());
    }

    public TSENode insertNode(TSENode tSENode, TSEGraph tSEGraph) {
        TSEInsertNodeCommand tSEInsertNodeCommand = new TSEInsertNodeCommand(tSEGraph, tSENode);
        this.transmit(tSEInsertNodeCommand);
        return (TSENode)tSEInsertNodeCommand.getNode();
    }

    public TSEEdge insertEdge(TSEEdge tSEEdge) {
        return this.insertEdge(tSEEdge, this.getGraph());
    }

    public TSEEdge insertEdge(TSEEdge tSEEdge, TSEGraph tSEGraph) {
        TSEInsertEdgeCommand tSEInsertEdgeCommand = new TSEInsertEdgeCommand(tSEGraph, tSEEdge);
        this.transmit(tSEInsertEdgeCommand);
        return (TSEEdge)tSEInsertEdgeCommand.getEdge();
    }

    public TSENode addNode(double d, double d2, TSENodeUI tSENodeUI) {
        return this.addNode(d, d2, tSENodeUI, this.getGraph());
    }

    public TSENode addNode(double d, double d2, TSENodeUI tSENodeUI, TSEGraph tSEGraph) {
        return this.addNode(0, d, d2, tSENodeUI, tSEGraph);
    }

    public TSENode addNode(int n, double d, double d2, TSENodeUI tSENodeUI) {
        return this.addNode(n, d, d2, tSENodeUI, this.getGraph());
    }

    public TSENode addNode(int n, double d, double d2, TSENodeUI tSENodeUI, TSEGraph tSEGraph) {
        if (tSENodeUI == null) {
            tSENodeUI = this.getCurrentNodeUI();
        }
        TSEAddNodeCommand tSEAddNodeCommand = n == 0 ? new TSEAddNodeCommand(tSEGraph, d, d2, tSENodeUI, this.isNodeCreatedWithLabel()) : new TSEAddNodeCommand(n, tSEGraph, d, d2, tSENodeUI, this.isNodeCreatedWithLabel());
        this.transmit(tSEAddNodeCommand);
        return (TSENode)tSEAddNodeCommand.getNode();
    }

    public TSEEdge addEdge(TSENode tSENode, TSENode tSENode2, List list, TSEEdgeUI tSEEdgeUI) {
        return this.addEdge(0, tSENode, tSENode2, list, tSEEdgeUI, this.getGraph());
    }

    public TSEEdge addEdge(TSENode tSENode, TSENode tSENode2, List list, TSEEdgeUI tSEEdgeUI, TSEGraph tSEGraph) {
        return this.addEdge(0, tSENode, tSENode2, list, tSEEdgeUI, tSEGraph);
    }

    public TSEEdge addEdge(int n, TSENode tSENode, TSENode tSENode2, List list, TSEEdgeUI tSEEdgeUI) {
        return this.addEdge(n, tSENode, tSENode2, list, tSEEdgeUI, this.getGraph());
    }

    public TSEEdge addEdge(int n, TSENode tSENode, TSENode tSENode2, List vector, TSEEdgeUI tSEEdgeUI, TSEGraph tSEGraph) {
        TSSystem.tsAssert(tSENode != null);
        TSSystem.tsAssert(tSENode2 != null);
        if (vector == null) {
            vector = new Vector();
        }
        if (tSEEdgeUI == null) {
            tSEEdgeUI = this.getCurrentEdgeUI();
        }
        TSEAddEdgeCommand tSEAddEdgeCommand = n == 0 ? new TSEAddEdgeCommand(tSEGraph, tSENode, tSENode2, vector, tSEEdgeUI, this.isEdgeCreatedWithLabel()) : new TSEAddEdgeCommand(n, tSEGraph, tSENode, tSENode2, vector, tSEEdgeUI, this.isEdgeCreatedWithLabel());
        this.transmit(tSEAddEdgeCommand);
        return (TSEEdge)tSEAddEdgeCommand.getEdge();
    }

    public TSEEdge reconnectEdge(TSEEdge tSEEdge, TSENode tSENode, TSEConnector tSEConnector, boolean bl, List list, List list2) {
        TSSystem.tsAssert(tSENode != null);
        TSEGraph tSEGraph = bl ? (tSENode.getOwnerGraph() == tSEEdge.getTargetNode().getOwnerGraph() ? (TSEGraph)tSENode.getOwnerGraph() : (TSEGraph)this.getGraphManager().intergraph()) : (tSENode.getOwnerGraph() == tSEEdge.getSourceNode().getOwnerGraph() ? (TSEGraph)tSENode.getOwnerGraph() : (TSEGraph)this.getGraphManager().intergraph());
        TSEReconnectEdgeCommand tSEReconnectEdgeCommand = new TSEReconnectEdgeCommand(tSEGraph, tSEEdge, tSENode, (TSConnector)tSEConnector, bl, list, list2);
        this.transmit(tSEReconnectEdgeCommand);
        return (TSEEdge)tSEReconnectEdgeCommand.getEdge();
    }

    public TSEEdgeLabel addEdgeLabel(TSEEdge tSEEdge, double d, double d2, String string, TSELabelUI tSELabelUI) {
        TSSystem.tsAssert(tSEEdge.isOwned());
        if (tSELabelUI == null) {
            tSELabelUI = this.getCurrentLabelUI();
        }
        TSEAddEdgeLabelCommand tSEAddEdgeLabelCommand = new TSEAddEdgeLabelCommand(tSEEdge, d, d2, string, tSELabelUI);
        this.transmit(tSEAddEdgeLabelCommand);
        return (TSEEdgeLabel)tSEAddEdgeLabelCommand.getEdgeLabel();
    }

    public TSENodeLabel addNodeLabel(TSENode tSENode, double d, double d2, String string, TSELabelUI tSELabelUI) {
        TSSystem.tsAssert(tSENode.isOwned());
        if (tSELabelUI == null) {
            tSELabelUI = this.getCurrentLabelUI();
        }
        TSEAddNodeLabelCommand tSEAddNodeLabelCommand = new TSEAddNodeLabelCommand(tSENode, d, d2, string, tSELabelUI);
        this.transmit(tSEAddNodeLabelCommand);
        return (TSENodeLabel)tSEAddNodeLabelCommand.getNodeLabel();
    }

    public TSENodeLabel addNodeLabel(TSENode tSENode, String string, TSELabelUI tSELabelUI) {
        return this.addNodeLabel(tSENode, tSENode.getLocalCenterX(), tSENode.getLocalBounds().getBottom() - tSENode.getDefaultLabelDistance(), string, tSELabelUI);
    }

    public TSENodeLabel addNodeLabel(TSENode tSENode, String string, double d, String string2, TSELabelUI tSELabelUI) {
        TSSystem.tsAssert(tSENode.isOwned());
        if (tSELabelUI == null) {
            tSELabelUI = this.getCurrentLabelUI();
        }
        TSEAddNodeLabelCommand tSEAddNodeLabelCommand = new TSEAddNodeLabelCommand(tSENode, string, d, string2, tSELabelUI);
        this.transmit(tSEAddNodeLabelCommand);
        return (TSENodeLabel)tSEAddNodeLabelCommand.getNodeLabel();
    }

    public TSEConnectorLabel addConnectorLabel(TSEConnector tSEConnector, double d, double d2, String string, TSELabelUI tSELabelUI) {
        TSSystem.tsAssert(tSEConnector.isOwned());
        if (tSELabelUI == null) {
            tSELabelUI = this.getCurrentLabelUI();
        }
        TSEAddConnectorLabelCommand tSEAddConnectorLabelCommand = new TSEAddConnectorLabelCommand(tSEConnector, d, d2, string, tSELabelUI);
        this.transmit(tSEAddConnectorLabelCommand);
        return (TSEConnectorLabel)tSEAddConnectorLabelCommand.getConnectorLabel();
    }

    public TSEConnectorLabel addConnectorLabel(TSEConnector tSEConnector, String string, TSELabelUI tSELabelUI) {
        return this.addConnectorLabel(tSEConnector, tSEConnector.getLocalCenterX(), tSEConnector.getLocalBottom() - tSEConnector.getDefaultLabelDistance(), string, tSELabelUI);
    }

    public TSEConnectorLabel addConnectorLabel(TSEConnector tSEConnector, String string, double d, String string2, TSELabelUI tSELabelUI) {
        TSSystem.tsAssert(tSEConnector.isOwned());
        if (tSELabelUI == null) {
            tSELabelUI = this.currentLabelUI;
        }
        TSEAddConnectorLabelCommand tSEAddConnectorLabelCommand = new TSEAddConnectorLabelCommand(tSEConnector, string, d, string2, tSELabelUI);
        this.transmit(tSEAddConnectorLabelCommand);
        return (TSEConnectorLabel)tSEAddConnectorLabelCommand.getConnectorLabel();
    }

    public TSEPNode addPathNode(double d, double d2, TSPEdge tSPEdge) {
        TSSystem.tsAssert(tSPEdge.isOwned());
        TSSystem.tsAssert(tSPEdge.getOwner() instanceof TSEEdge);
        TSEEdge tSEEdge = (TSEEdge)tSPEdge.getOwner();
        TSEAddPNodeCommand tSEAddPNodeCommand = new TSEAddPNodeCommand(this.getGraph(), d, d2, tSPEdge);
        tSEEdge.setSelected(true);
        this.transmit(tSEAddPNodeCommand);
        return (TSEPNode)tSEAddPNodeCommand.getPathNode();
    }

    public TSEConnector addConnector(TSENode tSENode, double d, double d2, double d3, double d4, double d5, double d6, TSEConnectorUI tSEConnectorUI) {
        if (tSEConnectorUI == null) {
            tSEConnectorUI = this.getCurrentConnectorUI();
        }
        TSEAddConnectorCommand tSEAddConnectorCommand = new TSEAddConnectorCommand(tSENode, d, d2, d3, d4, d5, d6, tSEConnectorUI, this.isConnectorCreatedWithLabel());
        this.transmit(tSEAddConnectorCommand);
        return (TSEConnector)tSEAddConnectorCommand.getConnector();
    }

    public void clearAll() {
        TSEClearAllCommand tSEClearAllCommand = new TSEClearAllCommand(this);
        this.transmit(tSEClearAllCommand);
    }

    public void deleteSelected() {
        TSCommand tSCommand;
        Object object;
        Iterator iterator = this.getGraphManager().graphs(true).iterator();
        TSGroupCommand tSGroupCommand = new TSGroupCommand();
        boolean bl = this.isCoalesce();
        this.setCoalesce(true);
        TSEWindowTool tSEWindowTool = this.getCurrentTool();
        if (tSEWindowTool instanceof TSEReconnectEdgeTool && (object = ((TSEReconnectEdgeTool)tSEWindowTool).getEdge()) != null) {
            tSCommand = new TSEDeleteEdgeCommand((TSEEdge)object);
            tSGroupCommand.add(tSCommand);
        }
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            Iterator iterator2 = tSEGraph.selectedEdgeLabels().iterator();
            while (iterator2.hasNext()) {
                object = (TSEEdgeLabel)iterator2.next();
                tSCommand = new TSEDeleteEdgeLabelCommand((TSEEdgeLabel)object);
                tSGroupCommand.add(tSCommand);
            }
            iterator2 = tSEGraph.selectedNodeLabels().iterator();
            while (iterator2.hasNext()) {
                object = (TSENodeLabel)iterator2.next();
                tSCommand = new TSEDeleteNodeLabelCommand((TSENodeLabel)object);
                tSGroupCommand.add(tSCommand);
            }
            iterator2 = tSEGraph.selectedConnectorLabels().iterator();
            while (iterator2.hasNext()) {
                object = (TSEConnectorLabel)iterator2.next();
                tSCommand = new TSEDeleteConnectorLabelCommand((TSEConnectorLabel)object);
                tSGroupCommand.add(tSCommand);
            }
            iterator2 = tSEGraph.selectedConnectors().iterator();
            while (iterator2.hasNext()) {
                object = (TSEConnector)iterator2.next();
                tSCommand = new TSEDeleteConnectorCommand((TSEConnector)object);
                tSGroupCommand.add(tSCommand);
            }
            iterator2 = tSEGraph.selectedPathNodes().iterator();
            while (iterator2.hasNext()) {
                object = (TSEPNode)iterator2.next();
                tSCommand = new TSEDeletePNodeCommand((TSEPNode)object);
                tSGroupCommand.add(tSCommand);
            }
            iterator2 = tSEGraph.selectedEdges().iterator();
            while (iterator2.hasNext()) {
                object = (TSEEdge)iterator2.next();
                tSCommand = new TSEDeleteEdgeCommand((TSEEdge)object);
                tSGroupCommand.add(tSCommand);
            }
            iterator2 = tSEGraph.selectedNodes().iterator();
            while (iterator2.hasNext()) {
                object = new TSEDeleteNodeCommand((TSENode)iterator2.next());
                tSGroupCommand.add((TSCommand)object);
            }
        }
        this.transmit(tSGroupCommand);
        this.setCoalesce(bl);
    }

    public void deleteObject(TSEObject tSEObject) {
        TSCommand tSCommand = null;
        if (tSEObject instanceof TSENode) {
            tSCommand = new TSEDeleteNodeCommand((TSENode)tSEObject);
        } else if (tSEObject instanceof TSEEdge) {
            tSCommand = new TSEDeleteEdgeCommand((TSEEdge)tSEObject);
        } else if (tSEObject instanceof TSEEdgeLabel) {
            tSCommand = new TSEDeleteEdgeLabelCommand((TSEEdgeLabel)tSEObject);
        } else if (tSEObject instanceof TSENodeLabel) {
            tSCommand = new TSEDeleteNodeLabelCommand((TSENodeLabel)tSEObject);
        } else if (tSEObject instanceof TSEConnectorLabel) {
            tSCommand = new TSEDeleteConnectorLabelCommand((TSEConnectorLabel)tSEObject);
        } else if (tSEObject instanceof TSEPNode) {
            tSCommand = new TSEDeletePNodeCommand((TSEPNode)tSEObject);
        } else if (tSEObject instanceof TSEConnector) {
            tSCommand = new TSEDeleteConnectorCommand((TSEConnector)tSEObject);
        } else {
            throw new RuntimeException("The object cannot be deleted.");
        }
        this.transmit(tSCommand);
    }

    public void selectObject(TSEObject tSEObject, boolean bl) {
        f2.a(f2.az);
        if (tSEObject.isSelected()) {
            return;
        }
        tSEObject.setSelected(true);
        this.addInvalidRegion(tSEObject);
        if (bl) {
            this.updateInvalidRegion(true);
        }
    }

    public void deselectObject(TSEObject tSEObject, boolean bl) {
        if (!tSEObject.isSelected()) {
            return;
        }
        this.addInvalidRegion(tSEObject);
        tSEObject.setSelected(false);
        if (bl) {
            this.updateInvalidRegion(true);
        }
    }

    public void deselectAll(boolean bl) {
        this.deselectAll(bl, null);
    }

    public void deselectAll(boolean bl, TSEObject tSEObject) {
        boolean bl2 = this.getGraphManager().hasSelected(true);
        Iterator iterator = this.getGraphManager().graphs(true).iterator();
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        while (iterator.hasNext()) {
            TSEGraph tSEGraph = (TSEGraph)iterator.next();
            tSEGraph.deselectAll(tSEObject);
        }
        this.setCoalesce(bl3);
        if (bl2) {
            if (bl) {
                this.drawGraph();
                this.fastRepaint();
            } else {
                this.addInvalidRegion(this.transform.getWorldBounds());
            }
        }
    }

    public void selectAll(boolean bl) {
        this.getGraphManager().selectAll(true);
        if (bl) {
            this.drawGraph();
            this.fastRepaint();
        } else {
            this.addInvalidRegion(this.transform.getWorldBounds());
        }
    }

    public void selectGroup(List list, boolean bl) {
        f2.a(f2.az);
        if (list == null) {
            return;
        }
        boolean bl2 = this.isCoalesce();
        this.setCoalesce(true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TSEObject)) continue;
            ((TSEObject)e).setSelected(true);
        }
        this.addInvalidRegion(list);
        this.setCoalesce(bl2);
        if (bl) {
            this.updateInvalidRegion(true);
        }
    }

    public void toggleGroupSelection(List list, boolean bl) {
        f2.a(f2.az);
        if (list == null) {
            return;
        }
        this.addInvalidRegion(list);
        boolean bl2 = this.isCoalesce();
        this.setCoalesce(true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSEObject tSEObject;
            Object e = iterator.next();
            if (!(e instanceof TSEObject)) continue;
            tSEObject.setSelected(!(tSEObject = (TSEObject)e).isSelected());
        }
        this.setCoalesce(bl2);
        this.addInvalidRegion(list);
        if (bl) {
            this.updateInvalidRegion(true);
        }
    }

    public void selectAllNodes(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSENode == null ? (class$com$tomsawyer$editor$TSENode = TSEGraphWindow.class$("com.tomsawyer.editor.TSENode")) : class$com$tomsawyer$editor$TSENode, bl, true);
    }

    public void deselectAllNodes(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSENode == null ? (class$com$tomsawyer$editor$TSENode = TSEGraphWindow.class$("com.tomsawyer.editor.TSENode")) : class$com$tomsawyer$editor$TSENode, bl, false);
    }

    public void selectAllNodeLabels(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSENodeLabel == null ? (class$com$tomsawyer$editor$TSENodeLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSENodeLabel")) : class$com$tomsawyer$editor$TSENodeLabel, bl, true);
    }

    public void deselectAllNodeLabels(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSENodeLabel == null ? (class$com$tomsawyer$editor$TSENodeLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSENodeLabel")) : class$com$tomsawyer$editor$TSENodeLabel, bl, false);
    }

    public void selectAllEdges(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEEdge == null ? (class$com$tomsawyer$editor$TSEEdge = TSEGraphWindow.class$("com.tomsawyer.editor.TSEEdge")) : class$com$tomsawyer$editor$TSEEdge, bl, true);
    }

    public void deselectAllEdges(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEEdge == null ? (class$com$tomsawyer$editor$TSEEdge = TSEGraphWindow.class$("com.tomsawyer.editor.TSEEdge")) : class$com$tomsawyer$editor$TSEEdge, bl, false);
    }

    public void selectAllEdgeLabels(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEEdgeLabel == null ? (class$com$tomsawyer$editor$TSEEdgeLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSEEdgeLabel")) : class$com$tomsawyer$editor$TSEEdgeLabel, bl, true);
    }

    public void deselectAllEdgeLabels(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEEdgeLabel == null ? (class$com$tomsawyer$editor$TSEEdgeLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSEEdgeLabel")) : class$com$tomsawyer$editor$TSEEdgeLabel, bl, false);
    }

    public void selectAllConnectorLabels(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEConnectorLabel == null ? (class$com$tomsawyer$editor$TSEConnectorLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSEConnectorLabel")) : class$com$tomsawyer$editor$TSEConnectorLabel, bl, true);
    }

    public void deselectAllConnectorLabels(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEConnectorLabel == null ? (class$com$tomsawyer$editor$TSEConnectorLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSEConnectorLabel")) : class$com$tomsawyer$editor$TSEConnectorLabel, bl, false);
    }

    public void selectAllPathNodes(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEPNode == null ? (class$com$tomsawyer$editor$TSEPNode = TSEGraphWindow.class$("com.tomsawyer.editor.TSEPNode")) : class$com$tomsawyer$editor$TSEPNode, bl, true);
    }

    public void deselectAllPathNodes(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEPNode == null ? (class$com$tomsawyer$editor$TSEPNode = TSEGraphWindow.class$("com.tomsawyer.editor.TSEPNode")) : class$com$tomsawyer$editor$TSEPNode, bl, false);
    }

    public void selectAllConnectors(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEConnector == null ? (class$com$tomsawyer$editor$TSEConnector = TSEGraphWindow.class$("com.tomsawyer.editor.TSEConnector")) : class$com$tomsawyer$editor$TSEConnector, bl, true);
    }

    public void deselectAllConnectors(boolean bl) {
        this.selectObjects(class$com$tomsawyer$editor$TSEConnector == null ? (class$com$tomsawyer$editor$TSEConnector = TSEGraphWindow.class$("com.tomsawyer.editor.TSEConnector")) : class$com$tomsawyer$editor$TSEConnector, bl, false);
    }

    void selectObjects(Class clazz, boolean bl, boolean bl2) {
        TSEGraph tSEGraph = this.getGraph();
        TSEGraphManager tSEGraphManager = (TSEGraphManager)tSEGraph.getOwner();
        Cursor cursor = this.showWaitCursorOnCanvas();
        boolean bl3 = this.isCoalesce();
        this.setCoalesce(true);
        if (clazz == (class$com$tomsawyer$editor$TSENode == null ? (class$com$tomsawyer$editor$TSENode = TSEGraphWindow.class$("com.tomsawyer.editor.TSENode")) : class$com$tomsawyer$editor$TSENode)) {
            tSEGraphManager.selectAllNodes(bl2);
        } else if (clazz == (class$com$tomsawyer$editor$TSEEdge == null ? (class$com$tomsawyer$editor$TSEEdge = TSEGraphWindow.class$("com.tomsawyer.editor.TSEEdge")) : class$com$tomsawyer$editor$TSEEdge)) {
            tSEGraphManager.selectAllEdges(bl2);
        } else if (clazz == (class$com$tomsawyer$editor$TSEPNode == null ? (class$com$tomsawyer$editor$TSEPNode = TSEGraphWindow.class$("com.tomsawyer.editor.TSEPNode")) : class$com$tomsawyer$editor$TSEPNode)) {
            tSEGraphManager.selectAllPathNodes(bl2);
        } else if (clazz == (class$com$tomsawyer$editor$TSEEdgeLabel == null ? (class$com$tomsawyer$editor$TSEEdgeLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSEEdgeLabel")) : class$com$tomsawyer$editor$TSEEdgeLabel)) {
            tSEGraphManager.selectAllEdgeLabels(bl2);
        } else if (clazz == (class$com$tomsawyer$editor$TSENodeLabel == null ? (class$com$tomsawyer$editor$TSENodeLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSENodeLabel")) : class$com$tomsawyer$editor$TSENodeLabel)) {
            tSEGraphManager.selectAllNodeLabels(bl2);
        } else if (clazz == (class$com$tomsawyer$editor$TSEConnectorLabel == null ? (class$com$tomsawyer$editor$TSEConnectorLabel = TSEGraphWindow.class$("com.tomsawyer.editor.TSEConnectorLabel")) : class$com$tomsawyer$editor$TSEConnectorLabel)) {
            tSEGraphManager.selectAllConnectorLabels(bl2);
        } else if (clazz == (class$com$tomsawyer$editor$TSEConnector == null ? (class$com$tomsawyer$editor$TSEConnector = TSEGraphWindow.class$("com.tomsawyer.editor.TSEConnector")) : class$com$tomsawyer$editor$TSEConnector)) {
            tSEGraphManager.selectAllConnectors(bl2);
        }
        this.setCoalesce(bl3);
        if (bl) {
            this.drawGraph();
            this.fastRepaint();
        } else {
            this.addInvalidRegion(this.transform.getWorldBounds());
        }
        this.setCursorOnCanvas(cursor);
    }

    public TSConstPoint getWorldPoint(Point point) {
        return new TSConstPoint(this.getWorldX(point), this.getWorldY(point));
    }

    public double getWorldX(Point point) {
        return this.getAlignedWorldX(point);
    }

    public double getWorldY(Point point) {
        return this.getAlignedWorldY(point);
    }

    public TSConstPoint getNonalignedWorldPoint(Point point) {
        return new TSConstPoint(this.getNonalignedWorldX(point), this.getNonalignedWorldY(point));
    }

    public double getNonalignedWorldX(Point point) {
        return this.getTransform().xToWorld(point.x);
    }

    public double getNonalignedWorldY(Point point) {
        return this.getTransform().yToWorld(point.y);
    }

    public TSConstPoint getAlignedWorldPoint(Point point) {
        return new TSPoint(this.getAlignedWorldX(point), this.getAlignedWorldY(point));
    }

    public double getAlignedWorldX(Point point) {
        double d = this.getNonalignedWorldX(point);
        TSEWindowTool tSEWindowTool = this.getCurrentTool();
        if (this.hasGrid() && tSEWindowTool instanceof TSEWindowInputTool) {
            d = ((TSEWindowInputTool)tSEWindowTool).getGridOffsetX() + this.getGrid().getNearestGridX(d);
        }
        return d;
    }

    public double getAlignedWorldY(Point point) {
        double d = this.getNonalignedWorldY(point);
        TSEWindowTool tSEWindowTool = this.getCurrentTool();
        if (this.hasGrid() && tSEWindowTool instanceof TSEWindowInputTool) {
            d = ((TSEWindowInputTool)tSEWindowTool).getGridOffsetY() + this.getGrid().getNearestGridX(d);
        }
        return d;
    }

    public TSConstRect getWorldBounds() {
        return this.getTransform().getWorldBounds();
    }

    public void cut() {
        this.cut(null);
    }

    public void cut(TSOptionData tSOptionData) {
        TSEDeleteEdgeCommand tSEDeleteEdgeCommand;
        Object object;
        f2.a(f2.bv);
        Cursor cursor = this.showWaitCursorOnCanvas();
        this.getCutCopyPasteControl().copy((TSDGraphManager)this.graphManager, tSOptionData, this.graphManager.selectedNodes(), this.graphManager.selectedEdges(true), this.graphManager.selectedNodeLabels(), this.graphManager.selectedConnectorLabels(), this.graphManager.selectedEdgeLabels(true));
        TSGroupCommand tSGroupCommand = new TSGroupCommand();
        Iterator iterator = this.graphManager.selectedEdgeLabels(true).iterator();
        while (iterator.hasNext()) {
            object = new TSEDeleteEdgeLabelCommand((TSEEdgeLabel)iterator.next());
            tSGroupCommand.add((TSCommand)object);
        }
        iterator = this.graphManager.selectedNodeLabels().iterator();
        while (iterator.hasNext()) {
            object = new TSEDeleteNodeLabelCommand((TSENodeLabel)iterator.next());
            tSGroupCommand.add((TSCommand)object);
        }
        iterator = this.graphManager.selectedConnectorLabels().iterator();
        while (iterator.hasNext()) {
            object = new TSEDeleteConnectorLabelCommand((TSEConnectorLabel)iterator.next());
            tSGroupCommand.add((TSCommand)object);
        }
        iterator = this.graphManager.selectedNodes().iterator();
        while (iterator.hasNext()) {
            object = (TSENode)iterator.next();
            this.deepMarkNodes((TSENode)object, true);
        }
        iterator = this.graphManager.selectedEdges(true).iterator();
        while (iterator.hasNext()) {
            object = (TSEEdge)iterator.next();
            if (!((TSEdge)object).getSourceNode().isMarked() && !((TSEdge)object).getTargetNode().isMarked()) continue;
            tSEDeleteEdgeCommand = new TSEDeleteEdgeCommand((TSEEdge)object);
            tSGroupCommand.add(tSEDeleteEdgeCommand);
        }
        iterator = this.graphManager.intergraphEdges().iterator();
        while (iterator.hasNext()) {
            object = (TSEEdge)iterator.next();
            if (((TSEEdge)object).isSelected() || !((TSEdge)object).getSourceNode().isMarked() && !((TSEdge)object).getTargetNode().isMarked()) continue;
            tSEDeleteEdgeCommand = new TSEDeleteEdgeCommand((TSEEdge)object);
            tSGroupCommand.add(tSEDeleteEdgeCommand);
        }
        iterator = this.graphManager.selectedNodes().iterator();
        while (iterator.hasNext()) {
            object = (TSENode)iterator.next();
            this.deepMarkNodes((TSENode)object, false);
        }
        iterator = this.graphManager.selectedNodes().iterator();
        while (iterator.hasNext()) {
            object = new TSEDeleteNodeCommand((TSENode)iterator.next());
            tSGroupCommand.add((TSCommand)object);
        }
        this.transmit(tSGroupCommand);
        this.setCursorOnCanvas(cursor);
    }

    private void deepMarkNodes(TSENode tSENode, boolean bl) {
        tSENode.setMarked(bl);
        if (tSENode.getChildGraph() != null) {
            Iterator iterator = tSENode.getChildGraph().nodes().iterator();
            while (iterator.hasNext()) {
                this.deepMarkNodes((TSENode)iterator.next(), bl);
            }
        }
    }

    public void copy() {
        this.copy(null);
    }

    public void copy(TSOptionData tSOptionData) {
        f2.a(f2.bw);
        Cursor cursor = this.showWaitCursorOnCanvas();
        this.getCutCopyPasteControl().copy((TSDGraphManager)this.graphManager, tSOptionData, this.graphManager.selectedNodes(), this.graphManager.selectedEdges(true), this.graphManager.selectedNodeLabels(), this.graphManager.selectedConnectorLabels(), this.graphManager.selectedEdgeLabels(true));
        this.setCursorOnCanvas(cursor);
    }

    public void duplicate() {
        this.duplicate(null);
    }

    public void duplicate(TSOptionData tSOptionData) {
        f2.a(f2.by);
        Cursor cursor = this.showWaitCursorOnCanvas();
        this.transmit(new TSEDuplicateCommand(this.graphManager, tSOptionData));
        this.setCursorOnCanvas(cursor);
    }

    public TSCutCopyPasteControl getCutCopyPasteControl() {
        return this.cutCopyPasteControl;
    }

    protected TSCutCopyPasteControl newCutCopyPasteControl() {
        return new TSCutCopyPasteControl(this.getClipboard());
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0 || (n & 0x10) == 0;
    }

    /*
     * Unable to fully structure code
     */
    public void scrollBy(int var1_1, int var2_2, boolean var3_3) {
        block26: {
            block25: {
                var4_4 = new TSConstRect(this.getTransform().getWorldBounds());
                var5_5 = this.transform.widthToWorld(var1_1);
                var7_6 = this.transform.heightToWorld(var2_2);
                this.transform.moveWorldBy(var5_5, -var7_6);
                var9_7 = (TSEGraphUI)this.getGraph().getUI();
                var10_8 = var9_7.getBackgroundImageStyle();
                if (var10_8 == 2) break block25;
                if (var10_8 != 3) break block26;
            }
            if (var9_7.getBackgroundImage() == null) break block26;
            if (var9_7.isBackgroundImageTiled()) ** GOTO lbl-1000
            if (var10_8 == 3) lbl-1000:
            // 2 sources

            {
                this.addInvalidRegion(this.transform.getWorldBounds());
            } else {
                var11_9 = var9_7.getBackgroundImage().getImage();
                if (var11_9 != null) {
                    var12_10 = var9_7.getBackgroundImageX();
                    var14_17 = var9_7.getBackgroundImageY();
                    var16_18 = var11_9.getWidth(null);
                    var17_19 = var11_9.getHeight(null);
                    var18_20 = this.transform.getDeviceBounds();
                    var19_21 = (double)var18_20.x + (double)var18_20.width / 2.0 + var12_10 - (double)var16_18 / 2.0;
                    var21_22 = (double)var18_20.y + (double)var18_20.height / 2.0 + var14_17 - (double)var17_19 / 2.0;
                    var23_23 = this.transform.xToWorld((int)var19_21);
                    var25_24 = this.transform.yToWorld((int)var21_22);
                    var27_25 = this.transform.xToWorld((int)var19_21 + var16_18);
                    var29_26 = this.transform.yToWorld((int)var21_22 + var17_19);
                    if (var5_5 > 0.0) {
                        var23_23 -= var5_5;
                    } else if (var5_5 < 0.0) {
                        var27_25 -= var5_5;
                    }
                    if (var7_6 > 0.0) {
                        var25_24 += var7_6;
                    } else if (var7_6 < 0.0) {
                        var29_26 += var7_6;
                    }
                    this.addInvalidRegion(new TSConstRect(var23_23, var29_26, var27_25, var25_24));
                }
            }
        }
        this.doubleBuffer.getGraphics().translate(var1_1, -var2_2);
        if (var1_1 != 0) {
            if (var2_2 == 0 && var3_3) {
                this.updateInvalidRegion();
            }
            var11_9 = var1_1 < 0 ? new TSConstRect(this.transform.xToWorld(0), this.transform.yToWorld(0), this.transform.xToWorld(-var1_1), this.transform.yToWorld(this.getCanvas().getHeight())) : new TSConstRect(this.transform.xToWorld(this.getCanvas().getWidth() - var1_1), this.transform.yToWorld(0), this.transform.xToWorld(this.getCanvas().getWidth()), this.transform.yToWorld(this.getCanvas().getHeight()));
            this.addInvalidRegion((TSConstRect)var11_9);
        }
        if (var2_2 != 0) {
            if (var1_1 == 0 && var3_3) {
                this.updateInvalidRegion();
            }
            var11_9 = var2_2 < 0 ? new TSConstRect(this.transform.xToWorld(0), this.transform.yToWorld(0), this.transform.xToWorld(this.getCanvas().getWidth()), this.transform.yToWorld(-var2_2)) : new TSConstRect(this.transform.xToWorld(0), this.transform.yToWorld(this.getCanvas().getHeight() - var2_2), this.transform.xToWorld(this.getCanvas().getWidth()), this.transform.yToWorld(this.getCanvas().getHeight()));
            this.addInvalidRegion((TSConstRect)var11_9);
        }
        if ((var11_9 = this.getGraphManager()).hasSelectedNodes()) {
            var12_11 = var11_9.selectedNodes().iterator();
            while (var12_11.hasNext()) {
                var13_27 = (TSENodeUI)((TSENode)var12_11.next()).getUI();
                var13_27.invalidateGrapples();
            }
        }
        if (var11_9.hasSelectedEdgeLabels(true)) {
            var12_12 = var11_9.selectedEdgeLabels(true).iterator();
            while (var12_12.hasNext()) {
                var13_27 = (TSELabelUI)((TSEEdgeLabel)var12_12.next()).getUI();
                var13_27.invalidateGrapples();
            }
        }
        if (var11_9.hasSelectedNodeLabels()) {
            var12_13 = var11_9.selectedNodeLabels().iterator();
            while (var12_13.hasNext()) {
                var13_27 = (TSELabelUI)((TSENodeLabel)var12_13.next()).getUI();
                var13_27.invalidateGrapples();
            }
        }
        if (var11_9.hasSelectedConnectorLabels()) {
            var12_14 = var11_9.selectedConnectorLabels().iterator();
            while (var12_14.hasNext()) {
                var13_27 = (TSELabelUI)((TSEConnectorLabel)var12_14.next()).getUI();
                var13_27.invalidateGrapples();
            }
        }
        if (var11_9.hasSelectedPathNodes(true)) {
            var12_15 = var11_9.selectedPathNodes(true).iterator();
            while (var12_15.hasNext()) {
                var13_27 = (dc)((TSEPNode)var12_15.next()).getUI();
                var13_27.invalidateGrapples();
            }
        }
        if (var3_3) {
            this.updateScrollBarValues();
            this.updateInvalidRegion();
            this.fastRepaint();
        }
        if (!TSSystem.equals(var4_4, var12_16 = this.getTransform().getWorldBounds())) {
            this.getGraphManager().getEventManager().fireEvent(new TSEViewportChangeEvent(2L, new TSEViewportChangeEventData((Object)this, var4_4, var12_16)));
        }
    }

    public void smoothScrollBy(int n, int n2, int n3) {
        if (n3 < 1) {
            n3 = 1;
        }
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n3;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3 - 1; ++i) {
            int n6 = (int)(d3 += d) - n4;
            int n7 = (int)(d4 += d2) - n5;
            this.scrollBy(n6, n7, true);
            n4 += n6;
            n5 += n7;
        }
        this.scrollBy(n - n4, n2 - n5, true);
    }

    public double getMaxZoomLevel() {
        return this.getPreferences().getDoubleValue("maximumZoomLevel");
    }

    public void setMaxZoomLevel(double d) {
        this.getPreferences().setValue((Object)"maximumZoomLevel", d);
    }

    public double getMinZoomLevel() {
        return this.getPreferences().getDoubleValue("minimumZoomLevel");
    }

    public void setMinZoomLevel(double d) {
        this.getPreferences().setValue((Object)"minimumZoomLevel", d);
    }

    public double getZoomLevel() {
        return this.getTransform().getScaleX();
    }

    public void setZoomLevel(double d, boolean bl) {
        if (d <= 0.0) {
            return;
        }
        double d2 = this.getZoomLevel();
        if (d >= this.getMaxZoomLevel()) {
            d = this.getMaxZoomLevel();
        } else if (d <= this.getMinZoomLevel()) {
            d = this.getMinZoomLevel();
        }
        Cursor cursor = this.showWaitCursorOnCanvas();
        this.getTransform().setZoomLevel(1.0 / d);
        this.resetWorkBounds();
        if (bl) {
            this.updateScrollBarValues();
            this.drawGraph();
            this.fastRepaint();
        } else {
            this.addInvalidRegion(this.getTransform().getWorldBounds());
        }
        this.setCursorOnCanvas(cursor);
        if (d2 != this.getZoomLevel()) {
            this.getGraphManager().getEventManager().fireEvent(new TSEViewportChangeEvent(1L, new TSEViewportChangeEventData((Object)this, d2, this.getZoomLevel())));
        }
    }

    public void zoom(double d, boolean bl) {
        Cursor cursor = this.showWaitCursorOnCanvas();
        double d2 = this.getZoomLevel();
        double d3 = d < 0.0 ? 1.0 - d : 1.0 / (1.0 + d);
        if (d > 0.0 && this.getZoomLevel() / d3 >= this.getMaxZoomLevel()) {
            d3 = this.getZoomLevel() / this.getMaxZoomLevel();
        } else if (d < 0.0 && this.getZoomLevel() / d3 <= this.getMinZoomLevel()) {
            d3 = this.getZoomLevel() / this.getMinZoomLevel();
        }
        this.transform.expandWorldBy(d3, d3);
        this.resetWorkBounds();
        if (bl) {
            this.updateScrollBarValues();
            this.drawGraph();
            this.fastRepaint();
        } else {
            this.addInvalidRegion(this.transform.getWorldBounds());
        }
        this.setCursorOnCanvas(cursor);
        if (d2 != this.getZoomLevel()) {
            this.getGraphManager().getEventManager().fireEvent(new TSEViewportChangeEvent(1L, new TSEViewportChangeEventData((Object)this, d2, this.getZoomLevel())));
        }
    }

    public void fitRectInWindow(TSConstRect tSConstRect, boolean bl) {
        double d;
        double d2 = this.getZoomLevel();
        TSConstRect tSConstRect2 = this.getTransform().getWorldBounds();
        if (tSConstRect == null || tSConstRect.getWidth() == 0.0 || tSConstRect.getHeight() == 0.0) {
            return;
        }
        double d3 = (double)this.transform.getDeviceBounds().height / tSConstRect.getHeight();
        double d4 = (double)this.transform.getDeviceBounds().width / tSConstRect.getWidth();
        double d5 = Math.min(d4, d3);
        if (d5 > this.getMaxZoomLevel()) {
            d = d5 / this.getMaxZoomLevel();
            TSRect tSRect = new TSRect(tSConstRect);
            tSRect.setHeight(tSConstRect.getHeight() * d);
            tSRect.setWidth(tSConstRect.getWidth() * d);
            tSConstRect = tSRect;
        } else if (d5 < this.getMinZoomLevel()) {
            d = d5 / this.getMinZoomLevel();
            TSRect tSRect = new TSRect(tSConstRect);
            tSRect.setHeight(tSConstRect.getHeight() * d);
            tSRect.setWidth(tSConstRect.getWidth() * d);
            tSConstRect = tSRect;
        }
        Cursor cursor = this.showWaitCursorOnCanvas();
        this.transform.fitToDevice(tSConstRect);
        if (this.getGraph().numberOfNodes() == 0) {
            this.transform.setZoomLevel(1.0);
        }
        this.resetWorkBounds();
        if (bl) {
            this.updateScrollBarValues();
            this.drawGraph();
            this.fastRepaint();
        } else {
            this.addInvalidRegion(this.transform.getWorldBounds());
        }
        if (d2 != this.getZoomLevel() || !tSConstRect2.equals(this.getTransform().getWorldBounds())) {
            this.getGraphManager().getEventManager().fireEvent(new TSEViewportChangeEvent(1L, new TSEViewportChangeEventData((Object)this, d2, this.getZoomLevel())));
        }
        this.setCursorOnCanvas(cursor);
    }

    public void fitInWindow(boolean bl) {
        this.fitRectInWindow(this.getGraph().getFrameBounds(), bl);
    }

    public void centerRectInWindow(TSConstRect tSConstRect, boolean bl) {
        if (tSConstRect == null || tSConstRect.getWidth() == 0.0 || tSConstRect.getHeight() == 0.0) {
            return;
        }
        TSConstRect tSConstRect2 = new TSConstRect(this.getTransform().getWorldBounds());
        Cursor cursor = this.showWaitCursorOnCanvas();
        this.transform.centerWorldInDevice(tSConstRect);
        this.resetWorkBounds();
        if (bl) {
            this.updateScrollBarValues();
            this.drawGraph();
            this.fastRepaint();
        } else {
            this.addInvalidRegion(this.transform.getWorldBounds());
        }
        this.setCursorOnCanvas(cursor);
        TSConstRect tSConstRect3 = this.getTransform().getWorldBounds();
        if (!TSSystem.equals(tSConstRect2, tSConstRect3)) {
            this.getGraphManager().getEventManager().fireEvent(new TSEViewportChangeEvent(2L, new TSEViewportChangeEventData((Object)this, tSConstRect2, tSConstRect3)));
        }
    }

    public void centerPointInWindow(TSConstPoint tSConstPoint, boolean bl) {
        TSConstRect tSConstRect = new TSConstRect(tSConstPoint.getX() - 5.0, tSConstPoint.getY() - 5.0, tSConstPoint.getX() + 5.0, tSConstPoint.getY() + 5.0);
        this.centerRectInWindow(tSConstRect, bl);
    }

    public void centerGraph(boolean bl) {
        this.centerRectInWindow(this.getGraph().getFrameBounds(), bl);
    }

    public void setUndoLimit(int n) {
        this.getPreferences().setValue((Object)"undoStackSize", n);
    }

    public int getUndoLimit() {
        return this.getPreferences().getIntValue("undoStackSize");
    }

    public void setDefaultUndoLimit(int n) {
        this.undoStack.setDefaultUndoLimit(n);
    }

    public int getDefaultUndoLimit() {
        return this.undoStack.getDefaultUndoLimit();
    }

    public void clearUndoStack() {
        this.undoStack.clear();
    }

    public TSCommand popUndoStack() {
        return this.undoStack.pop();
    }

    public void undo() {
        TSCommand tSCommand = this.undoStack.undo();
        if (tSCommand != null) {
            TSEEventManager tSEEventManager = (TSEEventManager)this.getGraphManager().getEventManager();
            boolean bl = false;
            boolean bl2 = tSEEventManager.isFiringVetoableEvents();
            if (tSCommand.isCoalesced()) {
                bl = this.isCoalesce();
                this.setCoalesce(true);
            }
            tSEEventManager.setFireVetoableEvents(false);
            this.transmit(tSCommand);
            tSEEventManager.setFireVetoableEvents(bl2);
            if (tSCommand.isCoalesced()) {
                this.setCoalesce(bl);
            }
        }
    }

    public void redo() {
        TSCommand tSCommand = this.undoStack.redo();
        if (tSCommand != null) {
            TSEEventManager tSEEventManager = (TSEEventManager)this.getGraphManager().getEventManager();
            boolean bl = false;
            boolean bl2 = tSEEventManager.isFiringVetoableEvents();
            if (tSCommand.isCoalesced()) {
                bl = this.isCoalesce();
                this.setCoalesce(true);
            }
            tSEEventManager.setFireVetoableEvents(false);
            this.transmit(tSCommand);
            tSEEventManager.setFireVetoableEvents(bl2);
            if (tSCommand.isCoalesced()) {
                this.setCoalesce(bl);
            }
        }
    }

    public boolean canUndo() {
        return this.undoStack.canUndo();
    }

    public boolean canRedo() {
        return this.undoStack.canRedo();
    }

    public void resetGraphWindow() {
        this.switchTool(this.defaultTool);
        this.clearUndoStack();
        this.getCutCopyPasteControl().reset();
        this.updateScrollBarValues();
    }

    public void cancelAction() {
        this.currentTool.cancelAction();
    }

    public void switchState(TSEWindowState tSEWindowState) {
        this.switchTool(tSEWindowState);
    }

    public void switchTool(TSEWindowTool tSEWindowTool) {
        TSSystem.tsAssert(tSEWindowTool != null);
        this.getCurrentTool().cancelAction();
        if (this.getCurrentTool() != null) {
            this.getCurrentTool().finalizeTool();
        }
        this.setCurrentTool(tSEWindowTool);
        tSEWindowTool.resetTool();
    }

    public void updateScrollBarValues() {
        if (this.transform != null) {
            boolean bl;
            boolean bl2;
            this.growWorkBounds();
            int n = (int)(this.transform.getScaleX() * this.workBounds.getLeft());
            int n2 = (int)(this.transform.getScaleX() * this.workBounds.getRight());
            int n3 = (int)(this.transform.getScaleX() * this.transform.getWorldBounds().getLeft());
            int n4 = this.transform.getDeviceBounds().width;
            if (n4 >= n2 - n) {
                n4 = n2 - n - 1;
            }
            int n5 = (int)(this.transform.getScaleY() * this.workBounds.getBottom());
            int n6 = (int)(this.transform.getScaleY() * this.workBounds.getTop());
            int n7 = (int)(this.transform.getScaleY() * this.transform.getWorldBounds().getBottom());
            int n8 = this.transform.getDeviceBounds().height;
            if (n8 >= n5 - n6) {
                n8 = n5 - n6 - 1;
            }
            this.noRedrawInAdjustmentListener = true;
            this.horizontalScrollBar.getModel().setRangeProperties(n3, n4, n, n2, false);
            this.horizontalScrollBar.setBlockIncrement(this.getCanvas().getWidth() / 4);
            this.horizontalScrollBar.setUnitIncrement(this.getCanvas().getWidth() / 25);
            this.verticalScrollBar.getModel().setRangeProperties(n7 - n8, n8, n6, n5, false);
            this.verticalScrollBar.setBlockIncrement(this.getCanvas().getHeight() / 4);
            this.verticalScrollBar.setUnitIncrement(this.getCanvas().getHeight() / 25);
            this.noRedrawInAdjustmentListener = false;
            if (this.isAutoHidingScrollBars()) {
                bl2 = this.horizontalScrollBar.getVisibleAmount() < this.horizontalScrollBar.getMaximum() - this.horizontalScrollBar.getMinimum() - 1;
                bl = this.verticalScrollBar.getVisibleAmount() < this.verticalScrollBar.getMaximum() - this.verticalScrollBar.getMinimum() - 1;
            } else {
                bl = true;
                bl2 = true;
            }
            if (bl2 != this.horizontalScrollBar.isVisible() || bl != this.verticalScrollBar.isVisible()) {
                boolean bl3 = false;
                if (bl2 != this.horizontalScrollBar.isVisible()) {
                    this.horizontalScrollBar.setVisible(bl2);
                    bl3 = true;
                }
                if (bl != this.verticalScrollBar.isVisible()) {
                    this.verticalScrollBar.setVisible(bl);
                    bl3 = true;
                }
                this.doLayout();
                if (bl3) {
                    SwingUtilities.invokeLater(new gw(this));
                }
            }
        }
    }

    public void resetScrollRange() {
        double d = this.getXScrollRange();
        double d2 = this.getYScrollRange();
        this.setXScrollRange(d);
        this.setYScrollRange(d2);
    }

    public void growWorkBounds() {
        if (this.getGraph().numberOfNodes() == 0) {
            this.resetWorkBounds();
        }
        this.workBounds.merge(this.getGraph().getFrameBounds());
        this.workBounds.merge(this.transform.getWorldBounds());
    }

    public void resetWorkBounds() {
        double d = this.getXScrollRange();
        double d2 = this.getYScrollRange();
        this.setXScrollRange(d);
        this.setYScrollRange(d2);
    }

    public void setXScrollRange(double d) {
        this.proportionInX = d;
        double d2 = this.transform.widthToWorld(this.getCanvas().getWidth()) / 2.0;
        TSConstRect tSConstRect = this.getGraph().getFrameBounds();
        this.workBounds.setLeft(tSConstRect.getCenterX() - d2 * d);
        this.workBounds.setRight(tSConstRect.getCenterX() + d2 * d);
    }

    public void setYScrollRange(double d) {
        this.proportionInY = d;
        double d2 = this.transform.heightToWorld(this.getCanvas().getHeight()) / 2.0;
        TSConstRect tSConstRect = this.getGraph().getFrameBounds();
        this.workBounds.setTop(tSConstRect.getCenterY() + d2 * d);
        this.workBounds.setBottom(tSConstRect.getCenterY() - d2 * d);
    }

    public void setScrollRange(double d) {
        this.setXScrollRange(d);
        this.setYScrollRange(d);
    }

    public void setScrollRange(double d, double d2) {
        this.setXScrollRange(d);
        this.setYScrollRange(d2);
    }

    public double getDefaultScrollRange() {
        return 0.1;
    }

    public double getXScrollRange() {
        return this.proportionInX;
    }

    public double getYScrollRange() {
        return this.proportionInY;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public boolean isAutoHidingScrollBars() {
        return this.getPreferences().getBooleanValue("autoHideScrollbars");
    }

    public void setAutoHidingScrollBars(boolean bl) {
        this.getPreferences().setValue((Object)"autoHideScrollbars", bl);
    }

    public boolean isAutoHidingScrollBarsByDefault() {
        return false;
    }

    void createGUI(boolean bl) {
        this.setLayout(new GridBagLayout());
        this.setCanvas(new TSEInnerCanvas(this));
        this.horizontalScrollBar = new JScrollBar(0);
        this.verticalScrollBar = new JScrollBar(1);
        if (bl) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            if (!TSELocalization.getComponentOrientation().isLeftToRight()) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
            } else {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
            }
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 3;
            this.add((Component)this.verticalScrollBar, gridBagConstraints);
            if (!TSELocalization.getComponentOrientation().isLeftToRight()) {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
            } else {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
            }
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this.horizontalScrollBar, gridBagConstraints);
        }
    }

    public static String getToolTipFormat() {
        return tooltipFormat;
    }

    public static void setToolTipFormat(String string) {
        tooltipFormat = string;
    }

    public static void setToolTipFont(TSEFont tSEFont) {
        String string = tSEFont.getFont().getFontName();
        int n = tSEFont.getFont().getStyle();
        int n2 = tSEFont.getFont().getSize();
        String string2 = "<font face='" + string + "' size=" + n2 + ">";
        String string3 = "</font>";
        String string4 = null;
        if (n == 1) {
            string4 = "b";
        } else if (n == 2) {
            string4 = "i";
        }
        if (string4 != null) {
            string2 = string2 + "<" + string4 + ">";
            string3 = "</" + string4 + ">" + string3;
        }
        String string5 = "<html>" + string2 + TOOLTIP_PLACEHOLDER + string3 + "</html>";
        TSEGraphWindow.setToolTipFormat(string5);
    }

    public boolean isUserActionEnabled() {
        return this.userActionPossible;
    }

    public void setUserActionEnabled(boolean bl) {
        if (!bl) {
            this.currentTool.cancelAction();
            if (this.isWaitCursorShownOnCanvas()) {
                this.setCursorOnCanvas(Cursor.getPredefinedCursor(3));
            }
            this.getCanvas().setEnabled(false);
        } else {
            this.currentTool.resetTool();
            this.getCanvas().setEnabled(true);
        }
        this.userActionPossible = bl;
    }

    public TSEWindowTool getCurrentState() {
        return this.getCurrentTool();
    }

    public TSEWindowTool getCurrentTool() {
        return this.currentTool;
    }

    void setCurrentTool(TSEWindowTool tSEWindowTool) {
        this.currentTool = tSEWindowTool;
        this.currentTool.setGraphWindow(this);
    }

    public TSEWindowTool getDefaultState() {
        return this.getDefaultTool();
    }

    public TSEWindowTool getDefaultTool() {
        return this.defaultTool;
    }

    public void setDefaultState(TSEWindowState tSEWindowState) {
        this.setDefaultTool(tSEWindowState);
    }

    public void setDefaultTool(TSEWindowTool tSEWindowTool) {
        try {
            if (this.getDropTarget() != null) {
                this.getDropTarget().removeDropTargetListener(((TSEWindowInputTool)this.getDefaultTool()).getInternalDropTargetListener());
            }
            if (this.dragGestureRecognizer != null) {
                this.dragGestureRecognizer.removeDragGestureListener(((TSEWindowInputTool)this.getDefaultTool()).getInternalDragGestureListener());
            }
            if (tSEWindowTool == null) {
                tSEWindowTool = new TSESelectTool();
            }
            this.defaultTool = tSEWindowTool;
            this.setDragSource(new DragSource());
            if (this.dragGestureRecognizer != null) {
                this.dragGestureRecognizer.addDragGestureListener(((TSEWindowInputTool)this.getDefaultTool()).getInternalDragGestureListener());
            }
            if (this.getDropTarget() != null) {
                this.getDropTarget().addDropTargetListener(((TSEWindowInputTool)this.getDefaultTool()).getInternalDropTargetListener());
            }
            this.switchTool(tSEWindowTool);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getHitTolerance() {
        return this.getPreferences().getIntValue("hitTolerance");
    }

    public void setHitTolerance(int n) {
        this.getPreferences().setValue((Object)"hitTolerance", n);
    }

    public int getHitToleranceThreshold() {
        return this.getPreferences().getIntValue("hitToleranceThreshold");
    }

    public void setHitToleranceThreshold(int n) {
        this.getPreferences().setValue((Object)"hitToleranceThreshold", n);
    }

    public void setGraphManager(TSEGraphManager tSEGraphManager) {
        TSSystem.tsAssert(tSEGraphManager != null);
        if (!this.isOverview()) {
            TSSystem.tsAssert(tSEGraphManager.getGraphWindow() == null);
            this.graphManager.setGraphWindow(null);
            this.graphManager = tSEGraphManager;
            this.graphManager.setGraphWindow(this);
            if (tSEGraphManager.numberOfGraphs() == 0) {
                tSEGraphManager.addGraph();
            }
            if (tSEGraphManager.getMainDisplayGraph() == null) {
                tSEGraphManager.setMainDisplayGraph((TSEGraph)tSEGraphManager.firstGraph());
            }
            this.setGraph((TSEGraph)tSEGraphManager.getMainDisplayGraph(), true);
        } else {
            this.graphManager = tSEGraphManager;
            this.setGraph((TSEGraph)tSEGraphManager.getMainDisplayGraph(), true);
        }
    }

    public TSEGraphManager getGraphManager() {
        return this.graphManager;
    }

    public TSEGraph getGraphAt(TSConstPoint tSConstPoint) {
        TSENode tSENode = this.getExpandedNodeAt(tSConstPoint);
        TSEGraph tSEGraph = tSENode != null ? (TSEGraph)tSENode.getChildGraph() : this.getGraph();
        return tSEGraph;
    }

    public TSENode getExpandedNodeAt(TSConstPoint tSConstPoint) {
        if (this.isNestedGraphEditingEnabled()) {
            TSEGraph tSEGraph = this.getGraph();
            TSENode tSENode = null;
            while (true) {
                TSPoint tSPoint = new TSPoint(tSConstPoint);
                tSEGraph.inverseExpandedTransformPoint(tSPoint);
                TSENode tSENode2 = (TSENode)tSEGraph.getLocalLastNodeTouchingBounds(new TSConstRect(tSPoint.getX(), tSPoint.getY(), tSPoint.getX(), tSPoint.getY()), null);
                if (tSENode2 == null || !tSENode2.isExpanded()) break;
                tSENode = tSENode2;
                tSEGraph = (TSEGraph)tSENode.getChildGraph();
            }
            return tSENode;
        }
        return null;
    }

    public TSEGraph getGraph() {
        return (TSEGraph)this.getGraphManager().getMainDisplayGraph();
    }

    public void setGraph(TSEGraph tSEGraph, boolean bl) {
        f2.f(f2.aw);
        if (tSEGraph == null) {
            return;
        }
        TSSystem.tsAssert(tSEGraph != null && tSEGraph.getOwner() == this.graphManager);
        this.graphManager.setMainDisplayGraph(tSEGraph);
        if (!this.isOverview()) {
            tSEGraph.setSelected(true);
        }
        TSSystem.tsAssert(this.getGraph() == tSEGraph);
        this.currentTool.cancelAction();
        this.currentTool.resetTool();
        if (bl) {
            this.drawGraph();
            this.fastRepaint();
        } else {
            this.addInvalidRegion(this.transform.getWorldBounds());
        }
    }

    public TSENodeUI getCurrentNodeUI() {
        return this.currentNodeUI;
    }

    public void setCurrentNodeUI(TSENodeUI tSENodeUI) {
        this.currentNodeUI = tSENodeUI;
    }

    public TSEEdgeUI getCurrentEdgeUI() {
        return this.currentEdgeUI;
    }

    public void setCurrentEdgeUI(TSEEdgeUI tSEEdgeUI) {
        this.currentEdgeUI = tSEEdgeUI;
    }

    public TSELabelUI getCurrentLabelUI() {
        return this.currentLabelUI;
    }

    public TSEConnectorUI getCurrentConnectorUI() {
        return this.currentConnectorUI;
    }

    public void setCurrentLabelUI(TSELabelUI tSELabelUI) {
        this.currentLabelUI = tSELabelUI;
    }

    public void setCurrentConnectorUI(TSEConnectorUI tSEConnectorUI) {
        this.currentConnectorUI = tSEConnectorUI;
    }

    public void setCurrentMetaEdgeUI(TSEEdgeUI tSEEdgeUI) {
        this.currentMetaEdgeUI = tSEEdgeUI;
    }

    public TSEEdgeUI getCurrentMetaEdgeUI() {
        return this.currentMetaEdgeUI;
    }

    public boolean isEdgeCreatedWithLabel() {
        return this.edgeCreatedWithLabel;
    }

    public boolean isNodeCreatedWithLabel() {
        return this.nodeCreatedWithLabel;
    }

    public boolean isConnectorCreatedWithLabel() {
        return this.connectorCreatedWithLabel;
    }

    public void setEdgeCreatedWithLabel(boolean bl) {
        this.edgeCreatedWithLabel = bl;
    }

    public void setNodeCreatedWithLabel(boolean bl) {
        this.nodeCreatedWithLabel = bl;
    }

    public void setConnectorCreatedWithLabel(boolean bl) {
        this.connectorCreatedWithLabel = bl;
    }

    public dc getCurrentPathNodeUI() {
        return this.currentPathNodeUI;
    }

    public TSTransform getTransform() {
        return this.transform;
    }

    public JComponent getCanvas() {
        return this.canvas;
    }

    public void setCanvas(TSEInnerCanvas tSEInnerCanvas) {
        boolean bl = this.isToolTipShown();
        this.setToolTipShown(false);
        if (this.canvas != null) {
            this.remove(this.canvas);
        }
        this.canvas = tSEInnerCanvas;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (!TSELocalization.getComponentOrientation().isLeftToRight()) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)tSEInnerCanvas, gridBagConstraints);
        if (this.getDefaultTool() != null) {
            this.setDragSource(new DragSource());
            this.dragGestureRecognizer = this.getDragSource().createDefaultDragGestureRecognizer(this.getCanvas(), this.getAcceptableDragActions(), ((TSEWindowInputTool)this.getDefaultTool()).getInternalDragGestureListener());
            this.setDropTarget(new DropTarget(tSEInnerCanvas, this.getAcceptableDropActions(), ((TSEWindowInputTool)this.getDefaultTool()).getInternalDropTargetListener()));
        }
        this.setToolTipShown(bl);
    }

    public boolean canPaste() {
        return this.getCutCopyPasteControl().canPaste();
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard("graph window clipboard");
        }
        return this.clipboard;
    }

    public void setClipboard(Clipboard clipboard) {
        if (clipboard != this.clipboard) {
            this.clipboard = clipboard;
            this.getCutCopyPasteControl().setClipboard(clipboard);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 50);
    }

    public TSRect getWorkBounds() {
        return this.workBounds;
    }

    public void setGrid(TSEGrid tSEGrid) {
        TSEGrid tSEGrid2 = this.grid;
        this.grid = tSEGrid;
        this.drawGraph();
        this.fastRepaint();
        this.updateScrollBarValues();
        this.getGraph().fireEvent(new TSEModeChangeEvent(2L, new TSEModeChangeEventData(this, tSEGrid2, tSEGrid)));
    }

    public TSEGrid getGrid() {
        return this.grid;
    }

    public Image getVisibleGraphImage() {
        return this.getVisibleGraphImage(false, false);
    }

    public Image getVisibleGraphImage(boolean bl, boolean bl2) {
        this.drawGraph(null, bl, false, bl2);
        if (bl2) {
            TSEGraphics tSEGraphics = this.newGraphics(this.doubleBuffer.getGraphics());
            this.drawAdditionalSelectedObjects(this.getGraphManager(), tSEGraphics);
        }
        return this.doubleBuffer;
    }

    public void createEntireGraphImage(Image image) {
        this.createEntireGraphImage(image, 1, false, false);
    }

    public void createEntireGraphImage(Image image, int n, boolean bl, boolean bl2) {
        this.createEntireGraphImage(image, n, bl, bl2, (int)this.getGraph().getWidth(), (int)this.getGraph().getHeight());
    }

    public void createEntireGraphImage(Image image, int n, boolean bl, boolean bl2, int n2, int n3) {
        if (image == null) {
            throw new IllegalArgumentException("null image");
        }
        TSEGraphics tSEGraphics = this.newGraphics(image.getGraphics());
        this.drawEntireGraph(tSEGraphics, n, bl, bl2, n2, n3);
    }

    public TSEGraphManager generateGraphManager() {
        this.graphManager = this.newGraphManager();
        this.graphManager.setMainDisplayGraph((TSEGraph)this.graphManager.addGraph());
        this.graphManager.setGraphWindow(this);
        return this.graphManager;
    }

    protected TSEGraphManager newGraphManager() {
        return new TSEGraphManager();
    }

    public void setDragSource(DragSource dragSource) {
        this.dragSource = dragSource;
    }

    public void initDropTarget() {
        this.setDropTarget(this.getDefaultDropTarget());
    }

    public void setDropTarget(DropTarget dropTarget) {
        if (this.dropTarget == null || TSSystem.isApplet()) {
            if (TSSystem.isApplet()) {
                Thread thread = new Thread(new g3(this));
                SwingUtilities.invokeLater(thread);
            } else {
                this.dropTarget = dropTarget;
            }
        }
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public DropTarget getDefaultDropTarget() {
        return new DropTarget(this.getCanvas(), this.getAcceptableDropActions(), ((TSEWindowInputTool)this.getDefaultTool()).getInternalDropTargetListener(), true);
    }

    public int getAcceptableDropActions() {
        return 0x40000003;
    }

    public int getAcceptableDragActions() {
        return 0;
    }

    public void setNestedGraphEditingEnabled(boolean bl) {
        this.getPreferences().setValue((Object)"inPlaceEditing", bl);
    }

    public boolean isNestedGraphEditingEnabled() {
        return this.getPreferences().getBooleanValue("inPlaceEditing");
    }

    public boolean isNestedGraphEditingEnabledByDefault() {
        return true;
    }

    public TSEPreferences newPreferences(TSEGraphWindow tSEGraphWindow) {
        return new TSEPreferences(tSEGraphWindow);
    }

    public TSEPreferences getPreferences() {
        return this.preferences;
    }

    public void onPreferenceChanged(TSProperty tSProperty) {
        String string = tSProperty.getName();
        Object object = tSProperty.getValue();
        if (string.equals("undoStackSize") && object instanceof Integer) {
            this.undoStack.setUndoLimit((Integer)object);
        } else if (string.equals("tooltipsEnabled") && object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.setEnabled(true);
                toolTipManager.registerComponent(this.getCanvas());
                toolTipManager.setInitialDelay(250);
            } else {
                ToolTipManager.sharedInstance().unregisterComponent(this.getCanvas());
            }
        } else if (string.equals("autoHideScrollbars")) {
            this.resetWorkBounds();
            this.updateScrollBarValues();
        } else if (string.equals("compressMetaEdges")) {
            this.getGraphManager().setCompressMetaEdges((Boolean)object);
        }
    }

    public TSEHitTesting getHitTesting() {
        return this.hitTesting;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

