/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.graphics.TSEGraphics;

public abstract class TSEGrid {
    static final double SPACING_X = 10.0;
    static final double SPACING_Y = 10.0;
    protected double xSpacing;
    protected double ySpacing;

    public TSEGrid() {
        this.setXSpacing(this.getDefaultXSpacing());
        this.setYSpacing(this.getDefaultYSpacing());
    }

    public TSConstPoint getNearestGridPoint(TSConstPoint tSConstPoint) {
        return new TSPoint(this.getNearestGridX(tSConstPoint.getX()), this.getNearestGridY(tSConstPoint.getY()));
    }

    public double getNearestGridX(double d) {
        return (double)Math.round(d / this.xSpacing) * this.xSpacing;
    }

    public double getNearestGridY(double d) {
        return (double)Math.round(d / this.ySpacing) * this.ySpacing;
    }

    public double getLeftNearestGridX(double d) {
        return Math.floor(d / this.xSpacing) * this.xSpacing;
    }

    public double getRightNearestGridX(double d) {
        return Math.ceil(d / this.xSpacing) * this.xSpacing;
    }

    public double getUpperNearestGridY(double d) {
        return Math.ceil(d / this.ySpacing) * this.ySpacing;
    }

    public double getLowerNearestGridY(double d) {
        return Math.floor(d / this.ySpacing) * this.ySpacing;
    }

    public void setXSpacing(double d) {
        if (d > 0.0) {
            this.xSpacing = d;
        }
    }

    public double getXSpacing() {
        return this.xSpacing;
    }

    public double getDefaultXSpacing() {
        return 10.0;
    }

    public void setYSpacing(double d) {
        if (d > 0.0) {
            this.ySpacing = d;
        }
    }

    public double getYSpacing() {
        return this.ySpacing;
    }

    public double getDefaultYSpacing() {
        return 10.0;
    }

    public abstract void draw(TSEGraphics var1, TSConstRect var2);
}

