/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.command.TSAddEdgeCommand;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEAddEdgeCommand
extends TSAddEdgeCommand {
    TSEEdgeUI ui;
    TSEEdgeLabel label = null;
    List pointList;
    boolean withLabel;
    TSEGraphManager graphManager;
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;

    public TSEAddEdgeCommand(TSEGraph tSEGraph, TSENode tSENode, TSENode tSENode2, TSEEdgeUI tSEEdgeUI, boolean bl) {
        this(tSEGraph, tSENode, tSENode2, null, tSEEdgeUI, bl);
    }

    public TSEAddEdgeCommand(int n, TSEGraph tSEGraph, TSENode tSENode, TSENode tSENode2, TSEEdgeUI tSEEdgeUI, boolean bl) {
        this(n, tSEGraph, tSENode, tSENode2, null, tSEEdgeUI, bl);
    }

    public TSEAddEdgeCommand(TSEGraph tSEGraph, TSENode tSENode, TSENode tSENode2, List list, TSEEdgeUI tSEEdgeUI, boolean bl) {
        super(tSEGraph, tSENode, tSENode2);
        f2.a(f2.bq);
        this.withLabel = bl;
        this.ui = tSEEdgeUI;
        this.pointList = new Vector(list);
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.graphManager = (TSEGraphManager)this.getGraph().getOwnerGraphManager();
    }

    public TSEAddEdgeCommand(int n, TSEGraph tSEGraph, TSENode tSENode, TSENode tSENode2, List list, TSEEdgeUI tSEEdgeUI, boolean bl) {
        super(n, tSEGraph, tSENode, tSENode2);
        this.withLabel = bl;
        this.ui = tSEEdgeUI;
        this.pointList = new Vector(list);
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.graphManager = (TSEGraphManager)this.getGraph().getOwnerGraphManager();
    }

    protected void doAction() throws Throwable {
        super.doAction();
        TSEGraph tSEGraph = (TSEGraph)this.getGraph();
        boolean bl = tSEGraph.isFiringEvents();
        tSEGraph.setFireEvents(false);
        TSEEdge tSEEdge = (TSEEdge)this.getEdge();
        TSConstRect tSConstRect = this.getGraph().getLocalBounds();
        tSEEdge.reroute(this.getPointList());
        tSEGraph.setFireEvents(bl);
        if (!tSConstRect.equals(this.getGraph().getLocalBounds())) {
            this.getGraph().fireEvent(new TSDrawingChangeEvent(0x800000L, new TSDrawingChangeEventData(this.getGraph(), tSConstRect, this.getGraph().getLocalBounds())));
        }
        if (this.withLabel()) {
            this.label = (TSEEdgeLabel)tSEEdge.addLabel();
            this.label.setDistanceFromSource(0.5);
            this.label.setUI((TSEObjectUI)this.graphManager.getGraphWindow().getCurrentLabelUI().clone());
            this.label.setSelected(true);
        }
        tSEEdge.setUI((TSEObjectUI)this.getUI().clone());
        tSEEdge.setSelected(true);
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
    }

    protected void undoAction() throws Throwable {
        if (this.updateMetaEdges) {
            TSEEdge tSEEdge;
            Iterator iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                this.graphManager.remove(tSEEdge);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                tSEEdge.getOwnerGraph().insert(tSEEdge);
            }
        }
        super.undoAction();
    }

    public void redoAction() throws Throwable {
        super.redoAction();
        ((TSEEdge)this.getEdge()).setSelected(true);
        if (this.withLabel()) {
            this.getLabel().setSelected(true);
        }
        if (this.updateMetaEdges) {
            TSEEdge tSEEdge;
            Iterator iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                tSEEdge.getOwnerGraph().insert(tSEEdge);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                this.graphManager.remove(tSEEdge);
            }
        }
    }

    public List getAffectedObjects() {
        List list = super.getAffectedObjects();
        if (this.label != null) {
            list.add(this.getLabel());
        }
        return list;
    }

    public TSEEdgeUI getUI() {
        return this.ui;
    }

    public List getPointList() {
        return this.pointList;
    }

    public boolean withLabel() {
        return this.withLabel;
    }

    public TSEEdgeLabel getLabel() {
        return this.label;
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }

    public boolean isOrderPreservedInCoalescing() {
        return true;
    }

    public boolean isCoalesced() {
        return true;
    }
}

