/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.command.TSAddNodeCommand;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.util.f2;
import java.util.List;

public class TSEAddNodeCommand
extends TSAddNodeCommand {
    TSENodeUI ui;
    TSENodeLabel label = null;
    boolean withLabel;
    TSConstPoint oldCenter = null;

    public TSEAddNodeCommand(TSEGraph tSEGraph, double d, double d2, TSENodeUI tSENodeUI, boolean bl) {
        super(tSEGraph, d, d2);
        f2.a(f2.bq);
        this.withLabel = bl;
        this.ui = tSENodeUI;
        if (this.ui == null) {
            this.ui = ((TSEGraph)this.getGraph()).getGraphWindow().getCurrentNodeUI();
        }
    }

    public TSEAddNodeCommand(int n, TSEGraph tSEGraph, double d, double d2, TSENodeUI tSENodeUI, boolean bl) {
        super(n, tSEGraph, d, d2);
        f2.a(f2.bq);
        this.withLabel = bl;
        this.ui = tSENodeUI;
        if (this.ui == null) {
            this.ui = ((TSEGraph)this.getGraph()).getGraphWindow().getCurrentNodeUI();
        }
    }

    protected void doAction() throws Throwable {
        TSENode tSENode;
        if (this.getGraph().getBounds().isEmpty() && this.getGraph().getParent() != null && this.getGraph().getParent() instanceof TSENode && (tSENode = (TSENode)this.getGraph().getParent()).isExpanded()) {
            this.oldCenter = tSENode.getCenter();
        }
        super.doAction();
        tSENode = (TSENode)this.getNode();
        if (this.withLabel()) {
            this.label = (TSENodeLabel)tSENode.addLabel();
            this.label.setDefaultOffset();
        }
        tSENode.setUI((TSEObjectUI)this.ui.clone());
        tSENode.setSelected(true);
    }

    protected void undoAction() throws Throwable {
        super.undoAction();
        if (this.oldCenter != null && this.getGraph().getParent() instanceof TSENode) {
            ((TSENode)this.getGraph().getParent()).setCenter(this.oldCenter);
        }
    }

    protected void redoAction() throws Throwable {
        super.redoAction();
        ((TSENode)this.getNode()).setSelected(true);
    }

    public List getAffectedObjects() {
        List list = super.getAffectedObjects();
        if (this.label != null) {
            list.add(this.label);
        }
        if (this.getGraph().getParent() instanceof TSENode && this.getGraph().getParent().isExpanded()) {
            list.add(this.getGraph().getParent());
        }
        return list;
    }

    public TSENodeUI getUI() {
        return this.ui;
    }

    public boolean withLabel() {
        return this.withLabel;
    }

    public TSENodeLabel getLabel() {
        return this.label;
    }
}

