/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.util.command.TSCommand;

public class TSEViewRootGraphCommand
extends TSCommand {
    TSEGraph childGraph;
    TSEGraph rootGraph;
    TSEGraphWindow window;
    TSRect oldOriginalVisibleBounds;

    public TSEViewRootGraphCommand(TSEGraphWindow tSEGraphWindow, TSEGraph tSEGraph) {
        if (tSEGraphWindow == null || tSEGraph == null || tSEGraph.getOwner() != tSEGraphWindow.getGraphManager()) {
            throw new IllegalArgumentException();
        }
        this.childGraph = tSEGraph;
        this.rootGraph = (TSEGraph)tSEGraph.getGreatestAncestor();
        this.window = tSEGraphWindow;
        this.oldOriginalVisibleBounds = null;
    }

    protected void doAction() throws Throwable {
        if (this.window.getGraph().getOriginalVisibleBounds() != null) {
            this.oldOriginalVisibleBounds = new TSRect(this.window.getGraph().getOriginalVisibleBounds());
        }
        this.window.getGraph().setOriginalVisibleBounds(this.window.getTransform().getWorldBounds());
        this.window.setGraph(this.rootGraph, false);
        if (this.rootGraph.getOriginalVisibleBounds() != null) {
            this.window.fitRectInWindow(this.rootGraph.getOriginalVisibleBounds(), false);
        } else {
            this.window.fitInWindow(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.window.setGraph(this.childGraph, false);
        if (this.childGraph.getOriginalVisibleBounds() != null) {
            this.window.fitRectInWindow(this.childGraph.getOriginalVisibleBounds(), false);
        }
        this.window.getGraph().setOriginalVisibleBounds(this.oldOriginalVisibleBounds);
    }

    public TSEGraph getChildGraph() {
        return this.childGraph;
    }

    public TSEGraph getRootGraph() {
        return this.rootGraph;
    }

    public TSEGraphWindow getGraphWindow() {
        return this.window;
    }
}

