/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity.command;

import com.tomsawyer.complexity.TSComplexityManager;
import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.command.TSExpandCommand;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.diagramming.command.cs;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.complexity.TSENestingManager;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f2;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEExpandCommand
extends TSExpandCommand {
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;
    List hiddenRemovedMetaEdges = new Vector();
    List hiddenRemovedMetaEdgeEndNodes = new Vector();
    cs adjustmentCommand;
    boolean geometricAdjustment = false;

    public TSEExpandCommand(TSEGraph tSEGraph, boolean bl) {
        this(tSEGraph, bl, false);
    }

    public TSEExpandCommand(TSEGraph tSEGraph, boolean bl, boolean bl2) {
        this.graphManager = (TSEGraphManager)tSEGraph.getOwnerGraphManager();
        df df2 = new df();
        List list = this.getNodeList();
        TSENestingManager.getManager(this.getGraphManager());
        if (!bl) {
            tSEGraph.buildChildGraphList(df2);
        } else {
            tSEGraph.buildAllChildGraphList(df2);
        }
        Iterator iterator = df2.iterator();
        while (iterator.hasNext()) {
            TSEGraph tSEGraph2 = (TSEGraph)iterator.next();
            if (!(tSEGraph2.getParent() instanceof TSENode)) continue;
            TSENode tSENode = (TSENode)tSEGraph2.getParent();
            if ((bl2 || !tSENode.isSelected()) && !bl2 || tSENode.isExpanded()) continue;
            list.add(tSENode);
        }
        if (list.size() == 0) {
            this.setAddToUndoStack(false);
        }
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.compressMetaEdges = this.getGraphManager().getCompressMetaEdges();
    }

    public TSEExpandCommand(List list) {
        super(list);
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        if (list.size() != 0) {
            TSENestingManager.getManager(this.getGraphManager());
        }
    }

    public TSEExpandCommand(TSDNode tSDNode) {
        super(tSDNode);
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        TSENestingManager.getManager(this.getGraphManager());
    }

    protected void init() {
        super.init();
        this.geometricAdjustment = ((TSENestingManager)TSENestingManager.getManager(this.graphManager)).isUsingGeometricAdjustment();
        if (this.geometricAdjustment) {
            this.adjustmentCommand = new cs(this.graphManager, this.getNodeList(), 0);
        }
    }

    protected void doAction() throws Throwable {
        f2.a(f2.be);
        this.storeOldMargins();
        if (!this.getNodeList().isEmpty()) {
            Object object;
            TSEGraphManager tSEGraphManager = (TSEGraphManager)this.getGraphManager();
            tSEGraphManager.getGraphWindow().deselectAll(false);
            Vector vector = new Vector();
            vector.addAll(this.getNodeList());
            Collections.reverse(vector);
            Iterator iterator = vector.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                object = (TSENode)iterator.next();
                if (!((TSGraphMember)object).hasChildGraph() || ((TSDNode)object).isExpanded()) continue;
                if (tSEGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(1L, new TSComplexityChangeEventData(object, null, null)), true)) {
                    this.storeOldClippings((TSDNode)object);
                    TSENestingManager.expand((TSDNode)object);
                    ((TSDNode)object).adjustIncidentClippings();
                    ((TSENode)object).setSelected(true);
                    bl = true;
                    continue;
                }
                iterator.remove();
            }
            if (bl && this.updateMetaEdges) {
                Cloneable cloneable;
                Object object2;
                this.insertedMetaEdges = new Vector();
                this.removedMetaEdges = new Vector();
                tSEGraphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
                object = (TSEHidingManager)TSEHidingManager.getManager(tSEGraphManager);
                Iterator iterator2 = this.removedMetaEdges.iterator();
                while (iterator2.hasNext()) {
                    object2 = (TSEEdge)iterator2.next();
                    if (!((TSEdge)object2).getOwnerGraph().isHideGraph()) continue;
                    this.hiddenRemovedMetaEdges.add(object2);
                    cloneable = new Vector<Object>();
                    cloneable.add(object2);
                    ((TSHidingManager)object).unhide((TSEGraph)((TSEdge)object2).getSourceNode().getOwnerGraph(), null, (List)((Object)cloneable), false);
                    if (!this.hiddenRemovedMetaEdgeEndNodes.contains(((TSEdge)object2).getSourceNode())) {
                        this.hiddenRemovedMetaEdgeEndNodes.add(((TSEdge)object2).getSourceNode());
                    }
                    if (this.hiddenRemovedMetaEdgeEndNodes.contains(((TSEdge)object2).getTargetNode())) continue;
                    this.hiddenRemovedMetaEdgeEndNodes.add(((TSEdge)object2).getTargetNode());
                }
                tSEGraphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
                if (!this.hiddenRemovedMetaEdgeEndNodes.isEmpty()) {
                    object2 = this.hiddenRemovedMetaEdgeEndNodes.iterator();
                    while (object2.hasNext()) {
                        cloneable = (TSENode)object2.next();
                        ((TSENode)cloneable).getNodeUI().updateHideMark();
                    }
                }
                ((TSComplexityManager)object).clearResultLists();
            }
            this.setAddToUndoStack(bl);
            if (this.geometricAdjustment) {
                if (this.getState() == TSCommand.CREATED) {
                    this.adjustmentCommand.execute();
                } else if (this.getState() == TSCommand.UNDONE) {
                    this.adjustmentCommand.redo();
                }
            }
        }
    }

    protected void undoAction() throws Throwable {
        if (!this.getNodeList().isEmpty()) {
            Object object;
            Object object2;
            Iterator iterator;
            if (this.geometricAdjustment) {
                this.adjustmentCommand.undo();
            }
            if (this.updateMetaEdges) {
                iterator = this.insertedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    object2 = (TSEEdge)iterator.next();
                    this.graphManager.remove((TSEdge)object2);
                }
                iterator = this.removedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    object2 = (TSEEdge)iterator.next();
                    ((TSEdge)object2).getOwnerGraph().insert((TSEdge)object2);
                }
                if (!this.hiddenRemovedMetaEdges.isEmpty()) {
                    Cloneable cloneable;
                    iterator = this.hiddenRemovedMetaEdges.iterator();
                    object2 = (TSEHidingManager)TSEHidingManager.getManager(this.graphManager);
                    while (iterator.hasNext()) {
                        object = (TSEEdge)iterator.next();
                        cloneable = new Vector<Object>();
                        cloneable.add(object);
                        ((TSHidingManager)object2).hide((TSEGraph)((TSEdge)object).getOwnerGraph(), null, (List)((Object)cloneable));
                    }
                    object = this.hiddenRemovedMetaEdgeEndNodes.iterator();
                    while (object.hasNext()) {
                        cloneable = (TSENode)object.next();
                        ((TSENode)cloneable).getNodeUI().updateHideMark();
                    }
                }
            }
            iterator = (TSEGraphManager)this.getGraphManager();
            ((TSEGraphManager)((Object)iterator)).getGraphWindow().deselectAll(false);
            object2 = this.getNodeList().iterator();
            while (object2.hasNext()) {
                object = (TSENode)object2.next();
                if (!((TSGraphMember)object).hasChildGraph() || !((TSDNode)object).isExpanded()) continue;
                TSENestingManager.collapse((TSDNode)object);
                ((TSENode)object).setSelected(true);
            }
            this.restoreOldClippings();
            this.restoreMargins();
        }
    }

    protected void redoAction() throws Throwable {
        if (!this.getNodeList().isEmpty()) {
            boolean bl = this.updateMetaEdges;
            this.updateMetaEdges = false;
            super.redoAction();
            this.updateMetaEdges = bl;
            if (this.updateMetaEdges) {
                TSGraphMember tSGraphMember;
                Iterator iterator;
                Iterator iterator2 = this.insertedMetaEdges.iterator();
                while (iterator2.hasNext()) {
                    iterator = (TSEEdge)iterator2.next();
                    ((TSEdge)((Object)iterator)).getOwnerGraph().insert((TSEdge)((Object)iterator));
                }
                if (!this.hiddenRemovedMetaEdges.isEmpty()) {
                    iterator2 = this.hiddenRemovedMetaEdges.iterator();
                    iterator = (TSEHidingManager)TSEHidingManager.getManager(this.graphManager);
                    while (iterator2.hasNext()) {
                        tSGraphMember = (TSEEdge)iterator2.next();
                        Vector<TSEEdge> vector = new Vector<TSEEdge>();
                        vector.add((TSEEdge)tSGraphMember);
                        ((TSHidingManager)((Object)iterator)).unhide((TSEGraph)((TSEdge)tSGraphMember).getSourceNode().getOwnerGraph(), null, vector, false);
                    }
                    ((TSComplexityManager)((Object)iterator)).clearResultLists();
                }
                iterator2 = this.removedMetaEdges.iterator();
                while (iterator2.hasNext()) {
                    iterator = (TSEEdge)iterator2.next();
                    this.getGraphManager().remove((TSEdge)((Object)iterator));
                }
                if (!this.hiddenRemovedMetaEdgeEndNodes.isEmpty()) {
                    iterator = this.hiddenRemovedMetaEdgeEndNodes.iterator();
                    while (iterator.hasNext()) {
                        tSGraphMember = (TSENode)iterator.next();
                        ((TSENode)tSGraphMember).getNodeUI().updateHideMark();
                    }
                }
            }
        }
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }
}

