/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity.command;

import com.tomsawyer.complexity.TSComplexityManager;
import com.tomsawyer.complexity.TSFoldingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.command.TSFoldCommand;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.diagramming.command.cs;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.complexity.TSEFoldingManager;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSGroupCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TSEFoldCommand
extends TSFoldCommand {
    TSEGraph graph;
    boolean isDeep;
    List nodeList;
    TSGroupCommand groupFoldCommand;
    TSENode folder;
    boolean compressMetaEdges;
    TSENodeUI folderUI;
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;
    TSEGraphManager graphManager;
    TSEGraph foldGraph;
    cs adjustmentCommand;
    boolean geometricAdjustment = false;

    public TSEFoldCommand(TSEGraph tSEGraph, boolean bl) {
        this(tSEGraph, null, bl);
    }

    public TSEFoldCommand(TSEGraph tSEGraph, TSENodeUI tSENodeUI, boolean bl) {
        this.graph = tSEGraph;
        this.isDeep = bl;
        this.folder = null;
        this.folderUI = tSENodeUI;
        this.nodeList = new Vector();
        this.compressMetaEdges = ((TSEGraphManager)this.graph.getOwner()).getCompressMetaEdges();
        if (this.graph.hasSelectedNodes()) {
            this.nodeList.addAll(this.graph.selectedNodes());
        }
        if (this.isDeep) {
            this.groupFoldCommand = new TSGroupCommand();
            Vector vector = new Vector();
            TSNestingManager.buildAllNestedGraphList(tSEGraph, vector, false);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TSEGraph tSEGraph2 = (TSEGraph)iterator.next();
                TSEFoldCommand tSEFoldCommand = new TSEFoldCommand(tSEGraph2, tSENodeUI, false);
                tSEFoldCommand.setUpdateMetaEdges(false);
                this.groupFoldCommand.add(tSEFoldCommand);
            }
        }
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.graphManager = (TSEGraphManager)tSEGraph.getOwnerGraphManager();
    }

    public TSEFoldCommand(List list) {
        TSSystem.tsAssert(list != null && list.size() > 0);
        this.graph = (TSEGraph)((TSENode)list.get(0)).getOwner();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((TSENode)iterator.next()).getOwnerGraph() == this.graph) continue;
            throw new IllegalArgumentException();
        }
        this.nodeList = new LinkedList();
        this.nodeList.addAll(list);
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.graphManager = (TSEGraphManager)this.graph.getOwnerGraphManager();
        this.compressMetaEdges = this.graphManager.getCompressMetaEdges();
    }

    protected void init() {
        super.init();
        this.geometricAdjustment = ((TSEFoldingManager)TSEFoldingManager.getManager(this.graphManager)).isUsingGeometricAdjustment();
        if (this.geometricAdjustment) {
            this.adjustmentCommand = new cs(this.graphManager, this.nodeList, 2);
        }
    }

    protected void doAction() throws Throwable {
        if (!this.nodeList.isEmpty()) {
            Object object;
            Iterator iterator = this.nodeList.iterator();
            while (iterator.hasNext()) {
                object = (TSENode)iterator.next();
                if (this.graphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(4L, new TSComplexityChangeEventData(object, null, null)), true)) continue;
                iterator.remove();
            }
            if (!this.nodeList.isEmpty()) {
                object = (TSEFoldingManager)TSEFoldingManager.getManager(this.graphManager);
                if (this.folder == null) {
                    this.folder = (TSENode)this.graph.addNode();
                    this.folder.setSize(this.folder.getDefaultWidth(), this.folder.getDefaultHeight());
                    this.folder.setTag("Folder");
                    this.folder.setUI(((TSEFoldingManager)object).getFolderUI());
                }
                if (this.foldGraph == null) {
                    this.foldGraph = (TSEGraph)this.graphManager.addGraph();
                }
                boolean bl = ((TSFoldingManager)object).fold(this.folder, this.foldGraph, this.nodeList, true);
                this.setAddToUndoStack(bl);
                ((TSComplexityManager)object).clearResultLists();
            } else {
                this.setAddToUndoStack(false);
            }
            if (this.folder != null) {
                this.folder.setSelected(true);
                if (this.folderUI != null) {
                    this.folder.setUI(this.folderUI);
                }
            }
        }
        if (this.isDeep) {
            this.groupFoldCommand.execute();
        }
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
        if (this.geometricAdjustment) {
            this.adjustmentCommand.execute();
        }
    }

    protected void redoAction() throws Throwable {
        Iterator iterator;
        if (this.folder != null) {
            this.graph.insert(this.folder);
            iterator = (TSEFoldingManager)TSEFoldingManager.getManager((TSEGraphManager)this.graph.getOwner());
            ((TSFoldingManager)((Object)iterator)).fold(this.folder, this.foldGraph, this.nodeList, true);
            this.folder.setSelected(true);
            if (this.folderUI != null) {
                this.folder.setUI(this.folderUI);
            }
            ((TSComplexityManager)((Object)iterator)).clearResultLists();
        }
        if (this.isDeep) {
            this.groupFoldCommand.redo();
        }
        if (this.updateMetaEdges) {
            TSEEdge tSEEdge;
            if (this.insertedMetaEdges != null) {
                iterator = this.insertedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    tSEEdge = (TSEEdge)iterator.next();
                    tSEEdge.getOwnerGraph().insert(tSEEdge);
                }
            }
            if (this.removedMetaEdges != null) {
                iterator = this.removedMetaEdges.iterator();
                while (iterator.hasNext()) {
                    tSEEdge = (TSEEdge)iterator.next();
                    this.graphManager.remove(tSEEdge);
                }
            }
        }
        if (this.geometricAdjustment) {
            this.adjustmentCommand.redo();
        }
    }

    protected void undoAction() throws Throwable {
        Object object;
        Object object2;
        if (this.geometricAdjustment) {
            this.adjustmentCommand.undo();
        }
        if (this.updateMetaEdges) {
            if (this.insertedMetaEdges != null) {
                object2 = this.insertedMetaEdges.iterator();
                while (object2.hasNext()) {
                    object = (TSEEdge)object2.next();
                    this.graphManager.remove((TSEdge)object);
                }
            }
            if (this.removedMetaEdges != null) {
                object2 = this.removedMetaEdges.iterator();
                while (object2.hasNext()) {
                    object = (TSEEdge)object2.next();
                    ((TSEdge)object).getOwnerGraph().insert((TSEdge)object);
                }
            }
        }
        if (this.isDeep) {
            this.groupFoldCommand.undo();
        }
        if (this.folder != null) {
            Object object3;
            object2 = (TSEFoldingManager)TSEFoldingManager.getManager((TSEGraphManager)this.graph.getOwner());
            ((TSFoldingManager)object2).unfold(this.folder, true);
            this.graph.remove(this.folder);
            this.graphManager.remove(this.foldGraph);
            object = ((TSComplexityManager)object2).getResultEdgeList().iterator();
            while (object.hasNext()) {
                object3 = (TSEEdge)object.next();
                ((TSEEdge)object3).setSelected(true);
                ((TSEEdge)object3).setLabelsSelected(true);
            }
            object3 = this.nodeList.iterator();
            while (object3.hasNext()) {
                TSENode tSENode = (TSENode)object3.next();
                tSENode.setSelected(true);
                tSENode.setLabelsSelected(true);
                tSENode.setConnectorLabelsSelected(true);
            }
            ((TSComplexityManager)object2).clearResultLists();
        }
    }

    public boolean isCoalesced() {
        return true;
    }

    public boolean isOrderPreservedInCoalescing() {
        return true;
    }

    public TSDNode getFolderNode() {
        return this.folder;
    }

    public void setFolderNode(TSENode tSENode) {
        this.folder = tSENode;
    }

    public TSDGraph getFoldGraph() {
        return this.foldGraph;
    }

    public void setFoldGraph(TSEGraph tSEGraph) {
        this.foldGraph = tSEGraph;
    }

    public boolean isAddToUndoStack() {
        boolean bl = super.isAddToUndoStack();
        if (this.isDeep) {
            Iterator iterator = this.groupFoldCommand.getCommandList().iterator();
            while (iterator.hasNext()) {
                TSCommand tSCommand = (TSCommand)iterator.next();
                bl = bl || tSCommand.isAddToUndoStack();
            }
        }
        return bl;
    }

    protected void undoCleanup() {
        if (this.folder != null && !this.folder.isOwned()) {
            this.folder.dispose();
        }
        if (this.foldGraph != null && !this.folder.isOwned()) {
            this.foldGraph.dispose();
        }
        if (this.groupFoldCommand != null) {
            this.groupFoldCommand.undoCleanup();
        }
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }
}

