/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.dialog;

import com.tomsawyer.editor.dialog.TSFileFilter;
import com.tomsawyer.util.TSSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class TSFileChooser
extends JFileChooser {
    private int returnValue = -1;

    public TSFileChooser() {
    }

    public TSFileChooser(File file) {
        super(file);
    }

    public TSFileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
    }

    public TSFileChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
    }

    public TSFileChooser(String string) {
        super(string);
    }

    public TSFileChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
    }

    public void setSelectedFileAndFilter(File file) {
        FileFilter fileFilter;
        if (file != null && (fileFilter = this.getFilterForFile(file)) != null) {
            this.setFileFilter(fileFilter);
        }
        this.setSelectedFile(file.getAbsoluteFile());
    }

    FileFilter getFilterForFile(File file) {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        FileFilter fileFilter = null;
        FileFilter fileFilter2 = this.getAcceptAllFileFilter();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter3 = fileFilterArray[i];
            if (fileFilter3.equals(fileFilter2) || !fileFilter3.accept(file)) continue;
            fileFilter = fileFilter3;
            break;
        }
        return fileFilter;
    }

    public void setSelectedFiles(File[] fileArray) {
        if (!TSSystem.isJVM14() || fileArray != null) {
            super.setSelectedFiles(fileArray);
        }
    }

    public void setSelectedFile(File file) {
        if (TSSystem.isJVM14()) {
            super.setSelectedFile(file);
            return;
        }
        if (file != null && !file.isDirectory()) {
            super.setSelectedFile(file);
            return;
        }
        if (file == null && this.getFileFilter() instanceof TSFileFilter) {
            String string = null;
            File file2 = this.getSelectedFile();
            if (file2 != null) {
                String string2 = file2.getName();
                int n = string2.lastIndexOf(46);
                if (n != -1) {
                    String string3 = string2.substring(0, n);
                    String string4 = ((TSFileFilter)this.getFileFilter()).getExtension();
                    string = string3 + "." + string4;
                } else {
                    string = string2;
                }
            }
            if (string != null) {
                super.setSelectedFile(new File(string));
            } else {
                super.setSelectedFile(file);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (TSSystem.isJVM14orAbove()) {
            return super.getPreferredSize();
        }
        return this.getLayout().preferredLayoutSize(this);
    }

    public void approveSelection() {
        super.approveSelection();
        this.returnValue = 0;
    }

    public void cancelSelection() {
        super.cancelSelection();
        this.returnValue = 1;
    }

    public int showDialog(Component component, String string) {
        super.showDialog(component, string);
        int n = this.returnValue;
        this.returnValue = -1;
        return n;
    }
}

