/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.dialog;

import com.tomsawyer.editor.dialog.gx;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class TSUnsignedDoubleField
extends JTextField
implements FocusListener,
KeyListener {
    String defaultString = "";
    double minimum;
    double maximum;
    DecimalFormat format;

    public TSUnsignedDoubleField(int n) {
        this(null, n);
    }

    public TSUnsignedDoubleField(String string, int n) {
        super(n);
        ((JTextComponent)this).setDocument(new gx(this, Double.POSITIVE_INFINITY));
        this.setText(string);
        this.minimum = 0.0;
        this.maximum = Double.POSITIVE_INFINITY;
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public TSUnsignedDoubleField(int n, double d, double d2) {
        this(null, n, d, d2);
    }

    public TSUnsignedDoubleField(String string, int n, double d, double d2) {
        this(string, n, d, d2, Integer.MAX_VALUE);
    }

    public TSUnsignedDoubleField(String string, int n, double d, double d2, int n2) {
        super(n);
        ((JTextComponent)this).setDocument(new gx(this, d2));
        this.setText(string);
        this.minimum = d >= 0.0 ? d : 0.0;
        this.maximum = d2;
        this.setMaxAfterDecimal(n2);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
        ((gx)this.getDocument()).a = d;
        this.ensureValidValue();
    }

    public void setMaximum(double d, boolean bl) {
        this.maximum = d;
        ((gx)this.getDocument()).a = d;
        if (bl) {
            this.ensureValidValue();
        }
    }

    public void setMaxAfterDecimal(int n) {
        ((gx)this.getDocument()).c = n;
        this.ensureValidValue();
    }

    public void setMinimum(double d) {
        this.minimum = d;
        this.ensureValidValue();
    }

    public void setMinimum(double d, boolean bl) {
        this.minimum = d;
        if (bl) {
            this.ensureValidValue();
        }
    }

    public String getOldValue() {
        return this.defaultString;
    }

    public void setOldValue(String string) {
        this.defaultString = string;
    }

    public void setText(String string) {
        this.setText(string, null);
    }

    public void setText(String string, DecimalFormat decimalFormat) {
        this.format = decimalFormat;
        if (this.isValueValid(string)) {
            super.setText(string);
            this.setOldValue(string);
        } else {
            String string2 = String.valueOf(this.findClosestValue(string));
            super.setText(string2);
            this.setOldValue(string2);
        }
    }

    double findClosestValue(String string) {
        double d = 0.0;
        double d2 = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            d = this.minimum;
            d2 = this.minimum;
        }
        d2 = d < this.minimum ? this.minimum : (d > this.maximum ? this.maximum : d);
        return d2;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.ensureValidValue();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.ensureValidValue();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    boolean isValueValid(String string) {
        double d = 0.0;
        boolean bl = true;
        if (string == null || string.equals("")) {
            return true;
        }
        try {
            d = this.format == null ? Double.parseDouble(string) : this.format.parse(string).doubleValue();
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl && (d < this.getMinimum() || d > this.getMaximum())) {
            bl = false;
        }
        return bl;
    }

    public void ensureValidValue() {
        String string = super.getText();
        String string2 = this.getOldValue();
        boolean bl = this.isValueValid(string);
        if (bl) {
            this.setOldValue(string);
        } else {
            this.setText(string2, this.format);
        }
    }

    public String getText() {
        this.ensureValidValue();
        return super.getText();
    }
}

