/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.export.TSEMultiPageExportSetup;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSEGraphUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Enumeration;

public class TSEExportData {
    TSEGraphWindow graphWindow;
    TSEMultiPageExportSetup exportSetup;
    int nCol;
    int nRow;
    double imageableWidth;
    double imageableHeight;
    TSTransform transform;
    double scale;
    double scaledImageableWidth;
    double scaledImageableHeight;

    public TSEExportData(TSEMultiPageExportSetup tSEMultiPageExportSetup) {
        this.graphWindow = tSEMultiPageExportSetup.getGraphWindow();
        this.exportSetup = tSEMultiPageExportSetup;
        this.nCol = tSEMultiPageExportSetup.getPageColumns();
        this.nRow = tSEMultiPageExportSetup.getPageRows();
        this.imageableWidth = tSEMultiPageExportSetup.getImageableWidth();
        this.imageableHeight = tSEMultiPageExportSetup.getImageableHeight();
        this.setScale(1.0);
    }

    public boolean renderGraphics(Graphics graphics, int n) {
        if (n > this.nCol * this.nRow - 1) {
            return false;
        }
        if (this.transform == null) {
            this.transform = new TSTransform(0, 0, (int)((double)this.nCol * this.scaledImageableWidth), (int)((double)this.nRow * this.scaledImageableHeight));
        }
        int n2 = n % this.nCol;
        int n3 = n / this.nCol;
        graphics.translate((int)(this.exportSetup.getImageableX() * this.scale), (int)(this.exportSetup.getImageableY() * this.scale));
        this.drawPreGraph(graphics, n2, n3);
        if (this.exportSetup.isBorderExported()) {
            this.drawBorders(graphics, n2, n3);
        }
        if (this.exportSetup.isCropMarkExported()) {
            this.drawCropMark(graphics, n2, n3);
        }
        if (this.exportSetup.isCaptionExported()) {
            if (this.exportSetup.getCaptionPosition() == 7 && n2 == 0 && n3 == 0) {
                this.drawCaption(graphics);
            } else if (this.exportSetup.getCaptionPosition() == 8 && n2 == this.nCol - 1 && n3 == 0) {
                this.drawCaption(graphics);
            } else if (this.exportSetup.getCaptionPosition() == 9 && n2 == 0 && n3 == this.nRow - 1) {
                this.drawCaption(graphics);
            } else if (this.exportSetup.getCaptionPosition() == 10 && n2 == this.nCol - 1 && n3 == this.nRow - 1) {
                this.drawCaption(graphics);
            }
        }
        if (this.exportSetup.getExportRange() == 1) {
            this.renderEntireGraph(graphics, n2, n3);
        } else if (this.exportSetup.getExportRange() == 2) {
            this.renderCurrentWindow(graphics, n2, n3);
        } else if (this.exportSetup.getExportRange() == 3) {
            this.renderCurrentSelection(graphics, n2, n3);
        }
        if (this.exportSetup.isPageNumberExported()) {
            this.drawPageNumber(graphics, n2, n3);
        }
        this.drawPostGraph(graphics, n2, n3);
        graphics.translate(-((int)(this.exportSetup.getImageableX() * this.scale)), -((int)(this.exportSetup.getImageableY() * this.scale)));
        graphics.setClip(null);
        return true;
    }

    public void renderEntireGraph(Graphics graphics, int n, int n2) {
        Font font = graphics.getFont();
        int n3 = (int)((double)n * this.scaledImageableWidth);
        int n4 = (int)((double)n2 * this.scaledImageableHeight);
        int n5 = (int)((double)this.nCol * this.scaledImageableWidth);
        int n6 = (int)((double)this.nRow * this.scaledImageableHeight);
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        this.transform.setDeviceBounds(-n3, -n4, n5, n6);
        if (this.exportSetup.getExportScale() == 4) {
            this.transform.fitToDevice(this.graphWindow.getGraph().getFrameBounds());
        } else if (this.exportSetup.getExportScale() == 5) {
            this.transform.setScaleX(this.scale);
            this.transform.setScaleY(-this.scale);
            this.transform.centerWorldInDevice(this.graphWindow.getGraph().getFrameBounds());
        } else if (this.exportSetup.getExportScale() == 6) {
            this.transform.setScaleX(this.scale * this.graphWindow.getZoomLevel());
            this.transform.setScaleY(this.scale * -this.graphWindow.getZoomLevel());
            this.transform.centerWorldInDevice(this.graphWindow.getGraph().getFrameBounds());
        }
        TSEGraphics tSEGraphics = this.graphWindow.newGraphics(graphics, this.transform);
        Shape shape = graphics.getClip();
        if (this.exportSetup.isBackgroundExported()) {
            graphics.setClip(Math.max(1, (int)(2.0 * this.scale)), Math.max(1, (int)(2.0 * this.scale)), (int)((this.imageableWidth - 4.0) * this.scale), (int)((this.imageableHeight - 4.0) * this.scale));
            this.drawBackground(tSEGraphics, this.transform.getWorldBounds());
        }
        if (this.graphWindow.hasGrid() && this.exportSetup.isGridExported()) {
            graphics.setClip(Math.max(1, (int)(2.0 * this.scale)), Math.max(1, (int)(2.0 * this.scale)), (int)((this.imageableWidth - 4.0) * this.scale), (int)((this.imageableHeight - 4.0) * this.scale));
            this.drawGrid(tSEGraphics, this.transform.getWorldBounds());
        }
        graphics.setClip(0, 0, (int)this.scaledImageableWidth, (int)this.scaledImageableHeight);
        this.getGraphUI().draw(tSEGraphics, false);
        graphics.setClip(shape);
        graphics.setFont(font);
    }

    public void renderCurrentWindow(Graphics graphics, int n, int n2) {
        Font font = graphics.getFont();
        int n3 = (int)((double)n * this.scaledImageableWidth);
        int n4 = (int)((double)n2 * this.scaledImageableHeight);
        int n5 = (int)((double)this.nCol * this.scaledImageableWidth);
        int n6 = (int)((double)this.nRow * this.scaledImageableHeight);
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        this.transform.setDeviceBounds(-n3, -n4, n5, n6);
        if (this.exportSetup.getExportScale() == 4) {
            this.transform.fitToDevice(this.graphWindow.getTransform().getWorldBounds());
        } else if (this.exportSetup.getExportScale() == 5) {
            this.transform.setScaleX(this.scale);
            this.transform.setScaleY(-this.scale);
            this.transform.centerWorldInDevice(this.graphWindow.getTransform().getWorldBounds());
        } else if (this.exportSetup.getExportScale() == 6) {
            this.transform.setScaleX(this.graphWindow.getZoomLevel() * this.scale);
            this.transform.setScaleY(-this.graphWindow.getZoomLevel() * this.scale);
            this.transform.centerWorldInDevice(this.graphWindow.getTransform().getWorldBounds());
        }
        TSEGraphics tSEGraphics = this.graphWindow.newGraphics(graphics, this.transform);
        Shape shape = graphics.getClip();
        if (this.exportSetup.isBackgroundExported()) {
            graphics.setClip(Math.max(1, (int)(2.0 * this.scale)), Math.max(1, (int)(2.0 * this.scale)), (int)((this.imageableWidth - 4.0) * this.scale), (int)((this.imageableHeight - 4.0) * this.scale));
            this.drawBackground(tSEGraphics, this.transform.getWorldBounds());
        }
        if (this.graphWindow.hasGrid() && this.exportSetup.isGridExported()) {
            graphics.setClip(Math.max(1, (int)(2.0 * this.scale)), Math.max(1, (int)(2.0 * this.scale)), (int)((this.imageableWidth - 4.0) * this.scale), (int)((this.imageableHeight - 4.0) * this.scale));
            this.drawGrid(tSEGraphics, this.transform.getWorldBounds());
        }
        graphics.setClip(0, 0, (int)this.scaledImageableWidth, (int)this.scaledImageableHeight);
        this.getGraphUI().draw(tSEGraphics, false, this.graphWindow.getTransform().getWorldBounds());
        graphics.setClip(shape);
        graphics.setFont(font);
    }

    public void renderCurrentSelection(Graphics graphics, int n, int n2) {
        Object object;
        Object object2;
        Font font = graphics.getFont();
        if (!this.graphWindow.getGraphManager().hasSelected(true)) {
            return;
        }
        int n3 = (int)((double)n * this.scaledImageableWidth);
        int n4 = (int)((double)n2 * this.scaledImageableHeight);
        int n5 = (int)((double)this.nCol * this.scaledImageableWidth);
        int n6 = (int)((double)this.nRow * this.scaledImageableHeight);
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        this.transform.setDeviceBounds(-n3, -n4, n5, n6);
        if (this.exportSetup.getExportScale() == 4) {
            object2 = this.graphWindow.getGraphManager().getSelectedObjectsBounds();
            object = this.graphWindow.getGraph().getTailor();
            double d = ((TSGraphTailor)object).getLeftMarginSpacing().getCombinedSpacing(((TSConstRect)object2).getWidth());
            double d2 = ((TSGraphTailor)object).getRightMarginSpacing().getCombinedSpacing(((TSConstRect)object2).getWidth());
            double d3 = ((TSGraphTailor)object).getBottomMarginSpacing().getCombinedSpacing(((TSConstRect)object2).getHeight());
            double d4 = ((TSGraphTailor)object).getTopMarginSpacing().getCombinedSpacing(((TSConstRect)object2).getHeight());
            ((TSRect)object2).setBounds(((TSConstRect)object2).getLeft() - d, ((TSConstRect)object2).getBottom() - d3, ((TSConstRect)object2).getRight() + d2, ((TSConstRect)object2).getTop() + d4);
            this.transform.fitToDevice((TSConstRect)object2);
        } else if (this.exportSetup.getExportScale() == 5) {
            this.transform.setScaleX(this.scale);
            this.transform.setScaleY(-this.scale);
            this.transform.centerWorldInDevice(this.graphWindow.getGraphManager().getSelectedObjectsBounds());
        } else if (this.exportSetup.getExportScale() == 6) {
            this.transform.setScaleX(this.graphWindow.getZoomLevel() * this.scale);
            this.transform.setScaleY(-this.graphWindow.getZoomLevel() * this.scale);
            this.transform.centerWorldInDevice(this.graphWindow.getGraphManager().getSelectedObjectsBounds());
        }
        object2 = this.graphWindow.newGraphics(graphics, this.transform);
        object = graphics.getClip();
        if (this.exportSetup.isBackgroundExported()) {
            graphics.setClip(Math.max(1, (int)(2.0 * this.scale)), Math.max(1, (int)(2.0 * this.scale)), (int)((this.imageableWidth - 4.0) * this.scale), (int)((this.imageableHeight - 4.0) * this.scale));
            this.drawBackground((TSEGraphics)object2, this.transform.getWorldBounds());
        }
        if (this.graphWindow.hasGrid() && this.exportSetup.isGridExported()) {
            graphics.setClip(Math.max(1, (int)(2.0 * this.scale)), Math.max(1, (int)(2.0 * this.scale)), (int)((this.imageableWidth - 4.0) * this.scale), (int)((this.imageableHeight - 4.0) * this.scale));
            this.drawGrid((TSEGraphics)object2, this.transform.getWorldBounds());
        }
        this.graphWindow.getGraph().getGraphUI().draw((TSEGraphics)object2, false, false, this.transform.boundsToWorld(0, 0, (int)this.scaledImageableWidth, (int)this.scaledImageableHeight), true);
        this.graphWindow.drawAdditionalSelectedObjects(this.graphWindow.getGraphManager(), (TSEGraphics)object2);
        graphics.setFont(font);
    }

    protected TSEGraphUI getGraphUI() {
        return (TSEGraphUI)this.graphWindow.getGraph().getUI();
    }

    public void drawBackground(TSEGraphics tSEGraphics, TSConstRect tSConstRect) {
        this.getGraphUI().drawBackground(tSEGraphics, tSConstRect);
    }

    public void drawGrid(TSEGraphics tSEGraphics, TSConstRect tSConstRect) {
        this.graphWindow.getGrid().draw(tSEGraphics, tSConstRect);
    }

    public void drawPreGraph(Graphics graphics, int n, int n2) {
    }

    public void drawPostGraph(Graphics graphics, int n, int n2) {
    }

    public void drawBorders(Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(this.exportSetup.getBorderColor());
        if (n == 0) {
            this.drawWestBorder(graphics);
        }
        if (n == this.nCol - 1) {
            this.drawEastBorder(graphics);
        }
        if (n2 == 0) {
            this.drawNorthBorder(graphics);
        }
        if (n2 == this.nRow - 1) {
            this.drawSouthBorder(graphics);
        }
        graphics.setColor(color);
    }

    public void drawNorthBorder(Graphics graphics) {
        graphics.drawLine(0, 0, (int)this.scaledImageableWidth, 0);
    }

    public void drawSouthBorder(Graphics graphics) {
        graphics.drawLine(0, (int)this.scaledImageableHeight, (int)this.scaledImageableWidth, (int)this.scaledImageableHeight);
    }

    public void drawEastBorder(Graphics graphics) {
        graphics.drawLine((int)this.scaledImageableWidth, 0, (int)this.scaledImageableWidth, (int)this.scaledImageableHeight);
    }

    public void drawWestBorder(Graphics graphics) {
        graphics.drawLine(0, 0, 0, (int)this.scaledImageableHeight);
    }

    public void drawCaption(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        TSEFont tSEFont = this.exportSetup.getCaptionFont();
        graphics.setFont(tSEFont.getScaledFont(this.scale));
        int n = this.exportSetup.getCaption().size();
        int n2 = this.exportSetup.getCaptionPosition() == 7 || this.exportSetup.getCaptionPosition() == 8 ? -n * graphics.getFontMetrics().getHeight() - (int)(5.0 * this.scale) : (int)(this.scaledImageableHeight + 5.0 * this.scale);
        Enumeration enumeration = this.exportSetup.getCaption().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = this.exportSetup.getCaptionPosition() == 7 || this.exportSetup.getCaptionPosition() == 9 ? 0 : (int)this.scaledImageableWidth - graphics.getFontMetrics().stringWidth(string);
            graphics.drawString(string, n3, n2 += graphics.getFontMetrics().getHeight());
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public void drawPageNumber(Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        TSEFont tSEFont = new TSEFont(font);
        graphics.setFont(tSEFont.getScaledFont(this.scale));
        graphics.setColor(Color.black);
        String string = new String("[" + (n2 + 1) + ", " + (n + 1) + "]");
        if (n2 != 0) {
            graphics.drawString(string.concat(" - T"), (int)(this.scaledImageableWidth / 2.0), (int)(-5.0 * this.scale));
        }
        if (n2 != this.nRow - 1) {
            graphics.drawString(string.concat(" - B"), (int)(this.scaledImageableWidth / 2.0), (int)this.scaledImageableHeight + (int)(15.0 * this.scale));
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(Math.toRadians(90.0));
        if (n != 0) {
            graphics2D.drawString(string.concat(" - L"), (int)(this.scaledImageableHeight / 2.0), (int)(15.0 * this.scale));
        }
        if (n != this.nCol - 1) {
            graphics2D.drawString(string.concat(" - R"), (int)(this.scaledImageableHeight / 2.0), -((int)this.scaledImageableWidth) - (int)(5.0 * this.scale));
        }
        graphics2D.rotate(Math.toRadians(-90.0));
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public void drawCropMark(Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n3 = (int)this.exportSetup.getCropMarkLength();
        double d = (double)n3 * this.scale;
        if (n != 0) {
            graphics.drawLine(0, 0, 0, (int)d);
            graphics.drawLine(0, (int)this.scaledImageableHeight, 0, (int)(this.scaledImageableHeight - d));
        }
        if (n != this.nCol - 1) {
            graphics.drawLine((int)this.scaledImageableWidth, 0, (int)this.scaledImageableWidth, (int)d);
            graphics.drawLine((int)this.scaledImageableWidth, (int)this.scaledImageableHeight, (int)this.scaledImageableWidth, (int)(this.scaledImageableHeight - d));
        }
        if (n2 != 0) {
            graphics.drawLine(0, 0, (int)d, 0);
            graphics.drawLine((int)this.scaledImageableWidth, 0, (int)(this.scaledImageableWidth - d), 0);
        }
        if (n2 != this.nRow - 1) {
            graphics.drawLine(0, (int)this.scaledImageableHeight, (int)d, (int)this.scaledImageableHeight);
            graphics.drawLine((int)this.scaledImageableWidth, (int)this.scaledImageableHeight, (int)(this.scaledImageableWidth - d), (int)this.scaledImageableHeight);
        }
        graphics.setColor(color);
    }

    public void setScale(double d) {
        this.scale = d;
        this.scaledImageableHeight = d * this.imageableHeight;
        this.scaledImageableWidth = d * this.imageableWidth;
    }

    public double getScale() {
        return this.scale;
    }
}

