/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.editor.export.TSEExportData;
import com.tomsawyer.editor.export.TSEPrintSetup;
import com.tomsawyer.editor.export.c2;
import com.tomsawyer.editor.export.c3;
import com.tomsawyer.util.f2;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class TSEPrintPreviewPane
extends JScrollPane {
    public static int GAP = 16;
    TSEPrintSetup printSetup;
    c3 previewContainer;
    double scale;

    public TSEPrintPreviewPane(TSEPrintSetup tSEPrintSetup, int n, double d) {
        f2.a(f2.a3);
        this.printSetup = tSEPrintSetup;
        this.scale = d;
        this.previewContainer = new c3(this.printSetup.getPageColumns(), this.printSetup.getPageRows(), n, true);
        this.init();
    }

    public TSEPrintPreviewPane(TSEPrintSetup tSEPrintSetup) {
        this(tSEPrintSetup, GAP, 1.0);
    }

    protected void init() {
        this.populatePreviewContainer();
        this.setViewportView(this.previewContainer);
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        JViewport jViewport = this.getViewport();
        jViewport.setScrollMode(2);
    }

    protected TSEExportData newPrintData() {
        return new TSEExportData(this.printSetup);
    }

    void populatePreviewContainer() {
        TSEExportData tSEExportData = this.newPrintData();
        int n = 0;
        do {
            c2 c22 = new c2(tSEExportData, n, (int)this.printSetup.getWidth(), (int)this.printSetup.getHeight(), this.scale);
            this.previewContainer.add(c22);
        } while (++n <= this.printSetup.getPageColumns() * this.printSetup.getPageRows() - 1);
    }

    public void rebuildPreviewContainer(boolean bl) {
        int n = this.previewContainer.a();
        this.previewContainer = new c3(this.printSetup.getPageColumns(), this.printSetup.getPageRows(), n, false);
        this.populatePreviewContainer();
        this.setViewportView(this.previewContainer);
        JViewport jViewport = this.getViewport();
        jViewport.setScrollMode(2);
        this.validate();
        if (bl) {
            this.fitInViewport();
        }
    }

    public void fitInViewport() {
        double d = this.getFitInScale();
        if (d > 0.0) {
            this.setScale(d);
        }
    }

    public double getFitInScale() {
        JViewport jViewport = this.getViewport();
        int n = jViewport.getSize().width;
        int n2 = jViewport.getSize().height;
        double d = this.previewContainer.a(n, n2);
        return d;
    }

    public void setScale(double d) {
        if (d <= 0.0) {
            return;
        }
        this.scale = d;
        Component[] componentArray = this.previewContainer.getComponents();
        if (componentArray.length >= 1) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == null || !(componentArray[i] instanceof c2)) continue;
                c2 c22 = (c2)componentArray[i];
                c22.a(this.scale);
            }
            this.previewContainer.doLayout();
            this.previewContainer.getParent().getParent().validate();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setPrintSetup(TSEPrintSetup tSEPrintSetup, boolean bl, boolean bl2) {
        this.printSetup = tSEPrintSetup;
        if (bl) {
            this.rebuildPreviewContainer(bl2);
        }
    }

    public TSEPrintSetup getPrintSetup() {
        return this.printSetup;
    }

    public void setGap(int n) {
        this.previewContainer.a(n);
    }

    public int getGap() {
        return this.previewContainer.a();
    }

    public JPanel getPreviewContainer() {
        return this.previewContainer;
    }
}

