/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.drawing.TSDLicenseManager;
import com.tomsawyer.editor.TSEButtonKeyListener;
import com.tomsawyer.editor.TSEGraphImageEncoder;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.dialog.TSDialogCallBackListener;
import com.tomsawyer.editor.dialog.TSDialogWithCallBack;
import com.tomsawyer.editor.dialog.TSFileChooser;
import com.tomsawyer.editor.dialog.TSFileFilter;
import com.tomsawyer.editor.dialog.TSUnsignedIntegerField;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.util.TSSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TSESaveAsImageDialog
extends JDialog
implements ActionListener,
KeyListener,
ChangeListener,
TSDialogWithCallBack {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JComboBox fileType;
    protected JTextField fileName;
    protected JCheckBox visible;
    protected JCheckBox selected;
    protected JCheckBox drawGrid;
    protected TSUnsignedIntegerField qualityField;
    protected JSlider slider;
    protected JRadioButton zoomLevel;
    protected JRadioButton actual;
    protected JRadioButton custom;
    protected JRadioButton fitInWindow;
    protected TSUnsignedIntegerField width;
    protected TSUnsignedIntegerField height;
    TSEGraphWindow graphWindow;
    protected TSEGraphImageEncoder encoder;
    protected Color normalTextColor;
    protected Color disableTextColor;
    protected Color labelColor = Color.black;
    protected Font font;
    protected int defaultQuality = 100;
    protected boolean ignoreEvent = false;
    protected JFileChooser fileChooser;
    protected String type;
    protected KeyListener keyListener;
    protected TSFileFilter jpgFilter;
    protected TSFileFilter svgFilter;
    protected TSFileFilter pngFilter;
    protected TSFileFilter pdfFilter;
    protected double graphWidth;
    protected double graphHeight;
    protected double widthHeightRatio;
    protected double heightWidthRatio;
    public int flags;
    public static int JPG_FORMAT = 1;
    public static int SVG_FORMAT = 2;
    public static int PNG_FORMAT = 4;
    public static int PDF_FORMAT = 8;
    public static int ALL_FORMATS = JPG_FORMAT | SVG_FORMAT | PNG_FORMAT | PDF_FORMAT;
    protected TSEResourceBundleWrapper labels;
    String jpgExtension;
    String svgExtension;
    String pngExtension;
    String pdfExtension;
    String jpgDescription;
    String svgDescription;
    String pngDescription;
    String pdfDescription;
    boolean firstTime = true;
    int zoomOption;
    TSDialogCallBackListener callBackListener;

    public TSESaveAsImageDialog(Frame owner, String title, TSEGraphWindow graphWindow) {
        this(owner, title, graphWindow, ALL_FORMATS);
    }

    public TSESaveAsImageDialog(Frame owner, String title, TSEGraphWindow graphWindow, int flags) {
        super(owner, title, true);
        this.setGraphWindow(graphWindow);
        this.flags = flags;
        this.init();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected void init() {
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
        this.normalTextColor = Color.white;
        this.disableTextColor = new Color(204, 204, 204);
        this.keyListener = new TSEButtonKeyListener(this, this);
        this.addKeyListener(this);
        this.jpgExtension = "jpg";
        this.svgExtension = "svg";
        this.pngExtension = "png";
        this.pdfExtension = "pdf";
        this.jpgDescription = this.translateText("JPEG_Image_(*.jpg)");
        this.svgDescription = this.translateText("Scalable_Vector_Graphics_(*.svg)");
        this.pngDescription = this.translateText("Portable_Network_Graphics_(*.png)");
        this.pdfDescription = this.translateText("Portable_Document_Format_(*.pdf)");
        JPanel mainPanel = this.createMainPanel();
        JPanel buttonPanel = this.createButtonPanel();
        Container contentPane = this.getContentPane();
        Dimension mainPanelSize = mainPanel.getPreferredSize();
        Dimension buttonPanelSize = buttonPanel.getPreferredSize();
        int margin = 12;
        int compWidth = (int)Math.max(mainPanelSize.getWidth(), buttonPanelSize.getWidth());
        mainPanel.setBounds(margin, margin, compWidth, (int)mainPanelSize.getHeight());
        buttonPanel.setBounds(margin, 2 * margin + (int)mainPanelSize.getHeight(), compWidth, (int)buttonPanelSize.getHeight());
        ((JPanel)contentPane).setPreferredSize(new Dimension(2 * margin + compWidth, 3 * margin + (int)mainPanelSize.getHeight() + (int)buttonPanelSize.getHeight()));
        contentPane.setLayout(null);
        contentPane.add(mainPanel);
        contentPane.add(buttonPanel);
        this.type = this.jpgExtension;
        this.setResizable(false);
        this.jpgFilter = new TSFileFilter("jpg", this.jpgDescription);
        this.svgFilter = new TSFileFilter("svg", this.svgDescription);
        this.pngFilter = new TSFileFilter("png", this.pngDescription);
        this.pdfFilter = new TSFileFilter("pdf", this.pdfDescription);
        this.setDefaultCloseOperation(1);
        this.setAccessibleProperties(this, null, "Save_As_Image");
    }

    public JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel imagePanel = this.createImagePanel();
        JPanel imageContent = this.createImageContent();
        JPanel imageChar = this.createImageChar();
        JPanel imageSize = this.createImageSize();
        imagePanel.setAlignmentX(0.0f);
        imageContent.setAlignmentX(0.0f);
        imageChar.setAlignmentX(0.0f);
        imageSize.setAlignmentX(0.0f);
        panel.add(imagePanel);
        panel.add(imageContent);
        panel.add(imageChar);
        panel.add(imageSize);
        return panel;
    }

    public JPanel createImagePanel() {
        JLabel typeLabel = this.createLabel(this.translateText("Type"));
        JLabel fileNameLabel = this.createLabel(this.translateText("File_Name"));
        this.fileType = new JComboBox();
        if ((this.flags & JPG_FORMAT) != 0) {
            this.fileType.addItem(this.jpgDescription);
        }
        if ((this.flags & PDF_FORMAT) != 0) {
            this.fileType.addItem(this.pdfDescription);
        }
        if ((this.flags & PNG_FORMAT) != 0) {
            this.fileType.addItem(this.pngDescription);
        }
        if ((this.flags & SVG_FORMAT) != 0) {
            this.fileType.addItem(this.svgDescription);
        }
        this.fileType.setActionCommand("file type changed");
        this.fileType.addActionListener(this);
        this.fileType.setMaximumSize(this.fileType.getPreferredSize());
        this.fileName = new JTextField();
        this.fileName.setText(new File("untitled1.jpg").getAbsolutePath());
        this.fileName.setPreferredSize(new Dimension((int)this.fileType.getPreferredSize().getWidth(), (int)this.fileName.getPreferredSize().getHeight()));
        this.fileName.setMaximumSize(this.fileName.getPreferredSize());
        JButton browse = this.createButton("Browse", "browse");
        if (this.isMotif()) {
            browse.setMaximumSize(new Dimension(40, 35));
        }
        typeLabel.setLabelFor(this.fileType);
        typeLabel.setDisplayedMnemonic(this.getMnemonic("Type"));
        this.setAccessibleProperties(this.fileType, null, "Type");
        fileNameLabel.setLabelFor(this.fileName);
        fileNameLabel.setDisplayedMnemonic(this.getMnemonic("File_Name"));
        this.setAccessibleProperties(this.fileName, null, "File_Name");
        browse.setMnemonic(this.getMnemonic("Browse"));
        JPanel panel = new JPanel();
        this.createBorder(panel, this.translateText("Image"), 0, 6, 5, 5);
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        typeLabel.setAlignmentY(0.5f);
        this.fileType.setAlignmentY(0.5f);
        top.add(typeLabel);
        top.add(Box.createRigidArea(new Dimension(40, 0)));
        top.add(this.fileType);
        top.add(Box.createHorizontalGlue());
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        fileNameLabel.setAlignmentY(0.5f);
        this.fileName.setAlignmentY(0.5f);
        browse.setAlignmentY(0.5f);
        bottom.add(fileNameLabel);
        bottom.add(Box.createRigidArea(new Dimension(9, 0)));
        bottom.add(this.fileName);
        bottom.add(Box.createRigidArea(new Dimension(9, 0)));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(browse);
        top.setAlignmentX(0.0f);
        bottom.setAlignmentX(0.0f);
        panel.add(top);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(bottom);
        return panel;
    }

    public JPanel createImageContent() {
        this.visible = this.createCheckbox("Visible_Window_Only", "visible");
        this.selected = this.createCheckbox("Selected_Objects_Only", "Selected Objects Only");
        this.drawGrid = this.createCheckbox("Draw_Grid", "Draw Grid");
        this.adjustCheckboxes();
        JPanel panel = new JPanel();
        this.createBorder(panel, this.translateText("Image_Content"), 0, 6, 5, 5);
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.add(this.visible);
        top.add(Box.createHorizontalGlue());
        top.add(this.selected);
        top.add(Box.createHorizontalGlue());
        top.setAlignmentX(0.0f);
        this.drawGrid.setAlignmentX(0.0f);
        panel.add(top);
        panel.add(Box.createRigidArea(new Dimension(0, 6)));
        panel.add(this.drawGrid);
        return panel;
    }

    public JPanel createImageChar() {
        JLabel qualityLabel = this.createLabel(this.translateText("Image_Quality_(0-100)"));
        this.qualityField = this.createIntegerField(3, 0, 100);
        this.qualityField.setText(String.valueOf(this.defaultQuality));
        qualityLabel.setLabelFor(this.qualityField);
        qualityLabel.setDisplayedMnemonic(this.getMnemonic("Image_Quality_(0-100)"));
        this.setAccessibleProperties(this.qualityField, null, "Image_Quality");
        this.slider = new JSlider(0, 0, 100, this.defaultQuality);
        this.slider.addChangeListener(this);
        this.slider.setPaintTicks(true);
        this.slider.setMinorTickSpacing(5);
        this.setAccessibleProperties(this.slider, "Image_Quality_Slider", "Image_Quality_Slider");
        JLabel low = this.createLabel(this.translateText("Low"));
        JLabel high = this.createLabel(this.translateText("High"));
        JPanel panel = new JPanel();
        this.createBorder(panel, this.translateText("Image_Characteristics"), 0, 12, 5, 12);
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.add(qualityLabel);
        top.add(Box.createRigidArea(new Dimension(5, 0)));
        top.add(this.qualityField);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        low.setAlignmentY(0.0f);
        this.slider.setAlignmentY(0.0f);
        high.setAlignmentY(0.0f);
        bottom.add(low);
        if (this.isMotif()) {
            bottom.add(Box.createRigidArea(new Dimension(5, 0)));
            bottom.add(this.slider);
            bottom.add(Box.createRigidArea(new Dimension(5, 0)));
        } else {
            bottom.add(this.slider);
        }
        bottom.add(high);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(top);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(bottom);
        return panel;
    }

    public JPanel createImageSize() {
        this.zoomLevel = this.createRadioButton("Current_Zoom_Level", "zoom level");
        this.actual = this.createRadioButton("Actual_Size", "actual");
        this.custom = this.createRadioButton("Custom", "custom");
        this.fitInWindow = this.createRadioButton("Fit_In_Window", "fit");
        this.width = this.createIntegerField(4, 1, 5000);
        this.height = this.createIntegerField(4, 1, 5000);
        this.setZoomOption(this.getDefaultZoomOption());
        ButtonGroup group = new ButtonGroup();
        group.add(this.zoomLevel);
        group.add(this.actual);
        group.add(this.custom);
        group.add(this.fitInWindow);
        this.graphWidth = this.getGraphWindow().getGraph().getFrameBounds().getWidth();
        this.graphHeight = this.getGraphWindow().getGraph().getFrameBounds().getHeight();
        this.widthHeightRatio = this.graphWidth / this.graphHeight;
        this.heightWidthRatio = this.graphHeight / this.graphWidth;
        this.width.setText(String.valueOf((int)this.graphWidth));
        this.height.setText(String.valueOf((int)this.graphHeight));
        this.disable(this.width);
        this.disable(this.height);
        JPanel panel = new JPanel();
        this.createBorder(panel, this.translateText("Size"), 0, 6, 5, 5);
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        left.add(this.zoomLevel);
        left.add(this.actual);
        left.add(this.fitInWindow);
        left.add(this.custom);
        JPanel labels = new JPanel();
        labels.setLayout(new BoxLayout(labels, 1));
        JLabel widthLabel = this.createLabel(this.translateText("Width"));
        widthLabel.setLabelFor(this.width);
        widthLabel.setDisplayedMnemonic(this.getMnemonic("Width"));
        this.setAccessibleProperties(this.width, null, "Width");
        JLabel heightLabel = this.createLabel(this.translateText("Height"));
        heightLabel.setLabelFor(this.height);
        heightLabel.setDisplayedMnemonic(this.getMnemonic("Height"));
        this.setAccessibleProperties(this.height, null, "Height");
        labels.add(Box.createRigidArea(new Dimension(0, 4)));
        labels.add(widthLabel);
        labels.add(Box.createRigidArea(new Dimension(0, 9)));
        labels.add(heightLabel);
        JPanel right = new JPanel();
        right.add(Box.createRigidArea(new Dimension(0, 2)));
        right.setLayout(new BoxLayout(right, 1));
        right.add(this.width);
        right.add(Box.createRigidArea(new Dimension(0, 5)));
        right.add(this.height);
        left.setAlignmentY(0.0f);
        labels.setAlignmentY(0.0f);
        right.setAlignmentY(0.0f);
        panel.add(left);
        panel.add(Box.createHorizontalGlue());
        panel.add(labels);
        panel.add(Box.createRigidArea(new Dimension(10, 0)));
        panel.add(right);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public JPanel createButtonPanel() {
        JPanel buttons = new JPanel();
        this.okButton = this.createButton("OK", "ok");
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.setMnemonic(this.getMnemonic("OK"));
        this.cancelButton = this.createButton("Cancel", "cancel");
        buttons.setLayout(new BoxLayout(buttons, 0));
        LinkedList<JButton> comps = new LinkedList<JButton>();
        comps.add(this.okButton);
        comps.add(this.cancelButton);
        this.normalizeComponentWidths(comps);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.okButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.cancelButton);
        return buttons;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ok")) {
            if (this.onOK()) {
                this.dispose();
            }
        } else if (command.equals("cancel")) {
            this.dispose();
        } else if (command.equals("browse")) {
            this.onBrowse();
        } else if (command.equals("zoom level")) {
            this.setZoomOption(0);
        } else if (command.equals("actual")) {
            this.setZoomOption(1);
        } else if (command.equals("fit")) {
            this.setZoomOption(2);
        } else if (command.equals("custom")) {
            this.setZoomOption(3);
        } else if (command.equals("visible")) {
            this.actual.setEnabled(!this.visible.isSelected());
            this.fitInWindow.setEnabled(!this.visible.isSelected());
            this.custom.setEnabled(!this.visible.isSelected());
            if (!this.visible.isSelected() && this.custom.isSelected()) {
                this.enable(this.width);
                this.enable(this.height);
            } else {
                this.disable(this.width);
                this.disable(this.height);
            }
            if (this.visible.isSelected()) {
                this.zoomLevel.setSelected(true);
            }
        } else if (command.equals("file type changed")) {
            JComboBox list = (JComboBox)e.getSource();
            String file = this.fileName.getText();
            if (file.lastIndexOf(".") != -1) {
                file = file.substring(0, file.lastIndexOf("."));
            }
            if (list.getSelectedItem().equals(this.jpgDescription)) {
                this.fileName.setText(file + "." + this.jpgExtension);
                this.enable(this.slider);
                this.enable(this.qualityField);
                this.type = this.jpgExtension;
            } else if (list.getSelectedItem().equals(this.svgDescription)) {
                this.fileName.setText(file + "." + this.svgExtension);
                this.disable(this.slider);
                this.disable(this.qualityField);
                this.type = this.svgExtension;
            } else if (list.getSelectedItem().equals(this.pngDescription)) {
                this.fileName.setText(file + "." + this.pngExtension);
                this.disable(this.slider);
                this.disable(this.qualityField);
                this.type = this.pngExtension;
            } else if (list.getSelectedItem().equals(this.pdfDescription)) {
                this.fileName.setText(file + "." + this.pdfExtension);
                this.disable(this.slider);
                this.disable(this.qualityField);
                this.type = this.pdfExtension;
            }
        }
    }

    public void onBrowse() {
        File selectedFile;
        JFileChooser fileChooser = this.getFileChooser();
        fileChooser.setSelectedFile(new File(this.fileName.getText()));
        int rc = fileChooser.showDialog(this.getGraphWindow(), "OK");
        if (rc == 0 && (selectedFile = fileChooser.getSelectedFile()) != null) {
            this.fileType.setSelectedItem(this.fileChooser.getFileFilter().getDescription());
            String selectedFileName = selectedFile.getPath();
            if (!selectedFileName.endsWith("." + this.type)) {
                selectedFileName = selectedFileName.concat("." + this.type);
            }
            this.fileName.setText(selectedFileName);
        }
    }

    public boolean onOK() {
        boolean overWrite = true;
        if (TSDLicenseManager.checkLicense(TSDLicenseManager.IMAGE_EXPORT)) {
            block23: {
                int zoomType = this.actual.isSelected() ? 1 : (this.zoomLevel.isSelected() ? 0 : (this.fitInWindow.isSelected() ? 2 : 3));
                if (this.width.getText().equals("0") || this.height.getText().equals("0")) {
                    return false;
                }
                File file = new File(this.fileName.getText());
                if (file.exists()) {
                    overWrite = this.overWriteConfirm();
                } else if (!file.getParentFile().exists()) {
                    String newText = TSSystem.replace(this.translateText("%X%_does_not_exist."), "%X%", file.getParent());
                    JOptionPane.showMessageDialog(this, newText, this.translateText("No_such_directory"), 0);
                    return false;
                }
                if (overWrite) {
                    try {
                        if (this.type == this.jpgExtension) {
                            int quality = 100;
                            try {
                                FileOutputStream stream = new FileOutputStream(file);
                                quality = Integer.parseInt(this.qualityField.getText());
                                this.encoder.writeJPEGFormat(stream, this.visible.isSelected(), zoomType, this.drawGrid.isSelected(), this.selected.isSelected(), (float)((double)quality / 100.0), Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText()));
                                stream.close();
                                break block23;
                            }
                            catch (FileNotFoundException fnfe) {
                                String newText = TSSystem.replace(this.translateText("%X%_cannot_be_overwritten."), "%X%", file.getAbsolutePath());
                                JOptionPane.showMessageDialog(this, newText, this.translateText("Cannot_overwrite_file"), 0);
                                return false;
                            }
                        }
                        if (this.type == this.svgExtension) {
                            try {
                                FileOutputStream stream = new FileOutputStream(file);
                                this.encoder.writeSVGFormat(stream, this.visible.isSelected(), zoomType, this.drawGrid.isSelected(), this.selected.isSelected(), Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText()));
                                stream.close();
                                break block23;
                            }
                            catch (FileNotFoundException fnfe) {
                                String newText = TSSystem.replace(this.translateText("%X%_cannot_be_overwritten."), "%X%", file.getAbsolutePath());
                                JOptionPane.showMessageDialog(this, newText, this.translateText("Cannot_overwrite_file"), 0);
                                return false;
                            }
                        }
                        if (this.type == this.pngExtension) {
                            try {
                                FileOutputStream stream = new FileOutputStream(file);
                                this.encoder.writePNGFormat(stream, this.visible.isSelected(), zoomType, this.drawGrid.isSelected(), this.selected.isSelected(), Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText()));
                                stream.close();
                                break block23;
                            }
                            catch (FileNotFoundException fnfe) {
                                String newText = TSSystem.replace(this.translateText("%X%_cannot_be_overwritten."), "%X%", file.getAbsolutePath());
                                JOptionPane.showMessageDialog(this, newText, this.translateText("Cannot_overwrite_file"), 0);
                                return false;
                            }
                        }
                        try {
                            FileOutputStream stream = new FileOutputStream(file);
                            this.encoder.writePDFFormat(stream, this.visible.isSelected(), zoomType, this.drawGrid.isSelected(), this.selected.isSelected(), Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText()));
                            stream.close();
                        }
                        catch (FileNotFoundException fnfe) {
                            String newText = TSSystem.replace(this.translateText("%X%_cannot_be_overwritten."), "%X%", file.getAbsolutePath());
                            JOptionPane.showMessageDialog(this, newText, this.translateText("Cannot_overwrite_file"), 0);
                            return false;
                        }
                    }
                    catch (NegativeArraySizeException nase) {
                        JOptionPane.showMessageDialog(this, this.labels.getStringSafely("JVM_array_size_limit"), this.labels.getStringSafely("Cannot_create_image"), 0);
                        return false;
                    }
                    catch (Exception ex) {
                        String errorMessage = ex.getMessage();
                        if (errorMessage == null || errorMessage.equals("")) {
                            errorMessage = ex.getClass().getName();
                        }
                        JOptionPane.showMessageDialog(this, errorMessage, this.labels.getStringSafely("Cannot_create_image"), 0);
                        return false;
                    }
                    catch (OutOfMemoryError err) {
                        String errorMessage = err.getMessage();
                        if (errorMessage == null || errorMessage.equals("")) {
                            errorMessage = err.getClass().getName();
                        }
                        JOptionPane.showMessageDialog(this, errorMessage, this.labels.getStringSafely("Cannot_create_image"), 0);
                        return false;
                    }
                }
            }
            return overWrite;
        }
        this.callBack(new TSLicenseRuntimeException());
        return false;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.ignoreEvent) {
            this.ignoreEvent = false;
        } else {
            JSlider source = (JSlider)e.getSource();
            int quality = source.getValue();
            this.qualityField.setText(String.valueOf(quality));
        }
    }

    public void registerCallBackListener(TSDialogCallBackListener listener) {
        this.callBackListener = listener;
    }

    public Object callBack(Object object) {
        Object rc = null;
        if (this.callBackListener != null) {
            rc = this.callBackListener.uponCallBack(object);
        }
        return rc;
    }

    public TSUnsignedIntegerField createIntegerField(int length, int min, int max) {
        TSUnsignedIntegerField field = new TSUnsignedIntegerField(length, min, max);
        field.setMaximumSize(field.getPreferredSize());
        field.addKeyListener(this);
        return field;
    }

    public JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setForeground(this.labelColor);
        return label;
    }

    public void createBorder(JPanel panel, String text, int top, int left, int bottom, int right) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(text);
        titledBorder.setTitleColor(this.labelColor);
        titledBorder.setTitleFont(this.font);
        CompoundBorder border = BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(top, left, bottom, right));
        panel.setBorder(border);
    }

    public JCheckBox createCheckbox(String text) {
        return this.createCheckbox(text, text);
    }

    public JCheckBox createCheckbox(String labelKey, String actionCommand) {
        JCheckBox checkbox = new JCheckBox(" " + this.translateText(labelKey));
        checkbox.setActionCommand(actionCommand);
        checkbox.addActionListener(this);
        checkbox.setBorder(null);
        this.setAccessibleProperties(checkbox, null, labelKey);
        checkbox.setMnemonic(this.getMnemonic(labelKey));
        return checkbox;
    }

    public JRadioButton createRadioButton(String text) {
        return this.createRadioButton(text, text);
    }

    public JRadioButton createRadioButton(String labelKey, String actionCommand) {
        JRadioButton button = new JRadioButton(" " + this.translateText(labelKey));
        button.setActionCommand(actionCommand);
        button.addActionListener(this);
        this.setAccessibleProperties(button, null, labelKey);
        button.setMnemonic(this.getMnemonic(labelKey));
        return button;
    }

    public JButton createButton(String labelKey, String actionCommand) {
        JButton button = new JButton(this.translateText(labelKey));
        button.setActionCommand(actionCommand);
        button.addActionListener(this);
        this.setAccessibleProperties(button, null, labelKey);
        return button;
    }

    protected void enable(JComponent component) {
        component.setEnabled(true);
        if (component instanceof JTextField) {
            component.setBackground(this.normalTextColor);
        }
    }

    protected void disable(JComponent component) {
        component.setEnabled(false);
        if (component instanceof JTextField) {
            component.setBackground(this.disableTextColor);
        }
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new TSFileChooser(new File(".").getAbsoluteFile());
            this.fileChooser.setDialogTitle("Save As");
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
            this.fileChooser.addChoosableFileFilter(this.jpgFilter);
            this.fileChooser.addChoosableFileFilter(this.svgFilter);
            this.fileChooser.addChoosableFileFilter(this.pngFilter);
            this.fileChooser.addChoosableFileFilter(this.pdfFilter);
        }
        if (this.type == this.jpgExtension) {
            this.fileChooser.setFileFilter(this.jpgFilter);
        } else if (this.type == this.svgExtension) {
            this.fileChooser.setFileFilter(this.svgFilter);
        } else if (this.type == this.pngExtension) {
            this.fileChooser.setFileFilter(this.pngFilter);
        } else if (this.type == this.pdfExtension) {
            this.fileChooser.setFileFilter(this.pdfFilter);
        }
        return this.fileChooser;
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public void setGraphWindow(TSEGraphWindow window) {
        this.graphWindow = window;
        try {
            this.encoder = this.newGraphImageEncoder(window);
        }
        catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
            // empty catch block
        }
    }

    public TSEGraphImageEncoder newGraphImageEncoder(TSEGraphWindow window) {
        return new TSEGraphImageEncoder(window);
    }

    public void keyPressed(KeyEvent e) {
        this.keyListener.keyPressed(e);
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.onOK();
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource().equals(this.qualityField)) {
            int value = this.slider.getMinimum();
            String text = this.qualityField.getText();
            if (!text.equals("")) {
                try {
                    value = Integer.parseInt(text);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (value <= this.slider.getMaximum()) {
                this.ignoreEvent = true;
                this.slider.setValue(value);
            }
        } else if (e.getSource().equals(this.width)) {
            if (this.width.getText().equals(null) || this.width.getText().equals("")) {
                this.height.setText(this.width.getText());
            } else {
                int newWidth = Integer.parseInt(this.width.getText());
                this.height.setText(String.valueOf((int)((double)newWidth * this.heightWidthRatio)));
            }
        } else if (e.getSource().equals(this.height)) {
            if (this.height.getText().equals(null) || this.height.getText().equals("")) {
                this.width.setText(this.height.getText());
            } else {
                int newHeight = Integer.parseInt(this.height.getText());
                this.width.setText(String.valueOf((int)((double)newHeight * this.widthHeightRatio)));
            }
        }
    }

    public boolean overWriteConfirm() {
        String newText = TSSystem.replace(this.translateText("%X%_already_exists.\nDo_you_want_to_replace_it?"), "%X%", this.fileName.getText());
        int option = JOptionPane.showConfirmDialog(this, newText, this.translateText("Overwrite_Confirmation"), 1, 2);
        return option == 0;
    }

    protected int normalizeComponentWidths(List components) {
        int width = -1;
        if (components != null) {
            for (JComponent comp : components) {
                width = (int)Math.max(comp.getPreferredSize().getWidth(), (double)width);
            }
            for (JComponent comp : components) {
                Dimension compDimension = new Dimension(width, (int)comp.getPreferredSize().getHeight());
                comp.setPreferredSize(compDimension);
                comp.setMinimumSize(compDimension);
                comp.setMaximumSize(compDimension);
            }
        }
        return width;
    }

    public String translateText(String text) {
        boolean isNumber = true;
        try {
            Integer.parseInt(text);
        }
        catch (Exception e) {
            isNumber = false;
        }
        if (text.equals("") || isNumber) {
            return text;
        }
        return this.labels.getStringSafely(text);
    }

    public void setVisible(boolean visible) {
        this.adjustCheckboxes();
        super.setVisible(visible);
    }

    public void adjustCheckboxes() {
        this.selected.setEnabled(this.getGraphWindow().getGraphManager().hasSelected(true, true));
        this.drawGrid.setEnabled(this.getGraphWindow().hasGrid());
    }

    public void setZoomOption(int zoomOption) {
        this.zoomOption = zoomOption;
        this.disable(this.visible);
        this.disable(this.width);
        this.disable(this.height);
        if (this.getZoomOption() == 0) {
            this.zoomLevel.setSelected(true);
            this.enable(this.visible);
        } else if (this.getZoomOption() == 1) {
            this.actual.setSelected(true);
        } else if (this.getZoomOption() == 2) {
            this.fitInWindow.setSelected(true);
        } else {
            this.custom.setSelected(true);
            this.enable(this.width);
            this.enable(this.height);
        }
    }

    public int getZoomOption() {
        return this.zoomOption;
    }

    protected int getDefaultZoomOption() {
        return 2;
    }

    private boolean isMotif() {
        return UIManager.getLookAndFeel().getName().endsWith("Motif");
    }

    protected void setAccessibleProperties(Component comp, String accsNameKey, String accsDescKey) {
        if (comp != null) {
            String labelStr = null;
            AccessibleContext accsContext = comp.getAccessibleContext();
            if (accsNameKey != null) {
                labelStr = this.labels.getStringSafely("ACSN_" + accsNameKey);
                accsContext.setAccessibleName(labelStr);
            }
            if (accsDescKey != null) {
                labelStr = this.labels.getStringSafely("ACSD_" + accsDescKey);
                accsContext.setAccessibleDescription(labelStr);
            }
        }
    }

    protected char getMnemonic(String bundleKey) {
        String mnm;
        char mnmChar = '?';
        if (bundleKey != null && (mnm = this.labels.getStringSafely("MNE_" + bundleKey)) != null && mnm.length() > 0) {
            mnmChar = mnm.charAt(0);
        }
        return mnmChar;
    }
}

