/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.inspector;

import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSELocalization;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.inspector.TSEColorEditor;
import com.tomsawyer.editor.inspector.TSEColorRenderer;
import com.tomsawyer.editor.inspector.TSEDoubleEditor;
import com.tomsawyer.editor.inspector.TSEFilenameInspectorPropertyEditor;
import com.tomsawyer.editor.inspector.TSEFontEditor;
import com.tomsawyer.editor.inspector.TSEFontRenderer;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEInspectorTable;
import com.tomsawyer.editor.inspector.TSEIntegerEditor;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyEditor;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyRenderer;
import com.tomsawyer.editor.inspector.TSETextEditor;
import com.tomsawyer.editor.inspector.TSETextRenderer;
import com.tomsawyer.editor.inspector.command.TSESetInspectorPropertyCommand;
import com.tomsawyer.editor.inspector.hi;
import com.tomsawyer.editor.inspector.hj;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f3;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TSEInspector
implements TableModelListener,
ActionListener {
    public static final String[] DEFAULT_COLUMN_NAME_KEYS;
    protected String allString;
    protected String graphString;
    protected String nodeString;
    protected String connectorString;
    protected String edgeString;
    protected String bendString;
    protected String labelString;
    private TSEInspectorTable table;
    private JComboBox comboBox;
    private List inspectees;
    private Hashtable selectionPropertyIDs;
    private f3 tableProperties;
    private Hashtable propertyLists;
    private List classList = new Vector();
    private boolean ignoringUpdates;
    private boolean needsUpdate;
    protected TSEGraphWindow parentWindow;
    private Timer updateTimer;
    protected hi eventListener;
    static /* synthetic */ Class class$com$tomsawyer$editor$inspector$TSEInspectable;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSENode;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEConnector;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEEdge;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSENodeLabel;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEConnectorLabel;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEEdgeLabel;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEPNode;
    static /* synthetic */ Class class$com$tomsawyer$editor$inspector$TSEKeyValueInspectorProperty;
    static /* synthetic */ Class class$com$tomsawyer$editor$inspector$TSEFilenameInspectorProperty;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEFont;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEColor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEGraph;

    public TSEInspector(TSEGraphWindow tSEGraphWindow) {
        this.inspectees = new Vector();
        this.selectionPropertyIDs = new Hashtable();
        this.tableProperties = new f3();
        this.propertyLists = new Hashtable();
        this.parentWindow = tSEGraphWindow;
        this.updateTimer = new Timer(0, this);
        this.updateTimer.setRepeats(false);
        this.updateTimer.setCoalesce(true);
        this.table = this.getDefaultTable();
        this.table.getModel().addTableModelListener(this);
        this.allString = this.getDefaultAllString();
        this.graphString = this.getDefaultGraphString();
        this.nodeString = this.getDefaultNodeString();
        this.connectorString = this.getDefaultConnectorString();
        this.edgeString = this.getDefaultEdgeString();
        this.bendString = this.getDefaultBendString();
        this.labelString = this.getDefaultLabelString();
        this.comboBox = this.getDefaultComboBox();
        this.comboBox.addActionListener(this);
        this.eventListener = new hi(this);
        this.setDefaultEditorsAndRenderers();
        this.setReadOnly(this.isReadOnlyByDefault());
    }

    private void addInspecteesFromList(List list, Class clazz) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isInstance(e)) continue;
            this.inspectees.add(e);
        }
    }

    private void updateInspectees() {
        this.inspectees.clear();
        if (this.getParentWindow() != null) {
            TSEGraphManager tSEGraphManager = this.getParentWindow().getGraphManager();
            Iterator iterator = this.classList.iterator();
            while (iterator.hasNext()) {
                Class clazz;
                if (!(class$com$tomsawyer$editor$inspector$TSEInspectable == null ? TSEInspector.class$("com.tomsawyer.editor.inspector.TSEInspectable") : class$com$tomsawyer$editor$inspector$TSEInspectable).isAssignableFrom(clazz = (Class)iterator.next())) continue;
                if ((class$com$tomsawyer$editor$TSENode == null ? TSEInspector.class$("com.tomsawyer.editor.TSENode") : class$com$tomsawyer$editor$TSENode).isAssignableFrom(clazz)) {
                    this.addInspecteesFromList(tSEGraphManager.selectedNodes(), clazz);
                    continue;
                }
                if ((class$com$tomsawyer$editor$TSEConnector == null ? TSEInspector.class$("com.tomsawyer.editor.TSEConnector") : class$com$tomsawyer$editor$TSEConnector).isAssignableFrom(clazz)) {
                    this.addInspecteesFromList(tSEGraphManager.selectedConnectors(), clazz);
                    continue;
                }
                if ((class$com$tomsawyer$editor$TSEEdge == null ? TSEInspector.class$("com.tomsawyer.editor.TSEEdge") : class$com$tomsawyer$editor$TSEEdge).isAssignableFrom(clazz)) {
                    this.addInspecteesFromList(tSEGraphManager.selectedEdges(true), clazz);
                    continue;
                }
                if ((class$com$tomsawyer$editor$TSENodeLabel == null ? TSEInspector.class$("com.tomsawyer.editor.TSENodeLabel") : class$com$tomsawyer$editor$TSENodeLabel).isAssignableFrom(clazz)) {
                    this.addInspecteesFromList(tSEGraphManager.selectedNodeLabels(), clazz);
                    continue;
                }
                if ((class$com$tomsawyer$editor$TSEConnectorLabel == null ? TSEInspector.class$("com.tomsawyer.editor.TSEConnectorLabel") : class$com$tomsawyer$editor$TSEConnectorLabel).isAssignableFrom(clazz)) {
                    this.addInspecteesFromList(tSEGraphManager.selectedConnectorLabels(), clazz);
                    continue;
                }
                if ((class$com$tomsawyer$editor$TSEEdgeLabel == null ? TSEInspector.class$("com.tomsawyer.editor.TSEEdgeLabel") : class$com$tomsawyer$editor$TSEEdgeLabel).isAssignableFrom(clazz)) {
                    this.addInspecteesFromList(tSEGraphManager.selectedEdgeLabels(true), clazz);
                    continue;
                }
                if ((class$com$tomsawyer$editor$TSEPNode == null ? TSEInspector.class$("com.tomsawyer.editor.TSEPNode") : class$com$tomsawyer$editor$TSEPNode).isAssignableFrom(clazz)) {
                    this.addInspecteesFromList(tSEGraphManager.selectedPathNodes(true), clazz);
                    continue;
                }
                if (!clazz.isInstance(tSEGraphManager.selectedGraph()) || this.inspectees.size() != 0) continue;
                this.inspectees.add(tSEGraphManager.selectedGraph());
            }
        }
    }

    private void fetchInspecteePropertyIDs() {
        Iterator iterator = this.inspectees.iterator();
        while (iterator.hasNext()) {
            TSEInspectable tSEInspectable = (TSEInspectable)iterator.next();
            if (this.selectionPropertyIDs.containsKey(tSEInspectable)) continue;
            df df2 = new df();
            tSEInspectable.getInspectorPropertyIDs(df2);
            this.selectionPropertyIDs.put(tSEInspectable, df2);
        }
    }

    private List buildTablePropertyIDs() {
        Object object;
        Vector<TSEInspectorPropertyID> vector = new Vector<TSEInspectorPropertyID>();
        f3 f32 = new f3();
        if (this.inspectees.isEmpty()) {
            return vector;
        }
        Iterator iterator = this.inspectees.iterator();
        TSEInspectable tSEInspectable = (TSEInspectable)iterator.next();
        List list = (List)this.selectionPropertyIDs.get(tSEInspectable);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            f32.a(iterator2.next(), new hj());
        }
        while (iterator.hasNext()) {
            tSEInspectable = (TSEInspectable)iterator.next();
            list = (List)this.selectionPropertyIDs.get(tSEInspectable);
            iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                TSEInspectorPropertyID tSEInspectorPropertyID = (TSEInspectorPropertyID)iterator2.next();
                object = (hj)f32.c(tSEInspectorPropertyID);
                if (object == null) continue;
                ++((hj)object).a;
            }
        }
        int n = this.inspectees.size();
        object = f32.d();
        while (object.hasNext()) {
            TSEInspectorPropertyID tSEInspectorPropertyID = (TSEInspectorPropertyID)object.next();
            hj hj2 = (hj)f32.c(tSEInspectorPropertyID);
            if (hj2.a != n) continue;
            vector.add(tSEInspectorPropertyID);
        }
        return vector;
    }

    private void updateTableProperties(List list) {
        this.tableProperties.a();
        this.propertyLists.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSEInspectorPropertyID tSEInspectorPropertyID = (TSEInspectorPropertyID)iterator.next();
            Vector<TSEInspectorProperty> vector = new Vector<TSEInspectorProperty>();
            TSEInspectorProperty tSEInspectorProperty = null;
            Class clazz = tSEInspectorPropertyID.getValueClass();
            Iterator iterator2 = this.inspectees.iterator();
            while (iterator2.hasNext()) {
                TSEInspectable tSEInspectable = (TSEInspectable)iterator2.next();
                TSEInspectorProperty tSEInspectorProperty2 = tSEInspectable.getInspectorProperty(tSEInspectorPropertyID);
                vector.add(tSEInspectorProperty2);
                if (tSEInspectorProperty2 == null) continue;
                if (tSEInspectorProperty2.getValue() == null) {
                    throw new RuntimeException("Property \"" + tSEInspectorPropertyID.getName() + "\"'s value is null.");
                }
                Class<?> clazz2 = tSEInspectorProperty2.getValue().getClass();
                if (tSEInspectorPropertyID.isStrict() && !clazz2.equals(clazz) || !tSEInspectorPropertyID.isStrict() && !clazz2.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Property \"" + tSEInspectorPropertyID.getName() + "\"'s value is not of the type " + "that its propertyID requires. " + "Required type:" + clazz.getName() + ", actual type:" + clazz2.getName() + ", strict:" + tSEInspectorPropertyID.isStrict() + ".");
                }
                if (tSEInspectorProperty == null) {
                    tSEInspectorProperty = tSEInspectorProperty2.copy();
                }
                if (!tSEInspectorProperty.isRenderableWith(tSEInspectorProperty2)) {
                    tSEInspectorProperty.setValue(null);
                }
                if (tSEInspectorProperty.isEditableWith(tSEInspectorProperty2)) continue;
                tSEInspectorProperty.setEditable(false);
            }
            this.propertyLists.put(tSEInspectorPropertyID, vector);
            if (tSEInspectorProperty == null) continue;
            this.tableProperties.a(tSEInspectorPropertyID, tSEInspectorProperty);
        }
    }

    private void updateTableRows() {
        this.table.emptyProperties();
        Iterator iterator = this.tableProperties.d();
        while (iterator.hasNext()) {
            TSEInspectorPropertyID tSEInspectorPropertyID = (TSEInspectorPropertyID)iterator.next();
            this.table.addProperty(tSEInspectorPropertyID, (TSEInspectorProperty)this.tableProperties.c(tSEInspectorPropertyID));
        }
    }

    private void updateTable() {
        this.updateInspectees();
        this.fetchInspecteePropertyIDs();
        List list = this.buildTablePropertyIDs();
        this.updateTableProperties(list);
        this.updateTableRows();
    }

    protected void smartUpdateTable() {
        boolean bl;
        TSEGraphManager tSEGraphManager = this.parentWindow.getGraphManager();
        boolean bl2 = tSEGraphManager.hasSelectedNodes();
        boolean bl3 = tSEGraphManager.hasSelectedConnectors();
        boolean bl4 = tSEGraphManager.hasSelectedEdges(true);
        boolean bl5 = tSEGraphManager.hasSelectedPathNodes(true);
        boolean bl6 = bl = tSEGraphManager.hasSelectedNodeLabels() || tSEGraphManager.hasSelectedConnectorLabels() || tSEGraphManager.hasSelectedEdgeLabels(true);
        if (bl2 && this.nodeString != null) {
            this.comboBox.setSelectedItem(this.nodeString);
        } else if (bl3 && this.connectorString != null) {
            this.comboBox.setSelectedItem(this.connectorString);
        } else if (bl4 && this.edgeString != null) {
            this.comboBox.setSelectedItem(this.edgeString);
        } else if (!bl5 && !bl && this.graphString != null) {
            this.comboBox.setSelectedItem(this.graphString);
        } else if (bl5 && !bl && this.bendString != null) {
            this.comboBox.setSelectedItem(this.bendString);
        } else if (!bl5 && bl && this.labelString != null) {
            this.comboBox.setSelectedItem(this.labelString);
        } else if (this.allString != null) {
            this.comboBox.setSelectedItem(this.allString);
        }
    }

    public void cancelEdit() {
        this.table.removeEditor();
        this.comboBox.hidePopup();
    }

    public void update() {
        this.updateTimer.stop();
        if (this.ignoringUpdates) {
            this.needsUpdate = true;
        } else {
            this.cancelEdit();
            this.selectionPropertyIDs.clear();
            if (this.isSmartUpdating()) {
                this.smartUpdateTable();
            } else {
                this.updateTable();
            }
        }
    }

    public void setDefaultEditorsAndRenderers() {
        this.getTable().setDefaultPropertyEditor(class$com$tomsawyer$editor$inspector$TSEKeyValueInspectorProperty == null ? (class$com$tomsawyer$editor$inspector$TSEKeyValueInspectorProperty = TSEInspector.class$("com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty")) : class$com$tomsawyer$editor$inspector$TSEKeyValueInspectorProperty, new TSEKeyValueInspectorPropertyEditor());
        this.getTable().setDefaultPropertyEditor(class$com$tomsawyer$editor$inspector$TSEFilenameInspectorProperty == null ? (class$com$tomsawyer$editor$inspector$TSEFilenameInspectorProperty = TSEInspector.class$("com.tomsawyer.editor.inspector.TSEFilenameInspectorProperty")) : class$com$tomsawyer$editor$inspector$TSEFilenameInspectorProperty, new TSEFilenameInspectorPropertyEditor());
        this.getTable().setDefaultEditor(class$com$tomsawyer$editor$TSEFont == null ? (class$com$tomsawyer$editor$TSEFont = TSEInspector.class$("com.tomsawyer.editor.TSEFont")) : class$com$tomsawyer$editor$TSEFont, new TSEFontEditor());
        this.getTable().setDefaultEditor(class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSEInspector.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor, new TSEColorEditor());
        this.getTable().setDefaultEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = TSEInspector.class$("java.lang.Integer")) : class$java$lang$Integer, new TSEIntegerEditor());
        this.getTable().setDefaultEditor(class$java$lang$Double == null ? (class$java$lang$Double = TSEInspector.class$("java.lang.Double")) : class$java$lang$Double, new TSEDoubleEditor());
        this.getTable().setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = TSEInspector.class$("java.lang.String")) : class$java$lang$String, new TSETextEditor());
        this.getTable().setDefaultPropertyRenderer(class$com$tomsawyer$editor$inspector$TSEKeyValueInspectorProperty == null ? (class$com$tomsawyer$editor$inspector$TSEKeyValueInspectorProperty = TSEInspector.class$("com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty")) : class$com$tomsawyer$editor$inspector$TSEKeyValueInspectorProperty, new TSEKeyValueInspectorPropertyRenderer());
        this.getTable().setDefaultRenderer(class$com$tomsawyer$editor$TSEFont == null ? (class$com$tomsawyer$editor$TSEFont = TSEInspector.class$("com.tomsawyer.editor.TSEFont")) : class$com$tomsawyer$editor$TSEFont, new TSEFontRenderer());
        this.getTable().setDefaultRenderer(class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSEInspector.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor, new TSEColorRenderer());
        this.getTable().setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = TSEInspector.class$("java.lang.String")) : class$java$lang$String, new TSETextRenderer());
    }

    protected Class[] getSharedSelectionClasses() {
        return new Class[]{class$com$tomsawyer$editor$TSENode == null ? (class$com$tomsawyer$editor$TSENode = TSEInspector.class$("com.tomsawyer.editor.TSENode")) : class$com$tomsawyer$editor$TSENode, class$com$tomsawyer$editor$TSEEdge == null ? (class$com$tomsawyer$editor$TSEEdge = TSEInspector.class$("com.tomsawyer.editor.TSEEdge")) : class$com$tomsawyer$editor$TSEEdge, class$com$tomsawyer$editor$TSEEdgeLabel == null ? (class$com$tomsawyer$editor$TSEEdgeLabel = TSEInspector.class$("com.tomsawyer.editor.TSEEdgeLabel")) : class$com$tomsawyer$editor$TSEEdgeLabel, class$com$tomsawyer$editor$TSENodeLabel == null ? (class$com$tomsawyer$editor$TSENodeLabel = TSEInspector.class$("com.tomsawyer.editor.TSENodeLabel")) : class$com$tomsawyer$editor$TSENodeLabel, class$com$tomsawyer$editor$TSEConnectorLabel == null ? (class$com$tomsawyer$editor$TSEConnectorLabel = TSEInspector.class$("com.tomsawyer.editor.TSEConnectorLabel")) : class$com$tomsawyer$editor$TSEConnectorLabel, class$com$tomsawyer$editor$TSEGraph == null ? (class$com$tomsawyer$editor$TSEGraph = TSEInspector.class$("com.tomsawyer.editor.TSEGraph")) : class$com$tomsawyer$editor$TSEGraph};
    }

    public void onComboBoxEvent(ActionEvent actionEvent) {
        this.classList.clear();
        String string = (String)this.comboBox.getSelectedItem();
        if (string == null) {
            return;
        }
        if (string.equals(this.allString)) {
            Class[] classArray = this.getSharedSelectionClasses();
            if (classArray != null) {
                for (int i = 0; i < classArray.length; ++i) {
                    this.classList.add(classArray[i]);
                }
            }
        } else if (string.equals(this.graphString)) {
            this.classList.add(class$com$tomsawyer$editor$TSEGraph == null ? (class$com$tomsawyer$editor$TSEGraph = TSEInspector.class$("com.tomsawyer.editor.TSEGraph")) : class$com$tomsawyer$editor$TSEGraph);
        } else if (string.equals(this.nodeString)) {
            this.classList.add(class$com$tomsawyer$editor$TSENode == null ? (class$com$tomsawyer$editor$TSENode = TSEInspector.class$("com.tomsawyer.editor.TSENode")) : class$com$tomsawyer$editor$TSENode);
        } else if (string.equals(this.connectorString)) {
            this.classList.add(class$com$tomsawyer$editor$TSEConnector == null ? (class$com$tomsawyer$editor$TSEConnector = TSEInspector.class$("com.tomsawyer.editor.TSEConnector")) : class$com$tomsawyer$editor$TSEConnector);
        } else if (string.equals(this.edgeString)) {
            this.classList.add(class$com$tomsawyer$editor$TSEEdge == null ? (class$com$tomsawyer$editor$TSEEdge = TSEInspector.class$("com.tomsawyer.editor.TSEEdge")) : class$com$tomsawyer$editor$TSEEdge);
        } else if (string.equals(this.bendString)) {
            this.classList.add(class$com$tomsawyer$editor$TSEPNode == null ? (class$com$tomsawyer$editor$TSEPNode = TSEInspector.class$("com.tomsawyer.editor.TSEPNode")) : class$com$tomsawyer$editor$TSEPNode);
        } else if (string.equals(this.labelString)) {
            this.classList.add(class$com$tomsawyer$editor$TSEEdgeLabel == null ? (class$com$tomsawyer$editor$TSEEdgeLabel = TSEInspector.class$("com.tomsawyer.editor.TSEEdgeLabel")) : class$com$tomsawyer$editor$TSEEdgeLabel);
            this.classList.add(class$com$tomsawyer$editor$TSENodeLabel == null ? (class$com$tomsawyer$editor$TSENodeLabel = TSEInspector.class$("com.tomsawyer.editor.TSENodeLabel")) : class$com$tomsawyer$editor$TSENodeLabel);
            this.classList.add(class$com$tomsawyer$editor$TSEConnectorLabel == null ? (class$com$tomsawyer$editor$TSEConnectorLabel = TSEInspector.class$("com.tomsawyer.editor.TSEConnectorLabel")) : class$com$tomsawyer$editor$TSEConnectorLabel);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.updateTimer) {
            this.update();
        } else if (actionEvent.getActionCommand().equals(this.comboBox.getActionCommand())) {
            this.onComboBoxEvent(actionEvent);
            this.updateTable();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() != -1) {
            this.ignoringUpdates = true;
            TSEEventManager tSEEventManager = (TSEEventManager)this.getParentWindow().getGraphManager().getEventManager();
            int n = tSEEventManager.getContext();
            tSEEventManager.setContext(15);
            if (this.isUsingCommands()) {
                TSESetInspectorPropertyCommand tSESetInspectorPropertyCommand = new TSESetInspectorPropertyCommand(this, this.inspectees, this.propertyLists);
                for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                    tSESetInspectorPropertyCommand.add(this.table.getPropertyID(i), this.table.getProperty(i));
                }
                this.getParentWindow().transmit(tSESetInspectorPropertyCommand);
            } else {
                Iterator iterator = this.inspectees.iterator();
                while (iterator.hasNext()) {
                    TSEInspectable tSEInspectable = (TSEInspectable)iterator.next();
                    for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                        tSEInspectable.setInspectorProperty(this.table.getPropertyID(i), this.table.getProperty(i));
                    }
                }
            }
            tSEEventManager.setContext(n);
            this.ignoringUpdates = false;
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.cancelEdit();
                this.selectionPropertyIDs.clear();
                this.updateTable();
            }
        }
    }

    public TSEInspectorTable getTable() {
        return this.table;
    }

    protected TSEInspectorTable getDefaultTable() {
        return new TSEInspectorTable(this, this.getDefaultColumnNames());
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    protected JComboBox getDefaultComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.allString);
        jComboBox.addItem(this.graphString);
        jComboBox.addItem(this.nodeString);
        jComboBox.addItem(this.edgeString);
        jComboBox.addItem(this.labelString);
        jComboBox.addItem(this.connectorString);
        jComboBox.addItem(this.bendString);
        TSELocalization.setComponentOrientation(jComboBox);
        return jComboBox;
    }

    public void setActive(boolean bl) {
        this.unregisterListeners();
        if (bl && this.getParentWindow() != null) {
            this.registerListeners();
            this.cancelEdit();
            this.selectionPropertyIDs.clear();
            this.smartUpdateTable();
        } else {
            this.classList.clear();
            this.inspectees.clear();
            this.tableProperties.a();
            this.selectionPropertyIDs.clear();
            this.table.emptyProperties();
        }
    }

    public void registerListeners() {
        if (this.getParentWindow() == null) {
            return;
        }
        TSEGraphManager tSEGraphManager = this.getParentWindow().getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        tSEEventManager.addGraphChangeListener(tSEGraphManager, this.eventListener, 3584L);
        tSEEventManager.addDrawingChangeListener(tSEGraphManager, this.eventListener);
        tSEEventManager.addComplexityChangeListener(tSEGraphManager, this.eventListener, 3L);
        tSEEventManager.addSelectionChangeListener(tSEGraphManager, this.eventListener);
        tSEEventManager.addPropertyChangeListener(tSEGraphManager, this.eventListener);
        tSEEventManager.addServiceInputChangeListener(tSEGraphManager, this.eventListener);
    }

    public void unregisterListeners() {
        if (this.getParentWindow() != null) {
            this.getParentWindow().getGraphManager().getEventManager().removeListener(this.eventListener);
        }
    }

    protected boolean isUsingCommands() {
        return true;
    }

    public boolean isReadOnly() {
        return this.table.readOnly;
    }

    public TSEGraphWindow getGraphWindow() {
        return this.parentWindow;
    }

    public TSEGraphWindow getParentWindow() {
        return this.getGraphWindow();
    }

    public void setGraphWindow(TSEGraphWindow tSEGraphWindow) {
        this.setActive(false);
        this.parentWindow = tSEGraphWindow;
        if (tSEGraphWindow != null) {
            this.setActive(true);
            this.update();
        }
    }

    public void setParentWindow(TSEGraphWindow tSEGraphWindow) {
        this.setGraphWindow(tSEGraphWindow);
    }

    public void setReadOnly(boolean bl) {
        this.table.readOnly = bl;
    }

    public boolean isReadOnlyByDefault() {
        return false;
    }

    protected String[] getDefaultColumnNames() {
        return new String[]{TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely(DEFAULT_COLUMN_NAME_KEYS[0]), TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely(DEFAULT_COLUMN_NAME_KEYS[1])};
    }

    public boolean isSmartUpdating() {
        return true;
    }

    protected String getDefaultAllString() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Shared_Selection_Properties");
    }

    protected String getDefaultGraphString() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Selected_Graph_Properties");
    }

    protected String getDefaultNodeString() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Selected_Node_Properties");
    }

    protected String getDefaultConnectorString() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Selected_Connector_Properties");
    }

    protected String getDefaultEdgeString() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Selected_Edge_Properties");
    }

    protected String getDefaultBendString() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Selected_Bend_Properties");
    }

    protected String getDefaultLabelString() {
        return TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Selected_Label_Properties");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[] stringArray = new String[2];
        stringArray[0] = "Attribute";
        stringArray[1] = "Value";
        DEFAULT_COLUMN_NAME_KEYS = stringArray;
    }
}

