/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.inspector;

import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.inspector.TSEInspector;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TSENumericInspectorProperty
extends TSEInspectorProperty {
    public static final String LOWER_BOUND_SUBSTRING = "%X%";
    public static final String UPPER_BOUND_SUBSTRING = "%Y%";
    public static final String BETWEEN_TEMPLATE = "Please_enter_a_value_between_%X%_and_%Y%.";
    public static final String GREATER_THAN_TEMPLATE = "Please_enter_a_value_greater_than_%X%.";
    public static final String LESS_THAN_TEMPLATE = "Please_enter_a_value_less_than_%Y%.";
    private Number lowerBound;
    private Number upperBound;

    public TSENumericInspectorProperty(Number number) {
        super(number);
        this.init(null, null);
    }

    public TSENumericInspectorProperty(Number number, String string) {
        super((Object)number, string);
        this.init(null, null);
    }

    public TSENumericInspectorProperty(Number number, Number number2, Number number3) {
        super(number);
        this.init(number2, number3);
    }

    public TSENumericInspectorProperty(Number number, Number number2, Number number3, String string) {
        super((Object)number, string);
        this.init(number2, number3);
    }

    public TSENumericInspectorProperty(Number number, boolean bl) {
        super((Object)number, bl);
        this.init(null, null);
    }

    public TSENumericInspectorProperty(Number number, boolean bl, String string) {
        super(number, bl, string);
        this.init(null, null);
    }

    public TSENumericInspectorProperty(Number number, boolean bl, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        super(number, bl, tableCellRenderer, tableCellEditor);
        this.init(null, null);
    }

    public TSENumericInspectorProperty(Number number, boolean bl, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor, String string) {
        super(number, bl, tableCellRenderer, tableCellEditor, string);
        this.init(null, null);
    }

    public TSENumericInspectorProperty(Number number, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor, Number number2, Number number3) {
        super(number, true, tableCellRenderer, tableCellEditor);
        this.init(number2, number3);
    }

    public TSENumericInspectorProperty(Number number, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor, Number number2, Number number3, String string) {
        super(number, true, tableCellRenderer, tableCellEditor, string);
        this.init(number2, number3);
    }

    private void init(Number number, Number number2) {
        this.lowerBound = number;
        this.upperBound = number2;
    }

    protected boolean validateValue(Object object) {
        if (!super.validateValue(object)) {
            return false;
        }
        boolean bl = true;
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (this.lowerBound != null && d < this.lowerBound.doubleValue()) {
                bl = false;
            } else if (this.upperBound != null && d > this.upperBound.doubleValue()) {
                bl = false;
            }
        } else if (this.lowerBound != null || this.upperBound != null) {
            bl = false;
        }
        return bl;
    }

    protected void onInvalidValue(TSEInspector tSEInspector) {
        int n;
        if (this.lowerBound == null && this.upperBound == null) {
            super.onInvalidValue(tSEInspector);
            return;
        }
        String string = null;
        string = this.lowerBound != null && this.upperBound == null ? TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely(GREATER_THAN_TEMPLATE) : (this.lowerBound == null && this.upperBound != null ? TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely(LESS_THAN_TEMPLATE) : TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely(BETWEEN_TEMPLATE));
        String string2 = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Invalid_Value");
        int n2 = string.indexOf(LOWER_BOUND_SUBSTRING);
        if (n2 != -1) {
            string = string.substring(0, n2) + " " + this.lowerBound + " " + string.substring(n2 + LOWER_BOUND_SUBSTRING.length());
        }
        if ((n = string.indexOf(UPPER_BOUND_SUBSTRING)) != -1) {
            string = string.substring(0, n) + " " + this.upperBound + " " + string.substring(n + UPPER_BOUND_SUBSTRING.length());
        }
        JOptionPane.showMessageDialog(tSEInspector.getParentWindow(), string, string2, 0);
    }

    public Number getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Number number) {
        this.lowerBound = number;
    }

    public Number getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Number number) {
        this.upperBound = number;
    }

    public boolean isRenderableWith(TSEInspectorProperty tSEInspectorProperty) {
        return super.isRenderableWith(tSEInspectorProperty);
    }

    public boolean isEditableWith(TSEInspectorProperty tSEInspectorProperty) {
        if (!super.isEditableWith(tSEInspectorProperty)) {
            return false;
        }
        TSENumericInspectorProperty tSENumericInspectorProperty = (TSENumericInspectorProperty)tSEInspectorProperty;
        if (this.getLowerBound() != null ? !this.getLowerBound().equals(tSENumericInspectorProperty.getLowerBound()) : tSENumericInspectorProperty.getLowerBound() != null) {
            return false;
        }
        return !(this.getUpperBound() != null ? !this.getUpperBound().equals(tSENumericInspectorProperty.getUpperBound()) : tSENumericInspectorProperty.getUpperBound() != null);
    }
}

