/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.ct;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.f7;
import com.tomsawyer.editor.ui.TSECurvedEdgeUI;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public abstract class TSEBuildEdgeTool
extends TSEWindowInputTool {
    boolean isBuildingEdge = false;
    boolean inFirstClick = false;
    boolean mouseMoved = false;
    TSENode sourceNode;
    TSENode targetNode;
    TSEConnector sourceConnector;
    TSEConnector targetConnector;
    Vector pointList;
    TSConstPoint sourcePoint;
    TSConstPoint lastPoint;
    ct sourceClipping;
    ct targetClipping;
    Timer timer;
    MouseEvent event;
    TSEEdgeUI edgeUI;
    double arrowSize;
    boolean useAntiAliasing = false;

    public TSEBuildEdgeTool() {
        this.setCursors();
    }

    public TSEBuildEdgeTool(TSEWindowTool tSEWindowTool) {
        super(tSEWindowTool);
        this.setCursors();
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
            if (!this.isBuildingEdge()) {
                boolean bl = this.possibleSourceAt(tSConstPoint);
                if (bl) {
                    this.isBuildingEdge = true;
                    this.mouseMoved = false;
                    this.initBuildEdge();
                    this.addDirtyRegion(this.getSourceNode());
                    this.inFirstClick = true;
                }
            } else {
                boolean bl = this.possibleTargetAt(tSConstPoint);
                if (bl) {
                    boolean bl2 = this.canConnectEdge(tSConstPoint);
                    if (bl2) {
                        this.addDirtyRegion(this.getTargetNode());
                        if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                            this.getGraphWindow().deselectAll(false);
                        }
                        this.connectEdge();
                        this.isBuildingEdge = false;
                    } else {
                        boolean bl3 = this.canAddBendInSourceNode();
                        if (bl3) {
                            this.addBendPoint(tSConstPoint);
                        }
                    }
                } else if (this.mouseMoved && (this.pointList.size() != 1 || !this.pointList.contains(tSConstPoint))) {
                    this.addBendPoint(tSConstPoint);
                }
            }
            this.setLastPoint(tSConstPoint);
        } else {
            super.onMousePressed(mouseEvent);
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            if (this.isBuildingEdge()) {
                TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
                boolean bl = this.possibleTargetAt(tSConstPoint);
                if (bl) {
                    boolean bl2 = this.canConnectEdge(tSConstPoint);
                    if (bl2) {
                        this.addDirtyRegion(this.getTargetNode());
                        if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                            this.getGraphWindow().deselectAll(false);
                        }
                        this.connectEdge();
                        this.isBuildingEdge = false;
                    } else if (this.inFirstClick && this.canAddBendInSourceNode()) {
                        this.addBendPoint(tSConstPoint);
                    }
                } else if (this.inFirstClick) {
                    if (this.mouseMoved) {
                        this.addBendPoint(tSConstPoint);
                    } else {
                        this.cancelAction();
                    }
                }
                this.inFirstClick = false;
            }
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        if (this.isBuildingEdge()) {
            this.mouseMoved = true;
            TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
            this.setLastPoint(tSConstPoint);
            this.addDirtyRegion(this.lastPoint, this.arrowSize);
            if (!this.updateVisibleArea(tSConstPoint, true)) {
                this.paintDirtyRegion(false);
            }
        } else {
            super.onMouseMoved(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.isBuildingEdge()) {
            this.mouseMoved = true;
            TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
            this.setMouseEvent(mouseEvent);
            this.setLastPoint(tSConstPoint);
            this.addDirtyRegion(this.lastPoint, this.arrowSize);
            if (!this.updateVisibleArea(tSConstPoint, true)) {
                this.paintDirtyRegion(false);
            }
        }
    }

    public void onMouseEntered(MouseEvent mouseEvent) {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseExited(MouseEvent mouseEvent) {
        if (this.isBuildingEdge()) {
            if (this.timer == null) {
                this.timer = new Timer(50, new f7(this));
                this.timer.setCoalesce(true);
            }
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
            MouseEvent mouseEvent2 = mouseEvent;
            synchronized (mouseEvent2) {
                this.setMouseEvent(mouseEvent);
            }
        }
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.isBuildingEdge()) {
            Cloneable cloneable;
            Object object;
            TSConstPoint tSConstPoint;
            int n;
            Cloneable cloneable2;
            Color color = tSEGraphics.getColor();
            tSEGraphics.setColor(this.edgeUI.getLineColor().getColor());
            Object object2 = tSEGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (this.useAntiAliasing) {
                tSEGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                tSEGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            TSShape tSShape = null;
            TSConstPoint tSConstPoint2 = null;
            TSConstPoint tSConstPoint3 = null;
            if (this.sourceConnector != null) {
                tSShape = this.sourceConnector.getShape();
            } else if (this.sourceNode != null) {
                tSShape = this.sourceNode.getShape();
            }
            if (tSShape != null && this.sourceNode != null) {
                cloneable2 = (TSDGraph)this.sourceNode.getOwnerGraph();
                for (n = 0; n < this.pointList.size(); ++n) {
                    TSConstPoint tSConstPoint4 = (TSConstPoint)this.pointList.elementAt(n);
                    TSPoint tSPoint = new TSPoint(tSConstPoint4);
                    ((TSDGraph)cloneable2).inverseExpandedTransformPoint(tSPoint);
                    if (!tSShape.contains(tSPoint)) {
                        tSConstPoint2 = tSConstPoint4;
                        break;
                    }
                    if (this.sourceConnector != null) continue;
                    tSConstPoint3 = tSConstPoint4;
                }
            }
            TSConstPoint tSConstPoint5 = tSConstPoint2 != null ? tSConstPoint2 : this.lastPoint;
            if (tSConstPoint3 != null) {
                tSConstPoint = this.findClippingPoint(this.sourceNode, this.sourceConnector, this.sourceClipping, tSConstPoint3, tSConstPoint5);
            } else if (this.sourceClipping != null && this.sourceClipping.c()) {
                cloneable2 = new TSRect(tSShape.getBounds());
                ((TSEGraph)this.sourceNode.getOwnerGraph()).expandedTransformRect((TSRect)cloneable2);
                tSConstPoint = this.findClippingPoint(this.sourceNode, this.sourceConnector, this.sourceClipping, this.sourceClipping.a((TSConstRect)cloneable2), tSConstPoint5);
            } else {
                tSConstPoint = this.findClippingPoint(this.sourceNode, this.sourceConnector, this.sourceClipping, this.sourcePoint, tSConstPoint5);
            }
            boolean bl = true;
            n = 1;
            Stroke stroke = tSEGraphics.getStroke();
            TSEGraphics tSEGraphics2 = this.edgeUI.convertGraphics(tSEGraphics);
            Cloneable cloneable3 = null;
            TSConstPoint tSConstPoint6 = null;
            TSShape tSShape2 = null;
            if (this.targetConnector != null) {
                tSShape2 = this.targetConnector.getShape();
            } else if (this.targetNode != null) {
                tSShape2 = this.targetNode.getShape();
            }
            if (tSShape2 != null && this.targetNode != null) {
                TSDGraph tSDGraph = (TSDGraph)this.targetNode.getOwnerGraph();
                for (int i = this.pointList.size() - 1; i >= 0; --i) {
                    TSConstPoint tSConstPoint7 = (TSConstPoint)this.pointList.elementAt(i);
                    object = new TSPoint(tSConstPoint7);
                    tSDGraph.inverseExpandedTransformPoint((TSPoint)object);
                    if (!tSShape2.contains((TSConstPoint)object)) break;
                    if (this.targetConnector != null) continue;
                    tSConstPoint6 = tSConstPoint7;
                }
            }
            boolean bl2 = this.edgeUI instanceof TSECurvedEdgeUI;
            Vector<Object> vector = null;
            if (bl2) {
                vector = new Vector<Object>();
            }
            boolean bl3 = false;
            if (tSConstPoint3 == null) {
                bl3 = true;
            }
            if (!this.pointList.isEmpty()) {
                n = 0;
                object = this.pointList.iterator();
                while (object.hasNext() && tSConstPoint != tSConstPoint6) {
                    boolean bl4;
                    cloneable = (TSConstPoint)object.next();
                    if (bl) {
                        this.addDirtyRegion(tSConstPoint, this.arrowSize);
                    }
                    if (!bl3 && cloneable == tSConstPoint2) {
                        bl3 = true;
                    } else if (bl3 && cloneable == tSConstPoint6) break;
                    if (!bl3) continue;
                    boolean bl5 = bl4 = bl && (this.edgeUI.getArrowType() & 1) != 0;
                    if (bl2) {
                        vector.add(tSConstPoint);
                    } else if (bl4) {
                        this.edgeUI.drawLineWithArrow(tSEGraphics2, tSConstPoint.getX(), tSConstPoint.getY(), ((TSConstPoint)cloneable).getX(), ((TSConstPoint)cloneable).getY(), true, false, true, true);
                    } else {
                        tSEGraphics2.drawLine(tSConstPoint, (TSConstPoint)cloneable);
                    }
                    cloneable3 = cloneable;
                    tSConstPoint = cloneable;
                    bl = false;
                }
                n = 1;
            }
            boolean bl6 = bl && (this.edgeUI.getArrowType() & 1) != 0;
            boolean bl7 = n != 0 && (this.edgeUI.getArrowType() & 2) != 0;
            object = null;
            if (tSConstPoint6 == null) {
                if (this.targetClipping != null && this.targetClipping.c()) {
                    cloneable = new TSRect(tSShape2.getBounds());
                    ((TSEGraph)this.targetNode.getOwnerGraph()).expandedTransformRect((TSRect)cloneable);
                    object = this.targetClipping.a((TSConstRect)cloneable);
                    object = this.findClippingPoint(this.targetNode, this.targetConnector, this.targetClipping, (TSConstPoint)object, tSConstPoint);
                } else {
                    object = this.findClippingPoint(this.targetNode, this.targetConnector, this.targetClipping, this.lastPoint, tSConstPoint);
                }
            } else {
                if (cloneable3 != null) {
                    tSConstPoint = cloneable3;
                }
                object = this.findClippingPoint(this.targetNode, this.targetConnector, this.targetClipping, tSConstPoint, tSConstPoint6);
            }
            if (tSConstPoint != null && object != null) {
                this.addDirtyRegion((TSConstPoint)object, this.arrowSize);
                if (bl2) {
                    vector.add(tSConstPoint);
                    vector.add(object);
                    this.paintCurve(tSEGraphics2, vector);
                } else {
                    cloneable = null;
                    if (bl6 || bl7) {
                        this.edgeUI.drawLineWithArrow(tSEGraphics2, tSConstPoint.getX(), tSConstPoint.getY(), ((TSConstPoint)object).getX(), ((TSConstPoint)object).getY(), bl6, bl7, true, true);
                        if (bl6) {
                            cloneable = new TSConstRect(tSConstPoint.getX() - this.edgeUI.getArrowWidth(), tSConstPoint.getY() - this.edgeUI.getArrowHeight(), tSConstPoint.getX() + this.edgeUI.getArrowWidth(), tSConstPoint.getY() + this.edgeUI.getArrowHeight());
                        } else if (bl7) {
                            cloneable = new TSConstRect(((TSConstPoint)object).getX() - this.edgeUI.getArrowWidth(), ((TSConstPoint)object).getY() - this.edgeUI.getArrowHeight(), ((TSConstPoint)object).getX() + this.edgeUI.getArrowWidth(), ((TSConstPoint)object).getY() + this.edgeUI.getArrowHeight());
                        }
                    } else {
                        tSEGraphics2.drawLine(tSConstPoint, (TSConstPoint)object);
                        cloneable = new TSConstRect(tSConstPoint, (TSConstPoint)object);
                    }
                    this.addDirtyRegion((TSConstRect)cloneable);
                }
            }
            tSEGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            tSEGraphics.setColor(color);
            tSEGraphics.setStroke(stroke);
        }
    }

    private void paintCurve(TSEGraphics tSEGraphics, List list) {
        Object object;
        Object object2;
        Object object3;
        TSECurvedEdgeUI tSECurvedEdgeUI = null;
        if (!(this.edgeUI instanceof TSECurvedEdgeUI)) {
            return;
        }
        tSECurvedEdgeUI = (TSECurvedEdgeUI)this.edgeUI;
        if (list.isEmpty()) {
            tSEGraphics.drawLine((TSConstPoint)list.get(0), (TSConstPoint)list.get(list.size() - 1));
        } else {
            object3 = tSEGraphics.getStroke();
            object2 = tSECurvedEdgeUI.getControlLineStroke();
            tSEGraphics.setStroke((Stroke)object2);
            object = new TSConstPoint[list.size()];
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                TSConstPoint tSConstPoint = (TSConstPoint)iterator.next();
                object[n++] = tSConstPoint;
            }
            n = 0;
            while (n < ((TSConstPoint[])object).length - 1) {
                tSECurvedEdgeUI.drawControlLine(tSEGraphics, object[n], object[++n]);
            }
            tSEGraphics.setStroke((Stroke)object3);
            tSECurvedEdgeUI.drawCurve(tSEGraphics, (TSConstPoint[])object);
        }
        if ((tSECurvedEdgeUI.getArrowType() & 1) != 0) {
            object3 = (TSConstPoint)list.get(0);
            object2 = (TSConstPoint)list.get(1);
            tSECurvedEdgeUI.drawArrow(tSEGraphics, ((TSConstPoint)object3).getX(), ((TSConstPoint)object3).getY(), ((TSConstPoint)object2).getX(), ((TSConstPoint)object2).getY(), true, false, true, true);
        }
        if ((tSECurvedEdgeUI.getArrowType() & 2) != 0) {
            int n = list.size();
            object2 = (TSConstPoint)list.get(n - 1);
            object = (TSConstPoint)list.get(n - 2);
            tSECurvedEdgeUI.drawArrow(tSEGraphics, ((TSConstPoint)object2).getX(), ((TSConstPoint)object2).getY(), ((TSConstPoint)object).getX(), ((TSConstPoint)object).getY(), true, false, true, true);
        }
    }

    private TSConstPoint findClippingPoint(TSENode tSENode, TSEConnector tSEConnector, ct ct2, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        TSConstPoint tSConstPoint3;
        if (tSENode == null) {
            tSConstPoint3 = tSConstPoint;
        } else {
            TSPoint tSPoint = new TSPoint(tSConstPoint);
            TSPoint tSPoint2 = new TSPoint(tSConstPoint2);
            TSEGraph tSEGraph = (TSEGraph)tSENode.getOwnerGraph();
            TSShape tSShape = null;
            if (tSEConnector != null) {
                tSShape = tSEConnector.getShape();
            } else if (tSENode != null) {
                tSShape = tSENode.getShape();
            }
            tSEGraph.inverseExpandedTransformPoint(tSPoint);
            tSEGraph.inverseExpandedTransformPoint(tSPoint2);
            tSConstPoint2 = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
            if (tSConstPoint2 != null) {
                tSPoint2 = new TSPoint(tSConstPoint2);
                tSEGraph.expandedTransformPoint(tSPoint2);
            } else {
                tSPoint2 = null;
            }
            tSConstPoint3 = tSPoint2;
            if (tSConstPoint3 == null) {
                if (ct2 != null && tSShape != null) {
                    TSRect tSRect = new TSRect(tSShape.getBounds());
                    boolean bl = tSEGraph.expandedTransformRect(tSRect);
                    if (!bl) {
                        tSRect = new TSRect(tSShape.getBounds());
                    }
                    tSConstPoint3 = ct2.a(tSRect);
                } else {
                    tSConstPoint3 = tSEConnector != null ? tSEConnector.getCenter() : tSConstPoint2;
                }
            }
        }
        return tSConstPoint3;
    }

    public abstract boolean possibleSourceAt(TSConstPoint var1);

    public boolean possibleTargetAt(TSConstPoint tSConstPoint) {
        this.targetNode = null;
        this.targetConnector = null;
        if (this.isBuildingEdge()) {
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            this.targetConnector = tSEHitTesting.getConnectorAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            this.targetNode = this.targetConnector == null ? tSEHitTesting.getNodeAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled()) : (TSENode)this.targetConnector.getOwner();
        }
        return this.targetNode != null;
    }

    public boolean canConnectEdge(TSConstPoint tSConstPoint) {
        boolean bl = false;
        if (this.isBuildingEdge() && this.targetNode != null) {
            if (this.targetNode != this.sourceNode) {
                bl = true;
            } else if (this.sourceConnector != null) {
                if (this.targetConnector != null && !this.pointList.isEmpty()) {
                    bl = true;
                } else if (this.targetConnector != null && this.sourceConnector != this.targetConnector) {
                    bl = true;
                } else if (!this.allBendsInSourceNode()) {
                    bl = true;
                }
            } else if (!this.pointList.isEmpty()) {
                bl = true;
            }
        }
        if (!bl) {
            this.targetConnector = null;
            this.targetNode = null;
        }
        return bl;
    }

    protected abstract void initBuildEdge();

    public abstract void connectEdge();

    public void addBendPoint(TSConstPoint tSConstPoint) {
        if (tSConstPoint == null) {
            throw new IllegalArgumentException("null point");
        }
        this.pointList.add(tSConstPoint);
    }

    private boolean canAddBendInSourceNode() {
        boolean bl = false;
        if (this.isBuildingEdge() && this.sourceConnector != null && (!this.inFirstClick || this.targetNode != null) && this.targetConnector == null && this.allBendsInSourceNode()) {
            bl = true;
        }
        return bl;
    }

    private boolean allBendsInSourceNode() {
        TSShape tSShape = null;
        if (this.sourceConnector != null) {
            tSShape = this.sourceConnector.getShape();
        } else if (this.sourceNode != null) {
            tSShape = this.sourceNode.getShape();
        }
        boolean bl = true;
        Iterator iterator = this.pointList.iterator();
        while (iterator.hasNext()) {
            TSPoint tSPoint = new TSPoint((TSConstPoint)iterator.next());
            ((TSDGraph)this.sourceNode.getOwnerGraph()).inverseExpandedTransformPoint(tSPoint);
            if (tSShape.contains(tSPoint)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setCursors() {
    }

    public void cancelAction() {
        this.setDirtyRegion(null);
        if (this.isBuildingEdge()) {
            this.isBuildingEdge = false;
            this.mouseMoved = false;
            this.pointList = null;
            this.sourceNode = null;
            this.getGraphWindow().fastRepaint();
        }
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.setMouseEvent(null);
    }

    public void resetTool() {
        this.isBuildingEdge = false;
        this.mouseMoved = false;
        this.pointList = null;
        this.sourceNode = null;
        this.sourceClipping = null;
        this.targetClipping = null;
        if (this.getGraphWindow() != null) {
            this.getGraphWindow().fastRepaint();
        }
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.setMouseEvent(null);
        super.resetTool();
    }

    public void finalizeTool() {
        super.finalizeTool();
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public List getBendPositions() {
        return this.pointList;
    }

    public TSENode getSourceNode() {
        return this.sourceNode;
    }

    protected void setSourceNode(TSENode tSENode) {
        this.sourceNode = tSENode;
    }

    public TSEConnector getSourceConnector() {
        return this.sourceConnector;
    }

    protected void setSourceConnector(TSEConnector tSEConnector) {
        this.sourceConnector = tSEConnector;
    }

    public TSENode getTargetNode() {
        return this.targetNode;
    }

    protected void setTargetNode(TSENode tSENode) {
        this.targetNode = tSENode;
    }

    public TSEConnector getTargetConnector() {
        return this.targetConnector;
    }

    protected void setTargetConnector(TSEConnector tSEConnector) {
        this.targetConnector = tSEConnector;
    }

    public TSConstPoint getLastPoint() {
        return this.lastPoint;
    }

    protected void setLastPoint(TSConstPoint tSConstPoint) {
        this.lastPoint = tSConstPoint;
    }

    public List getPointList() {
        return this.pointList;
    }

    protected void setPointList(Vector vector) {
        this.pointList = vector;
    }

    public MouseEvent getMouseEvent() {
        return this.event;
    }

    protected void setMouseEvent(MouseEvent mouseEvent) {
        this.event = mouseEvent;
    }

    public boolean isBuildingEdge() {
        return this.isBuildingEdge;
    }

    public void setBuildingEdge(boolean bl) {
        this.isBuildingEdge = bl;
    }
}

