/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.tool.TSEBuildEdgeTool;
import com.tomsawyer.util.f2;
import java.util.Vector;

public class TSECreateEdgeTool
extends TSEBuildEdgeTool {
    private boolean typeSpecified = false;
    int edgeType = 0;

    public TSECreateEdgeTool() {
        f2.a(f2.bq);
        this.typeSpecified = false;
    }

    public TSECreateEdgeTool(int n) {
        this();
        this.typeSpecified = true;
        this.setType(n);
    }

    public boolean possibleSourceAt(TSConstPoint tSConstPoint) {
        this.sourceNode = null;
        this.sourceConnector = null;
        if (!this.isBuildingEdge) {
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            this.sourceConnector = tSEHitTesting.getConnectorAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            this.sourceNode = this.sourceConnector == null ? tSEHitTesting.getNodeAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled()) : (TSENode)this.sourceConnector.getOwner();
        }
        return this.sourceNode != null;
    }

    protected void initBuildEdge() {
        this.edgeUI = this.getGraphWindow().getCurrentEdgeUI();
        this.arrowSize = Math.max(this.edgeUI.getArrowHeight(), this.edgeUI.getArrowWidth());
        this.pointList = new Vector();
        this.addDirtyRegion(this.sourceNode);
        this.sourcePoint = this.sourceConnector != null ? this.sourceConnector.getCenter() : this.sourceNode.getCenter();
    }

    public void connectEdge() {
        this.setDirtyRegion(null);
        TSEEdge tSEEdge = null;
        if (this.sourceNode != this.targetNode || !this.pointList.isEmpty() || this.sourceConnector != null) {
            TSEGraph tSEGraph = this.sourceNode.getOwnerGraph() == this.targetNode.getOwnerGraph() ? (TSEGraph)this.sourceNode.getOwnerGraph() : (TSEGraph)this.getGraphWindow().getGraphManager().intergraph();
            int n = this.getEventManager().getContext();
            this.getEventManager().setContext(this.getEventContext());
            tSEEdge = this.typeSpecified ? this.getGraphWindow().addEdge(this.edgeType, this.sourceNode, this.targetNode, this.pointList, null, tSEGraph) : this.getGraphWindow().addEdge(this.sourceNode, this.targetNode, this.pointList, null, tSEGraph);
            if (this.sourceConnector != null) {
                tSEEdge.setSourceConnector(this.sourceConnector);
            }
            if (this.targetConnector != null) {
                tSEEdge.setTargetConnector(this.targetConnector);
            }
            this.getEventManager().setContext(n);
            this.getGraphWindow().drawGraph();
            this.getGraphWindow().fastRepaint();
        }
        this.pointList = null;
        this.sourceNode = null;
        this.sourceConnector = null;
        this.targetNode = null;
        this.targetConnector = null;
        this.isBuildingEdge = false;
    }

    public void setCursors() {
        this.setDefaultCursor(TSECursorManager.getCursor("CreateEdge.32x32", 1));
        this.setActionCursor(TSECursorManager.getCursor("CreateEdge.32x32", 1));
    }

    public int getType() {
        return this.edgeType;
    }

    public void setType(int n) {
        if (n != 0) {
            this.typeSpecified = true;
            this.edgeType = n;
        }
    }

    public int getEventContext() {
        return 2;
    }
}

