/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.command.TSEAddNodeCommand;
import com.tomsawyer.editor.command.TSEInsertNodeCommand;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.f7;
import com.tomsawyer.util.f2;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public class TSECreateNodeTool
extends TSEWindowInputTool {
    private TSEGraph selectedGraph;
    private boolean typeSpecified = false;
    int nodeType = 0;
    TSENode virtualNode;
    boolean whileCreating;
    Timer timer;
    MouseEvent event;
    boolean discardVirtualNode;
    List graphs;
    List margins;

    public TSECreateNodeTool() {
        f2.a(f2.bq);
        this.typeSpecified = false;
        this.setDefaultCursor(TSECursorManager.getCursor("CreateNode.32x32", 12));
        this.setActionCursor(TSECursorManager.getCursor("CreateNode.32x32", 12));
        this.setDiscardVirtualNode(this.isDiscardVirtualNodeByDefault());
    }

    public TSECreateNodeTool(int n) {
        this();
        this.typeSpecified = true;
        this.setType(n);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            this.selectedGraph = this.getGraph();
            if (this.getGraphWindow().isNestedGraphEditingEnabled()) {
                this.selectedGraph = tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph());
            }
            this.storeOldMargins();
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.virtualNode = this.createVirtualNode(tSConstPoint);
            this.selectedGraph.remove(this.virtualNode);
            this.virtualNode.setUI((TSEObjectUI)this.getGraphWindow().getCurrentNodeUI().clone());
            this.virtualNode.setCenter(tSConstPoint.getX(), tSConstPoint.getY());
            this.virtualNode.ltUpdateBoundsOfLabels();
            this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(bl);
            this.whileCreating = true;
            this.getGraphWindow().drawGraph();
            this.getGraphWindow().fastRepaint();
        } else {
            super.onMousePressed(mouseEvent);
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            if (this.whileCreating) {
                this.whileCreating = false;
                TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
                boolean bl = this.getEventManager().isCoalesce();
                this.getEventManager().setCoalesce(true);
                int n = this.getEventManager().getContext();
                this.getEventManager().setContext(this.getEventContext());
                if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                    this.getGraphWindow().deselectAll(false);
                }
                this.createNode(tSConstPoint);
                this.getEventManager().setCoalesce(bl);
                this.getEventManager().setContext(n);
                this.virtualNode = null;
                if (this.timer != null) {
                    this.timer.stop();
                }
            }
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.whileCreating) {
            TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
            this.addDirtyRegion(this.virtualNode.getBounds(7));
            this.addDirtyRegion(this.virtualNode);
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.virtualNode.setCenter(tSConstPoint);
            this.virtualNode.ltUpdateBoundsOfLabels();
            this.getEventManager().setFireEvents(bl);
            this.addDirtyRegion(this.virtualNode.getBounds(7));
            this.addDirtyRegion(this.virtualNode);
            this.event = mouseEvent;
            if (!this.updateVisibleArea(tSConstPoint, true)) {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                this.paintDirtyRegion(true);
            } else {
                if (this.timer == null) {
                    this.timer = new Timer(50, new f7(this));
                    this.timer.setCoalesce(true);
                }
                if (!this.timer.isRunning()) {
                    this.timer.start();
                }
                MouseEvent mouseEvent2 = mouseEvent;
                synchronized (mouseEvent2) {
                    this.setMouseEvent(mouseEvent);
                }
            }
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.selectedGraph == null) {
            return;
        }
        TSEGraphics tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), this.selectedGraph.getLocalToMainDisplayGraphTransform()));
        if (this.whileCreating) {
            if (this.getGraphWindow().isDrawFullUIOnDragging()) {
                this.virtualNode.getUI().drawSelected(tSEGraphics2);
            } else {
                this.virtualNode.getUI().drawSelectedOutline(tSEGraphics2);
            }
            if (this.virtualNode.numberOfLabels() > 0) {
                Iterator iterator = this.virtualNode.labels().iterator();
                while (iterator.hasNext()) {
                    TSENodeLabel tSENodeLabel = (TSENodeLabel)iterator.next();
                    tSENodeLabel.getUI().draw(tSEGraphics2);
                }
            }
        }
    }

    public void cancelAction() {
        if (this.whileCreating) {
            this.whileCreating = false;
            this.getGraphWindow().addInvalidRegion(this.virtualNode);
            this.getGraphWindow().updateInvalidRegion(true);
            if (this.timer != null) {
                this.timer.stop();
            }
            this.virtualNode = null;
        }
    }

    public void resetTool() {
        this.whileCreating = false;
        this.virtualNode = null;
        this.setCursor(this.getDefaultCursor());
        if (this.timer != null) {
            this.timer.stop();
        }
        super.resetTool();
    }

    TSENode createVirtualNode(TSConstPoint tSConstPoint) {
        boolean bl = this.selectedGraph.isBoundsUpdatingEnabled();
        this.selectedGraph.setBoundsUpdatingEnabled(false);
        TSENode tSENode = this.typeSpecified ? (TSENode)this.selectedGraph.addNode(this.nodeType) : (TSENode)this.selectedGraph.addNode();
        if (this.getGraphWindow().isNodeCreatedWithLabel()) {
            TSENodeLabel tSENodeLabel = (TSENodeLabel)tSENode.addLabel();
            tSENodeLabel.setDefaultOffset();
            tSENodeLabel.setUI((TSEObjectUI)this.getGraphWindow().getCurrentLabelUI().clone());
        }
        this.selectedGraph.setBoundsUpdatingEnabled(bl);
        return tSENode;
    }

    public void createNode(TSConstPoint tSConstPoint) {
        if (!this.isDiscardVirtualNode()) {
            TSEInsertNodeCommand tSEInsertNodeCommand = new TSEInsertNodeCommand(this.selectedGraph, this.virtualNode);
            this.getGraphWindow().transmit(tSEInsertNodeCommand);
            tSEInsertNodeCommand.setMarginLists(this.graphs, this.margins);
        } else if (this.typeSpecified) {
            TSEAddNodeCommand tSEAddNodeCommand = new TSEAddNodeCommand(this.nodeType, this.selectedGraph, tSConstPoint.getX(), tSConstPoint.getY(), this.getGraphWindow().getCurrentNodeUI(), this.getGraphWindow().isNodeCreatedWithLabel());
            this.getGraphWindow().transmit(tSEAddNodeCommand);
            tSEAddNodeCommand.setMarginLists(this.graphs, this.margins);
        } else {
            TSEAddNodeCommand tSEAddNodeCommand = new TSEAddNodeCommand(this.selectedGraph, tSConstPoint.getX(), tSConstPoint.getY(), this.getGraphWindow().getCurrentNodeUI(), this.getGraphWindow().isNodeCreatedWithLabel());
            this.getGraphWindow().transmit(tSEAddNodeCommand);
            tSEAddNodeCommand.setMarginLists(this.graphs, this.margins);
        }
    }

    public void setType(int n) {
        if (n != 0) {
            this.typeSpecified = true;
            this.nodeType = n;
        }
    }

    public void setDiscardVirtualNode(boolean bl) {
        this.discardVirtualNode = bl;
    }

    public int getType() {
        return this.nodeType;
    }

    protected TSENode getVirtualNode() {
        return this.virtualNode;
    }

    public MouseEvent getMouseEvent() {
        return this.event;
    }

    public void setMouseEvent(MouseEvent mouseEvent) {
        this.event = mouseEvent;
    }

    public boolean isDiscardVirtualNode() {
        return this.discardVirtualNode;
    }

    public boolean isDiscardVirtualNodeByDefault() {
        return false;
    }

    public TSEGraph getSelectedGraph() {
        return this.selectedGraph;
    }

    private void storeOldMargins() {
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        if (tSEGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSEGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSEGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    public int getEventContext() {
        return 1;
    }
}

