/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f2;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class TSECreatePNodeTool
extends TSEWindowInputTool {
    TSEGraph selectedGraph;
    TSEPNode virtualBend;
    TSEEdge edge;
    TSPEdge pathSegment;
    TSConstPoint startPoint;

    public TSECreatePNodeTool(TSEWindowInputTool tSEWindowInputTool, TSConstPoint tSConstPoint) {
        super(tSEWindowInputTool);
        f2.a(f2.bq);
        TSSystem.tsAssert(tSEWindowInputTool != null);
        TSSystem.tsAssert(tSConstPoint != null);
        this.setDefaultCursor(TSECursorManager.getCursor("OnEdge.32x32", 1));
        this.setActionCursor(TSECursorManager.getCursor("OnEdge.32x32", 1));
        this.startPoint = tSConstPoint;
    }

    protected void init() {
        super.init();
        this.selectedGraph = this.getGraphWindow().getGraph();
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        this.edge = tSEHitTesting.getEdgeAt(this.startPoint, this.selectedGraph, this.getGraphWindow().isNestedGraphEditingEnabled());
        this.selectedGraph = (TSEGraph)this.edge.getTransformGraph();
        this.pathSegment = this.edge.isCurved() ? tSEHitTesting.getClosestPathEdge(this.startPoint, this.edge) : tSEHitTesting.getPathEdgeAt(this.startPoint, this.selectedGraph, this.getGraphWindow().isNestedGraphEditingEnabled());
        if (this.pathSegment == null) {
            this.finalizeTool();
        }
        boolean bl = this.getEventManager().isFiringEvents();
        this.getEventManager().setFireEvents(false);
        this.virtualBend = (TSEPNode)this.edge.addPathNode(this.pathSegment, this.startPoint);
        this.virtualBend.setUI((TSEObjectUI)this.getGraphWindow().getCurrentPathNodeUI().clone());
        this.virtualBend.setSelected(true);
        this.getEventManager().setFireEvents(bl);
        this.edge.setVisible(false);
        this.getGraphWindow().addInvalidRegion(this.edge);
        this.getGraphWindow().addInvalidRegion(this.edge.labels());
        this.getGraphWindow().updateInvalidRegion(true);
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            TSSystem.tsAssert(this.pathSegment.isOwned());
            TSSystem.tsAssert(this.pathSegment.getOwner() == this.edge);
            this.edge.setVisible(true);
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.edge.discard(this.virtualBend);
            this.getEventManager().setFireEvents(bl);
            this.virtualBend = null;
            this.createPathNode(this.getWorldPoint(mouseEvent));
            this.finalizeTool();
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
        this.updateDirtyRegion();
        boolean bl = this.getEventManager().isFiringEvents();
        this.getEventManager().setFireEvents(false);
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        ((TSEGraph)this.virtualBend.getTransformGraph()).inverseExpandedTransformPoint(tSPoint);
        this.virtualBend.assignCenter(tSPoint.getX(), tSPoint.getY());
        this.getEventManager().setFireEvents(bl);
        this.updateDirtyRegion();
        if (!this.updateVisibleArea(tSConstPoint, true)) {
            this.paintDirtyRegion(true);
        }
    }

    void updateDirtyRegion() {
        this.addDirtyRegion(this.edge.getUI().getInvalidRegion(this.getGraphWindow().getTransform(), this.selectedGraph.getLocalToMainDisplayGraphTransform()));
        this.addDirtyRegion(this.edge.labels());
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.selectedGraph == null) {
            return;
        }
        TSEGraphics tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), this.selectedGraph.getLocalToMainDisplayGraphTransform()));
        if (this.getGraphWindow().isDrawFullUIOnDragging()) {
            this.edge.getUI().drawSelected(tSEGraphics2);
            this.edge.getEdgeUI().drawAllBends(tSEGraphics2);
            Iterator iterator = this.edge.labels().iterator();
            while (iterator.hasNext()) {
                TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator.next();
                if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !tSEEdgeLabel.isVisible()) continue;
                if (tSEEdgeLabel.isSelected()) {
                    tSEEdgeLabel.getUI().drawSelected(tSEGraphics2);
                    continue;
                }
                tSEEdgeLabel.getUI().draw(tSEGraphics2);
            }
        } else {
            this.edge.getUI().drawSelectedOutline(tSEGraphics2);
            this.edge.getEdgeUI().drawAllBendOutlines(tSEGraphics2);
            Iterator iterator = this.edge.labels().iterator();
            while (iterator.hasNext()) {
                TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator.next();
                if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !tSEEdgeLabel.isVisible()) continue;
                if (tSEEdgeLabel.isSelected()) {
                    tSEEdgeLabel.getUI().drawSelectedOutline(tSEGraphics2);
                    continue;
                }
                tSEEdgeLabel.getUI().drawOutline(tSEGraphics2);
            }
        }
    }

    public void cancelAction() {
        this.edge.setVisible(true);
        this.getGraphWindow().addInvalidRegion(this.edge.getBounds(7));
        if (this.edge.getSourceNode() != null) {
            this.getGraphWindow().addInvalidRegion(((TSENode)this.edge.getSourceNode()).getBounds(4));
        }
        if (this.edge.getTargetNode() != null) {
            this.getGraphWindow().addInvalidRegion(((TSENode)this.edge.getTargetNode()).getBounds(4));
        }
        boolean bl = this.getEventManager().isFiringEvents();
        this.getEventManager().setFireEvents(false);
        this.edge.discard(this.virtualBend);
        this.getEventManager().setFireEvents(bl);
        this.virtualBend = null;
        this.getGraphWindow().updateInvalidRegion(true);
        this.finalizeTool();
    }

    public void createPathNode(TSConstPoint tSConstPoint) {
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        this.getGraphWindow().addPathNode(tSConstPoint.getX(), tSConstPoint.getY(), this.pathSegment);
        this.getEventManager().setContext(n);
    }

    public TSEPNode getVirtualPathNode() {
        return this.virtualBend;
    }

    public TSEEdge getEdge() {
        return this.edge;
    }

    public TSPEdge getPathEdge() {
        return this.pathSegment;
    }

    public TSConstPoint getStartPoint() {
        return this.startPoint;
    }

    public int getEventContext() {
        return 6;
    }
}

