/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.command.TSESetTagCommand;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.editor.tool.ik;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class TSEEditTextTool
extends TSEWindowInputTool
implements DocumentListener,
ActionListener,
KeyListener {
    TSConstRect oldBounds;
    TSESolidObject object;
    TSEAnnotatedUI objectUI;
    JTextComponent textCompo;
    Object oldTagValue;
    int maximumFontSize;
    int minimumFontSize;
    List affectedObjects;
    TSConstSize oldSize;

    public TSEEditTextTool(TSEWindowTool tSEWindowTool, TSESolidObject tSESolidObject) {
        super(tSEWindowTool);
        TSSystem.tsAssert(tSEWindowTool != null);
        this.object = tSESolidObject;
        this.objectUI = (TSEAnnotatedUI)this.object.getUI();
        this.oldTagValue = this.object.getTag();
        this.setDefaultCursor(TSECursorManager.getCursor("EditText.32x32", 2));
        this.setActionCursor(TSECursorManager.getCursor("EditText.32x32", 2));
        this.textCompo = this.createDefaultTextComponent();
        this.textCompo.setText(tSESolidObject.getText());
        this.textCompo.setLocation(-100, -100);
        this.textCompo.setSize(1, 1);
        this.setMaximumFontSize(this.getDefaultMaximumFontSize());
        this.setMinimumFontSize(this.getDefaultMinimumFontSize());
        this.oldSize = tSESolidObject.getSize();
    }

    protected JTextComponent createDefaultTextComponent() {
        ik ik2 = new ik(this);
        ik2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return ik2;
    }

    protected void init() {
        super.init();
        this.getCanvas().add(this.textCompo);
        this.textCompo.getDocument().addDocumentListener(this);
        this.textCompo.addKeyListener(this);
        this.textCompo.selectAll();
        if (this.oldTagValue == null) {
            this.getGraphWindow().addInvalidRegion(this.object);
        }
        this.affectedObjects = new Vector();
        this.affectedObjects.add(this.object);
        if (this.object instanceof TSENode) {
            this.affectedObjects.addAll(((TSENode)this.object).inEdges());
            this.affectedObjects.addAll(((TSENode)this.object).outEdges());
            this.affectedObjects.addAll(((TSENode)this.object).buildIncidentIntergraphEdgeList(true, false, true, true));
        }
        this.getGraphWindow().addInvalidRegion(this.affectedObjects);
        this.getGraphWindow().updateInvalidRegion(true);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        this.commitChanges();
        this.finalizeTool();
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        if (this.getParentTool() instanceof TSESelectTool) {
            super.onMouseMoved(mouseEvent);
        } else {
            this.setCursor(this.getParentTool().getActionCursor());
        }
    }

    public void cancelAction() {
        this.getGraphWindow().addInvalidRegion(this.affectedObjects);
        if (!this.textCompo.getText().equals(this.oldTagValue)) {
            this.object.setTag(this.oldTagValue);
        }
        this.finalizeTool();
    }

    public void finalizeTool() {
        this.objectUI = null;
        this.textCompo.transferFocus();
        this.textCompo.getDocument().removeDocumentListener(this);
        this.textCompo.setKeymap(null);
        this.textCompo.removeKeyListener(this);
        this.getCanvas().remove(this.textCompo);
        this.textCompo = null;
        this.getCanvas().requestFocus();
        this.getGraphWindow().addInvalidRegion(this.affectedObjects);
        this.getGraphWindow().updateInvalidRegion();
        this.getGraphWindow().fastRepaint();
        super.finalizeTool();
        this.setCursor(this.getParentTool().getDefaultCursor());
    }

    protected void updateComponent() {
        TSTransform tSTransform = this.getGraphWindow().getTransform();
        Font font = this.objectUI.getScaledFont(tSTransform);
        if (font.getSize() > this.getMaximumFontSize()) {
            font = new Font(font.getName(), font.getStyle(), this.getMaximumFontSize());
        } else if (font.getSize() < this.getMinimumFontSize()) {
            font = new Font(font.getName(), font.getStyle(), this.getMinimumFontSize());
        }
        this.textCompo.setFont(font);
        int n = tSTransform.xToDevice(this.object.getCenterX() + this.objectUI.getTextOffsetX());
        int n2 = tSTransform.yToDevice(this.object.getCenterY() + this.objectUI.getTextOffsetY());
        int n3 = tSTransform.getDeviceBounds().width;
        int n4 = tSTransform.getDeviceBounds().height;
        int n5 = Math.min(2 * n, 2 * ((int)tSTransform.getDeviceBounds().getMaxX() - n));
        n5 = Math.min(n5, n3);
        int n6 = Math.min(2 * n2, 2 * ((int)tSTransform.getDeviceBounds().getMaxY() - n2));
        n6 = Math.min(n6, n4);
        if (this.textCompo.getSize().width >= n5) {
            ik ik2 = (ik)this.textCompo;
            if (!ik2.getLineWrap()) {
                ik2.setLineWrap(true);
                ik2.setWrapStyleWord(true);
            } else if (ik2.getLineWrap() && ik2.getPreferredSize().getHeight() < (double)(2 * ik2.getRowHeight())) {
                ik2.setLineWrap(false);
                ik2.setWrapStyleWord(false);
            }
        } else {
            this.textCompo.setSize(1, 1);
        }
        int n7 = Math.min(this.textCompo.getPreferredSize().width, n5);
        int n8 = Math.min(this.textCompo.getPreferredSize().height, n6);
        int n9 = n - n7 / 2;
        int n10 = n2 - n8 / 2;
        this.textCompo.setBounds(n9, n10, n7, n8);
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.textCompo != null) {
            this.updateComponent();
            if (!this.textCompo.hasFocus()) {
                this.textCompo.requestFocus();
            }
            Rectangle rectangle = this.textCompo.getBounds();
            Shape shape = tSEGraphics.getClip();
            tSEGraphics.translate(rectangle.x, rectangle.y);
            tSEGraphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.getGraphWindow().invalidate();
            this.textCompo.paint(tSEGraphics);
            this.textCompo.repaint();
            tSEGraphics.translate(-rectangle.x, -rectangle.y);
            tSEGraphics.setClip(shape);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateText();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateText();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.commitChanges();
        this.finalizeTool();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            if (keyEvent.isShiftDown()) {
                ((JTextArea)this.textCompo).insert("\n", this.textCompo.getCaretPosition());
            } else {
                if (this.textCompo.getText().equals("\n")) {
                    this.textCompo.setText("");
                }
                this.commitChanges();
                this.finalizeTool();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void updateText() {
        String string = this.textCompo.getText();
        if (!string.equals(this.object.getTag())) {
            if (string.length() == 0) {
                string = " ";
            }
            this.getGraphWindow().addInvalidRegion(this.object);
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.object.setTag(string);
            this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(bl);
            this.getGraphWindow().addInvalidRegion(this.affectedObjects);
            this.getGraphWindow().updateInvalidRegion(true);
            this.updateComponent();
            this.textCompo.repaint();
        }
    }

    public void commitChanges() {
        String string = this.textCompo.getText();
        if ("".equals(string)) {
            string = null;
        }
        if (this.oldTagValue != string && (this.oldTagValue != null && !this.oldTagValue.equals(string) || this.oldTagValue == null)) {
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.object.setTag(this.oldTagValue);
            this.getEventManager().setFireEvents(bl);
            int n = this.getEventManager().getContext();
            this.getEventManager().setContext(this.getEventContext());
            TSESetTagCommand tSESetTagCommand = new TSESetTagCommand((TSGraphObject)((Object)this.object), string);
            tSESetTagCommand.setOldSize(this.oldSize);
            this.getGraphWindow().transmit(tSESetTagCommand);
            this.getEventManager().setContext(n);
        } else {
            if (string == null && this.object.getTag() != null) {
                boolean bl = this.getEventManager().isFiringEvents();
                this.getEventManager().setFireEvents(false);
                this.object.setTag(null);
                this.getEventManager().setFireEvents(bl);
            }
            this.getGraphWindow().drawGraph();
            this.getGraphWindow().repaint();
        }
    }

    public Object getOldTagValue() {
        return this.oldTagValue;
    }

    public String getNewText() {
        return this.textCompo.getText();
    }

    public TSESolidObject getChangedGraphObject() {
        return this.object;
    }

    public int getMaximumFontSize() {
        return this.maximumFontSize;
    }

    public void setMaximumFontSize(int n) {
        if (n <= 0 || n <= this.getMinimumFontSize()) {
            return;
        }
        this.maximumFontSize = n;
    }

    public int getDefaultMaximumFontSize() {
        return 144;
    }

    public int getMinimumFontSize() {
        return this.minimumFontSize;
    }

    public void setMinimumFontSize(int n) {
        if (n <= 0 || n >= this.getMaximumFontSize()) {
            return;
        }
        this.minimumFontSize = n;
    }

    public int getDefaultMinimumFontSize() {
        return 10;
    }

    public int getEventContext() {
        return 3;
    }
}

