/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.util.f2;
import java.awt.event.MouseEvent;

public class TSEPanTool
extends TSEWindowInputTool {
    boolean busyCursorShown;
    protected double MIN_PAN_MAGNIFIER = 0.0;
    protected double MAX_PAN_MAGNIFIER = 1000.0;
    protected TSEGraphWindow graphWindow;
    protected TSTransform transform;
    TSPoint devStartPoint;
    TSConstPoint currentPoint;
    boolean panning;
    double totalScrollX;
    double totalScrollY;

    public TSEPanTool() {
        f2.a(f2.a0);
        this.setDefaultCursor(TSECursorManager.getCursor("Pan.32x32", 12));
        this.setActionCursor(TSECursorManager.getCursor("Panning.32x32", 12));
        this.devStartPoint = new TSPoint();
        this.graphWindow = this.getGraphWindow();
        this.transform = null;
        this.panning = false;
    }

    public void resetTool() {
        if (this.graphWindow == null) {
            this.graphWindow = this.getGraphWindow();
        }
        if (this.transform == null) {
            this.transform = this.graphWindow.getTransform();
        }
        this.totalScrollX = 0.0;
        this.totalScrollY = 0.0;
        super.resetTool();
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        this.busyCursorShown = this.graphWindow.isWaitCursorShownOnCanvas();
        this.graphWindow.setWaitCursorShownOnCanvas(false);
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            this.setCursor(this.getActionCursor());
            this.currentPoint = this.getWorldPoint(mouseEvent);
            this.devStartPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.panning = true;
            this.totalScrollX = 0.0;
            this.totalScrollY = 0.0;
        } else {
            super.onMousePressed(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.panning) {
            this.currentPoint = this.getWorldPoint(mouseEvent);
            if (!this.transform.getWorldBounds().contains(this.currentPoint)) {
                this.devStartPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            double d = (double)mouseEvent.getX() - this.devStartPoint.getX();
            double d2 = (double)mouseEvent.getY() - this.devStartPoint.getY();
            this.pan(d, d2);
            this.totalScrollX += d;
            this.totalScrollY += d2;
            this.devStartPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            if (this.panning) {
                this.panning = false;
                this.setCursor(this.getDefaultCursor());
            }
            this.totalScrollX = 0.0;
            this.totalScrollY = 0.0;
        } else {
            super.onMouseReleased(mouseEvent);
        }
        this.graphWindow.setWaitCursorShownOnCanvas(this.busyCursorShown);
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void cancelAction() {
        if (this.panning) {
            this.pan(-this.totalScrollX, -this.totalScrollY);
            this.panning = false;
        }
        if (this.graphWindow != null) {
            this.graphWindow.fastRepaint();
        }
    }

    public void setProportionalPanOffset(double d) {
        this.setProportionalSensitivity(d);
    }

    public void setProportionalSensitivity(double d) {
        if (d > this.MIN_PAN_MAGNIFIER && d < this.MAX_PAN_MAGNIFIER) {
            this.getGraphWindow().getPreferences().setValue((Object)"panningSensitivity", d);
        }
    }

    public double getProportionalPanOffset() {
        return this.getProportionalSensitivity();
    }

    public double getProportionalSensitivity() {
        return (Double)this.getGraphWindow().getPreferences().getValue("panningSensitivity");
    }

    public double getDefaultProportionalPanOffset() {
        return 1.0;
    }

    public double getDefaultProportionalSensitivity() {
        return 1.0;
    }

    public void pan(double d, double d2) {
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        this.graphWindow.scrollBy((int)(-d * this.getProportionalSensitivity()), (int)(-d2 * this.getProportionalSensitivity()), true);
        this.getEventManager().setContext(n);
    }

    public int getEventContext() {
        return 13;
    }
}

