/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.ct;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.TSEBuildEdgeTool;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.util.f2;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;

public class TSEReconnectEdgeTool
extends TSEBuildEdgeTool {
    TSEEdge edge;
    TSEGraph oldGraph;
    TSENode oldNode;
    TSEConnector oldConnector;
    TSENode newNode;
    TSEConnector newConnector;
    Vector oldPointList;
    boolean reconnectingSource = false;

    public TSEReconnectEdgeTool(TSEWindowInputTool tSEWindowInputTool) {
        super(tSEWindowInputTool);
        f2.a(f2.b0);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 4) != 0 || mouseEvent.isPopupTrigger()) {
            this.cancelAction();
        }
        super.onMousePressed(mouseEvent);
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        if (!this.isReconnecting()) {
            TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            TSEObject tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            if (!(tSEObject instanceof TSEEdge)) {
                this.finalizeTool();
            } else {
                double d = this.distanceFromEndPoint((TSEEdge)tSEObject, tSConstPoint);
                if (d > this.getMaxDistanceFromNode()) {
                    this.finalizeTool();
                }
            }
        } else {
            super.onMouseMoved(mouseEvent);
        }
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.isReconnecting()) {
            TSEConnector tSEConnector = this.sourceConnector;
            TSEConnector tSEConnector2 = this.targetConnector;
            TSENode tSENode = this.sourceNode;
            TSENode tSENode2 = this.targetNode;
            TSConstPoint tSConstPoint = this.sourcePoint;
            TSConstPoint tSConstPoint2 = this.lastPoint;
            if (this.reconnectingSource) {
                this.sourceConnector = null;
                this.sourceNode = null;
                this.targetNode = (TSENode)this.edge.getTargetNode();
                this.targetConnector = (TSEConnector)this.edge.getTargetConnector();
                this.sourcePoint = this.lastPoint;
                this.lastPoint = this.targetConnector == null ? this.targetNode.getCenter() : this.edge.getTargetPoint();
            }
            super.paint(tSEGraphics);
            this.sourceNode = tSENode;
            this.targetNode = tSENode2;
            this.sourceConnector = tSEConnector;
            this.targetConnector = tSEConnector2;
            this.sourcePoint = tSConstPoint;
            this.lastPoint = tSConstPoint2;
        }
    }

    public boolean possibleSourceAt(TSConstPoint tSConstPoint) {
        if (!this.isReconnecting()) {
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            this.edge = tSEHitTesting.getEdgeAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            if (this.edge != null) {
                if (this.edge.isMetaEdge()) {
                    this.edge = null;
                } else {
                    this.distanceFromEndPoint(this.edge, tSConstPoint);
                }
                if (this.isReconnectingSource()) {
                    this.sourceNode = (TSENode)this.edge.getTargetNode();
                    this.sourceConnector = (TSEConnector)this.edge.getTargetConnector();
                } else {
                    this.sourceNode = (TSENode)this.edge.getSourceNode();
                    this.sourceConnector = (TSEConnector)this.edge.getSourceConnector();
                }
            }
        }
        return this.edge != null;
    }

    public boolean possibleTargetAt(TSConstPoint tSConstPoint) {
        boolean bl = super.possibleTargetAt(tSConstPoint);
        if (bl) {
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            this.targetConnector = tSEHitTesting.getConnectorAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            this.newNode = this.targetNode;
            this.newConnector = this.targetConnector;
        }
        return bl;
    }

    protected void initBuildEdge() {
        this.edgeUI = (TSEEdgeUI)this.edge.getUI();
        this.edge.setSelected(true);
        this.useAntiAliasing = this.edgeUI.isUsingAntiAliasing();
        this.arrowSize = Math.max(this.edgeUI.getArrowHeight(), this.edgeUI.getArrowWidth());
        this.pointList = new Vector();
        this.oldPointList = new Vector();
        Iterator iterator = this.edge.pathNodes().iterator();
        while (iterator.hasNext()) {
            TSEPNode tSEPNode = (TSEPNode)iterator.next();
            this.oldPointList.add(tSEPNode.getCenter());
            this.pointList.add(tSEPNode.getCenter());
        }
        this.oldGraph = (TSEGraph)this.edge.getOwnerGraph();
        if (this.isReconnectingSource()) {
            this.oldNode = (TSENode)this.edge.getSourceNode();
            this.oldConnector = (TSEConnector)this.edge.getSourceConnector();
            this.targetClipping = new ct(this.edge.getTargetClipping());
        } else {
            this.oldNode = (TSENode)this.edge.getTargetNode();
            this.oldConnector = (TSEConnector)this.edge.getTargetConnector();
            this.sourceClipping = new ct(this.edge.getSourceClipping());
            this.sourcePoint = this.edge.getSourceConnector() == null ? ((TSENode)this.edge.getSourceNode()).getCenter() : this.edge.getSourceClippingPoint();
        }
        this.addDirtyRegion(this.oldNode);
        this.addDirtyRegion(this.edge);
        boolean bl = this.getEventManager().isFiringEvents();
        this.getEventManager().setFireEvents(false);
        this.oldGraph.remove(this.edge);
        this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(bl);
        this.oldGraph.updateBounds();
        this.addDirtyRegion(this.edge);
        this.getGraphWindow().drawGraph();
        this.getGraphWindow().fastRepaint();
    }

    public void addBendPoint(TSConstPoint tSConstPoint) {
        if (tSConstPoint == null) {
            throw new IllegalArgumentException("null point");
        }
        if (this.isReconnectingSource()) {
            this.pointList.add(0, tSConstPoint);
        } else {
            this.pointList.add(tSConstPoint);
        }
    }

    public void connectEdge() {
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        boolean bl = true;
        if (this.pointList.equals(this.oldPointList) && this.newNode == this.oldNode && this.newConnector == this.oldConnector) {
            bl = false;
            this.edge.setSelected(true);
        }
        if (bl) {
            this.getGraphWindow().reconnectEdge(this.edge, this.newNode, this.newConnector, this.isReconnectingSource(), this.pointList, this.oldPointList);
        }
        if (!this.edge.isOwned()) {
            boolean bl2 = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.oldGraph.insert(this.edge);
            this.getEventManager().setFireEvents(bl2);
        }
        this.getEventManager().setContext(n);
        this.pointList = null;
        this.sourceNode = null;
        this.sourceConnector = null;
        this.sourceClipping = null;
        this.targetClipping = null;
        this.targetNode = null;
        this.targetConnector = null;
        this.edge = null;
        this.oldPointList = null;
        this.oldNode = null;
        this.oldConnector = null;
        this.newNode = null;
        this.newConnector = null;
        this.getGraphWindow().drawGraph();
        this.getGraphWindow().fastRepaint();
        this.finalizeTool();
    }

    protected double distanceFromEndPoint(TSEEdge tSEEdge, TSConstPoint tSConstPoint) {
        if (tSEEdge == null || tSConstPoint == null) {
            throw new IllegalArgumentException("null edge or currPoint");
        }
        double d = tSEEdge.getTargetClippingPoint().getX();
        double d2 = tSEEdge.getTargetClippingPoint().getY();
        double d3 = Math.sqrt((d - tSConstPoint.getX()) * (d - tSConstPoint.getX()) + (d2 - tSConstPoint.getY()) * (d2 - tSConstPoint.getY()));
        d = tSEEdge.getSourceClippingPoint().getX();
        d2 = tSEEdge.getSourceClippingPoint().getY();
        double d4 = Math.sqrt((d - tSConstPoint.getX()) * (d - tSConstPoint.getX()) + (d2 - tSConstPoint.getY()) * (d2 - tSConstPoint.getY()));
        if (d3 < d4) {
            this.reconnectingSource = false;
            return d3;
        }
        this.reconnectingSource = true;
        return d4;
    }

    public void setMaxDistanceFromNode(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("maxDistanceFromNode <= 0");
        }
        this.getGraphWindow().getPreferences().setValue((Object)"reconnectEdgeSensitivity", d);
    }

    public void setCursors() {
        this.setDefaultCursor(TSECursorManager.getCursor("ReconnectEdge.32x32", 1));
        this.setActionCursor(TSECursorManager.getCursor("ReconnectEdge.32x32", 1));
    }

    public void cancelAction() {
        if (this.edge != null) {
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.oldGraph.insert(this.edge);
            this.getEventManager().setFireEvents(bl);
            this.getGraphWindow().drawGraph();
        }
        this.targetNode = null;
        this.targetConnector = null;
        this.edge = null;
        this.oldPointList = null;
        this.oldNode = null;
        this.oldConnector = null;
        this.newNode = null;
        this.newConnector = null;
        super.cancelAction();
        this.finalizeTool();
    }

    public boolean isReconnecting() {
        return this.isBuildingEdge();
    }

    public TSEEdge getEdge() {
        return this.edge;
    }

    public TSEGraph getOldGraph() {
        return this.oldGraph;
    }

    public TSENode getOldNode() {
        return this.oldNode;
    }

    public TSEConnector getOldConnector() {
        return this.oldConnector;
    }

    public TSENode getNewNode() {
        return this.newNode;
    }

    public TSEConnector getNewConnector() {
        return this.newConnector;
    }

    public double getMaxDistanceFromNode() {
        return this.getParentTool().getGraphWindow().getPreferences().getDoubleValue("reconnectEdgeSensitivity");
    }

    public double getDefaultMaxDistanceFromNode() {
        return 4.0;
    }

    public boolean isReconnectingSource() {
        return this.reconnectingSource;
    }

    public int getEventContext() {
        return 7;
    }
}

