/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.command.TSEViewChildGraphCommand;
import com.tomsawyer.editor.command.TSEViewParentGraphCommand;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.complexity.command.TSEExpandCommand;
import com.tomsawyer.editor.complexity.command.TSEUnhideCommand;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.tool.TSECreatePNodeTool;
import com.tomsawyer.editor.tool.TSEEditTextTool;
import com.tomsawyer.editor.tool.TSEMoveSelectedTool;
import com.tomsawyer.editor.tool.TSEReconnectEdgeTool;
import com.tomsawyer.editor.tool.TSEResizeGraphObjectTool;
import com.tomsawyer.editor.tool.TSESelectRegionTool;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editor.ui.TSERectangularUI;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.util.f2;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class TSESelectTool
extends TSEWindowInputTool {
    private static final int PRE_RESIZE = 1;
    private static final int PRE_MOVE = 2;
    private static final int PRE_EDIT = 3;
    private static final int PRE_BEND = 4;
    private static final int PRE_MARQUEE = 5;
    private static final int SELECT = 6;
    private static final int EXPANDED_PRE_MARQUE = 7;
    protected TSEGraph selectedGraph;
    protected TSConstPoint startPoint;
    private int mode;
    boolean isGridOn;
    TSEReconnectEdgeTool reconnectEdgeTool;

    public TSESelectTool() {
        f2.a(f2.az);
        this.setDefaultCursor(TSECursorManager.getCursor("SelectDefault.32x32", 0));
        this.setActionCursor(TSECursorManager.getCursor("SelectAction.32x32", 13));
        this.setReconnectEdgeTool(this.getDefaultReconnectEdgeTool());
        this.mode = 6;
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            TSEInspectable tSEInspectable;
            TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
            this.isGridOn = this.getGraphWindow().hasGrid() && this.isAlignmentEnabled(mouseEvent);
            this.startPoint = tSConstPoint;
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            TSEObject tSEObject = null;
            int n2 = tSEHitTesting.getGrappleAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            TSESolidObject tSESolidObject = null;
            if (n2 != 0 && (tSESolidObject = tSEHitTesting.getOwnerOfGrappleAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled())).getUI() instanceof TSERectangularUI && !(tSEInspectable = (TSERectangularUI)tSESolidObject.getUI()).isGrappleEnabled(n2)) {
                n2 = 0;
            }
            if (n2 == 16) {
                tSEObject = tSESolidObject;
            } else if (n2 != 0) {
                this.mode = 1;
            } else {
                this.selectedGraph = this.getGraph();
                if (this.getGraphWindow().isNestedGraphEditingEnabled()) {
                    this.selectedGraph = tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph());
                }
                this.selectedGraph.setSelected(true);
                tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
                if (tSEObject == null) {
                    if (mouseEvent.getClickCount() == 2 && this.getGraphWindow().isNestedGraphEditingEnabled()) {
                        tSEInspectable = tSEHitTesting.getExpandedNodeAt(tSConstPoint, this.getGraph(), true);
                        if (tSEInspectable != null) {
                            this.goToChildGraph((TSGraphMember)((Object)tSEInspectable));
                        } else {
                            this.goToParentGraph();
                        }
                    } else {
                        this.mode = 5;
                    }
                }
            }
            if (tSEObject != null) {
                if (tSEObject instanceof TSEEdge && ((TSEEdge)tSEObject).getChildGraph() != null && mouseEvent.getClickCount() == 2) {
                    this.goToChildGraph((TSEEdge)tSEObject);
                } else if (tSEObject instanceof TSENode && (TSENodeUI)((TSENode)tSEObject).getUI() != null && ((TSENodeUI)((TSENode)tSEObject).getUI()).hasChildGraphMark() && ((TSENodeUI)((TSENode)tSEObject).getUI()).getChildGraphMarkBounds().contains(this.startPoint) && mouseEvent.getClickCount() == 2) {
                    try {
                        this.expandNode((TSENode)tSEObject);
                    }
                    catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
                        this.getEventManager().setContext(n);
                        throw tSLicenseRuntimeException;
                    }
                } else if (tSEObject instanceof TSENode && (TSENodeUI)tSEObject.getUI() != null && ((TSENodeUI)tSEObject.getUI()).hasHideMark() && ((TSENodeUI)tSEObject.getUI()).getHideMarkBounds().contains(this.startPoint) && mouseEvent.getClickCount() == 2) {
                    this.unhideNeighborsAndIncidentEdges((TSENode)tSEObject);
                } else if (!tSEObject.isSelected()) {
                    this.deselectAllExcept(tSEObject, mouseEvent);
                    if (!(tSEObject instanceof TSEEdge) && !(tSEObject instanceof TSEConnector)) {
                        this.mode = 2;
                    } else if (tSEObject instanceof TSEEdge) {
                        this.mode = 4;
                    }
                } else if (mouseEvent.isControlDown()) {
                    this.getGraphWindow().deselectObject(tSEObject, true);
                } else if (tSEObject instanceof TSEEdge) {
                    this.mode = 4;
                } else if (tSEObject instanceof TSEPNode) {
                    this.mode = 2;
                } else if (!(tSEObject instanceof TSEConnector)) {
                    this.mode = mouseEvent.getClickCount() == 2 ? 3 : 2;
                    if ((tSEObject instanceof TSENode || tSEObject instanceof TSENodeLabel || tSEObject instanceof TSEConnectorLabel || tSEObject instanceof TSEEdgeLabel) && tSEObject.getUI() != null && !((TSEAnnotatedUI)tSEObject.getUI()).isAnnotationEditable()) {
                        this.mode = 2;
                    }
                }
            }
        }
        this.getEventManager().setContext(n);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this == this.getGraphWindow().getCurrentTool()) {
            switch (this.mode) {
                case 4: {
                    this.createPNode(this.startPoint);
                    TSEWindowInputTool tSEWindowInputTool = (TSEWindowInputTool)this.getGraphWindow().getCurrentTool();
                    if (tSEWindowInputTool == this) break;
                    tSEWindowInputTool.onMouseDragged(mouseEvent);
                    break;
                }
                case 7: {
                    this.selectRegion(this.startPoint);
                    break;
                }
                case 5: {
                    this.selectRegion(this.startPoint);
                    break;
                }
                case 1: {
                    this.resizeGraphObject(this.startPoint);
                    break;
                }
                case 3: {
                    this.mode = 2;
                }
                case 2: {
                    this.moveSelected(this.startPoint);
                }
            }
        }
        this.mode = 6;
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            TSEObject tSEObject;
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            if (this.mode == 5 && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                this.getGraphWindow().deselectAll(true);
            } else if (this.mode == 4) {
                TSEObject tSEObject2 = tSEHitTesting.getGraphObjectAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
                this.deselectAllExcept(tSEObject2, mouseEvent);
            } else if (this.mode == 3) {
                TSESolidObject tSESolidObject;
                TSESolidObject tSESolidObject2 = (TSESolidObject)tSEHitTesting.getGraphObjectAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
                if (tSESolidObject2 == null && (tSESolidObject = tSEHitTesting.getOwnerOfGrappleAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled())) != null && tSESolidObject.isSelected()) {
                    tSESolidObject2 = tSESolidObject;
                }
                if (tSESolidObject2 != null) {
                    if (this.getGraphWindow().getGraph().numberOfSelectedObjects() > 1) {
                        this.deselectAllExcept(tSESolidObject2, mouseEvent);
                    } else {
                        this.editText(tSESolidObject2);
                    }
                }
            } else if (this.mode == 2) {
                TSEObject tSEObject3 = tSEHitTesting.getGraphObjectAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
                this.deselectAllExcept(tSEObject3, mouseEvent);
            } else if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && this.startPoint != null && (tSEObject = tSEHitTesting.getGraphObjectAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled())) instanceof TSEConnector) {
                this.deselectAllExcept(tSEObject, mouseEvent);
            }
            this.mode = 6;
        }
        this.getEventManager().setContext(n);
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        if (this == this.getGraphWindow().getCurrentTool() || this == this.getGraphWindow().getCurrentTool().getParentTool()) {
            Object object;
            TSEObject tSEObject;
            TSConstPoint tSConstPoint;
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            int n = tSEHitTesting.getGrappleAt(tSConstPoint = this.getNonalignedWorldPoint(mouseEvent), this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            if (n != 0 && (tSEObject = tSEHitTesting.getOwnerOfGrappleAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled())).getUI() instanceof TSERectangularUI && !((TSERectangularUI)(object = (TSERectangularUI)tSEObject.getUI())).isGrappleEnabled(n)) {
                n = 0;
            }
            if (n == 0) {
                tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
                if (tSEObject instanceof TSESolidObject) {
                    if (tSEObject instanceof TSEConnector) {
                        this.setCursor(TSECursorManager.getCursor("OnConnector.32x32", 0));
                    } else {
                        this.setCursor(this.getActionCursor());
                    }
                } else if (tSEObject instanceof TSEEdge && this == this.getGraphWindow().getCurrentTool()) {
                    double d;
                    double d2;
                    this.setCursor(TSECursorManager.getCursor("OnEdge.32x32", 1));
                    object = this.getReconnectEdgeTool();
                    if (object != null && (d2 = ((TSEReconnectEdgeTool)object).distanceFromEndPoint((TSEEdge)tSEObject, tSConstPoint)) <= (d = ((TSEReconnectEdgeTool)object).getMaxDistanceFromNode()) && !((TSEEdge)tSEObject).isMetaEdge()) {
                        this.setTool((TSEWindowTool)object);
                    }
                } else {
                    this.setCursor(this.getDefaultCursor());
                }
            } else {
                switch (n) {
                    case 1: {
                        this.setCursor(TSECursorManager.getCursor("NResize.32x32", 8));
                        break;
                    }
                    case 4: {
                        this.setCursor(TSECursorManager.getCursor("EResize.32x32", 11));
                        break;
                    }
                    case 8: {
                        this.setCursor(TSECursorManager.getCursor("WResize.32x32", 10));
                        break;
                    }
                    case 2: {
                        this.setCursor(TSECursorManager.getCursor("SResize.32x32", 9));
                        break;
                    }
                    case 5: {
                        this.setCursor(TSECursorManager.getCursor("NEResize.32x32", 7));
                        break;
                    }
                    case 9: {
                        this.setCursor(TSECursorManager.getCursor("NWResize.32x32", 6));
                        break;
                    }
                    case 6: {
                        this.setCursor(TSECursorManager.getCursor("SEResize.32x32", 5));
                        break;
                    }
                    case 10: {
                        this.setCursor(TSECursorManager.getCursor("SWResize.32x32", 4));
                        break;
                    }
                    default: {
                        this.setCursor(this.getDefaultCursor());
                    }
                }
            }
        }
    }

    public void cancelAction() {
        this.mode = 6;
    }

    public void resetTool() {
        this.mode = 6;
        super.resetTool();
    }

    public void selectRegion(TSConstPoint tSConstPoint) {
        TSESelectRegionTool tSESelectRegionTool = new TSESelectRegionTool(this, tSConstPoint, this.getSelectedGraph(), this.getPartialSelection());
        this.setTool(tSESelectRegionTool);
    }

    public void createPNode(TSConstPoint tSConstPoint) {
        try {
            TSECreatePNodeTool tSECreatePNodeTool = new TSECreatePNodeTool(this, tSConstPoint);
            this.setTool(tSECreatePNodeTool);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resizeGraphObject(TSConstPoint tSConstPoint) {
        try {
            TSEResizeGraphObjectTool tSEResizeGraphObjectTool = new TSEResizeGraphObjectTool(this, tSConstPoint, this.isGridOn());
            tSEResizeGraphObjectTool.setDefaultCursor(this.getGraphWindow().getCursorOnCanvas());
            tSEResizeGraphObjectTool.setActionCursor(this.getGraphWindow().getCursorOnCanvas());
            this.setTool(tSEResizeGraphObjectTool);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveSelected(TSConstPoint tSConstPoint) {
        try {
            TSEMoveSelectedTool tSEMoveSelectedTool = new TSEMoveSelectedTool(this, tSConstPoint, this.isGridOn());
            this.setTool(tSEMoveSelectedTool);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void editText(TSESolidObject tSESolidObject) {
        try {
            TSEEditTextTool tSEEditTextTool = new TSEEditTextTool(this.getGraphWindow().getCurrentTool(), tSESolidObject);
            this.setTool(tSEEditTextTool);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deselectAllExcept(TSEObject tSEObject, MouseEvent mouseEvent) {
        boolean bl = this.getEventManager().isCoalesce();
        this.getEventManager().setCoalesce(true);
        if (!tSEObject.isSelected()) {
            this.getGraphWindow().selectObject(tSEObject, true);
        }
        if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
            this.getGraphWindow().deselectAll(true, tSEObject);
        }
        this.getEventManager().setCoalesce(bl);
    }

    protected TSEReconnectEdgeTool getDefaultReconnectEdgeState() {
        return this.getDefaultReconnectEdgeTool();
    }

    protected TSEReconnectEdgeTool getDefaultReconnectEdgeTool() {
        TSEReconnectEdgeTool tSEReconnectEdgeTool = null;
        try {
            tSEReconnectEdgeTool = new TSEReconnectEdgeTool(this);
        }
        catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
            // empty catch block
        }
        return tSEReconnectEdgeTool;
    }

    public TSEReconnectEdgeTool getReconnectEdgeState() {
        return this.getReconnectEdgeTool();
    }

    public TSEReconnectEdgeTool getReconnectEdgeTool() {
        return this.reconnectEdgeTool;
    }

    public void setReconnectEdgeState(TSEReconnectEdgeTool tSEReconnectEdgeTool) {
        this.setReconnectEdgeTool(tSEReconnectEdgeTool);
    }

    public void setReconnectEdgeTool(TSEReconnectEdgeTool tSEReconnectEdgeTool) {
        this.reconnectEdgeTool = tSEReconnectEdgeTool;
    }

    public void setPartialSelection(boolean bl) {
        this.getGraphWindow().getPreferences().setValue((Object)"partialSelection", bl);
    }

    public boolean getPartialSelection() {
        return (Boolean)this.getGraphWindow().getPreferences().getValue("partialSelection");
    }

    public boolean getDefaultPartialSelection() {
        return true;
    }

    public void goToChildGraph(TSGraphMember tSGraphMember) {
        if (tSGraphMember.getChildGraph() != null) {
            TSEViewChildGraphCommand tSEViewChildGraphCommand = new TSEViewChildGraphCommand(this.getGraphWindow(), tSGraphMember);
            this.getGraphWindow().transmit(tSEViewChildGraphCommand);
        }
    }

    public void goToParentGraph() {
        TSEGraph tSEGraph = this.getGraph();
        if (tSEGraph.getParent() != null) {
            tSEGraph.deselectAll();
            TSEViewParentGraphCommand tSEViewParentGraphCommand = new TSEViewParentGraphCommand(this.getGraphWindow(), tSEGraph);
            this.getGraphWindow().transmit(tSEViewParentGraphCommand);
        }
    }

    protected void expandNode(TSENode tSENode) {
        TSEExpandCommand tSEExpandCommand = new TSEExpandCommand(tSENode);
        this.getGraphWindow().transmit(tSEExpandCommand);
    }

    protected void unhideNeighborsAndIncidentEdges(TSENode tSENode) {
        TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager(this.getGraphWindow().getGraphManager());
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        tSEHidingManager.findHiddenNeighbors(tSENode, 1L);
        vector.addAll(tSEHidingManager.getResultNodeList());
        vector2.addAll(tSEHidingManager.getResultEdgeList());
        tSEHidingManager.findHiddenIncidentEdgeList(tSENode);
        vector.addAll(tSEHidingManager.getResultNodeList());
        vector2.addAll(tSEHidingManager.getResultEdgeList());
        if (!vector.isEmpty() || !vector2.isEmpty()) {
            TSEUnhideCommand tSEUnhideCommand = new TSEUnhideCommand(vector, vector2);
            this.getGraphWindow().transmit(tSEUnhideCommand);
        }
    }

    public TSEGraph getSelectedGraph() {
        return this.selectedGraph;
    }

    public boolean isGridOn() {
        return this.isGridOn;
    }

    public int getEventContext() {
        return 9;
    }
}

