/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyEditor;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyRenderer;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.g0;
import com.tomsawyer.util.TSProperty;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.util.Iterator;
import java.util.List;

public abstract class TSEEdgeUI
extends TSEObjectUI {
    public static TSEInspectorPropertyID COLOR_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Color"), class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSEEdgeUI.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor);
    public static TSEInspectorPropertyID ANTI_ALIASING_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Anti_Aliasing"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = TSEEdgeUI.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TSEInspectorPropertyID ARROWHEAD_WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Arrowhead_Width"), class$java$lang$Double == null ? (class$java$lang$Double = TSEEdgeUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID ARROWHEAD_HEIGHT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Arrowhead_Height"), class$java$lang$Double == null ? (class$java$lang$Double = TSEEdgeUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID ARROWHEAD_STYLE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Arrowhead_Style"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEEdgeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID BEND_WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Bend_Width"), class$java$lang$Double == null ? (class$java$lang$Double = TSEEdgeUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID BEND_HEIGHT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Bend_Height"), class$java$lang$Double == null ? (class$java$lang$Double = TSEEdgeUI.class$("java.lang.Double")) : class$java$lang$Double);
    static TSEKeyValueInspectorPropertyEditor arrowEditor = null;
    static TSEKeyValueInspectorPropertyRenderer arrowRenderer = null;
    public static final int NO_ARROW = 0;
    public static final int SOURCE_ARROW = 1;
    public static final int TARGET_ARROW = 2;
    public static final int SOURCE_AND_TARGET_ARROW = 3;
    public static final String LINE_COLOR = "lineColor";
    public static final String USING_ANTI_ALIASING = "antiAliasing";
    public static final String ARROW_WIDTH = "arrowWidth";
    public static final String ARROW_HEIGHT = "arrowHeight";
    public static final String ARROW_TYPE = "arrowType";
    public static final String BEND_WIDTH = "bendWidth";
    public static final String BEND_HEIGHT = "bendHeight";
    private TSEEdge ownerEdge;
    TSEColor lineColor;
    TSEColor highlightedColor;
    boolean useAntiAliasing;
    double arrowWidth;
    double arrowHeight;
    int arrowType;
    double bendWidth;
    double bendHeight;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEColor;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public void reset() {
        super.reset();
        this.setArrowWidth(this.getDefaultArrowWidth());
        this.setArrowHeight(this.getDefaultArrowHeight());
        this.setArrowType(this.getDefaultArrowType());
        this.setLineColor(this.getDefaultLineColor());
        this.setHighlightedColor(this.getDefaultHighlightedColor());
        this.setBendWidth(this.getDefaultBendWidth());
        this.setBendHeight(this.getDefaultBendHeight());
        this.setUsingAntiAliasing(this.getDefaultUsingAntiAliasing());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSEEdgeUI tSEEdgeUI = (TSEEdgeUI)tSEObjectUI;
        this.setArrowWidth(tSEEdgeUI.getArrowWidth());
        this.setArrowHeight(tSEEdgeUI.getArrowHeight());
        this.setArrowType(tSEEdgeUI.getArrowType());
        this.setLineColor(tSEEdgeUI.getLineColor());
        this.setHighlightedColor(tSEEdgeUI.getHighlightedColor());
        this.setBendWidth(tSEEdgeUI.getBendWidth());
        this.setBendHeight(tSEEdgeUI.getBendHeight());
        this.setUsingAntiAliasing(tSEEdgeUI.isUsingAntiAliasing());
    }

    public abstract void draw(TSEGraphics var1);

    public abstract void drawOutline(TSEGraphics var1);

    public abstract void drawSelected(TSEGraphics var1);

    public abstract void drawSelectedOutline(TSEGraphics var1);

    public void drawPath(TSEGraphics tSEGraphics) {
        this.drawPath(tSEGraphics, true, true, false);
    }

    public void drawPathOutline(TSEGraphics tSEGraphics) {
        this.drawPath(tSEGraphics, false, true, false);
    }

    public TSEGraphics convertGraphics(TSEGraphics tSEGraphics) {
        return tSEGraphics;
    }

    public void drawPath(TSEGraphics tSEGraphics, boolean bl, boolean bl2, boolean bl3) {
        Object object = null;
        if (this.isUsingAntiAliasing()) {
            object = tSEGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            tSEGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        if (tSPEdge != null && tSPEdge2 != null) {
            TSPEdge tSPEdge3 = tSPEdge;
            TSPEdge tSPEdge4 = tSPEdge2;
            if (!this.getOwnerEdge().isStraight()) {
                if (bl3) {
                    TSGNode tSGNode;
                    if (tSPEdge.length() <= this.getArrowHeight() && (tSGNode = (TSGNode)tSPEdge.getTargetNode()).isPathNode()) {
                        tSPEdge3 = ((TSPNode)tSGNode).getOutEdge();
                    }
                    if (tSPEdge2.length() <= this.getArrowHeight() && (tSGNode = (TSGNode)tSPEdge2.getSourceNode()).isPathNode()) {
                        tSPEdge4 = ((TSPNode)tSGNode).getInEdge();
                    }
                }
                boolean bl4 = false;
                Iterator iterator = this.getOwnerEdge().pathIterator();
                while (iterator.hasNext()) {
                    boolean bl5;
                    TSPEdge tSPEdge5 = (TSPEdge)iterator.next();
                    boolean bl6 = tSPEdge5 == tSPEdge;
                    boolean bl7 = bl5 = tSPEdge5 == tSPEdge2;
                    if (bl6) {
                        bl4 = true;
                    }
                    if (bl4) {
                        this.drawPathEdge(tSEGraphics, bl, bl2, tSPEdge5, bl6, bl5, tSPEdge3, tSPEdge4);
                    }
                    if (!bl5) continue;
                    break;
                }
            } else {
                TSPEdge tSPEdge6 = this.getOwnerEdge().getSourceEdge();
                this.drawPathEdge(tSEGraphics, bl, bl2, tSPEdge6, true, true, tSPEdge6, tSPEdge6);
            }
        }
        if (this.isUsingAntiAliasing()) {
            tSEGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    void drawPathEdge(TSEGraphics tSEGraphics, boolean bl, boolean bl2, TSPEdge tSPEdge, boolean bl3, boolean bl4, TSPEdge tSPEdge2, TSPEdge tSPEdge3) {
        boolean bl5 = tSPEdge == tSPEdge2 && (this.getArrowType() & 1) != 0;
        boolean bl6 = tSPEdge == tSPEdge3 && (this.getArrowType() & 2) != 0;
        TSConstPoint tSConstPoint = bl3 ? this.getOwnerEdge().getLocalSourceClippingPoint() : tSPEdge.getLocalSourcePoint();
        TSConstPoint tSConstPoint2 = bl4 ? this.getOwnerEdge().getLocalTargetClippingPoint() : tSPEdge.getLocalTargetPoint();
        if (bl5 || bl6) {
            this.drawLineWithArrow(tSEGraphics, tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY(), bl5, bl6, bl, bl2);
        } else {
            tSEGraphics.drawLine(tSConstPoint, tSConstPoint2);
        }
    }

    public void drawLineWithArrow(TSEGraphics tSEGraphics, double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f;
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        float f10 = tSTransform.widthToDevice(d3 - d);
        float f11 = (float)Math.sqrt(f10 * f10 + (f = (float)tSTransform.heightToDevice(d4 - d2)) * f);
        if (f11 == 0.0f) {
            return;
        }
        int n = tSTransform.xToDevice(d);
        int n2 = tSTransform.yToDevice(d2);
        int n3 = tSTransform.xToDevice(d3);
        int n4 = tSTransform.yToDevice(d4);
        float f12 = tSTransform.widthToDevice(this.getArrowWidth()) / 2;
        if (f12 < 0.5f) {
            tSEGraphics.drawLine(n, n2, n3, n4);
            return;
        }
        float f13 = tSTransform.heightToDevice(this.getArrowHeight());
        float f14 = f13 * (f10 /= f11);
        float f15 = f13 * (f /= f11);
        float f16 = f12 * f;
        float f17 = f12 * f10;
        Polygon polygon = null;
        Polygon polygon2 = null;
        if (bl) {
            polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + (int)(f14 - f16), n2 - (int)(f15 + f17));
            polygon.addPoint(n + (int)(f14 + f16), n2 - (int)(f15 - f17));
            n += (int)f14;
            n2 -= (int)f15;
        }
        if (bl2) {
            polygon2 = new Polygon();
            polygon2.addPoint(n3, n4);
            polygon2.addPoint(n3 - (int)(f14 - f16), n4 + (int)(f15 + f17));
            polygon2.addPoint(n3 - (int)(f14 + f16), n4 + (int)(f15 - f17));
            n3 -= (int)f14;
            n4 += (int)f15;
        }
        if (bl3 && f12 > 1.5f) {
            if (polygon != null) {
                tSEGraphics.fillPolygon(polygon);
            }
            if (polygon2 != null) {
                tSEGraphics.fillPolygon(polygon2);
            }
        }
        if (bl4) {
            if (polygon != null) {
                tSEGraphics.drawPolygon(polygon);
            }
            if (polygon2 != null) {
                tSEGraphics.drawPolygon(polygon2);
            }
        }
        tSEGraphics.drawLine(n, n2, n3, n4);
    }

    public void drawAllBends(TSEGraphics tSEGraphics) {
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        while (tSPEdge != null && tSPEdge2 != null && tSPEdge != tSPEdge2) {
            TSEPNode tSEPNode = (TSEPNode)tSPEdge.getTargetNode();
            tSEPNode.getUI().drawSelected(tSEGraphics);
            tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
        }
    }

    public void drawAllBendOutlines(TSEGraphics tSEGraphics) {
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        while (tSPEdge != null && tSPEdge2 != null && tSPEdge != tSPEdge2) {
            TSEPNode tSEPNode = (TSEPNode)tSPEdge.getTargetNode();
            tSEPNode.getUI().drawSelectedOutline(tSEGraphics);
            tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
        }
    }

    public void drawBends(TSEGraphics tSEGraphics, boolean bl) {
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        while (tSPEdge != null && tSPEdge2 != null && tSPEdge != tSPEdge2) {
            TSEPNode tSEPNode = (TSEPNode)tSPEdge.getTargetNode();
            if (tSEPNode.isSelected() && bl) {
                tSEPNode.getUI().drawSelected(tSEGraphics);
            } else if (this.getOwnerEdge().isSelected()) {
                tSEPNode.getUI().draw(tSEGraphics);
            }
            tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
        }
    }

    public void drawBends(TSEGraphics tSEGraphics) {
        this.drawBends(tSEGraphics, true);
    }

    public void drawBendOutlines(TSEGraphics tSEGraphics, boolean bl) {
        TSPEdge tSPEdge = this.getOwnerEdge().getFirstDrawablePEdge();
        TSPEdge tSPEdge2 = this.getOwnerEdge().getLastDrawablePEdge();
        while (tSPEdge != null && tSPEdge2 != null && tSPEdge != tSPEdge2) {
            TSEPNode tSEPNode = (TSEPNode)tSPEdge.getTargetNode();
            if (tSEPNode.isSelected() && bl) {
                tSEPNode.getUI().drawSelectedOutline(tSEGraphics);
            } else if (this.getOwnerEdge().isSelected()) {
                tSEPNode.getUI().drawOutline(tSEGraphics);
            }
            tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
        }
    }

    public void drawBendOutlines(TSEGraphics tSEGraphics) {
        this.drawBendOutlines(tSEGraphics, true);
    }

    public double getLeft() {
        double d = this.getArrowWidth() > this.getArrowHeight() ? this.getArrowWidth() : this.getArrowHeight();
        return this.getOwnerEdge().getLocalLeft() - d;
    }

    public double getRight() {
        double d = this.getArrowWidth() > this.getArrowHeight() ? this.getArrowWidth() : this.getArrowHeight();
        return this.getOwnerEdge().getLocalRight() + d;
    }

    public double getTop() {
        double d = this.getArrowWidth() > this.getArrowHeight() ? this.getArrowWidth() : this.getArrowHeight();
        return this.getOwnerEdge().getLocalTop() + d;
    }

    public double getBottom() {
        double d = this.getArrowWidth() > this.getArrowHeight() ? this.getArrowWidth() : this.getArrowHeight();
        return this.getOwnerEdge().getLocalBottom() - d;
    }

    public TSConstRect getBounds() {
        double d = this.getArrowWidth() > this.getArrowHeight() ? this.getArrowWidth() : this.getArrowHeight();
        TSConstRect tSConstRect = this.getOwnerEdge().getLocalBounds();
        return new TSConstRect(tSConstRect.getLeft() - d, tSConstRect.getBottom() - d, tSConstRect.getRight() + d, tSConstRect.getTop() + d);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.getOwnerEdge().locallyIntersects(d - this.arrowWidth, d2 - this.arrowWidth, d3 + this.arrowWidth, d4 + this.arrowWidth);
    }

    public TSConstRect getInvalidRegion(TSTransform tSTransform, TSExpTransform tSExpTransform) {
        TSRect tSRect = new TSRect();
        tSExpTransform.transformRect(this.getBounds(), tSRect);
        return tSRect;
    }

    public TSEColor getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(TSEColor tSEColor) {
        TSEColor tSEColor2 = this.lineColor;
        this.lineColor = tSEColor;
        this.firePropertyChangedEvent(LINE_COLOR, tSEColor2, tSEColor);
    }

    public void setHighlightedColor(TSEColor tSEColor) {
        this.highlightedColor = tSEColor;
    }

    public TSEColor getHighlightedColor() {
        return this.highlightedColor;
    }

    public double getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(double d) {
        Double d2 = new Double(this.arrowWidth);
        this.arrowWidth = d;
        this.firePropertyChangedEvent(ARROW_WIDTH, d2, new Double(d));
    }

    public double getArrowHeight() {
        return this.arrowHeight;
    }

    public void setArrowHeight(double d) {
        Double d2 = new Double(this.arrowHeight);
        this.arrowHeight = d;
        this.firePropertyChangedEvent(ARROW_HEIGHT, d2, new Double(d));
    }

    public int getArrowType() {
        return this.arrowType;
    }

    public void setArrowType(int n) {
        Integer n2 = new Integer(this.arrowType);
        this.arrowType = n;
        this.firePropertyChangedEvent(ARROW_TYPE, n2, new Integer(n));
    }

    public double getBendWidth() {
        return this.bendWidth;
    }

    public void setBendWidth(double d) {
        Double d2 = new Double(this.bendWidth);
        this.bendWidth = d;
        this.firePropertyChangedEvent(BEND_WIDTH, d2, new Double(d));
    }

    public double getBendHeight() {
        return this.bendHeight;
    }

    public void setBendHeight(double d) {
        Double d2 = new Double(this.bendHeight);
        this.bendHeight = d;
        this.firePropertyChangedEvent(BEND_WIDTH, d2, new Double(d));
    }

    public boolean isUsingAntiAliasing() {
        return this.useAntiAliasing;
    }

    public void setUsingAntiAliasing(boolean bl) {
        Boolean bl2 = new Boolean(this.useAntiAliasing);
        this.useAntiAliasing = bl;
        this.firePropertyChangedEvent(USING_ANTI_ALIASING, bl2, new Boolean(bl));
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(LINE_COLOR, this.lineColor));
        list.add(new TSProperty(ARROW_WIDTH, new Double(this.arrowWidth)));
        list.add(new TSProperty(ARROW_HEIGHT, new Double(this.arrowHeight)));
        list.add(new TSProperty(ARROW_TYPE, new Integer(this.arrowType)));
        list.add(new TSProperty(BEND_WIDTH, new Double(this.getBendHeight())));
        list.add(new TSProperty(BEND_HEIGHT, new Double(this.getBendHeight())));
        list.add(new TSProperty(USING_ANTI_ALIASING, new Boolean(this.isUsingAntiAliasing())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (!this.getDefaultLineColor().equals(this.getLineColor())) {
            list.add(new TSProperty(LINE_COLOR, this.getLineColor()));
        }
        if (this.getDefaultArrowWidth() != this.getArrowWidth()) {
            list.add(new TSProperty(ARROW_WIDTH, new Double(this.getArrowWidth())));
        }
        if (this.getDefaultArrowHeight() != this.getArrowHeight()) {
            list.add(new TSProperty(ARROW_HEIGHT, new Double(this.getArrowHeight())));
        }
        if (this.getDefaultArrowType() != this.getArrowType()) {
            list.add(new TSProperty(ARROW_TYPE, new Integer(this.getArrowType())));
        }
        if (this.getDefaultBendWidth() != this.getBendWidth()) {
            list.add(new TSProperty(BEND_WIDTH, new Double(this.getBendHeight())));
        }
        if (this.getDefaultBendHeight() != this.getBendHeight()) {
            list.add(new TSProperty(BEND_HEIGHT, new Double(this.getBendHeight())));
        }
        if (this.getDefaultUsingAntiAliasing() != this.isUsingAntiAliasing()) {
            list.add(new TSProperty(USING_ANTI_ALIASING, new Boolean(this.isUsingAntiAliasing())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (LINE_COLOR.equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEColor) {
                this.setLineColor((TSEColor)tSProperty.getValue());
            } else {
                this.setLineColor(new TSEColor(tSProperty.getValue().toString()));
            }
        } else if (tSProperty.getName().equals(ARROW_WIDTH)) {
            this.setArrowWidth(Double.valueOf(tSProperty.getValue().toString()));
        } else if (tSProperty.getName().equals(ARROW_HEIGHT)) {
            this.setArrowHeight(Double.valueOf(tSProperty.getValue().toString()));
        } else if (tSProperty.getName().equals(ARROW_TYPE)) {
            this.setArrowType(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (tSProperty.getName().equals(BEND_WIDTH)) {
            this.setBendWidth(Double.valueOf(tSProperty.getValue().toString()));
        } else if (tSProperty.getName().equals(BEND_HEIGHT)) {
            this.setBendHeight(Double.valueOf(tSProperty.getValue().toString()));
        } else if (USING_ANTI_ALIASING.equals(tSProperty.getName())) {
            this.setUsingAntiAliasing(Boolean.valueOf(tSProperty.getValue().toString()));
        }
    }

    public TSEColor getDefaultLineColor() {
        return TSEColor.black;
    }

    public TSEColor getDefaultHighlightedColor() {
        return TSEColor.magenta;
    }

    public double getDefaultArrowWidth() {
        return 6.0;
    }

    public double getDefaultArrowHeight() {
        return 6.0;
    }

    public int getDefaultArrowType() {
        return 2;
    }

    public double getDefaultBendWidth() {
        return 5.0;
    }

    public double getDefaultBendHeight() {
        return 5.0;
    }

    public boolean getDefaultUsingAntiAliasing() {
        return false;
    }

    public TSEObject getOwner() {
        return this.ownerEdge;
    }

    public TSEEdge getOwnerEdge() {
        return this.ownerEdge;
    }

    public void setOwner(TSEEdge tSEEdge) {
        this.ownerEdge = tSEEdge;
    }

    protected void nullifyOwner() {
        this.ownerEdge = null;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(COLOR_ID);
        list.add(ARROWHEAD_STYLE_ID);
        list.add(ARROWHEAD_WIDTH_ID);
        list.add(ARROWHEAD_HEIGHT_ID);
        list.add(BEND_WIDTH_ID);
        list.add(BEND_HEIGHT_ID);
        list.add(ANTI_ALIASING_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        block3: {
            TSEInspectorProperty tSEInspectorProperty2;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            block4: {
                                block2: {
                                    if (!tSEInspectorPropertyID.equals(COLOR_ID)) break block2;
                                    tSEInspectorProperty = new TSEInspectorProperty(this.getLineColor());
                                    break block3;
                                }
                                if (!tSEInspectorPropertyID.equals(ARROWHEAD_WIDTH_ID)) break block4;
                                tSEInspectorProperty = new TSENumericInspectorProperty((Number)new Double(this.getArrowWidth()), new Double(0.0), new Double(18.0));
                                break block3;
                            }
                            if (!tSEInspectorPropertyID.equals(ARROWHEAD_HEIGHT_ID)) break block5;
                            tSEInspectorProperty = new TSENumericInspectorProperty((Number)new Double(this.getArrowHeight()), new Double(0.0), new Double(24.0));
                            break block3;
                        }
                        if (!tSEInspectorPropertyID.equals(ARROWHEAD_STYLE_ID)) break block6;
                        if (arrowEditor == null) break block7;
                        if (arrowRenderer != null) break block8;
                    }
                    arrowEditor = new TSEKeyValueInspectorPropertyEditor();
                    arrowEditor.getComboBox().setRenderer(new g0());
                    arrowRenderer = new TSEKeyValueInspectorPropertyRenderer();
                    arrowRenderer.getComboBox().setRenderer(new g0());
                }
                TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getArrowType()), true, arrowRenderer, arrowEditor);
                tSEKeyValueInspectorProperty.put(new Integer(0), new Integer(0));
                tSEKeyValueInspectorProperty.put(new Integer(1), new Integer(1));
                tSEKeyValueInspectorProperty.put(new Integer(2), new Integer(2));
                tSEKeyValueInspectorProperty.put(new Integer(3), new Integer(3));
                tSEInspectorProperty = tSEKeyValueInspectorProperty;
                break block3;
            }
            tSEInspectorProperty = tSEInspectorPropertyID.equals(BEND_WIDTH_ID) ? new TSENumericInspectorProperty((Number)new Double(this.getBendWidth()), new Double(0.0), new Double(10.0)) : (tSEInspectorPropertyID.equals(BEND_HEIGHT_ID) ? new TSENumericInspectorProperty((Number)new Double(this.getBendHeight()), new Double(0.0), new Double(10.0)) : (tSEInspectorPropertyID.equals(ANTI_ALIASING_ID) ? (tSEInspectorProperty2 = new TSEInspectorProperty((Object)new Boolean(this.isUsingAntiAliasing()), true)) : super.getInspectorProperty(tSEInspectorPropertyID)));
        }
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(COLOR_ID)) {
            this.setLineColor((TSEColor)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(ARROWHEAD_WIDTH_ID)) {
            this.setArrowWidth((Double)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(ARROWHEAD_HEIGHT_ID)) {
            this.setArrowHeight((Double)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(ARROWHEAD_STYLE_ID)) {
            this.setArrowType((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(BEND_WIDTH_ID)) {
            this.setBendWidth((Double)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(BEND_HEIGHT_ID)) {
            this.setBendHeight((Double)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(ANTI_ALIASING_ID)) {
            this.setUsingAntiAliasing((Boolean)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

