/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editor.ui.h2;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSProperty;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Shape;
import java.awt.print.PrinterGraphics;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;

public abstract class TSEJComponentNodeUI
extends TSENodeUI {
    public static TSEInspectorPropertyID MARGIN_SIZE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Margin_Size"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEJComponentNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID MARGIN_COLOR_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Margin_Color"), class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSEJComponentNodeUI.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor);
    public static TSEInspectorPropertyID MINIMUM_JCOMPONENT_SIZE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Min._Component_Size"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEJComponentNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID MAXIMUM_JCOMPONENT_SIZE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Max._Component_Size"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEJComponentNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String MARGINSIZE = "marginSize";
    public static final String MARGIN_COLOR = "marginColor";
    public static final String MINIMUMJCOMPONENTSIZE = "minJCSize";
    public static final String MAXIMUMJCOMPONENTSIZE = "maxJCSize";
    static final int MARGIN_SIZE = 0;
    static final int MINIMUM_JCOMPONENT_SIZE = 50;
    static final int MAXIMUM_JCOMPONENT_SIZE = 2000;
    int marginSize;
    TSEColor marginColor;
    int minimumJComponentSize;
    int maximumJComponentSize;
    JComponent jComponent;
    boolean onCanvas;
    boolean onscreen;
    TSEGraphWindow parentWindow;
    EventListener eventListener;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEColor;

    public void reset() {
        this.onCanvas = false;
        this.onscreen = false;
        this.parentWindow = null;
        this.setJComponent(this.newJComponent());
        super.reset();
        this.setMarginSize(this.getDefaultMarginSize());
        this.setMarginColor(this.getDefaultFillColor());
        this.setMinimumJComponentSize(this.getDefaultMinimumJComponentSize());
        this.setMaximumJComponentSize(this.getDefaultMaximumJComponentSize());
        this.eventListener = new h2(this);
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSEJComponentNodeUI tSEJComponentNodeUI = (TSEJComponentNodeUI)tSEObjectUI;
        this.setMarginSize(tSEJComponentNodeUI.getMarginSize());
        this.setMarginColor(tSEJComponentNodeUI.getMarginColor());
        this.setMinimumJComponentSize(tSEJComponentNodeUI.getMinimumJComponentSize());
        this.setMaximumJComponentSize(tSEJComponentNodeUI.getMaximumJComponentSize());
    }

    public abstract JComponent newJComponent();

    public boolean isOnscreen() {
        return this.onscreen;
    }

    public boolean isOnCanvas() {
        return this.onCanvas;
    }

    protected void addToCanvas() {
        if (!this.isOnCanvas()) {
            this.parentWindow.getCanvas().add(this.jComponent);
            this.onCanvas = true;
        }
    }

    protected void removeFromCanvas() {
        if (this.isOnCanvas()) {
            this.parentWindow.getCanvas().remove(this.jComponent);
            this.onCanvas = false;
            this.parentWindow.getCanvas().requestFocus();
        }
    }

    protected boolean shouldBeOnscreen(TSTransform tSTransform) {
        if (this.jComponent == null) {
            return false;
        }
        TSENode tSENode = this.getOwnerNode();
        if (tSENode == null) {
            return false;
        }
        if (tSENode.getUI() != this) {
            return false;
        }
        if (!tSENode.isViewable()) {
            return false;
        }
        TSGraphObject tSGraphObject = tSENode;
        while (tSGraphObject != null) {
            if (!((TSGraphObject)tSGraphObject).isVisible()) {
                return false;
            }
            if (tSGraphObject instanceof TSEObject && ((TSEObject)((Object)tSGraphObject)).isDragged()) {
                return false;
            }
            if (tSGraphObject instanceof TSGraph) {
                tSGraphObject = ((TSGraph)tSGraphObject).getParent();
                continue;
            }
            tSGraphObject = tSGraphObject.getOwner();
        }
        int n = tSTransform.widthToDevice(tSENode.getWidth() - 2.0 * this.getMarginWorldWidth());
        int n2 = tSTransform.heightToDevice(tSENode.getHeight() - 2.0 * this.getMarginWorldHeight());
        if (n < this.getMinimumJComponentSize() || n2 < this.getMinimumJComponentSize()) {
            return false;
        }
        return tSTransform.getWorldBounds().intersects(tSENode.getLocalBounds());
    }

    protected TSTransform getOwnerTransform() {
        return TSTransform.compose(this.parentWindow.getTransform(), ((TSEGraph)this.getOwnerNode().getOwnerGraph()).getLocalToMainDisplayGraphTransform());
    }

    protected boolean canRun() {
        if (this.parentWindow == null) {
            return false;
        }
        return this.parentWindow.isInRunMode();
    }

    protected void update(TSTransform tSTransform) {
        if (this.parentWindow == null) {
            this.attach();
            if (this.parentWindow == null) {
                return;
            }
        }
        this.onscreen = this.shouldBeOnscreen(tSTransform);
        if (!(!this.isOnCanvas() || this.isOnscreen() && this.canRun())) {
            this.removeFromCanvas();
        } else if (!this.isOnCanvas() && this.isOnscreen() && this.canRun()) {
            this.addToCanvas();
        }
        if (this.isOnCanvas()) {
            this.updateLocationFromOwner(tSTransform);
            this.updateSizeFromOwner(tSTransform);
        }
    }

    private TSEGraphWindow findGraphWindow() {
        TSEObject tSEObject = this.getOwner();
        if (tSEObject instanceof TSGraphObject) {
            TSGraphObject tSGraphObject = (TSGraphObject)((Object)tSEObject);
            do {
                TSEGraphWindow tSEGraphWindow;
                if (!(tSGraphObject instanceof TSEGraph) || (tSEGraphWindow = ((TSEGraph)tSGraphObject).getGraphWindow()) == null || tSEGraphWindow.isOverview()) continue;
                return tSEGraphWindow;
            } while ((tSGraphObject = tSGraphObject.getOwner()) != null);
        }
        return null;
    }

    protected void attach() {
        this.detach();
        this.parentWindow = this.findGraphWindow();
        if (this.parentWindow != null) {
            this.registerListeners();
        }
    }

    protected void detach() {
        if (this.parentWindow != null) {
            this.unregisterListeners();
            if (this.jComponent != null) {
                this.removeFromCanvas();
            }
            this.parentWindow = null;
        }
    }

    protected void initializeJComponent() {
    }

    public void setJComponent(JComponent jComponent) {
        this.attach();
        this.jComponent = jComponent;
        this.onCanvas = false;
        if (this.jComponent != null) {
            this.initializeJComponent();
            if (this.parentWindow != null) {
                TSTransform tSTransform = this.parentWindow.getTransform();
                this.updateLocationFromOwner(tSTransform);
                this.updateSizeFromOwner(tSTransform);
                if (this.shouldBeOnscreen(tSTransform) && this.canRun()) {
                    this.addToCanvas();
                }
            }
        }
    }

    public void setOwner(TSENode tSENode) {
        super.setOwner(tSENode);
        this.updateOwnerSize();
        if (this.parentWindow != null) {
            TSTransform tSTransform = this.parentWindow.getTransform();
            this.updateLocationFromOwner(tSTransform);
            if (this.shouldBeOnscreen(tSTransform) && this.canRun()) {
                this.addToCanvas();
            }
        }
    }

    public final JComponent getJComponent() {
        return this.jComponent;
    }

    public final TSEGraphWindow getParentWindow() {
        return this.parentWindow;
    }

    public TSEFont getFont() {
        if (this.jComponent == null) {
            return null;
        }
        return new TSEFont(this.jComponent.getFont());
    }

    public Font getScaledFont(TSTransform tSTransform) {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getFont();
    }

    protected void updateLocationFromOwner(TSTransform tSTransform) {
        Point point = new Point(tSTransform.xToDevice(this.getOwner().getLocalLeft()) + this.getMarginDeviceWidth(tSTransform), tSTransform.yToDevice(this.getOwner().getLocalTop()) + this.getMarginDeviceHeight(tSTransform));
        if (!point.equals(this.jComponent.getLocation())) {
            this.jComponent.setLocation(point);
        }
    }

    protected void updateSizeFromOwner(TSTransform tSTransform) {
        Dimension dimension = new Dimension(tSTransform.widthToDevice(this.getOwner().getLocalWidth()) - 2 * this.getMarginDeviceWidth(tSTransform), tSTransform.heightToDevice(this.getOwner().getLocalHeight()) - 2 * this.getMarginDeviceHeight(tSTransform));
        if (!dimension.equals(this.jComponent.getSize())) {
            this.jComponent.setSize(dimension);
            this.jComponent.validate();
        }
    }

    public void updateOwnerSize() {
        TSENode tSENode = this.getOwnerNode();
        if (tSENode != null) {
            tSENode.setLocalAdjustedSize(this.getTightWidth(), this.getTightHeight());
            tSENode.setLocalAdjustedOriginalSize(this.getTightWidth(), this.getTightHeight());
        }
    }

    public void updateOwnerSize(TSTransform tSTransform) {
        TSENode tSENode = this.getOwnerNode();
        if (tSENode != null) {
            tSENode.setLocalAdjustedSize(tSTransform.widthToWorld((int)this.getTightWidth()), tSTransform.heightToWorld((int)this.getTightHeight()));
            tSENode.setLocalAdjustedOriginalSize(tSTransform.widthToWorld((int)this.getTightWidth()), tSTransform.heightToWorld((int)this.getTightHeight()));
        }
    }

    public double getTightWidth() {
        if (this.jComponent != null) {
            return this.jComponent.getPreferredSize().width + 2 * this.getMarginSize();
        }
        return super.getTightWidth();
    }

    public double getTightHeight() {
        if (this.jComponent != null) {
            return this.jComponent.getPreferredSize().height + 2 * this.getMarginSize();
        }
        return super.getTightHeight();
    }

    public void drawProxy(TSEGraphics tSEGraphics, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            tSEGraphics.setColor(TSEColor.paleGray);
            tSEGraphics.fillRect(n, n2, n3, n4);
            int n5 = n3 / 2;
            int n6 = n4 / 2;
            tSEGraphics.setColor(TSEColor.white);
            tSEGraphics.fillRect(n, n2, n5, n6);
            tSEGraphics.fillRect(n + n5, n2 + n6, n3 - n5, n4 - n6);
        }
        tSEGraphics.setColor(TSEColor.gray);
        tSEGraphics.drawRect(n, n2, n3, n4);
    }

    protected void drawComponent(TSEGraphics tSEGraphics, int n, int n2, int n3, int n4) {
        boolean bl;
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        Point point = this.jComponent.getLocation();
        Dimension dimension = this.jComponent.getSize();
        boolean bl2 = this.parentWindow != null;
        this.update(tSTransform);
        boolean bl3 = bl = this.isOnscreen() && !this.isOnCanvas();
        if (this.parentWindow == null || !this.isOnCanvas() && !bl) {
            this.drawProxy(tSEGraphics, n, n2, n3, n4);
            return;
        }
        Cursor cursor = this.jComponent.getCursor();
        if (bl) {
            this.jComponent.setCursor(this.parentWindow.getCursorOnCanvas());
            this.parentWindow.getCanvas().add(this.jComponent);
            this.updateLocationFromOwner(tSTransform);
            this.updateSizeFromOwner(tSTransform);
        }
        Shape shape = tSEGraphics.getClip();
        tSEGraphics.translate(n, n2);
        tSEGraphics.clipRect(0, 0, n3, n4);
        if (tSEGraphics instanceof PrinterGraphics) {
            this.jComponent.printAll(tSEGraphics);
        } else {
            this.jComponent.paintAll(tSEGraphics);
            if (!this.jComponent.isShowing()) {
                this.jComponent.paint(tSEGraphics);
            }
        }
        tSEGraphics.translate(-n, -n2);
        tSEGraphics.setClip(shape);
        if (bl) {
            this.parentWindow.getCanvas().remove(this.jComponent);
            this.jComponent.setCursor(cursor);
        }
        if (bl2) {
            this.jComponent.setLocation(point);
            this.jComponent.setSize(dimension);
            this.jComponent.validate();
        }
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        TSENode tSENode = this.getOwnerNode();
        int n = tSTransform.xToDevice(tSENode.getLocalLeft());
        int n2 = tSTransform.yToDevice(tSENode.getLocalTop());
        int n3 = tSTransform.widthToDevice(tSENode.getLocalWidth());
        int n4 = tSTransform.heightToDevice(tSENode.getLocalHeight());
        if (!this.isTransparent()) {
            tSEGraphics.setColor(this.getMarginColor());
            tSEGraphics.fillRect(n, n2, n3, n4);
        }
        int n5 = n3 - 2 * this.getMarginDeviceWidth(tSTransform);
        int n6 = n4 - 2 * this.getMarginDeviceHeight(tSTransform);
        if (n5 > 0 && n6 > 0) {
            int n7 = n + this.getMarginDeviceWidth(tSTransform);
            int n8 = n2 + this.getMarginDeviceHeight(tSTransform);
            if (this.jComponent == null) {
                this.drawProxy(tSEGraphics, n7, n8, n5, n6);
            } else {
                this.drawComponent(tSEGraphics, n7, n8, n5, n6);
            }
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor());
            tSEGraphics.drawRect(n, n2, n3, n4);
        }
        if (this.getOwnerNode().hasChildGraph()) {
            this.drawChildGraphMark(tSEGraphics);
        }
        if (this.hasHideMark()) {
            this.drawHideMark(tSEGraphics);
        }
        this.drawConstraintBadge(tSEGraphics);
    }

    public void drawOutline(TSEGraphics tSEGraphics) {
        this.removeFromCanvas();
        super.drawOutline(tSEGraphics);
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getMarginSize() != this.getDefaultMarginSize()) {
            list.add(new TSProperty(MARGINSIZE, new Integer(this.getMarginSize())));
        }
        if (this.getMinimumJComponentSize() != this.getDefaultMinimumJComponentSize()) {
            list.add(new TSProperty(MINIMUMJCOMPONENTSIZE, new Integer(this.getMinimumJComponentSize())));
        }
        if (this.getMaximumJComponentSize() != this.getDefaultMaximumJComponentSize()) {
            list.add(new TSProperty(MAXIMUMJCOMPONENTSIZE, new Integer(this.getMaximumJComponentSize())));
        }
        return list;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(MARGINSIZE, new Integer(this.getMarginSize())));
        list.add(new TSProperty(MARGIN_COLOR, this.getMarginColor()));
        list.add(new TSProperty(MINIMUMJCOMPONENTSIZE, new Integer(this.getMinimumJComponentSize())));
        list.add(new TSProperty(MAXIMUMJCOMPONENTSIZE, new Integer(this.getMaximumJComponentSize())));
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (MINIMUMJCOMPONENTSIZE.equals(tSProperty.getName())) {
            this.setMinimumJComponentSize(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (MAXIMUMJCOMPONENTSIZE.equals(tSProperty.getName())) {
            this.setMaximumJComponentSize(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (MARGINSIZE.equals(tSProperty.getName())) {
            this.setMarginSize(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (MARGIN_COLOR.equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEColor) {
                this.setMarginColor((TSEColor)tSProperty.getValue());
            } else {
                this.setMarginColor(this.parseColor(tSProperty.getValue().toString()));
            }
        } else {
            super.setProperty(tSProperty);
        }
    }

    public int getMinimumJComponentSize() {
        return this.minimumJComponentSize;
    }

    public void setMinimumJComponentSize(int n) {
        if (n >= 0) {
            Integer n2 = new Integer(this.minimumJComponentSize);
            this.minimumJComponentSize = n;
            this.firePropertyChangedEvent(MINIMUMJCOMPONENTSIZE, n2, new Integer(n));
        }
    }

    public int getMaximumJComponentSize() {
        return this.maximumJComponentSize;
    }

    public void setMaximumJComponentSize(int n) {
        if (n >= 0) {
            Integer n2 = new Integer(this.maximumJComponentSize);
            this.maximumJComponentSize = n;
            this.firePropertyChangedEvent(MAXIMUMJCOMPONENTSIZE, n2, new Integer(n));
        }
    }

    public int getMarginSize() {
        return this.marginSize;
    }

    public void setMarginSize(int n) {
        if (n >= 0) {
            Integer n2 = new Integer(this.marginSize);
            this.marginSize = n;
            this.firePropertyChangedEvent(MARGINSIZE, n2, new Integer(n));
        }
    }

    public TSEColor getMarginColor() {
        return this.marginColor;
    }

    public void setMarginColor(TSEColor tSEColor) {
        TSEColor tSEColor2 = this.marginColor;
        this.marginColor = tSEColor;
        this.firePropertyChangedEvent(MARGIN_COLOR, tSEColor2, tSEColor);
    }

    public void setFillColor(TSEColor tSEColor) {
        if (this.getJComponent() != null) {
            if (tSEColor != null) {
                this.getJComponent().setBackground(tSEColor.getColor());
            } else {
                this.getJComponent().setBackground(null);
            }
        }
        super.setFillColor(tSEColor);
    }

    protected double getMarginWorldWidth() {
        return this.parentWindow.getTransform().widthToWorld(this.getMarginSize());
    }

    protected double getMarginWorldHeight() {
        return this.parentWindow.getTransform().heightToWorld(this.getMarginSize());
    }

    protected int getMarginDeviceWidth(TSTransform tSTransform) {
        if (this.parentWindow != null) {
            return tSTransform.widthToDevice(this.parentWindow.getTransform().widthToWorld(this.getMarginSize()));
        }
        return this.getMarginSize();
    }

    protected int getMarginDeviceHeight(TSTransform tSTransform) {
        if (this.parentWindow != null) {
            return tSTransform.heightToDevice(this.parentWindow.getTransform().heightToWorld(this.getMarginSize()));
        }
        return this.getMarginSize();
    }

    public void getInspectorPropertyIDs(List list) {
        super.getInspectorPropertyIDs(list);
        list.add(MARGIN_SIZE_ID);
        list.add(MARGIN_COLOR_ID);
        list.add(MINIMUM_JCOMPONENT_SIZE_ID);
        list.add(MAXIMUM_JCOMPONENT_SIZE_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty = tSEInspectorPropertyID.equals(MARGIN_SIZE_ID) ? new TSENumericInspectorProperty((Number)new Integer(this.getMarginSize()), new Integer(0), new Integer(99)) : (tSEInspectorPropertyID.equals(MARGIN_COLOR_ID) ? new TSEInspectorProperty(this.getMarginColor()) : (tSEInspectorPropertyID.equals(MINIMUM_JCOMPONENT_SIZE_ID) ? new TSENumericInspectorProperty((Number)new Integer(this.getMinimumJComponentSize()), new Integer(0), new Integer(9999)) : (tSEInspectorPropertyID.equals(MAXIMUM_JCOMPONENT_SIZE_ID) ? new TSENumericInspectorProperty((Number)new Integer(this.getMaximumJComponentSize()), new Integer(0), new Integer(99999)) : super.getInspectorProperty(tSEInspectorPropertyID))));
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(MARGIN_SIZE_ID)) {
            this.setMarginSize((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(MARGIN_COLOR_ID)) {
            this.setMarginColor((TSEColor)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(MAXIMUM_JCOMPONENT_SIZE_ID)) {
            this.setMaximumJComponentSize((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(MINIMUM_JCOMPONENT_SIZE_ID)) {
            this.setMinimumJComponentSize((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    public int getDefaultMarginSize() {
        return 0;
    }

    public int getDefaultMinimumJComponentSize() {
        return 50;
    }

    public int getDefaultMaximumJComponentSize() {
        return 2000;
    }

    public boolean isBorderDrawnByDefault() {
        return false;
    }

    public void registerListeners() {
        TSEGraphManager tSEGraphManager = this.parentWindow.getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        TSEObject tSEObject = this.getOwner();
        tSEEventManager.addGraphChangeListener(tSEGraphManager, this.eventListener);
        tSEEventManager.addDrawingChangeListener(tSEGraphManager, this.eventListener);
        tSEEventManager.addComplexityChangeListener(tSEGraphManager, this.eventListener);
        tSEEventManager.addViewportChangeListener(this.parentWindow, this.eventListener);
        tSEEventManager.addPropertyChangeListener(tSEObject, this.eventListener);
        tSEEventManager.addModeChangeListener(this.parentWindow, this.eventListener);
    }

    public void unregisterListeners() {
        this.parentWindow.getGraphManager().getEventManager().removeListener(this.eventListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

