/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;

public abstract class TSERectangularUI
extends TSEObjectUI {
    public static TSEInspectorPropertyID COLOR_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Color"), class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSERectangularUI.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor);
    public static TSEInspectorPropertyID BORDER_COLOR_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Border_Color"), class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSERectangularUI.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor);
    public static TSEInspectorPropertyID TRANSPARENT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Transparent"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = TSERectangularUI.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TSEInspectorPropertyID SHOW_BORDER_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Show_Border"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = TSERectangularUI.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static final String FILL_COLOR = "fillColor";
    public static final String BORDER_COLOR = "borderColor";
    public static final String TRANSPARENT = "transparent";
    public static final String DRAW_BORDER = "drawBorder";
    public static final int[] DEFAULT_GRAPPLE_SIZES = new int[]{3, 5, 7, 9};
    public static final double[] DEFAULT_GRAPPLE_THRESHOLDS = new double[]{0.4444, 1.7778, 4.0};
    TSTransform transform = null;
    Rectangle tempGrappleBounds = new Rectangle();
    TSRect tempTransformRect = new TSRect();
    boolean grapplesOutOfDate;
    int[] grappleSizes;
    double[] grappleThresholds;
    TSEColor fillColor;
    TSEColor borderColor;
    boolean transparent;
    boolean drawBorder;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEColor;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void reset() {
        super.reset();
        this.invalidateGrapples();
        this.setDefaultGrappleSizes();
        this.setBorderColor(this.getDefaultBorderColor());
        this.setFillColor(this.getDefaultFillColor());
        this.setTransparent(this.isTransparentByDefault());
        this.setBorderDrawn(this.isBorderDrawnByDefault());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSERectangularUI tSERectangularUI = (TSERectangularUI)tSEObjectUI;
        this.setBorderColor(tSERectangularUI.getBorderColor());
        this.setFillColor(tSERectangularUI.getFillColor());
        this.setTransparent(tSERectangularUI.isTransparent());
        this.setBorderDrawn(tSERectangularUI.isBorderDrawn());
    }

    public void drawSelected(TSEGraphics tSEGraphics) {
        this.draw(tSEGraphics);
        tSEGraphics.setColor(this.getSelectedColor());
        this.drawGrapples(tSEGraphics);
    }

    public void drawSelectedOutline(TSEGraphics tSEGraphics) {
        tSEGraphics.setColor(this.getSelectedColor());
        this.drawOutline(tSEGraphics);
        this.drawGrappleOutlines(tSEGraphics);
    }

    public void drawOutline(TSEGraphics tSEGraphics) {
        tSEGraphics.drawRect(this.getOwner().getLocalBounds());
    }

    public void drawGrapples(TSEGraphics tSEGraphics) {
        if (this.grapplesOutOfDate) {
            this.updateGrapples(tSEGraphics.getTSTransform());
        }
        this.drawGrapple(tSEGraphics, 1);
        this.drawGrapple(tSEGraphics, 8);
        this.drawGrapple(tSEGraphics, 4);
        this.drawGrapple(tSEGraphics, 2);
        this.drawGrapple(tSEGraphics, 9);
        this.drawGrapple(tSEGraphics, 5);
        this.drawGrapple(tSEGraphics, 10);
        this.drawGrapple(tSEGraphics, 6);
        this.drawGrapple(tSEGraphics, 16);
    }

    public void drawGrappleOutlines(TSEGraphics tSEGraphics) {
        if (this.grapplesOutOfDate) {
            this.updateGrapples(tSEGraphics.getTSTransform());
        }
        this.drawGrappleOutline(tSEGraphics, 1);
        this.drawGrappleOutline(tSEGraphics, 8);
        this.drawGrappleOutline(tSEGraphics, 4);
        this.drawGrappleOutline(tSEGraphics, 2);
        this.drawGrappleOutline(tSEGraphics, 9);
        this.drawGrappleOutline(tSEGraphics, 5);
        this.drawGrappleOutline(tSEGraphics, 10);
        this.drawGrappleOutline(tSEGraphics, 6);
        this.drawGrappleOutline(tSEGraphics, 16);
    }

    protected boolean isGrappleVisible(int n, Rectangle rectangle) {
        return rectangle.getWidth() > 0.0 && rectangle.getHeight() > 0.0;
    }

    public boolean isGrappleEnabled(int n) {
        if (!(this.getOwner() instanceof TSESolidObject)) {
            return false;
        }
        TSESolidObject tSESolidObject = (TSESolidObject)this.getOwner();
        int n2 = tSESolidObject.getResizability();
        if ((n2 & 0x1000000) != 0 || !this.isResizable()) {
            return n == 16;
        }
        if (n == 1 || n == 2) {
            return (n2 & 4) == 0 && (n2 & 2) == 0;
        }
        if (n == 8 || n == 4) {
            return (n2 & 4) == 0 && (n2 & 1) == 0;
        }
        if (n == 9 || n == 5 || n == 10 || n == 6) {
            return (n2 & 1) == 0 && (n2 & 2) == 0;
        }
        return true;
    }

    public boolean isResizable() {
        return true;
    }

    public void drawGrapple(TSEGraphics tSEGraphics, int n) {
        Rectangle rectangle = this.getGrappleBounds(n);
        if (this.isGrappleVisible(n, rectangle)) {
            if (this.isGrappleEnabled(n)) {
                this.drawEnabledGrapple(tSEGraphics, n, rectangle);
            } else {
                this.drawDisabledGrapple(tSEGraphics, n, rectangle);
            }
        }
    }

    public void drawGrappleOutline(TSEGraphics tSEGraphics, int n) {
        Rectangle rectangle = this.getGrappleBounds(n);
        if (this.isGrappleVisible(n, rectangle)) {
            if (this.isGrappleEnabled(n)) {
                this.drawEnabledGrappleOutline(tSEGraphics, n, rectangle);
            } else {
                this.drawDisabledGrappleOutline(tSEGraphics, n, rectangle);
            }
        }
    }

    public void drawEnabledGrapple(TSEGraphics tSEGraphics, int n, Rectangle rectangle) {
        tSEGraphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawDisabledGrapple(TSEGraphics tSEGraphics, int n, Rectangle rectangle) {
        if (rectangle.width > 1 && rectangle.height > 1) {
            tSEGraphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        if (rectangle.width > 2 && rectangle.height > 2) {
            tSEGraphics.setColor(Color.white);
            tSEGraphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            tSEGraphics.setColor(this.getSelectedColor());
        }
    }

    public void drawEnabledGrappleOutline(TSEGraphics tSEGraphics, int n, Rectangle rectangle) {
        tSEGraphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public void drawDisabledGrappleOutline(TSEGraphics tSEGraphics, int n, Rectangle rectangle) {
        if (rectangle.width > 1 && rectangle.height > 1) {
            tSEGraphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    public int getGrappleTouchingBounds(Rectangle rectangle, TSTransform tSTransform) {
        if (this.grapplesOutOfDate) {
            this.updateGrapples(tSTransform);
        }
        int n = this.intersectsGrappleBounds(1, rectangle) ? 1 : (this.intersectsGrappleBounds(2, rectangle) ? 2 : (this.intersectsGrappleBounds(8, rectangle) ? 8 : (this.intersectsGrappleBounds(4, rectangle) ? 4 : (this.intersectsGrappleBounds(9, rectangle) ? 9 : (this.intersectsGrappleBounds(5, rectangle) ? 5 : (this.intersectsGrappleBounds(10, rectangle) ? 10 : (this.intersectsGrappleBounds(6, rectangle) ? 6 : (this.intersectsGrappleBounds(16, rectangle) ? 16 : 0))))))));
        return n;
    }

    public int getGrappleContainingPoint(int n, int n2, TSTransform tSTransform) {
        if (this.grapplesOutOfDate) {
            this.updateGrapples(tSTransform);
        }
        int n3 = this.getGrappleBounds(1).contains(n, n2) ? 1 : (this.getGrappleBounds(2).contains(n, n2) ? 2 : (this.getGrappleBounds(8).contains(n, n2) ? 8 : (this.getGrappleBounds(4).contains(n, n2) ? 4 : (this.getGrappleBounds(9).contains(n, n2) ? 9 : (this.getGrappleBounds(5).contains(n, n2) ? 5 : (this.getGrappleBounds(10).contains(n, n2) ? 10 : (this.getGrappleBounds(6).contains(n, n2) ? 6 : (this.getGrappleBounds(16).contains(n, n2) ? 16 : 0))))))));
        return n3;
    }

    protected boolean intersectsGrappleBounds(int n, Rectangle rectangle) {
        Rectangle rectangle2 = this.getGrappleBounds(n);
        return rectangle2.intersects(rectangle);
    }

    protected void updateGrapples(TSTransform tSTransform) {
        if (!this.grapplesOutOfDate) {
            return;
        }
        this.transform = tSTransform;
    }

    public Rectangle getGrappleBounds(int n) {
        boolean bl;
        int n2 = this.getGrappleSize(this.transform.getScaleX());
        int n3 = n2 / 2;
        this.tempGrappleBounds.setBounds(this.transform.xToDevice(this.getLeft()) - 1, this.transform.yToDevice(this.getTop()) - 1, this.transform.widthToDevice(this.getWidth()) + 2, this.transform.heightToDevice(this.getHeight()) + 2);
        int n4 = this.tempGrappleBounds.x - n2 + 1;
        int n5 = this.tempGrappleBounds.y - n2 + 1;
        int n6 = this.tempGrappleBounds.x + this.tempGrappleBounds.width / 2 - n3;
        int n7 = this.tempGrappleBounds.y + this.tempGrappleBounds.height / 2 - n3;
        int n8 = this.tempGrappleBounds.x + this.tempGrappleBounds.width;
        int n9 = this.tempGrappleBounds.y + this.tempGrappleBounds.height;
        int n10 = n2 + 2;
        boolean bl2 = this.tempGrappleBounds.width < n10;
        boolean bl3 = bl = this.tempGrappleBounds.height < n10;
        if (n == 1 || n == 2) {
            int n11 = n == 1 ? n5 : n9;
            if (bl2) {
                if (this.isGrappleEnabled(1) && this.isGrappleEnabled(2) && !this.isGrappleEnabled(5) && !this.isGrappleEnabled(9) && !this.isGrappleEnabled(6) && !this.isGrappleEnabled(10)) {
                    this.tempGrappleBounds.setBounds(n6, n11, n2, n2);
                } else {
                    this.tempGrappleBounds.setBounds(n6, n11, 0, 0);
                }
            } else {
                this.tempGrappleBounds.setBounds(n6, n11, n2, n2);
            }
        } else if (n == 8 || n == 4) {
            int n12 = n == 8 ? n4 : n8;
            if (bl) {
                if (this.isGrappleEnabled(8) && this.isGrappleEnabled(4) && !this.isGrappleEnabled(5) && !this.isGrappleEnabled(9) && !this.isGrappleEnabled(6) && !this.isGrappleEnabled(10)) {
                    this.tempGrappleBounds.setBounds(n12, n7, n2, n2);
                } else {
                    this.tempGrappleBounds.setBounds(n12, n7, 0, 0);
                }
            } else {
                this.tempGrappleBounds.setBounds(n12, n7, n2, n2);
            }
        } else if (n == 16) {
            boolean bl4;
            boolean bl5 = bl4 = this.tempGrappleBounds.width >= n2 || this.tempGrappleBounds.height >= n2;
            if (bl4) {
                this.tempGrappleBounds.setBounds(n6, n7, 0, 0);
            } else {
                this.tempGrappleBounds.setBounds(n6, n7, n2, n2);
            }
        } else if (n == 9 || n == 5 || n == 10 || n == 6) {
            int n13;
            int n14;
            boolean bl6;
            boolean bl7 = bl6 = this.tempGrappleBounds.width < n2 && this.tempGrappleBounds.height < n2;
            if (bl) {
                if (this.isGrappleEnabled(8) && this.isGrappleEnabled(4) && !this.isGrappleEnabled(5) && !this.isGrappleEnabled(9) && !this.isGrappleEnabled(6) && !this.isGrappleEnabled(10)) {
                    bl6 = true;
                }
            } else if (bl2 && this.isGrappleEnabled(1) && this.isGrappleEnabled(2) && !this.isGrappleEnabled(5) && !this.isGrappleEnabled(9) && !this.isGrappleEnabled(6) && !this.isGrappleEnabled(10)) {
                bl6 = true;
            }
            if (n == 9) {
                n14 = n4;
                n13 = n5;
            } else if (n == 5) {
                n14 = n8;
                n13 = n5;
            } else if (n == 10) {
                n14 = n4;
                n13 = n9;
            } else {
                n14 = n8;
                n13 = n9;
            }
            if (bl6) {
                this.tempGrappleBounds.setBounds(n14, n13, 0, 0);
            } else {
                this.tempGrappleBounds.setBounds(n14, n13, n2, n2);
            }
        }
        return this.tempGrappleBounds;
    }

    public double getLeft() {
        return this.getOwner().getLocalLeft();
    }

    public double getRight() {
        return this.getOwner().getLocalRight();
    }

    public double getTop() {
        return this.getOwner().getLocalTop();
    }

    public double getBottom() {
        return this.getOwner().getLocalBottom();
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.getOwner().locallyIntersects(d, d2, d3, d4);
    }

    public boolean invalidRegionIntersects(TSConstRect tSConstRect, TSTransform tSTransform, TSExpTransform tSExpTransform) {
        return this.getInvalidRegion(tSTransform, tSExpTransform).intersects(tSConstRect);
    }

    public TSConstRect getInvalidRegion(TSTransform tSTransform, TSExpTransform tSExpTransform) {
        TSSystem.tsAssert(tSTransform != null);
        TSSystem.tsAssert(tSExpTransform != null);
        if (this.getOwner().isSelected() || !this.getOwner().isOwned()) {
            this.tempTransformRect.setBounds(tSExpTransform.transformX(this.getLeft()), tSExpTransform.transformY(this.getBottom()), tSExpTransform.transformX(this.getRight()), tSExpTransform.transformY(this.getTop()));
            int n = this.getGrappleSize(tSTransform.getScaleX());
            double d = tSTransform.widthToWorld(1);
            double d2 = tSTransform.heightToWorld(1);
            this.tempTransformRect.setBounds(this.tempTransformRect.getLeft() - tSTransform.widthToWorld(n) - d, this.tempTransformRect.getBottom() - tSTransform.heightToWorld(n) - d2, this.tempTransformRect.getRight() + tSTransform.widthToWorld(n) + d, this.tempTransformRect.getTop() + tSTransform.heightToWorld(n) + d2);
            return this.tempTransformRect;
        }
        if (((TSEGraph)this.getOwner().getOwnerGraph()).isMainDisplayGraph()) {
            return this.getOwner().getLocalBounds();
        }
        return this.getOwner().getBounds();
    }

    public TSEColor getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(TSEColor tSEColor) {
        TSEColor tSEColor2 = this.borderColor;
        this.borderColor = tSEColor;
        this.firePropertyChangedEvent(BORDER_COLOR, tSEColor2, tSEColor);
    }

    public boolean isBorderDrawn() {
        return this.drawBorder;
    }

    public void setBorderDrawn(boolean bl) {
        Boolean bl2 = new Boolean(this.drawBorder);
        this.drawBorder = bl;
        this.firePropertyChangedEvent(DRAW_BORDER, bl2, new Boolean(bl));
    }

    public TSEColor getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(TSEColor tSEColor) {
        TSEColor tSEColor2 = this.fillColor;
        this.fillColor = tSEColor;
        this.firePropertyChangedEvent(FILL_COLOR, tSEColor2, tSEColor);
    }

    public void invalidateGrapples() {
        this.grapplesOutOfDate = true;
    }

    public void setGrappleSizes(int[] nArray, double[] dArray) {
        if (nArray != null && dArray != null && dArray.length == nArray.length - 1) {
            this.grappleSizes = nArray;
            this.grappleThresholds = dArray;
        }
    }

    protected int getGrappleSize(double d) {
        if (this.grappleSizes == null || this.grappleThresholds == null || this.grappleThresholds.length != this.grappleSizes.length - 1) {
            return 3;
        }
        for (int i = 0; i < this.grappleThresholds.length; ++i) {
            if (!(d < this.grappleThresholds[i])) continue;
            return this.grappleSizes[i];
        }
        return this.grappleSizes[this.grappleSizes.length - 1];
    }

    protected void setDefaultGrappleSizes() {
        this.setGrappleSizes(DEFAULT_GRAPPLE_SIZES, DEFAULT_GRAPPLE_THRESHOLDS);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        Boolean bl2 = new Boolean(this.transparent);
        this.transparent = bl;
        this.firePropertyChangedEvent(TRANSPARENT, bl2, new Boolean(bl));
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(FILL_COLOR, this.getFillColor()));
        list.add(new TSProperty(BORDER_COLOR, this.getBorderColor()));
        list.add(new TSProperty(TRANSPARENT, new Boolean(this.isTransparent())));
        list.add(new TSProperty(DRAW_BORDER, new Boolean(this.isBorderDrawn())));
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        String string = null;
        if (tSProperty.getValue() != null) {
            string = tSProperty.getValue().toString();
        }
        if (FILL_COLOR.equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEColor) {
                this.setFillColor((TSEColor)tSProperty.getValue());
            } else {
                this.setFillColor(this.parseColor(tSProperty.getValue().toString()));
            }
        } else if (BORDER_COLOR.equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEColor) {
                this.setBorderColor((TSEColor)tSProperty.getValue());
            } else {
                this.setBorderColor(new TSEColor(tSProperty.getValue().toString()));
            }
        } else if (TRANSPARENT.equals(tSProperty.getName())) {
            this.setTransparent(Boolean.valueOf(string));
        } else if (DRAW_BORDER.equals(tSProperty.getName())) {
            this.setBorderDrawn(Boolean.valueOf(string));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (!this.getDefaultFillColor().equals(this.getFillColor())) {
            list.add(new TSProperty(FILL_COLOR, this.getFillColor()));
        }
        if (!this.getDefaultBorderColor().equals(this.getBorderColor())) {
            list.add(new TSProperty(BORDER_COLOR, this.getBorderColor()));
        }
        if (this.isTransparentByDefault() != this.isTransparent()) {
            list.add(new TSProperty(TRANSPARENT, new Boolean(this.isTransparent())));
        }
        if (this.isBorderDrawnByDefault() != this.isBorderDrawn()) {
            list.add(new TSProperty(DRAW_BORDER, new Boolean(this.isBorderDrawn())));
        }
        return list;
    }

    public TSEColor getDefaultBorderColor() {
        return TSEColor.black;
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.paleGray;
    }

    public int getDefaultGrappleSize() {
        return 4;
    }

    public boolean isTransparentByDefault() {
        return false;
    }

    public boolean isBorderDrawnByDefault() {
        return true;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(COLOR_ID);
        list.add(TRANSPARENT_ID);
        list.add(BORDER_COLOR_ID);
        list.add(SHOW_BORDER_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty = tSEInspectorPropertyID.equals(COLOR_ID) ? new TSEInspectorProperty(this.getFillColor()) : (tSEInspectorPropertyID.equals(BORDER_COLOR_ID) ? new TSEInspectorProperty(this.getBorderColor()) : (tSEInspectorPropertyID.equals(TRANSPARENT_ID) ? new TSEInspectorProperty(new Boolean(this.isTransparent())) : (tSEInspectorPropertyID.equals(SHOW_BORDER_ID) ? new TSEInspectorProperty(new Boolean(this.isBorderDrawn())) : super.getInspectorProperty(tSEInspectorPropertyID))));
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(COLOR_ID)) {
            this.setFillColor((TSEColor)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(BORDER_COLOR_ID)) {
            this.setBorderColor((TSEColor)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(TRANSPARENT_ID)) {
            this.setTransparent((Boolean)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(SHOW_BORDER_ID)) {
            this.setBorderDrawn((Boolean)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    public double getMinimumWidth() {
        return -1.0;
    }

    public double getMinimumHeight() {
        return -1.0;
    }

    public double getTightWidth() {
        return this.getMinimumWidth();
    }

    public double getTightHeight() {
        return this.getMinimumHeight();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

