/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.dialog.TSFileFilter;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEFilenameInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.util.TSProperty;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class TSEImageNodeUI
extends TSENodeUI
implements ImageObserver {
    public static TSEInspectorPropertyID PICTURE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Picture"), class$java$lang$String == null ? (class$java$lang$String = TSEImageNodeUI.class$("java.lang.String")) : class$java$lang$String);
    public static final String GIF_FILTER_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("GIF_Image_(*.gif)");
    public static final String JPEG_FILTER_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("JPEG_Image_(*.jpg)");
    public static final String IMAGE = "imageUsed";
    public static final String IMAGE_URL = "imageURL";
    public static final String TEXT = "text";
    public static final String SCALE = "scale";
    public static final String FIT_TO_IMAGE = "fit";
    TSEImage image;
    double imageWidth;
    double imageHeight;
    String defaultText;
    boolean imageScaled;
    boolean fitToImage;
    double currentImageWidth;
    double currentImageHeight;
    static /* synthetic */ Class class$java$lang$String;

    public void reset() {
        super.reset();
        this.setImageScaled(this.isImageScaledByDefault());
        this.setFitToImage(this.isFitToImageByDefault());
        this.setFormattingEnabled(false);
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSEImageNodeUI tSEImageNodeUI = (TSEImageNodeUI)tSEObjectUI;
        this.image = new TSEImage(tSEImageNodeUI.image);
        this.defaultText = tSEImageNodeUI.getDefaultText();
        this.imageWidth = tSEImageNodeUI.imageWidth;
        this.imageHeight = tSEImageNodeUI.imageHeight;
        this.currentImageWidth = tSEImageNodeUI.currentImageWidth;
        this.currentImageHeight = tSEImageNodeUI.currentImageHeight;
        this.setImageScaled(tSEImageNodeUI.isImageScaled());
        this.setFitToImage(tSEImageNodeUI.isFitToImage());
    }

    public void drawProxy(TSEGraphics tSEGraphics, int n, int n2, int n3, int n4) {
        tSEGraphics.setColor(Color.red);
        tSEGraphics.drawRect(n, n2, n3, n4);
        tSEGraphics.drawLine(n, n2, n + n3, n2 + n4);
        tSEGraphics.drawLine(n, n2 + n4, n + n3, n2);
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        int n = tSTransform.xToDevice(this.getOwnerNode().getLocalLeft());
        int n2 = tSTransform.yToDevice(this.getOwnerNode().getLocalTop());
        int n3 = tSTransform.widthToDevice(this.getOwnerNode().getLocalWidth());
        int n4 = tSTransform.heightToDevice(this.getOwnerNode().getLocalHeight());
        if (!this.isTransparent()) {
            tSEGraphics.setColor(this.getFillColor().getColor());
            tSEGraphics.fillRect(this.getOwnerNode().getLocalBounds());
        }
        double d = this.getOwnerNode().getLocalWidth() - 2.0 * this.getMarginWidth();
        double d2 = this.getOwnerNode().getLocalHeight() - 2.0 * this.getMarginHeight() - (double)this.getTextHeight();
        if (this.image == null || this.image.getImage() == null) {
            this.drawProxy(tSEGraphics, n, n2, tSTransform.widthToDevice(d), tSTransform.heightToDevice(d2));
        } else {
            double d3 = this.imageWidth;
            double d4 = this.imageHeight;
            if (this.isImageScaled()) {
                double d5 = Math.min(d / this.imageWidth, d2 / this.imageHeight);
                d3 *= d5;
                d4 *= d5;
            }
            this.currentImageWidth = d3;
            this.currentImageHeight = d4;
            int n5 = tSTransform.xToDevice(this.getOwnerNode().getLocalCenterX() - d3 / 2.0);
            int n6 = tSTransform.yToDevice(this.getOwnerNode().getLocalCenterY() + ((double)this.getTextHeight() + d4) / 2.0);
            int n7 = tSTransform.widthToDevice(d3);
            int n8 = tSTransform.widthToDevice(d4);
            if (n7 < 3 && n8 < 3) {
                tSEGraphics.setColor(Color.black);
                tSEGraphics.drawRect(n5, n6, n7, n8);
            } else {
                tSEGraphics.drawImage(this.image.getImage(), n5, n6, n7, n8, this);
            }
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor().getColor());
            tSEGraphics.drawRect(this.getOwnerNode().getLocalBounds());
        }
        this.drawText(tSEGraphics);
        if (this.getOwnerNode().hasChildGraph()) {
            this.drawChildGraphMark(tSEGraphics);
        }
        if (this.hasHideMark()) {
            this.drawHideMark(tSEGraphics);
        }
        this.drawConstraintBadge(tSEGraphics);
    }

    public void setImageScaled(boolean bl) {
        if (this.isFitToImage() || bl) {
            Boolean bl2 = new Boolean(this.imageScaled);
            this.imageScaled = bl;
            this.firePropertyChangedEvent(SCALE, bl2, new Boolean(bl));
        }
    }

    public boolean isImageScaled() {
        return this.imageScaled;
    }

    public void setFitToImage(boolean bl) {
        if (this.isImageScaled() || bl) {
            Boolean bl2 = new Boolean(this.fitToImage);
            this.fitToImage = bl;
            if (bl && this.getOwnerNode() != null) {
                this.getOwnerNode().setLocalAdjustedSize(this.getTightWidth(), this.getTightHeight());
                this.getOwnerNode().setLocalAdjustedOriginalSize(this.getTightWidth(), this.getTightHeight());
            }
            this.firePropertyChangedEvent(FIT_TO_IMAGE, bl2, new Boolean(bl));
        }
    }

    public boolean isFitToImage() {
        return this.fitToImage;
    }

    public void setImage(TSEImage tSEImage) {
        TSEImage tSEImage2 = this.image;
        this.image = tSEImage;
        if (tSEImage != null && tSEImage.getImage() != null) {
            this.imageWidth = tSEImage.getImage().getWidth(this);
            this.imageHeight = tSEImage.getImage().getHeight(this);
            this.currentImageWidth = this.imageWidth;
            this.currentImageHeight = this.imageHeight;
        }
        if (this.getOwnerNode() != null) {
            this.getOwnerNode().resize();
        }
        this.firePropertyChangedEvent(IMAGE, tSEImage2, tSEImage);
    }

    public TSEImage getImage() {
        return this.image;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0 || (n & 0x10) == 0;
    }

    public void setOwner(TSENode tSENode) {
        super.setOwner(tSENode);
        if (tSENode != null && this.isFitToImage()) {
            tSENode.setLocalAdjustedSize(this.getTightWidth(), this.getTightHeight());
        }
    }

    public double getMinimumWidth() {
        return (double)this.getTextWidth() + 2.0 * this.getMarginWidth();
    }

    public double getMinimumHeight() {
        return (double)this.getTextHeight() + 2.0 * this.getMarginHeight();
    }

    public double getTightWidth() {
        this.updateTextWidthAndHeight(this.getOwner().getText());
        return Math.max(this.currentImageWidth, (double)this.getTextWidth()) + 2.0 * this.getMarginWidth();
    }

    public double getTightHeight() {
        this.updateTextWidthAndHeight(this.getOwner().getText());
        return this.getMinimumHeight() + this.currentImageHeight;
    }

    public double getMarginWidth() {
        return 0.0;
    }

    public double getMarginHeight() {
        return 0.0;
    }

    public void onTextChanged(String string) {
        super.onTextChanged(string);
        this.getOwnerNode().setLocalAdjustedSize(this.getTightWidth(), this.getTightHeight());
        this.getOwnerNode().setLocalAdjustedOriginalSize(this.getOwnerNode().getLocalWidth(), this.getOwnerNode().getLocalHeight());
    }

    public void setFont(TSEFont tSEFont) {
        super.setFont(tSEFont);
        if (this.getOwnerNode() != null) {
            this.onTextChanged(this.getOwnerNode().getText());
        }
    }

    public double getTextOffsetX() {
        return 0.0;
    }

    public double getTextOffsetY() {
        return 1.0 + (double)this.getTextHeight() / 2.0 - this.getOwnerNode().getLocalHeight() / 2.0;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(IMAGE, this.getImage()));
        list.add(new TSProperty(SCALE, new Boolean(this.isImageScaled())));
        list.add(new TSProperty(FIT_TO_IMAGE, new Boolean(this.isFitToImage())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.image != null) {
            if (this.getImage().getResource() != null) {
                list.add(new TSProperty(IMAGE, TSEImage.checkPath(this.getImage().getResource())));
            } else if (this.getImage().getURL() != null) {
                list.add(new TSProperty(IMAGE_URL, this.getImage().getURL()));
            }
        }
        if (this.isImageScaled() != this.isImageScaledByDefault()) {
            list.add(new TSProperty(SCALE, new Boolean(this.isImageScaled())));
        }
        if (this.isFitToImage() != this.isFitToImageByDefault()) {
            list.add(new TSProperty(FIT_TO_IMAGE, new Boolean(this.isFitToImage())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (IMAGE.equals(tSProperty.getName()) || "image".equals(tSProperty.getName())) {
            if (tSProperty.getValue() == null || tSProperty.getValue() instanceof TSEImage) {
                this.setImage((TSEImage)tSProperty.getValue());
            } else {
                this.setImage(new TSEImage(tSProperty.getValue().toString()));
            }
        } else if (IMAGE_URL.equals(tSProperty.getName())) {
            try {
                this.setImage(new TSEImage(new URL(tSProperty.getValue().toString())));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else if (TEXT.equals(tSProperty.getName())) {
            this.defaultText = tSProperty.getValue().toString();
        } else if (SCALE.equals(tSProperty.getName())) {
            this.setImageScaled(Boolean.valueOf(tSProperty.getValue().toString()));
        } else if (FIT_TO_IMAGE.equals(tSProperty.getName())) {
            this.setFitToImage(Boolean.valueOf(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public boolean isTransparentByDefault() {
        return true;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public boolean isImageScaledByDefault() {
        return true;
    }

    public boolean isFitToImageByDefault() {
        return true;
    }

    public boolean isBorderDrawnByDefault() {
        return false;
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.white;
    }

    public void getInspectorPropertyIDs(List list) {
        if (this.getImage() != null) {
            list.add(PICTURE_ID);
        }
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        if (tSEInspectorPropertyID.equals(PICTURE_ID)) {
            String string = new String();
            if (this.image != null) {
                if (this.image.getResource() != null) {
                    string = this.image.getResource();
                } else if (this.image.getURL() != null) {
                    string = this.image.getURL().toString();
                }
            }
            TSEFilenameInspectorProperty tSEFilenameInspectorProperty = new TSEFilenameInspectorProperty(string, !string.startsWith("http"));
            tSEFilenameInspectorProperty.addFilter(new TSFileFilter("gif", GIF_FILTER_STRING));
            tSEFilenameInspectorProperty.addFilter(new TSFileFilter("jpg", JPEG_FILTER_STRING));
            return tSEFilenameInspectorProperty;
        }
        return super.getInspectorProperty(tSEInspectorPropertyID);
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(PICTURE_ID)) {
            this.setImage(new TSEImage((String)tSEInspectorProperty.getValue()));
            return 1;
        }
        return super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

