/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx.ui;

import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.util.TSProperty;
import java.util.List;

public class TSERoundRectNodeUI
extends TSENodeUI {
    public static TSEInspectorPropertyID ARC_WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Arc_Width"), class$java$lang$Double == null ? (class$java$lang$Double = TSERoundRectNodeUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID ARC_HEIGHT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Arc_Height"), class$java$lang$Double == null ? (class$java$lang$Double = TSERoundRectNodeUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static final String ARC_WIDTH = "arcwidth";
    public static final String ARC_HEIGHT = "archeight";
    double arcWidth;
    double arcHeight;
    static /* synthetic */ Class class$java$lang$Double;

    public void reset() {
        super.reset();
        this.setArcWidth(this.getDefaultArcWidth());
        this.setArcHeight(this.getDefaultArcHeight());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSERoundRectNodeUI tSERoundRectNodeUI = (TSERoundRectNodeUI)tSEObjectUI;
        this.setArcWidth(tSERoundRectNodeUI.getArcWidth());
        this.setArcHeight(tSERoundRectNodeUI.getArcHeight());
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSENode tSENode = this.getOwnerNode();
        TSSize tSSize = new TSSize(this.getArcWidth() * tSENode.getLocalWidth(), this.getArcHeight() * tSENode.getLocalHeight());
        if (!this.isTransparent()) {
            tSEGraphics.setColor(this.getFillColor());
            tSEGraphics.fillRoundRect(tSENode.getLocalBounds(), tSSize);
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor());
            tSEGraphics.drawRoundRect(tSENode.getLocalBounds(), tSSize);
        }
        this.drawText(tSEGraphics);
        if (this.getOwnerNode().hasChildGraph()) {
            this.drawChildGraphMark(tSEGraphics);
        }
        if (this.hasHideMark()) {
            this.drawHideMark(tSEGraphics);
        }
        this.drawConstraintBadge(tSEGraphics);
    }

    public void drawOutline(TSEGraphics tSEGraphics) {
        TSENode tSENode = this.getOwnerNode();
        TSSize tSSize = new TSSize(this.getArcWidth() * tSENode.getLocalWidth(), this.getArcHeight() * tSENode.getLocalHeight());
        tSEGraphics.drawRoundRect(tSENode.getLocalBounds(), tSSize);
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(ARC_WIDTH, new Double(this.getArcWidth())));
        list.add(new TSProperty(ARC_HEIGHT, new Double(this.getArcHeight())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getArcWidth() != this.getDefaultArcWidth()) {
            list.add(new TSProperty(ARC_WIDTH, new Double(this.getArcWidth())));
        }
        if (this.getArcWidth() != this.getDefaultArcHeight()) {
            list.add(new TSProperty(ARC_HEIGHT, new Double(this.getArcHeight())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (ARC_WIDTH.equals(tSProperty.getName())) {
            this.setArcWidth(Double.valueOf(tSProperty.getValue().toString()));
        }
        if (ARC_HEIGHT.equals(tSProperty.getName())) {
            this.setArcHeight(Double.valueOf(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public double getDefaultArcWidth() {
        return 0.5;
    }

    public double getDefaultArcHeight() {
        return 0.5;
    }

    public double getArcWidth() {
        return this.arcWidth;
    }

    public double getArcHeight() {
        return this.arcHeight;
    }

    public void setArcWidth(double d) {
        Double d2 = new Double(this.arcWidth);
        this.arcWidth = Math.min(1.0, Math.max(0.0, d));
        this.firePropertyChangedEvent(ARC_WIDTH, d2, new Double(this.arcWidth));
    }

    public void setArcHeight(double d) {
        Double d2 = new Double(this.arcHeight);
        this.arcHeight = Math.min(1.0, Math.max(0.0, d));
        this.firePropertyChangedEvent(ARC_HEIGHT, d2, new Double(this.arcHeight));
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(ARC_WIDTH_ID);
        list.add(ARC_HEIGHT_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        if (tSEInspectorPropertyID.equals(ARC_WIDTH_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getArcWidth()), new Double(0.0), new Double(1.0));
        }
        if (tSEInspectorPropertyID.equals(ARC_HEIGHT_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getArcHeight()), new Double(0.0), new Double(1.0));
        }
        return super.getInspectorProperty(tSEInspectorPropertyID);
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(ARC_WIDTH_ID)) {
            this.setArcWidth((Double)tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(ARC_HEIGHT_ID)) {
            this.setArcHeight((Double)tSEInspectorProperty.getValue());
            return 1;
        }
        return super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.yellow;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

