/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx.ui;

import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.dialog.TSFileFilter;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEFilenameInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editorx.TSESVGImage;
import com.tomsawyer.util.TSProperty;
import java.awt.Color;
import java.util.List;

public class TSESVGImageNodeUI
extends TSENodeUI {
    public static TSEInspectorPropertyID PICTURE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Picture"), class$java$lang$String == null ? (class$java$lang$String = TSESVGImageNodeUI.class$("java.lang.String")) : class$java$lang$String);
    public static final String SVG_FILTER_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Scalable_Vector_Graphics_(*.svg)");
    public static final String SCALE = "scale";
    public static final String IMAGE = "svgImage";
    TSESVGImage image;
    boolean imageScaled;
    String defaultText;
    double currentImageWidth;
    double currentImageHeight;
    static /* synthetic */ Class class$java$lang$String;

    public void reset() {
        super.reset();
        this.image = null;
        this.setImageScaled(this.isImageScaledByDefault());
        this.setFormattingEnabled(false);
    }

    public void setOwner(TSENode tSENode) {
        double d = tSENode.getLocalWidth();
        double d2 = tSENode.getLocalHeight();
        super.setOwner(tSENode);
        if (this.isImageScaled()) {
            this.currentImageWidth = d - 2.0 * this.getMarginWidth();
            this.currentImageHeight = d2 - this.getMinimumHeight();
        } else if (this.getImage() != null) {
            this.currentImageWidth = this.getImage().getWidth();
            this.currentImageHeight = this.getImage().getHeight();
        }
        this.onTextChanged(tSENode.getText());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSESVGImageNodeUI tSESVGImageNodeUI = (TSESVGImageNodeUI)tSEObjectUI;
        this.image = new TSESVGImage(tSESVGImageNodeUI.image);
        this.defaultText = tSESVGImageNodeUI.getDefaultText();
        this.setImageScaled(tSESVGImageNodeUI.isImageScaled());
        this.currentImageWidth = tSESVGImageNodeUI.currentImageWidth;
        this.currentImageHeight = tSESVGImageNodeUI.currentImageHeight;
    }

    public void setImageScaled(boolean bl) {
        Boolean bl2 = new Boolean(this.imageScaled);
        this.imageScaled = bl;
        if (bl2.booleanValue() != this.isImageScaled() && this.getOwnerNode() != null) {
            this.onTextChanged(this.getOwnerNode().getText());
        }
        this.firePropertyChangedEvent(SCALE, bl2, new Boolean(bl));
    }

    public boolean isImageScaled() {
        return this.imageScaled;
    }

    public void onTextChanged(String string) {
        super.onTextChanged(string);
        this.getOwnerNode().setLocalAdjustedSize(this.getTightWidth(), this.getTightHeight());
        this.getOwnerNode().setLocalAdjustedOriginalSize(this.getOwnerNode().getLocalWidth(), this.getOwnerNode().getLocalHeight());
    }

    public double getMinimumWidth() {
        return (double)this.getTextWidth() + 2.0 * this.getMarginWidth();
    }

    public double getMinimumHeight() {
        return (double)this.getTextHeight() + 2.0 * this.getMarginHeight();
    }

    public double getTightWidth() {
        if (this.image == null || this.image.getWidth() < 0.0) {
            return super.getTightWidth();
        }
        this.updateTextWidthAndHeight(this.getOwner().getText());
        return Math.max(this.currentImageWidth, (double)this.getTextWidth()) + 2.0 * this.getMarginWidth();
    }

    public double getTightHeight() {
        if (this.image == null || this.image.getHeight() < 0.0) {
            return super.getTightHeight();
        }
        this.updateTextWidthAndHeight(this.getOwner().getText());
        return this.getMinimumHeight() + this.currentImageHeight;
    }

    public double getMarginWidth() {
        return 0.0;
    }

    public double getMarginHeight() {
        return 0.0;
    }

    public double getTextOffsetX() {
        return 0.0;
    }

    public double getTextOffsetY() {
        return 1.0 + (double)this.getTextHeight() / 2.0 - this.getOwnerNode().getLocalHeight() / 2.0;
    }

    public void setFont(TSEFont tSEFont) {
        super.setFont(tSEFont);
        if (this.getOwnerNode() != null) {
            this.getOwnerNode().setLocalWidth(this.getTightWidth());
            this.getOwnerNode().setLocalOriginalWidth(this.getOwnerNode().getLocalWidth());
            this.getOwnerNode().setLocalHeight(this.getTightHeight());
            this.getOwnerNode().setLocalOriginalHeight(this.getOwnerNode().getLocalHeight());
        }
    }

    public void drawProxy(TSEGraphics tSEGraphics, int n, int n2, int n3, int n4) {
        tSEGraphics.setColor(Color.red);
        tSEGraphics.drawRect(n, n2, n3, n4);
        tSEGraphics.drawLine(n, n2, n + n3, n2 + n4);
        tSEGraphics.drawLine(n, n2 + n4, n + n3, n2);
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        int n = tSTransform.xToDevice(this.getOwnerNode().getLocalLeft());
        int n2 = tSTransform.yToDevice(this.getOwnerNode().getLocalTop());
        int n3 = tSTransform.widthToDevice(this.getOwnerNode().getLocalWidth());
        int n4 = tSTransform.heightToDevice(this.getOwnerNode().getLocalHeight());
        if (!this.isTransparent()) {
            tSEGraphics.setColor(this.getFillColor().getColor());
            tSEGraphics.fillRect(n, n2, n3, n4);
        }
        double d = this.getOwnerNode().getLocalHeight() - 2.0 * this.getMarginHeight() - (double)this.getTextHeight();
        double d2 = this.getOwnerNode().getLocalWidth() - 2.0 * this.getMarginWidth();
        if (this.image == null) {
            this.drawProxy(tSEGraphics, n, n2, tSTransform.widthToDevice(d2), tSTransform.heightToDevice(d));
        } else {
            double d3 = this.image.getWidth();
            double d4 = this.image.getHeight();
            if (this.isImageScaled()) {
                double d5 = Math.min(d2 / this.image.getWidth(), d / this.image.getHeight());
                d3 *= d5;
                d4 *= d5;
            }
            this.currentImageWidth = d3;
            this.currentImageHeight = d4;
            int n5 = tSTransform.xToDevice(this.getOwnerNode().getLocalCenterX() - d3 / 2.0);
            int n6 = tSTransform.yToDevice(this.getOwnerNode().getLocalCenterY() + ((double)this.getTextHeight() + d4) / 2.0);
            int n7 = tSTransform.widthToDevice(d3);
            int n8 = tSTransform.widthToDevice(d4);
            if (n7 < 3 && n8 < 3) {
                tSEGraphics.setColor(Color.black);
                tSEGraphics.drawRect(n5, n6, n7, n8);
            } else {
                try {
                    this.image.draw(tSEGraphics, n5, n6, n7, n8, tSTransform.getDeviceBounds());
                }
                catch (Exception exception) {
                    this.drawProxy(tSEGraphics, n5, n6, n7, n8);
                    System.err.println("Unable to draw image \"" + this.image + "\": \"" + exception.getMessage() + "\".");
                }
            }
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor().getColor());
            tSEGraphics.drawRect(n, n2, n3, n4);
        }
        this.drawText(tSEGraphics);
        if (this.getOwnerNode().hasChildGraph()) {
            this.drawChildGraphMark(tSEGraphics);
        }
        if (this.hasHideMark()) {
            this.drawHideMark(tSEGraphics);
        }
        this.drawConstraintBadge(tSEGraphics);
    }

    public void setImage(TSESVGImage tSESVGImage) {
        TSESVGImage tSESVGImage2 = this.image;
        if (tSESVGImage != null) {
            this.image = new TSESVGImage(tSESVGImage);
            if (!this.isImageScaled()) {
                this.currentImageWidth = this.image.getWidth();
                this.currentImageHeight = this.image.getHeight();
            }
        } else {
            this.image = null;
        }
        this.firePropertyChangedEvent(IMAGE, tSESVGImage2, tSESVGImage);
    }

    public TSESVGImage getImage() {
        return this.image;
    }

    public List getProperties() {
        List list = super.getProperties();
        if (this.image != null) {
            list.add(new TSProperty(IMAGE, this.image.getResource()));
        } else {
            list.add(new TSProperty(IMAGE, null));
        }
        list.add(new TSProperty(SCALE, new Boolean(this.isImageScaled())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.image != null && this.image.getResource() != null) {
            list.add(new TSProperty(IMAGE, TSEImage.checkPath(this.image.getResource())));
        }
        if (this.isImageScaled() != this.isImageScaledByDefault()) {
            list.add(new TSProperty(SCALE, new Boolean(this.isImageScaled())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (IMAGE.equals(tSProperty.getName()) || "imageUsed".equals(tSProperty.getName()) || "image".equals(tSProperty.getName())) {
            if (tSProperty.getValue() != null) {
                this.setImage(TSESVGImage.loadImage(tSProperty.getValue().toString()));
            }
        } else if ("text".equals(tSProperty.getName())) {
            this.defaultText = tSProperty.getValue().toString();
        } else if (SCALE.equals(tSProperty.getName())) {
            this.setImageScaled(Boolean.valueOf(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public boolean isTransparentByDefault() {
        return true;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public boolean isBorderDrawnByDefault() {
        return false;
    }

    public boolean isImageScaledByDefault() {
        return true;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(PICTURE_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        if (tSEInspectorPropertyID.equals(PICTURE_ID)) {
            String string = this.image != null && this.image.getResource() != null ? this.image.getResource() : new String();
            TSEFilenameInspectorProperty tSEFilenameInspectorProperty = new TSEFilenameInspectorProperty(string);
            tSEFilenameInspectorProperty.addFilter(new TSFileFilter("svg", SVG_FILTER_STRING));
            return tSEFilenameInspectorProperty;
        }
        return super.getInspectorProperty(tSEInspectorPropertyID);
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(PICTURE_ID)) {
            this.setImage(TSESVGImage.loadImage((String)tSEInspectorProperty.getValue()));
            return 1;
        }
        return super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

